/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateViewDesc;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class CreateViewOperation
extends DDLOperation<CreateViewDesc> {
    public CreateViewOperation(DDLOperationContext context, CreateViewDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table oldview = this.context.getDb().getTable(((CreateViewDesc)this.desc).getViewName(), false);
        if (oldview != null) {
            if (((CreateViewDesc)this.desc).getReplicationSpec().isInReplicationScope()) {
                Map<String, String> dbParams = this.context.getDb().getDatabase(oldview.getDbName()).getParameters();
                if (((CreateViewDesc)this.desc).getReplicationSpec().allowEventReplacementInto(dbParams)) {
                    ((CreateViewDesc)this.desc).setReplace(true);
                } else {
                    LOG.debug("DDLTask: Create View is skipped as view {} is newer than update", (Object)((CreateViewDesc)this.desc).getViewName());
                    return 0;
                }
            }
            if (!((CreateViewDesc)this.desc).isReplace()) {
                if (((CreateViewDesc)this.desc).getIfNotExists()) {
                    return 0;
                }
                throw new HiveException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(((CreateViewDesc)this.desc).getViewName()));
            }
            assert (!((CreateViewDesc)this.desc).isMaterialized());
            oldview.setViewOriginalText(((CreateViewDesc)this.desc).getViewOriginalText());
            oldview.setViewExpandedText(((CreateViewDesc)this.desc).getViewExpandedText());
            oldview.setFields(((CreateViewDesc)this.desc).getSchema());
            if (((CreateViewDesc)this.desc).getComment() != null) {
                oldview.setProperty("comment", ((CreateViewDesc)this.desc).getComment());
            }
            if (((CreateViewDesc)this.desc).getTblProps() != null) {
                oldview.getTTable().getParameters().putAll(((CreateViewDesc)this.desc).getTblProps());
            }
            oldview.setPartCols(((CreateViewDesc)this.desc).getPartCols());
            if (((CreateViewDesc)this.desc).getInputFormat() != null) {
                oldview.setInputFormatClass(((CreateViewDesc)this.desc).getInputFormat());
            }
            if (((CreateViewDesc)this.desc).getOutputFormat() != null) {
                oldview.setOutputFormatClass(((CreateViewDesc)this.desc).getOutputFormat());
            }
            oldview.checkValidity(null);
            if (((CreateViewDesc)this.desc).getOwnerName() != null) {
                oldview.setOwner(((CreateViewDesc)this.desc).getOwnerName());
            }
            this.context.getDb().alterTable(((CreateViewDesc)this.desc).getViewName(), oldview, false, null, true);
            DDLUtils.addIfAbsentByName(new WriteEntity(oldview, WriteEntity.WriteType.DDL_NO_LOCK), this.context.getWork().getOutputs());
        } else {
            Table tbl = ((CreateViewDesc)this.desc).toTable(this.context.getConf());
            if (tbl.isMaterializedView()) {
                CreationMetadata cm = new CreationMetadata(MetaStoreUtils.getDefaultCatalog(this.context.getConf()), tbl.getDbName(), tbl.getTableName(), ImmutableSet.copyOf(((CreateViewDesc)this.desc).getTablesUsed()));
                cm.setValidTxnList(this.context.getConf().get("hive.txn.tables.valid.writeids"));
                tbl.getTTable().setCreationMetadata(cm);
            }
            this.context.getDb().createTable(tbl, ((CreateViewDesc)this.desc).getIfNotExists());
            DDLUtils.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK), this.context.getWork().getOutputs());
            LineageInfo.DataContainer dc = new LineageInfo.DataContainer(tbl.getTTable());
            if (((CreateViewDesc)this.desc).isMaterialized()) {
                Path tlocation;
                Map<String, String> tblProps = tbl.getTTable().getParameters();
                try {
                    Warehouse wh = new Warehouse(this.context.getConf());
                    tlocation = wh.getDefaultTablePath(this.context.getDb().getDatabase(tbl.getDbName()), tbl.getTableName(), tblProps == null || !AcidUtils.isTablePropertyTransactional(tblProps));
                }
                catch (MetaException e) {
                    throw new HiveException(e);
                }
                this.context.getQueryState().getLineageState().setLineage(tlocation, dc, tbl.getCols());
            } else {
                this.context.getQueryState().getLineageState().setLineage(new Path(((CreateViewDesc)this.desc).getViewName()), dc, tbl.getCols());
            }
        }
        return 0;
    }
}

