/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite;

import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite.AlterMaterializedViewRewriteDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;

public class AlterMaterializedViewRewriteOperation
extends DDLOperation<AlterMaterializedViewRewriteDesc> {
    public AlterMaterializedViewRewriteOperation(DDLOperationContext context, AlterMaterializedViewRewriteDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table mv = this.context.getDb().getTable(((AlterMaterializedViewRewriteDesc)this.desc).getMaterializedViewName());
        if (mv.isRewriteEnabled() == ((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable()) {
            return 0;
        }
        Table newMV = mv.copy();
        if (((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable()) {
            try {
                QueryState qs = new QueryState.Builder().withHiveConf(this.context.getConf()).build();
                CalcitePlanner planner = new CalcitePlanner(qs);
                Context ctx = new Context(this.context.getConf());
                ctx.setIsLoadingMaterializedView(true);
                planner.initCtx(ctx);
                planner.init(false);
                RelNode plan = planner.genLogicalPlan(ParseUtils.parse(mv.getViewExpandedText()));
                if (plan == null) {
                    String msg = "Cannot enable automatic rewriting for materialized view.";
                    if (ctx.getCboInfo() != null) {
                        msg = msg + " " + ctx.getCboInfo();
                    }
                    throw new HiveException(msg);
                }
                if (!planner.isValidAutomaticRewritingMaterialization()) {
                    throw new HiveException("Cannot enable rewriting for materialized view. " + planner.getInvalidAutomaticRewritingMaterializationReason());
                }
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        newMV.setRewriteEnabled(((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable());
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        this.context.getDb().alterTable(newMV, false, environmentContext, true);
        return 0;
    }
}

