/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.drop;

import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.materialized.drop.DropMaterializedViewDesc;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class DropMaterializedViewOperation
extends DDLOperation<DropMaterializedViewDesc> {
    public DropMaterializedViewOperation(DDLOperationContext context, DropMaterializedViewDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table table = this.getTable();
        if (table == null) {
            return 0;
        }
        if (!table.isMaterializedView()) {
            if (((DropMaterializedViewDesc)this.desc).isIfExists()) {
                return 0;
            }
            if (table.isView()) {
                throw new HiveException("Cannot drop a view with DROP MATERIALIZED VIEW");
            }
            throw new HiveException("Cannot drop a base table with DROP MATERIALIZED VIEW");
        }
        this.context.getDb().dropTable(((DropMaterializedViewDesc)this.desc).getTableName(), false);
        HiveMaterializedViewsRegistry.get().dropMaterializedView(table.getDbName(), table.getTableName());
        DDLUtils.addIfAbsentByName(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        return 0;
    }

    private Table getTable() throws HiveException {
        try {
            return this.context.getDb().getTable(((DropMaterializedViewDesc)this.desc).getTableName());
        }
        catch (InvalidTableException e) {
            return null;
        }
    }
}

