/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.mapping.drop;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.mapping.drop.DropWMMappingDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={886})
public class DropWMMappingAnalyzer
extends BaseSemanticAnalyzer {
    public DropWMMappingAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getChildCount() != 3) {
            throw new SemanticException("Invalid syntax for drop mapping.");
        }
        String resourcePlanName = DropWMMappingAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String entityType = ast.getChild(1).getText();
        String entityName = PlanUtils.stripQuotes(ast.getChild(2).getText());
        DropWMMappingDesc desc = new DropWMMappingDesc(resourcePlanName, entityType, entityName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

