/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.create;

import java.io.IOException;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.create.CreateWMPoolDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class CreateWMPoolOperation
extends DDLOperation<CreateWMPoolDesc> {
    public CreateWMPoolOperation(DDLOperationContext context, CreateWMPoolDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException {
        WMPool pool = new WMPool(((CreateWMPoolDesc)this.desc).getResourcePlanName(), ((CreateWMPoolDesc)this.desc).getPoolPath());
        pool.setAllocFraction(((CreateWMPoolDesc)this.desc).getAllocFraction());
        pool.setQueryParallelism(((CreateWMPoolDesc)this.desc).getQueryParallelism());
        if (((CreateWMPoolDesc)this.desc).getSchedulingPolicy() != null) {
            if (!MetaStoreUtils.isValidSchedulingPolicy(((CreateWMPoolDesc)this.desc).getSchedulingPolicy())) {
                throw new SemanticException("Invalid scheduling policy " + ((CreateWMPoolDesc)this.desc).getSchedulingPolicy());
            }
            pool.setSchedulingPolicy(((CreateWMPoolDesc)this.desc).getSchedulingPolicy());
        }
        this.context.getDb().createWMPool(pool);
        return 0;
    }
}

