/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.drop;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.WMUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.drop.DropWMPoolDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={888})
public class DropWMPoolAnalyzer
extends BaseSemanticAnalyzer {
    public DropWMPoolAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() != 2) {
            throw new SemanticException("Invalid syntax for drop pool.");
        }
        String resourcePlanName = DropWMPoolAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String poolPath = WMUtils.poolPath(root.getChild(1));
        DropWMPoolDesc desc = new DropWMPoolDesc(resourcePlanName, poolPath);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

