/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlanStatus;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManager;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class AbstractAlterResourcePlanStatusOperation<T extends DDLDesc>
extends DDLOperation<T> {
    public AbstractAlterResourcePlanStatusOperation(DDLOperationContext context, T desc) {
        super(context, desc);
    }

    protected void handleWMServiceChangeIfNeeded(WMFullResourcePlan appliedResourcePlan, boolean isActivate, boolean isForceDeactivate, boolean replace) throws HiveException {
        boolean mustHaveAppliedChange;
        boolean bl = mustHaveAppliedChange = isActivate || isForceDeactivate;
        if (!mustHaveAppliedChange && !replace) {
            return;
        }
        if (appliedResourcePlan == null && !mustHaveAppliedChange) {
            return;
        }
        WorkloadManager wm = WorkloadManager.getInstance();
        boolean isInTest = HiveConf.getBoolVar(this.context.getConf(), HiveConf.ConfVars.HIVE_IN_TEST);
        if (wm == null && isInTest) {
            return;
        }
        if (appliedResourcePlan == null != isForceDeactivate) {
            throw new HiveException("Cannot get a resource plan to apply; or non-null plan on disable");
        }
        assert (appliedResourcePlan == null || appliedResourcePlan.getPlan().getStatus() == WMResourcePlanStatus.ACTIVE);
        this.handleWMServiceChange(wm, isActivate, appliedResourcePlan);
    }

    private int handleWMServiceChange(WorkloadManager wm, boolean isActivate, WMFullResourcePlan appliedResourcePlan) throws HiveException {
        TezSessionPoolManager pm;
        String name = null;
        if (isActivate) {
            name = appliedResourcePlan.getPlan().getName();
            LOG.info("Activating a new resource plan " + name + ": " + appliedResourcePlan);
        } else {
            LOG.info("Disabling workload management");
        }
        if (wm != null) {
            ListenableFuture<Boolean> future = wm.updateResourcePlanAsync(appliedResourcePlan);
            boolean isOk = false;
            try {
                future.get();
                isOk = true;
                if (isActivate) {
                    LOG.info("Successfully activated resource plan " + name);
                } else {
                    LOG.info("Successfully disabled workload management");
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new HiveException(e);
            }
            finally {
                if (!isOk) {
                    if (isActivate) {
                        LOG.error("Failed to activate resource plan " + name);
                    } else {
                        LOG.error("Failed to disable workload management");
                    }
                }
            }
        }
        if ((pm = TezSessionPoolManager.getInstance()) != null) {
            Collection<String> appliedTriggers = pm.updateTriggers(appliedResourcePlan);
            LOG.info("Updated tez session pool manager with active resource plan: {} appliedTriggers: {}", (Object)name, appliedTriggers);
        }
        return 0;
    }
}

