/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.enable;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.enable.AlterResourcePlanEnableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={815})
public class AlterResourcePlanEnableAnalyzer
extends BaseSemanticAnalyzer {
    public AlterResourcePlanEnableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() == 0) {
            this.console.printError("Activate a resource plan to enable workload management!");
            return;
        }
        String resourcePlanName = AlterResourcePlanEnableAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        boolean enable = false;
        boolean activate = false;
        boolean replace = false;
        block5: for (int i = 1; i < root.getChildCount(); ++i) {
            Tree child = root.getChild(i);
            switch (child.getType()) {
                case 751: {
                    activate = true;
                    if (child.getChildCount() > 1) {
                        throw new SemanticException("Expected 0 or 1 arguments " + root.toStringTree());
                    }
                    if (child.getChildCount() != 1) continue block5;
                    if (child.getChild(0).getType() != 1032) {
                        throw new SemanticException("Incorrect syntax " + root.toStringTree());
                    }
                    replace = true;
                    continue block5;
                }
                case 892: {
                    enable = true;
                    continue block5;
                }
                case 1032: {
                    replace = true;
                    continue block5;
                }
                default: {
                    throw new SemanticException("Unexpected token in alter resource plan statement: " + child.getType());
                }
            }
        }
        AlterResourcePlanEnableDesc desc = new AlterResourcePlanEnableDesc(resourcePlanName, enable, activate, replace);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

