/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableOperation;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hive.common.util.HiveStringUtils;
import org.stringtemplate.v4.ST;

public class DDLPlanUtils {
    private static final String EXTERNAL = "external";
    private static final String TEMPORARY = "temporary";
    private static final String LIST_COLUMNS = "columns";
    private static final String COMMENT = "comment";
    private static final String PARTITIONS = "partitions";
    private static final String BUCKETS = "buckets";
    private static final String SKEWED = "skewedinfo";
    private static final String ROW_FORMAT = "row_format";
    private static final String LOCATION_BLOCK = "location_block";
    private static final String LOCATION = "location";
    private static final String PROPERTIES = "properties";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String DATABASE_NAME = "DATABASE_NAME";
    private static final String DATABASE_NAME_FR = "DATABASE_NAME_FR";
    private static final String PARTITION = "PARTITION";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TBLPROPERTIES = "TABLE_PROPERTIES";
    private static final String PARTITION_NAME = "PARTITION_NAME";
    private static final String CONSTRAINT_NAME = "CONSTRAINT_NAME";
    private static final String COL_NAMES = "COLUMN_NAMES";
    private static final String CHILD_TABLE_NAME = "CHILD_TABLE_NAME";
    private static final String PARENT_TABLE_NAME = "PARENT_TABLE_NAME";
    private static final String CHILD_COL_NAME = "CHILD_COL_NAME";
    private static final String PARENT_COL_NAME = "PARENT_COL_NAME";
    private static final String CHECK_EXPRESSION = "CHECK_EXPRESSION";
    private static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    private static final String COL_TYPE = "COL_TYPE";
    private static final String SQL = "SQL";
    private static final String COMMENT_SQL = "COMMENT_SQL";
    private static final String ENABLE = "ENABLE";
    private static final String RELY = "RELY";
    private static final String VALIDATE = "VALIDATE";
    private static final String HIVE_DEFAULT_PARTITION = "__HIVE_DEFAULT_PARTITION__";
    private static final String BASE_64_VALUE = "BASE_64";
    private static final String numNulls = "'numNulls'='";
    private static final String numDVs = "'numDVs'='";
    private static final String numTrues = "'numTrues'='";
    private static final String numFalses = "'numFalses'='";
    private static final String lowValue = "'lowValue'='";
    private static final String highValue = "'highValue'='";
    private static final String avgColLen = "'avgColLen'='";
    private static final String maxColLen = "'maxColLen'='";
    private static final String[] req = new String[]{"numRows", "rawDataSize"};
    private static final String[] explain_plans = new String[]{"EXPLAIN", "EXPLAIN CBO", "EXPLAIN VECTORIZED"};
    private static final String CREATE_DATABASE_STMT = "CREATE DATABASE IF NOT EXISTS <DATABASE_NAME>;";
    private final String CREATE_TABLE_TEMPLATE = "CREATE <temporary><external>TABLE <if(DATABASE_NAME)>`<DATABASE_NAME>`.<endif>`<TABLE_NAME>`(\n<columns>)\n<comment>\n<partitions>\n<buckets>\n<skewedinfo>\n<row_format>\n<location_block>TBLPROPERTIES (\n<properties>)";
    private static final String CREATE_VIEW_TEMPLATE = "CREATE VIEW <if(DATABASE_NAME)>`<DATABASE_NAME>`.<endif>`<TABLE_NAME>`<partitions> AS <SQL>";
    private final String CREATE_TABLE_TEMPLATE_LOCATION = "LOCATION\n<location>\n";
    private final Set<String> PROPERTIES_TO_IGNORE_AT_TBLPROPERTIES = Sets.union(ImmutableSet.of("TEMPORARY", "EXTERNAL", "comment", "SORTBUCKETCOLSPREFIX", "storage_handler", "created_with_ctas", new String[0]), new HashSet<String>(StatsSetupConst.TABLE_PARAMS_STATS_KEYS));
    private final String ALTER_TABLE_CREATE_PARTITION = "<if(COMMENT_SQL)><COMMENT_SQL> <endif>ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD IF NOT EXISTS PARTITION (<PARTITION>);";
    private final String ALTER_TABLE_UPDATE_STATISTICS_TABLE_COLUMN = "ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> UPDATE STATISTICS FOR COLUMN <COLUMN_NAME> SET(<TABLE_PROPERTIES> );";
    private final String ALTER_TABLE_UPDATE_STATISTICS_PARTITION_COLUMN = "<if(COMMENT_SQL)><COMMENT_SQL> <endif>ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> PARTITION (<PARTITION_NAME>) UPDATE STATISTICS FOR COLUMN <COLUMN_NAME> SET(<TABLE_PROPERTIES> );";
    private final String ALTER_TABLE_UPDATE_STATISTICS_TABLE_BASIC = "ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> UPDATE STATISTICS SET(<TABLE_PROPERTIES> );";
    private final String ALTER_TABLE_UPDATE_STATISTICS_PARTITION_BASIC = "<if(COMMENT_SQL)><COMMENT_SQL> <endif>ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> PARTITION (<PARTITION_NAME>) UPDATE STATISTICS SET(<TABLE_PROPERTIES> );";
    private final String ALTER_TABLE_ADD_PRIMARY_KEY = "ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> PRIMARY KEY (<COLUMN_NAMES>) <ENABLE> <VALIDATE> <RELY>;";
    private final String ALTER_TABLE_ADD_FOREIGN_KEY = "ALTER TABLE <DATABASE_NAME>.<CHILD_TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> FOREIGN KEY (<CHILD_COL_NAME>) REFERENCES <DATABASE_NAME_FR>.<PARENT_TABLE_NAME>(<PARENT_COL_NAME>) <ENABLE> <VALIDATE> <RELY>;";
    private final String ALTER_TABLE_ADD_UNIQUE_CONSTRAINT = "ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> UNIQUE (<COLUMN_NAME>) <ENABLE> <VALIDATE> <RELY>;";
    private final String ALTER_TABLE_ADD_CHECK_CONSTRAINT = "ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> CHECK (<CHECK_EXPRESSION>) <ENABLE> <VALIDATE> <RELY>;";
    private final String ALTER_TABLE_ADD_NOT_NULL_CONSTRAINT = "ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> CHANGE COLUMN < COLUMN_NAME> <COLUMN_NAME> <COL_TYPE> CONSTRAINT <CONSTRAINT_NAME> NOT NULL <ENABLE> <VALIDATE> <RELY>;";
    private final String ALTER_TABLE_ADD_DEFAULT_CONSTRAINT = "ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> CHANGE COLUMN < COLUMN_NAME> <COLUMN_NAME> <COL_TYPE> CONSTRAINT <CONSTRAINT_NAME> DEFAULT <DEFAULT_VALUE> <ENABLE> <VALIDATE> <RELY>;";
    private final String EXIST_BIT_VECTORS = "-- BIT VECTORS PRESENT FOR <DATABASE_NAME>.<TABLE_NAME> FOR COLUMN <COLUMN_NAME> BUT THEY ARE NOT SUPPORTED YET. THE BASE64 VALUE FOR THE BITVECTOR IS <BASE_64> ";
    private final String EXIST_BIT_VECTORS_PARTITIONED = "-- BIT VECTORS PRESENT FOR <DATABASE_NAME>.<TABLE_NAME> PARTITION <PARTITION_NAME> FOR COLUMN <COLUMN_NAME> BUT THEY ARE NOT SUPPORTED YET.THE BASE64 VALUE FOR THE BITVECTOR IS <BASE_64> ";

    public List<String> getCreateDatabaseStmt(Set<String> dbNames) {
        ArrayList<String> allDbStmt = new ArrayList<String>();
        for (String dbName : dbNames) {
            if (dbName.equals("default")) continue;
            ST command = new ST(CREATE_DATABASE_STMT);
            command.add(DATABASE_NAME, (Object)dbName);
            allDbStmt.add(command.render());
        }
        return allDbStmt;
    }

    public Map<String, String> getTableColumnsToType(Table tbl) {
        List<FieldSchema> fieldSchemas = tbl.getAllCols();
        HashMap<String, String> ret = new HashMap<String, String>();
        fieldSchemas.stream().forEach(f -> ret.put(f.getName(), f.getType()));
        return ret;
    }

    public List<String> getTableColumnNames(Table tbl) {
        List<FieldSchema> fieldSchemas = tbl.getAllCols();
        ArrayList<String> ret = new ArrayList<String>();
        fieldSchemas.stream().forEach(f -> ret.add(f.getName()));
        return ret;
    }

    public String getPartitionActualName(Partition pt) {
        Map<String, String> colTypeMap = this.getTableColumnsToType(pt.getTable());
        String[] partColsDef = pt.getName().split("/");
        ArrayList<String> ptParam = new ArrayList<String>();
        for (String partCol : partColsDef) {
            String[] colValue = partCol.split("=");
            if (colTypeMap.get(colValue[0]).equalsIgnoreCase("string")) {
                ptParam.add(colValue[0] + "='" + colValue[1] + "'");
                continue;
            }
            ptParam.add(colValue[0] + "=" + colValue[1]);
        }
        return StringUtils.join(ptParam, ",");
    }

    public boolean checkIfDefaultPartition(String pt) {
        return pt.contains(HIVE_DEFAULT_PARTITION);
    }

    public String getAlterTableAddPartition(Partition pt) throws MetaException {
        Table tb = pt.getTable();
        ST command = new ST("<if(COMMENT_SQL)><COMMENT_SQL> <endif>ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD IF NOT EXISTS PARTITION (<PARTITION>);");
        command.add(DATABASE_NAME, (Object)tb.getDbName());
        command.add(TABLE_NAME, (Object)tb.getTableName());
        command.add(PARTITION, (Object)this.getPartitionActualName(pt));
        if (this.checkIfDefaultPartition(pt.getName())) {
            command.add(COMMENT_SQL, (Object)"--");
        }
        return command.render();
    }

    public void addLongStats(ColumnStatisticsData cd, List<String> ls) {
        if (!cd.isSetLongStats()) {
            return;
        }
        LongColumnStatsData lg = cd.getLongStats();
        ls.add(lowValue + lg.getLowValue() + "'");
        ls.add(highValue + lg.getHighValue() + "'");
        ls.add(numNulls + lg.getNumNulls() + "'");
        ls.add(numDVs + lg.getNumDVs() + "'");
    }

    public void addBooleanStats(ColumnStatisticsData cd, List<String> ls) {
        if (!cd.isSetBooleanStats()) {
            return;
        }
        BooleanColumnStatsData bd = cd.getBooleanStats();
        ls.add(numTrues + bd.getNumFalses() + "'");
        ls.add(numFalses + bd.getNumTrues() + "'");
        ls.add(numNulls + bd.getNumNulls() + "'");
    }

    public void addStringStats(ColumnStatisticsData cd, List<String> ls) {
        if (!cd.isSetStringStats()) {
            return;
        }
        StringColumnStatsData lg = cd.getStringStats();
        ls.add(avgColLen + lg.getAvgColLen() + "'");
        ls.add(maxColLen + lg.getMaxColLen() + "'");
        ls.add(numNulls + lg.getNumNulls() + "'");
        ls.add(numDVs + lg.getNumDVs() + "'");
    }

    public void addDateStats(ColumnStatisticsData cd, List<String> ls) {
        if (!cd.isSetDateStats()) {
            return;
        }
        DateColumnStatsData dt = cd.getDateStats();
        ls.add(lowValue + dt.getLowValue().getDaysSinceEpoch() + "'");
        ls.add(highValue + dt.getHighValue().getDaysSinceEpoch() + "'");
        ls.add(numNulls + dt.getNumNulls() + "'");
        ls.add(numDVs + dt.getNumDVs() + "'");
    }

    public void addBinaryStats(ColumnStatisticsData cd, List<String> ls) {
        if (!cd.isSetBinaryStats()) {
            return;
        }
        BinaryColumnStatsData bd = cd.getBinaryStats();
        ls.add(avgColLen + bd.getAvgColLen() + "'");
        ls.add(maxColLen + bd.getMaxColLen() + "'");
        ls.add(numNulls + bd.getNumNulls() + "'");
    }

    public byte[] setByteArrayToLongSize(byte[] arr) {
        int i;
        byte[] temp = new byte[Math.max(arr.length, 8)];
        for (i = 0; i < arr.length; ++i) {
            temp[i] = arr[i];
        }
        for (i = arr.length; i < 8; ++i) {
            temp[i] = 0;
        }
        return temp;
    }

    public void addDecimalStats(ColumnStatisticsData cd, List<String> ls) {
        if (!cd.isSetDecimalStats()) {
            return;
        }
        DecimalColumnStatsData dc = cd.getDecimalStats();
        if (dc.isSetHighValue()) {
            byte[] highValArr = this.setByteArrayToLongSize(dc.getHighValue().getUnscaled());
            ls.add(highValue + ByteBuffer.wrap(highValArr).getLong() + "E" + dc.getHighValue().getScale() + "'");
        }
        if (dc.isSetLowValue()) {
            byte[] lowValArr = this.setByteArrayToLongSize(dc.getLowValue().getUnscaled());
            ls.add(lowValue + ByteBuffer.wrap(lowValArr).getLong() + "E" + dc.getLowValue().getScale() + "'");
        }
        ls.add(numNulls + dc.getNumNulls() + "'");
        ls.add(numDVs + dc.getNumDVs() + "'");
    }

    public void addDoubleStats(ColumnStatisticsData cd, List<String> ls) {
        if (!cd.isSetDoubleStats()) {
            return;
        }
        DoubleColumnStatsData dc = cd.getDoubleStats();
        ls.add(numNulls + dc.getNumNulls() + "'");
        ls.add(numDVs + dc.getNumDVs() + "'");
        ls.add(highValue + dc.getHighValue() + "'");
        ls.add(lowValue + dc.getLowValue() + "'");
    }

    public String checkBitVectors(ColumnStatisticsData cd) {
        if (cd.isSetDoubleStats() && cd.getDoubleStats().isSetBitVectors()) {
            return Base64.getEncoder().encodeToString(cd.getDoubleStats().getBitVectors());
        }
        if (cd.isSetBinaryStats() && cd.getBinaryStats().isSetBitVectors()) {
            return Base64.getEncoder().encodeToString(cd.getBinaryStats().getBitVectors());
        }
        if (cd.isSetStringStats() && cd.getStringStats().isSetBitVectors()) {
            return Base64.getEncoder().encodeToString(cd.getStringStats().getBitVectors());
        }
        if (cd.isSetDateStats() && cd.getDateStats().isSetBitVectors()) {
            return Base64.getEncoder().encodeToString(cd.getDateStats().getBitVectors());
        }
        if (cd.isSetLongStats() && cd.getLongStats().isSetBitVectors()) {
            return Base64.getEncoder().encodeToString(cd.getLongStats().getBitVectors());
        }
        if (cd.isSetDecimalStats() && cd.getDecimalStats().isSetBitVectors()) {
            return Base64.getEncoder().encodeToString(cd.getDecimalStats().getBitVectors());
        }
        if (cd.isSetDoubleStats() && cd.getBooleanStats().isSetBitVectors()) {
            return Base64.getEncoder().encodeToString(cd.getBooleanStats().getBitVectors());
        }
        return null;
    }

    public String addAllColStats(ColumnStatisticsData columnStatisticsData) {
        ArrayList<String> temp = new ArrayList<String>();
        this.addBinaryStats(columnStatisticsData, temp);
        this.addLongStats(columnStatisticsData, temp);
        this.addBooleanStats(columnStatisticsData, temp);
        this.addStringStats(columnStatisticsData, temp);
        this.addDateStats(columnStatisticsData, temp);
        this.addDoubleStats(columnStatisticsData, temp);
        this.addDecimalStats(columnStatisticsData, temp);
        return Joiner.on(",").join(temp);
    }

    public String getAlterTableStmtCol(ColumnStatisticsData columnStatisticsData, String colName, String tblName, String dbName) {
        ST command = new ST("ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> UPDATE STATISTICS FOR COLUMN <COLUMN_NAME> SET(<TABLE_PROPERTIES> );");
        command.add(DATABASE_NAME, (Object)dbName);
        command.add(TABLE_NAME, (Object)tblName);
        command.add(COLUMN_NAME, (Object)colName);
        command.add(TBLPROPERTIES, (Object)this.addAllColStats(columnStatisticsData));
        return command.render();
    }

    public List<String> getAlterTableStmtTableStatsColsAll(Table tbl) throws HiveException {
        ArrayList<String> alterTblStmt = new ArrayList<String>();
        List<String> accessedColumns = this.getTableColumnNames(tbl);
        List<ColumnStatisticsObj> tableColumnStatistics = Hive.get().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), accessedColumns, true);
        ColumnStatisticsObj[] columnStatisticsObj = tableColumnStatistics.toArray(new ColumnStatisticsObj[0]);
        for (int i = 0; i < columnStatisticsObj.length; ++i) {
            alterTblStmt.add(this.getAlterTableStmtCol(columnStatisticsObj[i].getStatsData(), columnStatisticsObj[i].getColName(), tbl.getTableName(), tbl.getDbName()));
            String base64 = this.checkBitVectors(columnStatisticsObj[i].getStatsData());
            if (base64 == null) continue;
            ST command = new ST("-- BIT VECTORS PRESENT FOR <DATABASE_NAME>.<TABLE_NAME> FOR COLUMN <COLUMN_NAME> BUT THEY ARE NOT SUPPORTED YET. THE BASE64 VALUE FOR THE BITVECTOR IS <BASE_64> ");
            command.add(DATABASE_NAME, (Object)tbl.getDbName());
            command.add(TABLE_NAME, (Object)tbl.getTableName());
            command.add(COLUMN_NAME, (Object)columnStatisticsObj[i].getColName());
            command.add(BASE_64_VALUE, (Object)base64);
            alterTblStmt.add(command.render());
        }
        return alterTblStmt;
    }

    public String getAlterTableStmtPartitionColStat(ColumnStatisticsData columnStatisticsData, String colName, String tblName, String ptName, String dbName) {
        ST command = new ST("<if(COMMENT_SQL)><COMMENT_SQL> <endif>ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> PARTITION (<PARTITION_NAME>) UPDATE STATISTICS FOR COLUMN <COLUMN_NAME> SET(<TABLE_PROPERTIES> );");
        command.add(DATABASE_NAME, (Object)dbName);
        command.add(TABLE_NAME, (Object)tblName);
        command.add(COLUMN_NAME, (Object)colName);
        command.add(PARTITION_NAME, (Object)ptName);
        command.add(TBLPROPERTIES, (Object)this.addAllColStats(columnStatisticsData));
        if (this.checkIfDefaultPartition(ptName)) {
            command.add(COMMENT_SQL, (Object)"--");
        }
        return command.render();
    }

    public List<String> getAlterTableStmtPartitionStatsColsAll(List<ColumnStatisticsObj> columnStatisticsObjList, String tblName, String ptName, String dbName) {
        ArrayList<String> alterTableStmt = new ArrayList<String>();
        ColumnStatisticsObj[] columnStatisticsObj = columnStatisticsObjList.toArray(new ColumnStatisticsObj[0]);
        for (int i = 0; i < columnStatisticsObj.length; ++i) {
            alterTableStmt.add(this.getAlterTableStmtPartitionColStat(columnStatisticsObj[i].getStatsData(), columnStatisticsObj[i].getColName(), tblName, ptName, dbName));
            String base64 = this.checkBitVectors(columnStatisticsObj[i].getStatsData());
            if (base64 == null) continue;
            ST command = new ST("-- BIT VECTORS PRESENT FOR <DATABASE_NAME>.<TABLE_NAME> PARTITION <PARTITION_NAME> FOR COLUMN <COLUMN_NAME> BUT THEY ARE NOT SUPPORTED YET.THE BASE64 VALUE FOR THE BITVECTOR IS <BASE_64> ");
            command.add(DATABASE_NAME, (Object)dbName);
            command.add(TABLE_NAME, (Object)tblName);
            command.add(PARTITION_NAME, (Object)ptName);
            command.add(COLUMN_NAME, (Object)columnStatisticsObj[i].getColName());
            command.add(BASE_64_VALUE, (Object)base64);
            alterTableStmt.add(command.render());
        }
        return alterTableStmt;
    }

    public String paramToValues(Map<String, String> parameters) {
        ArrayList<String> paramsToValue = new ArrayList<String>();
        for (String s : req) {
            String p = parameters.get(s);
            if (p == null) {
                p = "0";
            }
            paramsToValue.add("'" + s + "'='" + p + "'");
        }
        return Joiner.on(",").join(paramsToValue);
    }

    public String getAlterTableStmtPartitionStatsBasic(Partition pt) {
        Map<String, String> parameters = pt.getParameters();
        ST command = new ST("<if(COMMENT_SQL)><COMMENT_SQL> <endif>ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> PARTITION (<PARTITION_NAME>) UPDATE STATISTICS SET(<TABLE_PROPERTIES> );");
        command.add(DATABASE_NAME, (Object)pt.getTable().getDbName());
        command.add(TABLE_NAME, (Object)pt.getTable().getTableName());
        command.add(PARTITION_NAME, (Object)this.getPartitionActualName(pt));
        command.add(TBLPROPERTIES, (Object)this.paramToValues(parameters));
        if (this.checkIfDefaultPartition(pt.getName())) {
            command.add(COMMENT_SQL, (Object)"--");
        }
        return command.render();
    }

    public List<String> getDDLPlanForPartitionWithStats(Table table, Map<String, List<Partition>> tableToPartitionList) throws MetaException, HiveException {
        ArrayList<String> alterTableStmt = new ArrayList<String>();
        String tableName = table.getTableName();
        for (Partition pt : tableToPartitionList.get(tableName)) {
            alterTableStmt.add(this.getAlterTableAddPartition(pt));
            alterTableStmt.add(this.getAlterTableStmtPartitionStatsBasic(pt));
        }
        String databaseName = table.getDbName();
        ArrayList<String> partNames = new ArrayList<String>();
        List<String> columnNames = this.getTableColumnNames(table);
        tableToPartitionList.get(tableName).stream().forEach(p -> partNames.add(p.getName()));
        Map<String, List<ColumnStatisticsObj>> partitionColStats = Hive.get().getPartitionColumnStatistics(databaseName, tableName, partNames, columnNames, true);
        HashMap partitionToActualName = new HashMap();
        tableToPartitionList.get(tableName).stream().forEach(p -> partitionToActualName.put(p.getName(), this.getPartitionActualName((Partition)p)));
        for (String partitionName : partitionColStats.keySet()) {
            alterTableStmt.addAll(this.getAlterTableStmtPartitionStatsColsAll(partitionColStats.get(partitionName), tableName, (String)partitionToActualName.get(partitionName), databaseName));
        }
        return alterTableStmt;
    }

    public String getAlterTableStmtTableStatsBasic(Table tbl) {
        Map<String, String> parameters = tbl.getParameters();
        ST command = new ST("ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> UPDATE STATISTICS SET(<TABLE_PROPERTIES> );");
        command.add(TABLE_NAME, (Object)tbl.getTableName());
        command.add(DATABASE_NAME, (Object)tbl.getDbName());
        command.add(TBLPROPERTIES, (Object)this.paramToValues(parameters));
        return command.render();
    }

    public String getAlterTableStmtPrimaryKeyConstraint(PrimaryKeyInfo pr) {
        if (!PrimaryKeyInfo.isNotEmpty(pr)) {
            return null;
        }
        ST command = new ST("ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> PRIMARY KEY (<COLUMN_NAMES>) <ENABLE> <VALIDATE> <RELY>;");
        command.add(TABLE_NAME, (Object)pr.getTableName());
        command.add(DATABASE_NAME, (Object)pr.getDatabaseName());
        command.add(CONSTRAINT_NAME, (Object)pr.getConstraintName());
        command.add(COL_NAMES, (Object)String.join((CharSequence)",", pr.getColNames().values()));
        command.add(ENABLE, (Object)pr.getEnable());
        command.add(VALIDATE, (Object)pr.getValidate());
        command.add(RELY, (Object)pr.getRely());
        return command.render();
    }

    public void getAlterTableStmtForeignKeyConstraint(ForeignKeyInfo fr, List<String> constraints, Set<String> allTableNames) {
        if (!ForeignKeyInfo.isNotEmpty(fr)) {
            return;
        }
        Map<String, List<ForeignKeyInfo.ForeignKeyCol>> all = fr.getForeignKeys();
        for (String key : all.keySet()) {
            for (ForeignKeyInfo.ForeignKeyCol fkc : all.get(key)) {
                ST command = new ST("ALTER TABLE <DATABASE_NAME>.<CHILD_TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> FOREIGN KEY (<CHILD_COL_NAME>) REFERENCES <DATABASE_NAME_FR>.<PARENT_TABLE_NAME>(<PARENT_COL_NAME>) <ENABLE> <VALIDATE> <RELY>;");
                command.add(CHILD_TABLE_NAME, (Object)fr.getChildTableName());
                command.add(DATABASE_NAME, (Object)fr.getChildDatabaseName());
                command.add(CONSTRAINT_NAME, (Object)key);
                command.add(CHILD_COL_NAME, (Object)fkc.childColName);
                command.add(DATABASE_NAME_FR, (Object)fkc.parentDatabaseName);
                command.add(PARENT_TABLE_NAME, (Object)fkc.parentTableName);
                command.add(PARENT_COL_NAME, (Object)fkc.parentColName);
                command.add(ENABLE, (Object)fkc.enable);
                command.add(VALIDATE, (Object)fkc.validate);
                command.add(RELY, (Object)fkc.rely);
                constraints.add(command.render());
            }
        }
    }

    public void getAlterTableStmtUniqueConstraint(UniqueConstraint uq, List<String> constraints) {
        if (!UniqueConstraint.isNotEmpty(uq)) {
            return;
        }
        Map<String, List<UniqueConstraint.UniqueConstraintCol>> uniqueConstraints = uq.getUniqueConstraints();
        for (String key : uniqueConstraints.keySet()) {
            ST command = new ST("ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> UNIQUE (<COLUMN_NAME>) <ENABLE> <VALIDATE> <RELY>;");
            command.add(DATABASE_NAME, (Object)uq.getDatabaseName());
            command.add(TABLE_NAME, (Object)uq.getTableName());
            command.add(CONSTRAINT_NAME, (Object)key);
            ArrayList<String> colNames = new ArrayList<String>();
            for (UniqueConstraint.UniqueConstraintCol col : uniqueConstraints.get(key)) {
                colNames.add(col.colName);
            }
            command.add(COLUMN_NAME, (Object)Joiner.on(",").join(colNames));
            command.add(ENABLE, (Object)uniqueConstraints.get((Object)key).get((int)0).enable);
            command.add(VALIDATE, (Object)uniqueConstraints.get((Object)key).get((int)0).validate);
            command.add(RELY, (Object)uniqueConstraints.get((Object)key).get((int)0).rely);
            constraints.add(command.render());
        }
    }

    public void getAlterTableStmtDefaultConstraint(DefaultConstraint dc, Table tb, List<String> constraints) {
        if (!DefaultConstraint.isNotEmpty(dc)) {
            return;
        }
        Map<String, String> colType = this.getTableColumnsToType(tb);
        Map<String, List<DefaultConstraint.DefaultConstraintCol>> defaultConstraints = dc.getDefaultConstraints();
        for (String constraintName : defaultConstraints.keySet()) {
            List<DefaultConstraint.DefaultConstraintCol> defaultConstraintCols = defaultConstraints.get(constraintName);
            for (DefaultConstraint.DefaultConstraintCol col : defaultConstraintCols) {
                ST command = new ST("ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> CHANGE COLUMN < COLUMN_NAME> <COLUMN_NAME> <COL_TYPE> CONSTRAINT <CONSTRAINT_NAME> DEFAULT <DEFAULT_VALUE> <ENABLE> <VALIDATE> <RELY>;");
                command.add(DATABASE_NAME, (Object)dc.getTableName());
                command.add(TABLE_NAME, (Object)dc.getTableName());
                command.add(COLUMN_NAME, (Object)col.colName);
                command.add(COL_TYPE, (Object)colType.get(col.colName));
                command.add(DEFAULT_VALUE, (Object)col.defaultVal);
                command.add(ENABLE, (Object)col.enable);
                command.add(VALIDATE, (Object)col.validate);
                command.add(RELY, (Object)col.rely);
                constraints.add(command.render());
            }
        }
    }

    public void getAlterTableStmtCheckConstraint(CheckConstraint ck, List<String> constraints) {
        if (!CheckConstraint.isNotEmpty(ck)) {
            return;
        }
        Map<String, List<CheckConstraint.CheckConstraintCol>> checkConstraints = ck.getCheckConstraints();
        for (String constraintName : checkConstraints.keySet()) {
            List<CheckConstraint.CheckConstraintCol> checkConstraintCols = checkConstraints.get(constraintName);
            if (checkConstraintCols == null || checkConstraintCols.size() <= 0) continue;
            for (CheckConstraint.CheckConstraintCol col : checkConstraintCols) {
                ST command = new ST("ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> ADD CONSTRAINT <CONSTRAINT_NAME> CHECK (<CHECK_EXPRESSION>) <ENABLE> <VALIDATE> <RELY>;");
                command.add(DATABASE_NAME, (Object)ck.getDatabaseName());
                command.add(TABLE_NAME, (Object)ck.getTableName());
                command.add(CONSTRAINT_NAME, (Object)constraintName);
                command.add(CHECK_EXPRESSION, (Object)col.getCheckExpression());
                command.add(ENABLE, (Object)col.getEnable());
                command.add(VALIDATE, (Object)col.getValidate());
                command.add(RELY, (Object)col.getRely());
                constraints.add(command.render());
            }
        }
    }

    public void getAlterTableStmtNotNullConstraint(NotNullConstraint nc, Table tb, List<String> constraints) {
        if (!NotNullConstraint.isNotEmpty(nc)) {
            return;
        }
        Map<String, String> colType = this.getTableColumnsToType(tb);
        Map<String, String> notNullConstraints = nc.getNotNullConstraints();
        Map<String, List<String>> enableValidateRely = nc.getEnableValidateRely();
        for (String constraintName : notNullConstraints.keySet()) {
            ST command = new ST("ALTER TABLE <DATABASE_NAME>.<TABLE_NAME> CHANGE COLUMN < COLUMN_NAME> <COLUMN_NAME> <COL_TYPE> CONSTRAINT <CONSTRAINT_NAME> NOT NULL <ENABLE> <VALIDATE> <RELY>;");
            command.add(DATABASE_NAME, (Object)nc.getDatabaseName());
            command.add(TABLE_NAME, (Object)nc.getTableName());
            command.add(COLUMN_NAME, (Object)notNullConstraints.get(constraintName));
            command.add(COL_TYPE, (Object)colType.get(notNullConstraints.get(constraintName)));
            command.add(CONSTRAINT_NAME, (Object)constraintName);
            command.add(ENABLE, (Object)enableValidateRely.get(constraintName).get(0));
            command.add(VALIDATE, (Object)enableValidateRely.get(constraintName).get(1));
            command.add(RELY, (Object)enableValidateRely.get(constraintName).get(2));
            constraints.add(command.render());
        }
    }

    public List<String> populateConstraints(Table tb, Set<String> allTableNames) {
        ArrayList<String> constraints = new ArrayList<String>();
        this.getAlterTableStmtForeignKeyConstraint(tb.getForeignKeyInfo(), constraints, allTableNames);
        this.getAlterTableStmtUniqueConstraint(tb.getUniqueKeyInfo(), constraints);
        this.getAlterTableStmtDefaultConstraint(tb.getDefaultConstraint(), tb, constraints);
        this.getAlterTableStmtCheckConstraint(tb.getCheckConstraint(), constraints);
        this.getAlterTableStmtNotNullConstraint(tb.getNotNullConstraint(), tb, constraints);
        return constraints;
    }

    public List<String> addExplainPlans(String sql) {
        ArrayList<String> exp = new ArrayList<String>();
        for (String ex : explain_plans) {
            exp.add(sql.replaceAll("(?i)explain ddl", ex) + ";");
        }
        return exp;
    }

    public String getCreateViewStmt(Table table) {
        return this.getCreateViewCommand(table, false) + ";";
    }

    public String getCreateViewCommand(Table table, boolean isRelative) {
        ST command = new ST(CREATE_VIEW_TEMPLATE);
        if (!isRelative) {
            command.add(DATABASE_NAME, (Object)table.getDbName());
        }
        command.add(TABLE_NAME, (Object)table.getTableName());
        command.add(PARTITIONS, (Object)this.getPartitionsForView(table));
        command.add(SQL, (Object)table.getViewExpandedText());
        return command.render();
    }

    public String getCreateTableCommand(Table table, boolean isRelative) throws HiveException {
        ST command = new ST("CREATE <temporary><external>TABLE <if(DATABASE_NAME)>`<DATABASE_NAME>`.<endif>`<TABLE_NAME>`(\n<columns>)\n<comment>\n<partitions>\n<buckets>\n<skewedinfo>\n<row_format>\n<location_block>TBLPROPERTIES (\n<properties>)");
        if (!isRelative) {
            command.add(DATABASE_NAME, (Object)table.getDbName());
        }
        command.add(TABLE_NAME, (Object)table.getTableName());
        command.add(TEMPORARY, (Object)this.getTemporary(table));
        command.add(EXTERNAL, (Object)this.getExternal(table));
        command.add(LIST_COLUMNS, (Object)this.getColumns(table));
        command.add(COMMENT, (Object)this.getComment(table));
        command.add(PARTITIONS, (Object)this.getPartitions(table));
        command.add(BUCKETS, (Object)this.getBuckets(table));
        command.add(SKEWED, (Object)this.getSkewed(table));
        command.add(ROW_FORMAT, (Object)this.getRowFormat(table));
        command.add(LOCATION_BLOCK, (Object)this.getLocationBlock(table));
        command.add(PROPERTIES, (Object)this.getProperties(table));
        return command.render();
    }

    private String getTemporary(Table table) {
        return table.isTemporary() ? "TEMPORARY " : "";
    }

    private String getExternal(Table table) {
        return table.getTableType() == TableType.EXTERNAL_TABLE ? "EXTERNAL " : "";
    }

    private String getColumns(Table table) throws HiveException {
        ArrayList<String> columnDescs = new ArrayList<String>();
        for (FieldSchema column : table.getCols()) {
            String columnType = this.formatType(TypeInfoUtils.getTypeInfoFromTypeString(column.getType()));
            String columnDesc = "  `" + column.getName() + "` " + columnType;
            if (column.getComment() != null) {
                columnDesc = columnDesc + " COMMENT '" + HiveStringUtils.escapeHiveCommand(column.getComment()) + "'";
            }
            columnDescs.add(columnDesc);
        }
        return StringUtils.join(columnDescs, ", \n");
    }

    private String formatType(TypeInfo typeInfo) throws HiveException {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return typeInfo.getTypeName();
            }
            case STRUCT: {
                StringBuilder structFormattedType = new StringBuilder();
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                for (int i = 0; i < structTypeInfo.getAllStructFieldNames().size(); ++i) {
                    if (structFormattedType.length() != 0) {
                        structFormattedType.append(", ");
                    }
                    String structElementName = structTypeInfo.getAllStructFieldNames().get(i);
                    String structElementType = this.formatType(structTypeInfo.getAllStructFieldTypeInfos().get(i));
                    structFormattedType.append("`" + structElementName + "`:" + structElementType);
                }
                return "struct<" + structFormattedType.toString() + ">";
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                String elementType = this.formatType(listTypeInfo.getListElementTypeInfo());
                return "array<" + elementType + ">";
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                String keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo().getTypeName();
                String valueTypeInfo = this.formatType(mapTypeInfo.getMapValueTypeInfo());
                return "map<" + keyTypeInfo + "," + valueTypeInfo + ">";
            }
            case UNION: {
                StringBuilder unionFormattedType = new StringBuilder();
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                for (TypeInfo unionElementTypeInfo : unionTypeInfo.getAllUnionObjectTypeInfos()) {
                    if (unionFormattedType.length() != 0) {
                        unionFormattedType.append(", ");
                    }
                    String unionElementType = this.formatType(unionElementTypeInfo);
                    unionFormattedType.append(unionElementType);
                }
                return "uniontype<" + unionFormattedType.toString() + ">";
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)typeInfo.getCategory()));
    }

    private String getComment(Table table) {
        String comment = table.getProperty(COMMENT);
        return comment != null ? "COMMENT '" + HiveStringUtils.escapeHiveCommand(comment) + "'" : "";
    }

    private String getPartitionsForView(Table table) {
        List<FieldSchema> partitionKeys = table.getPartCols();
        if (partitionKeys.isEmpty()) {
            return "";
        }
        ArrayList<String> partitionCols = new ArrayList<String>();
        for (String col : table.getPartColNames()) {
            partitionCols.add('`' + col + '`');
        }
        return " PARTITIONED ON (" + StringUtils.join(partitionCols, ", ") + ")";
    }

    private String getPartitions(Table table) {
        List<FieldSchema> partitionKeys = table.getPartitionKeys();
        if (partitionKeys.isEmpty()) {
            return "";
        }
        ArrayList<String> partitionDescs = new ArrayList<String>();
        for (FieldSchema partitionKey : partitionKeys) {
            String partitionDesc = "  `" + partitionKey.getName() + "` " + partitionKey.getType();
            if (partitionKey.getComment() != null) {
                partitionDesc = partitionDesc + " COMMENT '" + HiveStringUtils.escapeHiveCommand(partitionKey.getComment()) + "'";
            }
            partitionDescs.add(partitionDesc);
        }
        return "PARTITIONED BY ( \n" + StringUtils.join(partitionDescs, ", \n") + ")";
    }

    private String getBuckets(Table table) {
        List<String> bucketCols = table.getBucketCols();
        if (bucketCols.isEmpty()) {
            return "";
        }
        String buckets = "CLUSTERED BY ( \n  " + StringUtils.join(bucketCols, ", \n  ") + ") \n";
        List<Order> sortColumns = table.getSortCols();
        if (!sortColumns.isEmpty()) {
            ArrayList<String> sortKeys = new ArrayList<String>();
            for (Order sortColumn : sortColumns) {
                String sortKeyDesc = "  " + sortColumn.getCol() + " " + DirectionUtils.codeToText(sortColumn.getOrder());
                sortKeys.add(sortKeyDesc);
            }
            buckets = buckets + "SORTED BY ( \n" + StringUtils.join(sortKeys, ", \n") + ") \n";
        }
        buckets = buckets + "INTO " + table.getNumBuckets() + " BUCKETS";
        return buckets;
    }

    private String getSkewed(Table table) {
        SkewedInfo skewedInfo = table.getSkewedInfo();
        if (skewedInfo == null || skewedInfo.getSkewedColNames().isEmpty()) {
            return "";
        }
        ArrayList<String> columnValuesList = new ArrayList<String>();
        for (List<String> columnValues : skewedInfo.getSkewedColValues()) {
            columnValuesList.add("('" + StringUtils.join(columnValues, "','") + "')");
        }
        String skewed = "SKEWED BY (" + StringUtils.join(skewedInfo.getSkewedColNames(), ",") + ")\n  ON (" + StringUtils.join(columnValuesList, ",") + ")";
        if (table.isStoredAsSubDirectories()) {
            skewed = skewed + "\n  STORED AS DIRECTORIES";
        }
        return skewed;
    }

    private String getRowFormat(Table table) {
        StringBuilder rowFormat = new StringBuilder();
        StorageDescriptor sd = table.getTTable().getSd();
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        rowFormat.append("ROW FORMAT SERDE \n").append("  '" + HiveStringUtils.escapeHiveCommand(serdeInfo.getSerializationLib()) + "' \n");
        Map<String, String> serdeParams = serdeInfo.getParameters();
        if (table.getStorageHandler() == null) {
            if ("1".equals(serdeParams.get("serialization.format"))) {
                serdeParams.remove("serialization.format");
            }
            if (!serdeParams.isEmpty()) {
                DDLPlanUtils.appendSerdeParams(rowFormat, serdeParams);
                rowFormat.append(" \n");
            }
            rowFormat.append("STORED AS INPUTFORMAT \n  '" + HiveStringUtils.escapeHiveCommand(sd.getInputFormat()) + "' \n").append("OUTPUTFORMAT \n  '" + HiveStringUtils.escapeHiveCommand(sd.getOutputFormat()) + "'");
        } else {
            String metaTableStorage = table.getParameters().get("storage_handler");
            rowFormat.append("STORED BY \n  '" + HiveStringUtils.escapeHiveCommand(metaTableStorage) + "' \n");
            if (!serdeParams.isEmpty()) {
                DDLPlanUtils.appendSerdeParams(rowFormat, serdeInfo.getParameters());
            }
        }
        return rowFormat.toString();
    }

    public static void appendSerdeParams(StringBuilder builder, Map<String, String> serdeParams) {
        TreeMap<String, String> sortedSerdeParams = new TreeMap<String, String>(serdeParams);
        ArrayList<String> serdeCols = new ArrayList<String>();
        for (Map.Entry entry : sortedSerdeParams.entrySet()) {
            serdeCols.add("  '" + (String)entry.getKey() + "'='" + HiveStringUtils.escapeUnicode(HiveStringUtils.escapeHiveCommand((String)entry.getValue())) + "'");
        }
        builder.append("WITH SERDEPROPERTIES ( \n").append(StringUtils.join(serdeCols, ", \n")).append(')');
    }

    private String getLocationBlock(Table table) {
        if (!CreateTableOperation.doesTableNeedLocation(table)) {
            return "";
        }
        ST locationBlock = new ST("LOCATION\n<location>\n");
        StorageDescriptor sd = table.getTTable().getSd();
        locationBlock.add(LOCATION, (Object)("  '" + HiveStringUtils.escapeHiveCommand(sd.getLocation()) + "'"));
        return locationBlock.render();
    }

    private String getProperties(Table table) {
        return DDLUtils.propertiesToString(table.getParameters(), this.PROPERTIES_TO_IGNORE_AT_TBLPROPERTIES);
    }
}

