/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTask
extends Task<ExportWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger LOG = LoggerFactory.getLogger(ExportTask.class);

    @Override
    public String getName() {
        return "EXPORT";
    }

    @Override
    public int execute() {
        try {
            TableExport.Paths exportPaths = new TableExport.Paths(((ExportWork)this.work).getAstRepresentationForErrorMsg(), ((ExportWork)this.work).getExportRootDir(), this.conf, false);
            Hive db = this.getHive();
            this.LOG.debug("Exporting data to: {}", (Object)exportPaths.metadataExportRootDir());
            ((ExportWork)this.work).acidPostProcess(db);
            TableExport tableExport = new TableExport(exportPaths, ((ExportWork)this.work).getTableSpec(), ((ExportWork)this.work).getReplicationSpec(), db, null, this.conf, ((ExportWork)this.work).getMmContext());
            tableExport.write(true, null, false);
        }
        catch (Exception e) {
            this.LOG.error("failed", (Throwable)e);
            this.setException(e);
            return 1;
        }
        return 0;
    }

    @Override
    public StageType getType() {
        return StageType.REPL_DUMP;
    }
}

