/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class ReplTxnTask
extends Task<ReplTxnWork> {
    private static final long serialVersionUID = 1L;

    @Override
    public int execute() {
        String replPolicy = ((ReplTxnWork)this.work).getReplPolicy();
        String tableName = ((ReplTxnWork)this.work).getTableName();
        ReplicationSpec replicationSpec = ((ReplTxnWork)this.work).getReplicationSpec();
        if (tableName != null && replicationSpec != null) {
            try {
                Database database = Hive.get().getDatabase(((ReplTxnWork)this.work).getDbName());
                if (!replicationSpec.allowReplacementInto(database.getParameters())) {
                    LOG.debug("ReplTxnTask: Event is skipped as it is already replayed. Event Id: " + replicationSpec.getReplicationState() + "Event Type: " + (Object)((Object)((ReplTxnWork)this.work).getOperationType()));
                    return 0;
                }
            }
            catch (HiveException e1) {
                LOG.error("Get database failed with exception " + e1.getMessage());
                return 1;
            }
        }
        try {
            HiveTxnManager txnManager = this.context.getHiveTxnManager();
            String user = UserGroupInformation.getCurrentUser().getUserName();
            switch (((ReplTxnWork)this.work).getOperationType()) {
                case REPL_OPEN_TXN: {
                    List<Long> txnIds = txnManager.replOpenTxn(replPolicy, ((ReplTxnWork)this.work).getTxnIds(), user);
                    assert (txnIds.size() == ((ReplTxnWork)this.work).getTxnIds().size());
                    LOG.info("Replayed OpenTxn Event for policy " + replPolicy + " with srcTxn " + ((ReplTxnWork)this.work).getTxnIds().toString() + " and target txn id " + txnIds.toString());
                    return 0;
                }
                case REPL_ABORT_TXN: {
                    for (long txnId : ((ReplTxnWork)this.work).getTxnIds()) {
                        txnManager.replRollbackTxn(replPolicy, txnId);
                        LOG.info("Replayed AbortTxn Event for policy " + replPolicy + " with srcTxn " + txnId);
                    }
                    return 0;
                }
                case REPL_COMMIT_TXN: {
                    assert (((ReplTxnWork)this.work).getTxnIds().size() == 1);
                    long txnId = ((ReplTxnWork)this.work).getTxnIds().get(0);
                    CommitTxnRequest commitTxnRequest = new CommitTxnRequest(txnId);
                    commitTxnRequest.setReplPolicy(((ReplTxnWork)this.work).getReplPolicy());
                    commitTxnRequest.setWriteEventInfos(((ReplTxnWork)this.work).getWriteEventInfos());
                    commitTxnRequest.setTxn_type(TxnType.REPL_CREATED);
                    txnManager.replCommitTxn(commitTxnRequest);
                    LOG.info("Replayed CommitTxn Event for replPolicy: " + replPolicy + " with srcTxn: " + txnId + "WriteEventInfos: " + ((ReplTxnWork)this.work).getWriteEventInfos());
                    return 0;
                }
                case REPL_ALLOC_WRITE_ID: {
                    assert (((ReplTxnWork)this.work).getTxnToWriteIdList() != null);
                    String dbName = ((ReplTxnWork)this.work).getDbName();
                    List<TxnToWriteId> txnToWriteIdList = ((ReplTxnWork)this.work).getTxnToWriteIdList();
                    if (ReplUtils.filterTransactionOperations(this.conf)) {
                        List<Long> txnIdsToOpen = txnToWriteIdList.stream().map(txn2WriteId -> new Long(txn2WriteId.getTxnId())).collect(Collectors.toList());
                        List<Long> openedTxnIds = txnManager.replOpenTxn(replPolicy, txnIdsToOpen, user);
                        assert (openedTxnIds.size() == txnIdsToOpen.size());
                        LOG.info("Replayed (implicit) OpenTxn Event for policy " + replPolicy + " with srcTxn " + txnIdsToOpen.toString() + " and target txn id " + openedTxnIds.toString());
                    }
                    txnManager.replAllocateTableWriteIdsBatch(dbName, tableName, replPolicy, txnToWriteIdList);
                    LOG.info("Replayed alloc write Id Event for repl policy: " + replPolicy + " db Name : " + dbName + " txnToWriteIdList: " + txnToWriteIdList.toString() + " table name: " + tableName);
                    return 0;
                }
                case REPL_WRITEID_STATE: {
                    txnManager.replTableWriteIdState(((ReplTxnWork)this.work).getValidWriteIdList(), ((ReplTxnWork)this.work).getDbName(), tableName, ((ReplTxnWork)this.work).getPartNames());
                    LOG.info("Replicated WriteId state for DbName: " + ((ReplTxnWork)this.work).getDbName() + " TableName: " + tableName + " ValidWriteIdList: " + ((ReplTxnWork)this.work).getValidWriteIdList());
                    return 0;
                }
            }
            LOG.error("Operation Type " + (Object)((Object)((ReplTxnWork)this.work).getOperationType()) + " is not supported ");
            return 1;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            this.setException(e);
            LOG.error("ReplTxnTask failed", (Throwable)e);
            return ReplUtils.handleException(true, e, ((ReplTxnWork)this.work).getDumpDirectory(), ((ReplTxnWork)this.work).getMetricCollector(), this.getName(), this.conf);
        }
    }

    @Override
    public StageType getType() {
        return StageType.REPL_TXN;
    }

    @Override
    public String getName() {
        return "REPL_TRANSACTION";
    }

    public ReplTxnWork.OperationType getOperationType() {
        return ((ReplTxnWork)this.work).getOperationType();
    }
}

