/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.StringConvertibleObject;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="HDFS Copy Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DirCopyWork
implements Serializable,
StringConvertibleObject {
    public static final String URI_SEPARATOR = "#";
    private static final long serialVersionUID = 1L;
    private String tableName;
    private Path fullyQualifiedSourcePath;
    private Path fullyQualifiedTargetPath;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;
    private SnapshotUtils.SnapshotCopyMode copyMode = SnapshotUtils.SnapshotCopyMode.FALLBACK_COPY;
    private String snapshotPrefix = "";

    public DirCopyWork(ReplicationMetricCollector metricCollector, String dumpDirectory) {
        this.metricCollector = metricCollector;
        this.dumpDirectory = dumpDirectory;
    }

    public DirCopyWork(String tableName, Path fullyQualifiedSourcePath, Path fullyQualifiedTargetPath) {
        this.tableName = tableName;
        this.fullyQualifiedSourcePath = fullyQualifiedSourcePath;
        this.fullyQualifiedTargetPath = fullyQualifiedTargetPath;
    }

    public DirCopyWork(String tableName, Path fullyQualifiedSourcePath, Path fullyQualifiedTargetPath, SnapshotUtils.SnapshotCopyMode copyMode, String snapshotPrefix) {
        this(tableName, fullyQualifiedSourcePath, fullyQualifiedTargetPath);
        this.copyMode = copyMode;
        this.snapshotPrefix = snapshotPrefix;
    }

    public String toString() {
        return "DirCopyWork{fullyQualifiedSourcePath=" + this.getFullyQualifiedSourcePath() + ", fullyQualifiedTargetPath=" + this.getFullyQualifiedTargetPath() + ", tableName=" + this.tableName + ", copyMode=" + (Object)((Object)this.getCopyMode()) + ", snapshotPrefix=" + this.getSnapshotPrefix() + '}';
    }

    public Path getFullyQualifiedSourcePath() {
        return this.fullyQualifiedSourcePath;
    }

    public Path getFullyQualifiedTargetPath() {
        return this.fullyQualifiedTargetPath;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public SnapshotUtils.SnapshotCopyMode getCopyMode() {
        return this.copyMode;
    }

    public String getSnapshotPrefix() {
        return this.snapshotPrefix;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String convertToString() {
        StringBuilder objInStr = new StringBuilder();
        objInStr.append(this.fullyQualifiedSourcePath).append(URI_SEPARATOR).append(this.fullyQualifiedTargetPath).append(URI_SEPARATOR).append(this.tableName).append(URI_SEPARATOR).append((Object)this.copyMode).append(URI_SEPARATOR).append(this.snapshotPrefix);
        return objInStr.toString();
    }

    @Override
    public void loadFromString(String objectInStr) {
        String[] paths = objectInStr.split(URI_SEPARATOR);
        this.fullyQualifiedSourcePath = new Path(paths[0]);
        this.fullyQualifiedTargetPath = new Path(paths[1]);
        if (paths.length > 3) {
            this.tableName = paths[2];
            this.copyMode = SnapshotUtils.SnapshotCopyMode.valueOf(paths[3]);
            this.snapshotPrefix = paths[4];
        }
    }
}

