/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.AtlasDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.RangerDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.HiveWrapper;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandlerFactory;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.ConstraintsSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FunctionSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.BootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.IncrementalDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.FailoverMetaData;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplDumpTask
extends Task<ReplDumpWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";
    private static final String FUNCTION_METADATA_FILE_NAME = "_metadata";
    private static final long SLEEP_TIME = 300000L;
    private static final long SLEEP_TIME_FOR_TESTS = 30000L;
    private Set<String> tablesForBootstrap = new HashSet<String>();
    private List<TxnType> excludedTxns = Arrays.asList(TxnType.READ_ONLY, TxnType.REPL_CREATED);
    private Logger LOG = LoggerFactory.getLogger(ReplDumpTask.class);

    @VisibleForTesting
    public ReplDumpTask() {
    }

    @VisibleForTesting
    public ReplDumpTask(HiveConf conf, ReplDumpWork work) {
        this.conf = conf;
        this.work = work;
    }

    @Override
    public String getName() {
        return "REPL_DUMP";
    }

    @Override
    public int execute() {
        try {
            SecurityUtils.reloginExpiringKeytabUser();
            if (((ReplDumpWork)this.work).dataCopyIteratorsInitialized()) {
                this.initiateDataCopyTasks();
            } else {
                Path dumpRoot = ReplUtils.getEncodedDumpRootPath(this.conf, ((ReplDumpWork)this.work).dbNameOrPattern.toLowerCase());
                if (ReplUtils.failedWithNonRecoverableError(ReplUtils.getLatestDumpPath(dumpRoot, this.conf), this.conf)) {
                    this.LOG.error("Previous dump failed with non recoverable error. Needs manual intervention. ");
                    this.setException(new SemanticException(ErrorMsg.REPL_FAILED_WITH_NON_RECOVERABLE_ERROR.format(new String[0])));
                    return ErrorMsg.REPL_FAILED_WITH_NON_RECOVERABLE_ERROR.getErrorCode();
                }
                Path previousValidHiveDumpPath = this.getPreviousValidDumpMetadataPath(dumpRoot);
                boolean isFailoverMarkerPresent = false;
                if (previousValidHiveDumpPath == null) {
                    ((ReplDumpWork)this.work).setBootstrap(true);
                } else {
                    ((ReplDumpWork)this.work).setOldReplScope(new DumpMetaData(previousValidHiveDumpPath, this.conf).getReplScope());
                    isFailoverMarkerPresent = this.isDumpFailoverReady(previousValidHiveDumpPath);
                }
                if (this.shouldDump(previousValidHiveDumpPath, isFailoverMarkerPresent)) {
                    Long lastReplId;
                    Path currentDumpPath = this.getCurrentDumpPath(dumpRoot, ((ReplDumpWork)this.work).isBootstrap());
                    Path hiveDumpRoot = new Path(currentDumpPath, "hive");
                    if (!((ReplDumpWork)this.work).isBootstrap()) {
                        this.preProcessFailoverIfRequired(previousValidHiveDumpPath, isFailoverMarkerPresent);
                    }
                    String mapRedCustomName = ReplUtils.getDistCpCustomName(this.conf, ((ReplDumpWork)this.work).dbNameOrPattern);
                    this.conf.set("mapreduce.job.name", mapRedCustomName);
                    ((ReplDumpWork)this.work).setCurrentDumpPath(currentDumpPath);
                    ((ReplDumpWork)this.work).setMetricCollector(this.initMetricCollection(((ReplDumpWork)this.work).isBootstrap(), hiveDumpRoot));
                    if (this.shouldDumpAtlasMetadata()) {
                        this.addAtlasDumpTask(((ReplDumpWork)this.work).isBootstrap(), previousValidHiveDumpPath);
                        this.LOG.info("Added task to dump atlas metadata.");
                    }
                    if (this.shouldDumpAuthorizationMetadata()) {
                        this.initiateAuthorizationDumpTask();
                    }
                    DumpMetaData dmd = new DumpMetaData(hiveDumpRoot, this.conf);
                    ReplChangeManager.getInstance(this.conf);
                    Path cmRoot = new Path(this.conf.getVar(HiveConf.ConfVars.REPLCMDIR));
                    this.LOG.info("Data copy at load enabled : {}", (Object)this.conf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET));
                    if (((ReplDumpWork)this.work).isBootstrap()) {
                        lastReplId = this.bootStrapDump(hiveDumpRoot, dmd, cmRoot, this.getHive());
                    } else {
                        ((ReplDumpWork)this.work).setEventFrom(this.getEventFromPreviousDumpMetadata(previousValidHiveDumpPath));
                        lastReplId = this.incrementalDump(hiveDumpRoot, dmd, cmRoot, this.getHive());
                    }
                    ((ReplDumpWork)this.work).setResultValues(Arrays.asList(currentDumpPath.toUri().toString(), String.valueOf(lastReplId)));
                    this.initiateDataCopyTasks();
                } else if (isFailoverMarkerPresent) {
                    this.LOG.info("Previous Dump is failover ready. Skipping this iteration.");
                } else {
                    this.LOG.info("Previous Dump is not yet loaded. Skipping this iteration.");
                }
            }
        }
        catch (RuntimeException e) {
            this.LOG.error("replication failed with run time exception", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, ((ReplDumpWork)this.work).getCurrentDumpPath().toString(), ((ReplDumpWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                this.LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            this.setException(e);
            int errorCode = e instanceof SnapshotException ? ErrorMsg.getErrorMsg("SNAPSHOT_ERROR").getErrorCode() : ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
            try {
                return ReplUtils.handleException(true, e, ((ReplDumpWork)this.work).getCurrentDumpPath().toString(), ((ReplDumpWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                this.LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
        return 0;
    }

    private void preProcessFailoverIfRequired(Path previousValidHiveDumpDir, boolean isPrevFailoverReadyMarkerPresent) throws HiveException, IOException {
        FileSystem fs = previousValidHiveDumpDir.getFileSystem((Configuration)this.conf);
        Database db = this.getHive().getDatabase(((ReplDumpWork)this.work).dbNameOrPattern);
        if (isPrevFailoverReadyMarkerPresent) {
            if (MetaStoreUtils.isDbBeingFailedOverAtEndpoint(db, MetaStoreUtils.FailoverEndpoint.SOURCE)) {
                this.LOG.info("Rolling back failover initiated in previous dump iteration.");
                fs.delete(new Path(previousValidHiveDumpDir, ReplAck.FAILOVER_READY_MARKER.toString()), true);
            } else if (MetaStoreUtils.isDbBeingFailedOverAtEndpoint(db, MetaStoreUtils.FailoverEndpoint.TARGET)) {
                this.LOG.info("Switching to bootstrap dump as this is the first dump execution after failover.");
                ((ReplDumpWork)this.work).setFirstDumpAfterFailover(true);
            }
        }
        if (!this.shouldFailover() && !((ReplDumpWork)this.work).isFirstDumpAfterFailover()) {
            ReplUtils.unsetDbPropIfSet(db, "repl.failover.endpoint", this.getHive());
        }
    }

    private boolean isDumpFailoverReady(Path previousValidHiveDumpPath) throws IOException {
        FileSystem fs = previousValidHiveDumpPath.getFileSystem((Configuration)this.conf);
        Path failoverReadyMarkerFile = new Path(previousValidHiveDumpPath, ReplAck.FAILOVER_READY_MARKER.toString());
        return fs.exists(failoverReadyMarkerFile);
    }

    private void initiateAuthorizationDumpTask() throws SemanticException {
        Task<RangerDumpWork> rangerDumpTask;
        if ("ranger".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE))) {
            Path rangerDumpRoot = new Path(((ReplDumpWork)this.work).getCurrentDumpPath(), "ranger");
            this.LOG.info("Exporting Authorization Metadata from {} at {} ", (Object)"ranger", (Object)rangerDumpRoot);
            RangerDumpWork rangerDumpWork = new RangerDumpWork(rangerDumpRoot, ((ReplDumpWork)this.work).dbNameOrPattern, ((ReplDumpWork)this.work).getMetricCollector());
            rangerDumpTask = TaskFactory.get(rangerDumpWork, this.conf);
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
        } else {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format("Authorizer " + this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE) + " not supported for replication ", "ranger"));
        }
        this.childTasks.add(rangerDumpTask);
    }

    private boolean shouldDumpAuthorizationMetadata() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_AUTHORIZATION_METADATA);
    }

    private boolean shouldDumpAtlasMetadata() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_ATLAS_METADATA);
    }

    private Path getCurrentDumpPath(Path dumpRoot, boolean isBootstrap) throws IOException {
        Path lastDumpPath = ReplUtils.getLatestDumpPath(dumpRoot, this.conf);
        if (lastDumpPath != null && this.shouldResumePreviousDump(lastDumpPath, isBootstrap)) {
            Path hiveDumpRoot;
            Path failoverReadyMarkerFile;
            FileSystem fs;
            this.LOG.info("Resuming the dump with existing dump directory {}", (Object)lastDumpPath);
            if (!this.shouldFailover() && (fs = (failoverReadyMarkerFile = new Path(hiveDumpRoot = new Path(lastDumpPath, "hive"), ReplAck.FAILOVER_READY_MARKER.toString())).getFileSystem((Configuration)this.conf)).exists(failoverReadyMarkerFile)) {
                this.LOG.info("Deleting previous failover ready marker file: {}.", (Object)failoverReadyMarkerFile);
                fs.delete(failoverReadyMarkerFile, true);
            }
            ((ReplDumpWork)this.work).setShouldOverwrite(true);
            return lastDumpPath;
        }
        return new Path(dumpRoot, this.getNextDumpDir());
    }

    private void initiateDataCopyTasks() throws SemanticException, IOException {
        TaskTracker taskTracker = new TaskTracker(this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS));
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        List<Task<?>> externalTableCopyTasks = ((ReplDumpWork)this.work).externalTableCopyTasks(taskTracker, this.conf);
        this.childTasks.addAll(externalTableCopyTasks);
        this.LOG.debug("Scheduled {} external table copy tasks", (Object)externalTableCopyTasks.size());
        if (!externalTableCopyTasks.isEmpty() && !((ReplDumpWork)this.work).getExternalTblCopyPathIterator().hasNext()) {
            ReplUtils.addLoggerTask(((ReplDumpWork)this.work).getReplLogger(), this.childTasks, this.conf);
        }
        this.childTasks.addAll(((ReplDumpWork)this.work).managedTableCopyTasks(taskTracker, this.conf));
        this.childTasks.addAll(((ReplDumpWork)this.work).functionsBinariesCopyTasks(taskTracker, this.conf));
        if (this.childTasks.isEmpty()) {
            this.finishRemainingTasks();
        } else {
            DAGTraversal.traverse(this.childTasks, new AddDependencyToLeaves(TaskFactory.get(this.work, this.conf)));
        }
    }

    private void addAtlasDumpTask(boolean bootstrap, Path prevHiveDumpDir) {
        Path atlasDumpDir = new Path(((ReplDumpWork)this.work).getCurrentDumpPath(), "atlas");
        Path prevAtlasDumpDir = prevHiveDumpDir == null ? null : new Path(prevHiveDumpDir.getParent(), "atlas");
        Path tableListLoc = null;
        if (!((ReplDumpWork)this.work).replScope.includeAllTables()) {
            Path tableListDir = new Path(((ReplDumpWork)this.work).getCurrentDumpPath(), "hive/_tables");
            tableListLoc = new Path(tableListDir, ((ReplDumpWork)this.work).dbNameOrPattern.toLowerCase());
        }
        AtlasDumpWork atlasDumpWork = new AtlasDumpWork(((ReplDumpWork)this.work).dbNameOrPattern, atlasDumpDir, bootstrap, prevAtlasDumpDir, tableListLoc, ((ReplDumpWork)this.work).getMetricCollector());
        Task<AtlasDumpWork> atlasDumpTask = TaskFactory.get(atlasDumpWork, this.conf);
        this.childTasks = new ArrayList();
        this.childTasks.add(atlasDumpTask);
    }

    private void finishRemainingTasks() throws SemanticException {
        boolean isFailoverInProgress;
        boolean bl = isFailoverInProgress = this.shouldFailover() && !((ReplDumpWork)this.work).isBootstrap();
        if (isFailoverInProgress) {
            org.apache.hadoop.hive.ql.parse.repl.dump.Utils.create(new Path(((ReplDumpWork)this.work).getCurrentDumpPath(), "hive" + File.separator + (Object)((Object)ReplAck.FAILOVER_READY_MARKER)), this.conf);
            this.LOG.info("Dump marked as failover ready.");
        }
        Path dumpAckFile = new Path(((ReplDumpWork)this.work).getCurrentDumpPath(), "hive" + File.separator + (Object)((Object)ReplAck.DUMP_ACKNOWLEDGEMENT));
        org.apache.hadoop.hive.ql.parse.repl.dump.Utils.create(dumpAckFile, this.conf);
        this.prepareReturnValues(((ReplDumpWork)this.work).getResultValues());
        ((ReplDumpWork)this.work).getMetricCollector().reportEnd(isFailoverInProgress ? Status.FAILOVER_READY : Status.SUCCESS);
        this.deleteAllPreviousDumpMeta(((ReplDumpWork)this.work).getCurrentDumpPath());
    }

    private void prepareReturnValues(List<String> values) throws SemanticException {
        this.LOG.debug("prepareReturnValues : dump_dir,last_repl_id#string,string");
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        org.apache.hadoop.hive.ql.parse.repl.dump.Utils.writeOutput(Collections.singletonList(values), new Path(((ReplDumpWork)this.work).resultTempPath), this.conf);
    }

    private void deleteAllPreviousDumpMeta(Path currentDumpPath) {
        block6: {
            try {
                Path dumpRoot = this.getDumpRoot(currentDumpPath);
                if (dumpRoot == null) {
                    return;
                }
                FileSystem fs = dumpRoot.getFileSystem((Configuration)this.conf);
                if (!fs.exists(dumpRoot)) break block6;
                FileStatus[] statuses = fs.listStatus(dumpRoot, path -> !path.equals((Object)currentDumpPath) && !path.toUri().getPath().equals(currentDumpPath.toString()));
                int retainPrevDumpDirCount = this.conf.getIntVar(HiveConf.ConfVars.REPL_RETAIN_PREV_DUMP_DIR_COUNT);
                int numDumpDirs = statuses.length;
                if (this.shouldRetainPrevDumpDirs()) {
                    Arrays.sort(statuses, Comparator.comparingLong(fileStatus1 -> fileStatus1.getModificationTime()).thenComparingLong(fileStatus2 -> fileStatus2.getModificationTime()));
                }
                for (FileStatus status : statuses) {
                    if (numDumpDirs == 1 && ((ReplDumpWork)this.work).isFirstDumpAfterFailover()) {
                        this.LOG.info("Skipping deletion of last failover ready dump dir: ", (Object)status.getPath());
                        break;
                    }
                    if (this.shouldRetainPrevDumpDirs() && numDumpDirs <= retainPrevDumpDirCount) continue;
                    fs.delete(status.getPath(), true);
                    --numDumpDirs;
                }
            }
            catch (Exception ex) {
                this.LOG.warn("Possible leak on disk, could not delete the previous dump directory:" + currentDumpPath, (Throwable)ex);
            }
        }
    }

    private Path getDumpRoot(Path currentDumpPath) {
        if (ReplDumpWork.testDeletePreviousDumpMetaPath && (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL))) {
            return null;
        }
        return currentDumpPath.getParent();
    }

    private Long getEventFromPreviousDumpMetadata(Path previousDumpPath) throws SemanticException {
        if (previousDumpPath != null) {
            DumpMetaData dmd = new DumpMetaData(previousDumpPath, this.conf);
            if (dmd.isIncrementalDump()) {
                return dmd.getEventTo();
            }
            return dmd.getEventFrom();
        }
        return 0L;
    }

    private Path getPreviousValidDumpMetadataPath(Path dumpRoot) throws IOException {
        FileStatus latestValidStatus = null;
        FileSystem fs = dumpRoot.getFileSystem((Configuration)this.conf);
        if (fs.exists(dumpRoot)) {
            FileStatus[] statuses;
            for (FileStatus status : statuses = fs.listStatus(dumpRoot)) {
                this.LOG.info("Evaluating previous dump dir path:{}", (Object)status.getPath());
                if (latestValidStatus == null) {
                    latestValidStatus = this.validDump(status.getPath()) ? status : null;
                    continue;
                }
                if (!this.validDump(status.getPath()) || status.getModificationTime() <= latestValidStatus.getModificationTime()) continue;
                latestValidStatus = status;
            }
        }
        Path latestDumpDir = latestValidStatus == null ? null : new Path(latestValidStatus.getPath(), "hive");
        this.LOG.info("Selecting latest valid dump dir as {}", (Object)(latestDumpDir == null ? "null" : latestDumpDir.toString()));
        return latestDumpDir;
    }

    private boolean validDump(Path dumpDir) throws IOException {
        if (dumpDir != null) {
            FileSystem fs = dumpDir.getFileSystem((Configuration)this.conf);
            Path hiveDumpDir = new Path(dumpDir, "hive");
            return fs.exists(new Path(hiveDumpDir, ReplAck.DUMP_ACKNOWLEDGEMENT.toString()));
        }
        return false;
    }

    private boolean shouldDump(Path previousDumpPath, boolean isFailoverMarkerPresent) throws IOException {
        if (previousDumpPath == null) {
            return true;
        }
        if (isFailoverMarkerPresent && this.shouldFailover()) {
            return false;
        }
        FileSystem fs = previousDumpPath.getFileSystem((Configuration)this.conf);
        return fs.exists(new Path(previousDumpPath, ReplAck.LOAD_ACKNOWLEDGEMENT.toString()));
    }

    private boolean shouldExamineTablesToDump() {
        return this.previousReplScopeModified() || !this.tablesForBootstrap.isEmpty() || this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES) || this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES);
    }

    private boolean shouldFailover() {
        return this.conf.getBoolVar(HiveConf.ConfVars.HIVE_REPL_FAILOVER_START);
    }

    private boolean previousReplScopeModified() {
        return ((ReplDumpWork)this.work).oldReplScope != null && !((ReplDumpWork)this.work).oldReplScope.equals(((ReplDumpWork)this.work).replScope);
    }

    public static boolean shouldDumpExternalTableLocation(HiveConf conf) {
        return conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES) && !conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY) && !conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY_FOR_EXTERNAL_TABLE);
    }

    private boolean shouldBootstrapDumpExternalTable(String tableName) {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES) && (this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_EXTERNAL_TABLES) || !ReplUtils.tableIncludedInReplScope(((ReplDumpWork)this.work).oldReplScope, tableName));
    }

    private boolean isMaterializedViewsReplEnabled() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_MATERIALIZED_VIEWS);
    }

    private boolean shouldRetainPrevDumpDirs() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_RETAIN_PREV_DUMP_DIR);
    }

    private boolean shouldBootstrapDumpAcidTable(String tableName) {
        return ReplUtils.includeAcidTableInDump(this.conf) && (this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES) || !ReplUtils.tableIncludedInReplScope(((ReplDumpWork)this.work).oldReplScope, tableName));
    }

    private boolean shouldBootstrapDumpTable(Table table) {
        if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) && this.shouldBootstrapDumpExternalTable(table.getTableName())) {
            return true;
        }
        if (AcidUtils.isTransactionalTable(table) && this.shouldBootstrapDumpAcidTable(table.getTableName())) {
            return true;
        }
        if (this.tablesForBootstrap.contains(table.getTableName().toLowerCase())) {
            return true;
        }
        return !ReplUtils.tableIncludedInReplScope(((ReplDumpWork)this.work).oldReplScope, table.getTableName());
    }

    private boolean isTableSatifiesConfig(Table table) {
        if (table == null) {
            return false;
        }
        if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType()) && !this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES)) {
            return false;
        }
        return !AcidUtils.isTransactionalTable(table) || ReplUtils.includeAcidTableInDump(this.conf);
    }

    private void fetchFailoverMetadata(Hive hiveDb) throws HiveException, IOException, TException {
        Path hiveDumpDir = new Path(((ReplDumpWork)this.work).getCurrentDumpPath(), "hive");
        FailoverMetaData fmd = new FailoverMetaData(hiveDumpDir, this.conf);
        FileSystem fs = hiveDumpDir.getFileSystem((Configuration)this.conf);
        if (fs.exists(new Path(hiveDumpDir, "_failovermetadata")) && fmd.isValidMetadata()) {
            ((ReplDumpWork)this.work).setFailoverMetadata(fmd);
            return;
        }
        List<Long> txnsForDb = this.getOpenTxns(this.getTxnMgr().getValidTxns(this.excludedTxns), ((ReplDumpWork)this.work).dbNameOrPattern);
        if (!txnsForDb.isEmpty()) {
            this.LOG.debug("Going to abort transactions: {} for database: {}.", txnsForDb, (Object)((ReplDumpWork)this.work).dbNameOrPattern);
            hiveDb.abortTransactions(txnsForDb);
        }
        fmd.setAbortedTxns(txnsForDb);
        fmd.setCursorPoint(this.currentNotificationId(hiveDb));
        ValidTxnList allValidTxns = this.getTxnMgr().getValidTxns(this.excludedTxns);
        List<Long> openTxns = this.getOpenTxns(allValidTxns);
        fmd.setOpenTxns(openTxns);
        fmd.setTxnsWithoutLock(this.getTxnsNotPresentInHiveLocksTable(openTxns));
        txnsForDb = this.getOpenTxns(allValidTxns, ((ReplDumpWork)this.work).dbNameOrPattern);
        if (!txnsForDb.isEmpty()) {
            this.LOG.debug("Going to abort transactions: {} for database: {}.", txnsForDb, (Object)((ReplDumpWork)this.work).dbNameOrPattern);
            hiveDb.abortTransactions(txnsForDb);
            fmd.addToAbortedTxns(txnsForDb);
        }
        fmd.setFailoverEventId(this.currentNotificationId(hiveDb));
        fmd.write();
        ((ReplDumpWork)this.work).setFailoverMetadata(fmd);
    }

    /*
     * Exception decompiling
     */
    private Long incrementalDump(Path dumpRoot, DumpMetaData dmd, Path cmRoot, Hive hiveDb) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HashMap<String, Boolean> getNonTableLevelCopyPaths(Database db, boolean isSingleCopyTaskForExternalTables) {
        HashMap<String, Boolean> singleCopyPaths = new HashMap<String, Boolean>();
        if (db != null && isSingleCopyTaskForExternalTables) {
            List<String> paths = Arrays.asList(this.conf.getVar(HiveConf.ConfVars.REPL_EXTERNAL_WAREHOUSE_SINGLE_COPY_TASK_PATHS).split(","));
            for (String path : paths) {
                if (StringUtils.isEmpty(path)) continue;
                singleCopyPaths.put(path, false);
            }
            singleCopyPaths.put(db.getLocationUri(), false);
        }
        return singleCopyPaths;
    }

    private void setDataCopyIterators(FileList extTableFileList, FileList managedTableFileList) {
        boolean dataCopyAtLoad = this.conf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        if (dataCopyAtLoad) {
            ((ReplDumpWork)this.work).setManagedTableCopyPathIterator(Collections.emptyList().iterator());
            ((ReplDumpWork)this.work).setExternalTblCopyPathIterator(Collections.emptyList().iterator());
            this.LOG.info("Deferring table/partition data copy during dump. It should be done at load.");
        } else {
            ((ReplDumpWork)this.work).setManagedTableCopyPathIterator(managedTableFileList);
            ((ReplDumpWork)this.work).setExternalTblCopyPathIterator(extTableFileList);
        }
    }

    private ReplicationMetricCollector initMetricCollection(boolean isBootstrap, Path dumpRoot) {
        ReplicationMetricCollector collector = isBootstrap ? new BootstrapDumpMetricCollector(((ReplDumpWork)this.work).dbNameOrPattern, dumpRoot.toString(), this.conf) : new IncrementalDumpMetricCollector(((ReplDumpWork)this.work).dbNameOrPattern, dumpRoot.toString(), this.conf);
        return collector;
    }

    private int getMaxEventAllowed(int currentEventMaxLimit) {
        int maxDirItems = Integer.parseInt(this.conf.get("dfs.namenode.fs-limits.max-directory-items", "0"));
        if (maxDirItems > 0 && (maxDirItems -= 10) < currentEventMaxLimit) {
            this.LOG.warn("Changing the maxEventLimit from {} to {} as the 'dfs.namenode.fs-limits.max-directory-items' limit encountered. Set this config appropriately to increase the maxEventLimit", (Object)currentEventMaxLimit, (Object)maxDirItems);
            currentEventMaxLimit = maxDirItems;
        }
        return currentEventMaxLimit;
    }

    private void cleanFailedEventDirIfExists(Path dumpDir, long resumeFrom) throws SemanticException {
        Path nextEventRoot = new Path(dumpDir, String.valueOf(resumeFrom + 1L));
        Retryable retryable = Retryable.builder().withHiveConf(this.conf).withRetryOnException(IOException.class).build();
        try {
            retryable.executeCallable(() -> {
                FileSystem fs = FileSystem.get((URI)nextEventRoot.toUri(), (Configuration)this.conf);
                if (fs.exists(nextEventRoot)) {
                    fs.delete(nextEventRoot, true);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private long getResumeFrom(Path ackFile) throws SemanticException {
        Retryable retryable = Retryable.builder().withHiveConf(this.conf).withRetryOnException(Exception.class).build();
        try {
            return retryable.executeCallable(() -> {
                BufferedReader br = null;
                try {
                    FileSystem fs = ackFile.getFileSystem((Configuration)this.conf);
                    br = new BufferedReader(new InputStreamReader((InputStream)fs.open(ackFile), Charset.defaultCharset()));
                    long lastEventID = Long.parseLong(br.readLine());
                    Long l = lastEventID;
                    return l;
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
        }
    }

    private boolean needBootstrapAcidTablesDuringIncrementalDump() {
        if (!ReplUtils.includeAcidTableInDump(this.conf)) {
            return false;
        }
        return !((ReplDumpWork)this.work).replScope.includeAllTables() || this.previousReplScopeModified() || this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES);
    }

    private void dumpEvent(NotificationEvent ev, Path evRoot, Path dumpRoot, Path cmRoot, Hive db) throws Exception {
        EventHandler.Context context = new EventHandler.Context(evRoot, dumpRoot, cmRoot, db, this.conf, this.getNewEventOnlyReplicationSpec(ev.getEventId()), ((ReplDumpWork)this.work).replScope, ((ReplDumpWork)this.work).oldReplScope, this.tablesForBootstrap);
        EventHandler eventHandler = EventHandlerFactory.handlerFor(ev);
        eventHandler.handle(context);
        ((ReplDumpWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.EVENTS.name(), 1L);
        ((ReplDumpWork)this.work).getReplLogger().eventLog(String.valueOf(ev.getEventId()), eventHandler.dumpType().toString());
    }

    private ReplicationSpec getNewEventOnlyReplicationSpec(Long eventId) {
        ReplicationSpec rspec = this.getNewReplicationSpec(eventId.toString(), eventId.toString(), this.conf.getBoolean(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY.varname, false));
        rspec.setReplSpecType(ReplicationSpec.Type.INCREMENTAL_DUMP);
        return rspec;
    }

    private void dumpTableListToDumpLocation(List<String> tableList, Path dbRoot, String dbName, HiveConf hiveConf) throws Exception {
        if (tableList == null) {
            this.LOG.debug("Table list file is not created for db level replication.");
            return;
        }
        Retryable retryable = Retryable.builder().withHiveConf(this.conf).withRetryOnException(IOException.class).build();
        try {
            retryable.executeCallable(() -> {
                Path tableListFile = new Path(dbRoot, "_tables");
                tableListFile = new Path(tableListFile, dbName.toLowerCase());
                FSDataOutputStream writer = tableListFile.getFileSystem((Configuration)hiveConf).create(tableListFile);
                for (String tableName : tableList) {
                    String line = tableName.toLowerCase().concat("\n");
                    writer.write(line.getBytes(StandardCharsets.UTF_8));
                }
                writer.close();
                this.LOG.info("Table list file " + tableListFile.toUri() + " is created for table list - " + tableList);
                return null;
            });
        }
        catch (Exception e) {
            FileSystem.closeAllForUGI((UserGroupInformation)Utils.getUGI());
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
        }
    }

    /*
     * Exception decompiling
     */
    Long bootStrapDump(Path dumpRoot, DumpMetaData dmd, Path cmRoot, Hive hiveDb) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setReplFailoverEnabledAtSource(Database db) throws HiveException {
        Map<String, String> params = db.getParameters();
        if (params != null) {
            params.put("repl.failover.endpoint", MetaStoreUtils.FailoverEndpoint.SOURCE.toString());
        } else {
            db.setParameters(Collections.singletonMap("repl.failover.endpoint", MetaStoreUtils.FailoverEndpoint.SOURCE.toString()));
        }
        this.getHive().alterDatabase(((ReplDumpWork)this.work).dbNameOrPattern, db);
    }

    private void setReplSourceFor(Hive hiveDb, String dbName, Database db) throws HiveException {
        if (!ReplChangeManager.isSourceOfReplication(db)) {
            String value = this.conf.get("scheduled.query.schedulename", "default_" + this.getQueryState().getQueryString());
            this.updateReplSourceFor(hiveDb, dbName, db, value);
        } else {
            String scheduleQuery = this.conf.get("scheduled.query.schedulename");
            if (!StringUtils.isEmpty(scheduleQuery) && !ReplChangeManager.getReplPolicyIdString(db).contains(scheduleQuery)) {
                this.updateReplSourceFor(hiveDb, dbName, db, ReplChangeManager.getReplPolicyIdString(db) + ", " + scheduleQuery);
            }
        }
    }

    private void updateReplSourceFor(Hive hiveDb, String dbName, Database db, String value) throws HiveException {
        Map<String, String> params = db.getParameters();
        if (params != null) {
            params.put("repl.source.for", value);
        } else {
            db.setParameters(Collections.singletonMap("repl.source.for", value));
        }
        hiveDb.alterDatabase(dbName, db);
    }

    public static FileList createTableFileList(Path dumpRoot, String fileName, HiveConf conf) {
        Path backingFile = new Path(dumpRoot, fileName);
        return new FileList(backingFile, conf);
    }

    private boolean shouldResumePreviousDump(DumpMetaData dumpMetaData) {
        try {
            return dumpMetaData.getEventFrom() != null;
        }
        catch (Exception e) {
            this.LOG.info("No previous dump present");
            return false;
        }
    }

    private boolean shouldResumePreviousDump(Path lastDumpPath, boolean isBootStrap) throws IOException {
        if (this.validDump(lastDumpPath)) {
            return false;
        }
        Path hiveDumpPath = new Path(lastDumpPath, "hive");
        DumpMetaData dumpMetaData = new DumpMetaData(hiveDumpPath, this.conf);
        if (this.tableExpressionModified(dumpMetaData)) {
            return false;
        }
        if (isBootStrap) {
            return this.shouldResumePreviousDump(dumpMetaData);
        }
        Path lastEventFile = new Path(hiveDumpPath, ReplAck.EVENTS_DUMP.toString());
        long resumeFrom = 0L;
        try {
            resumeFrom = this.getResumeFrom(lastEventFile);
        }
        catch (SemanticException ex) {
            this.LOG.info("Could not get last repl id from {}, because of:", (Object)lastEventFile, (Object)ex.getMessage());
        }
        return resumeFrom > 0L;
    }

    private boolean tableExpressionModified(DumpMetaData dumpMetaData) {
        try {
            return !dumpMetaData.getReplScope().equals(((ReplDumpWork)this.work).replScope);
        }
        catch (Exception e) {
            this.LOG.info("No previous dump present");
            return false;
        }
    }

    long currentNotificationId(Hive hiveDb) throws TException {
        return hiveDb.getMSC().getCurrentNotificationEventId().getEventId();
    }

    Path dumpDbMetadata(String dbName, Path metadataRoot, long lastReplId, Hive hiveDb) throws Exception {
        Path dbRoot = new Path(metadataRoot, dbName);
        FileSystem fs = dbRoot.getFileSystem((Configuration)this.conf);
        Path dumpPath = new Path(dbRoot, FUNCTION_METADATA_FILE_NAME);
        HiveWrapper.Tuple<Database> database = new HiveWrapper(hiveDb, dbName, lastReplId).database();
        EximUtil.createDbExportDump(fs, dumpPath, (Database)database.object, database.replicationSpec, this.context.getConf());
        return dbRoot;
    }

    void dumpTable(String dbName, String tblName, String validTxnList, Path dbRootMetadata, Path dbRootData, long lastReplId, Hive hiveDb, HiveWrapper.Tuple<Table> tuple, FileList managedTbleList, boolean dataCopyAtLoad) throws Exception {
        this.LOG.info("Bootstrap Dump for table " + tblName);
        BaseSemanticAnalyzer.TableSpec tableSpec = new BaseSemanticAnalyzer.TableSpec((Table)tuple.object);
        TableExport.Paths exportPaths = new TableExport.Paths(((ReplDumpWork)this.work).astRepresentationForErrorMsg, dbRootMetadata, dbRootData, tblName, this.conf, true);
        String distCpDoAsUser = this.conf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
        tuple.replicationSpec.setIsReplace(true);
        if (AcidUtils.isTransactionalTable(tableSpec.tableHandle)) {
            tuple.replicationSpec.setValidTxnList(validTxnList);
            tuple.replicationSpec.setValidWriteIdList(this.getValidWriteIdList(dbName, tblName, validTxnList));
            tuple.replicationSpec.setCurrentReplicationState(String.valueOf(lastReplId));
        }
        ExportWork.MmContext mmCtx = ExportWork.MmContext.createIfNeeded(tableSpec.tableHandle);
        tuple.replicationSpec.setRepl(true);
        new TableExport(exportPaths, tableSpec, tuple.replicationSpec, hiveDb, distCpDoAsUser, this.conf, mmCtx).write(false, managedTbleList, dataCopyAtLoad);
        ((ReplDumpWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.TABLES.name(), 1L);
        ((ReplDumpWork)this.work).getReplLogger().tableLog(tblName, tableSpec.tableHandle.getTableType());
    }

    private String getValidWriteIdList(String dbName, String tblName, String validTxnString) throws LockException {
        if (validTxnString == null || validTxnString.isEmpty()) {
            return null;
        }
        String fullTableName = AcidUtils.getFullTableName(dbName, tblName);
        ValidWriteIdList validWriteIds = this.getTxnMgr().getValidWriteIds(Collections.singletonList(fullTableName), validTxnString).getTableValidWriteIdList(fullTableName);
        return validWriteIds != null ? validWriteIds.toString() : null;
    }

    private List<Long> getTxnsNotPresentInHiveLocksTable(List<Long> openTxnList) throws LockException {
        ArrayList<Long> txnsNotPresentInHiveLocks = new ArrayList<Long>();
        for (long openTxnId : openTxnList) {
            if (this.isTxnPresentInHiveLocks(openTxnId)) continue;
            txnsNotPresentInHiveLocks.add(openTxnId);
        }
        return txnsNotPresentInHiveLocks;
    }

    private boolean isTxnPresentInHiveLocks(long txnId) throws LockException {
        ShowLocksRequest request = new ShowLocksRequest();
        request.setTxnid(txnId);
        HiveLockManager lockManager = this.getTxnMgr().getLockManager();
        ShowLocksResponse showLocksResponse = ((DbLockManager)lockManager).getLocks(request);
        return !showLocksResponse.getLocks().isEmpty();
    }

    List<Long> getOpenTxns(ValidTxnList validTxnList, String dbName) throws LockException {
        HiveLockManager lockManager = this.getTxnMgr().getLockManager();
        long[] invalidTxns = validTxnList.getInvalidTransactions();
        ArrayList<Long> openTxns = new ArrayList<Long>();
        HashSet<Long> dbTxns = new HashSet<Long>();
        if (lockManager instanceof DbLockManager) {
            ShowLocksRequest request = new ShowLocksRequest();
            request.setDbname(dbName.toLowerCase());
            ShowLocksResponse showLocksResponse = ((DbLockManager)lockManager).getLocks(request);
            for (ShowLocksResponseElement showLocksResponseElement : showLocksResponse.getLocks()) {
                dbTxns.add(showLocksResponseElement.getTxnid());
            }
            for (Object invalidTxn : (Object)invalidTxns) {
                if (!dbTxns.contains((long)invalidTxn) || validTxnList.isTxnAborted((long)invalidTxn)) continue;
                openTxns.add((long)invalidTxn);
            }
        } else {
            for (long invalidTxn : invalidTxns) {
                if (validTxnList.isTxnAborted(invalidTxn)) continue;
                openTxns.add(invalidTxn);
            }
        }
        return openTxns;
    }

    String getValidTxnListForReplDump(Hive hiveDb, long waitUntilTime) throws HiveException {
        ValidTxnList validTxnList = this.getTxnMgr().getValidTxns(this.excludedTxns);
        while (System.currentTimeMillis() < waitUntilTime) {
            List<Long> openTxnListForAllDbs = this.getOpenTxns(validTxnList);
            if (openTxnListForAllDbs.isEmpty()) {
                return validTxnList.toString();
            }
            if (this.getTxnsNotPresentInHiveLocksTable(openTxnListForAllDbs).isEmpty() && this.getOpenTxns(validTxnList, ((ReplDumpWork)this.work).dbNameOrPattern).isEmpty()) {
                return validTxnList.toString();
            }
            try {
                Thread.sleep(this.getSleepTime());
            }
            catch (InterruptedException e) {
                this.LOG.info("REPL DUMP thread sleep interrupted", (Throwable)e);
            }
            validTxnList = this.getTxnMgr().getValidTxns(this.excludedTxns);
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_DUMP_ABORT_WRITE_TXN_AFTER_TIMEOUT)) {
            List<Long> openTxns = this.getOpenTxns(validTxnList, ((ReplDumpWork)this.work).dbNameOrPattern);
            if (!openTxns.isEmpty()) {
                hiveDb.abortTransactions(openTxns);
                validTxnList = this.getTxnMgr().getValidTxns(this.excludedTxns);
                openTxns = this.getOpenTxns(validTxnList, ((ReplDumpWork)this.work).dbNameOrPattern);
                if (!openTxns.isEmpty()) {
                    this.LOG.warn("REPL DUMP unable to force abort all the open txns: {} after timeout due to unknown reasons. However, this is rare case that shouldn't happen.", openTxns);
                    throw new IllegalStateException("REPL DUMP triggered abort txns failed for unknown reasons.");
                }
            }
        } else {
            this.LOG.warn("Force abort all the open txns is disabled after timeout");
            throw new IllegalStateException("REPL DUMP cannot proceed. Force abort all the open txns is disabled. Enable hive.repl.bootstrap.dump.abort.write.txn.after.timeout to proceed.");
        }
        return validTxnList.toString();
    }

    private long getSleepTime() {
        return this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL) ? 30000L : 300000L;
    }

    private List<Long> getOpenTxns(ValidTxnList validTxnList) {
        long[] invalidTxns = validTxnList.getInvalidTransactions();
        ArrayList<Long> openTxns = new ArrayList<Long>();
        for (long invalidTxn : invalidTxns) {
            if (validTxnList.isTxnAborted(invalidTxn)) continue;
            openTxns.add(invalidTxn);
        }
        return openTxns;
    }

    private ReplicationSpec getNewReplicationSpec(String evState, String objState, boolean isMetadataOnly) {
        return new ReplicationSpec(true, isMetadataOnly, evState, objState, false, true);
    }

    private String getNextDumpDir() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            String nextDump = ReplDumpWork.getInjectNextDumpDirForTest();
            if (nextDump == null) {
                return "next";
            }
            return nextDump;
        }
        return UUID.randomUUID().toString();
    }

    List<EximUtil.DataCopyPath> dumpFunctionMetadata(String dbName, Path dbMetadataRoot, Path dbDataRoot, Hive hiveDb, boolean copyAtLoad) throws Exception {
        ArrayList<EximUtil.DataCopyPath> functionsBinaryCopyPaths = new ArrayList<EximUtil.DataCopyPath>();
        Path functionsMetaRoot = new Path(dbMetadataRoot, "_functions");
        Path functionsDataRoot = new Path(dbDataRoot, "_functions");
        List<String> functionNames = hiveDb.getFunctions(dbName, "*");
        for (String functionName : functionNames) {
            HiveWrapper.Tuple<Function> tuple = this.functionTuple(functionName, dbName, hiveDb);
            if (tuple == null) continue;
            Path functionMetaRoot = new Path(functionsMetaRoot, functionName);
            Path functionMetadataFile = new Path(functionMetaRoot, FUNCTION_METADATA_FILE_NAME);
            Path functionDataRoot = new Path(functionsDataRoot, functionName);
            try (JsonWriter jsonWriter = new JsonWriter(functionMetadataFile.getFileSystem((Configuration)this.conf), functionMetadataFile);){
                FunctionSerializer serializer = new FunctionSerializer((Function)tuple.object, functionDataRoot, copyAtLoad, this.conf);
                serializer.writeTo(jsonWriter, tuple.replicationSpec);
                functionsBinaryCopyPaths.addAll(serializer.getFunctionBinaryCopyPaths());
            }
            ((ReplDumpWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.FUNCTIONS.name(), 1L);
            ((ReplDumpWork)this.work).getReplLogger().functionLog(functionName);
        }
        return functionsBinaryCopyPaths;
    }

    void dumpConstraintMetadata(String dbName, String tblName, Path dbRoot, Hive hiveDb) throws Exception {
        block28: {
            try {
                ConstraintsSerializer serializer2;
                Throwable throwable;
                JsonWriter jsonWriter;
                Path constraintsRoot = new Path(dbRoot, "_constraints");
                Path commonConstraintsFile = new Path(constraintsRoot, ConstraintFileType.COMMON.getPrefix() + tblName);
                Path fkConstraintsFile = new Path(constraintsRoot, ConstraintFileType.FOREIGNKEY.getPrefix() + tblName);
                List<SQLPrimaryKey> pks = hiveDb.getPrimaryKeyList(dbName, tblName);
                List<SQLForeignKey> fks = hiveDb.getForeignKeyList(dbName, tblName);
                List<SQLUniqueConstraint> uks = hiveDb.getUniqueConstraintList(dbName, tblName);
                List<SQLNotNullConstraint> nns = hiveDb.getNotNullConstraintList(dbName, tblName);
                if (pks != null && !pks.isEmpty() || uks != null && !uks.isEmpty() || nns != null && !nns.isEmpty()) {
                    jsonWriter = new JsonWriter(commonConstraintsFile.getFileSystem((Configuration)this.conf), commonConstraintsFile);
                    throwable = null;
                    try {
                        serializer2 = new ConstraintsSerializer(pks, null, uks, nns, this.conf);
                        serializer2.writeTo(jsonWriter, null);
                    }
                    catch (Throwable serializer2) {
                        throwable = serializer2;
                        throw serializer2;
                    }
                    finally {
                        if (jsonWriter != null) {
                            if (throwable != null) {
                                try {
                                    jsonWriter.close();
                                }
                                catch (Throwable serializer2) {
                                    throwable.addSuppressed(serializer2);
                                }
                            } else {
                                jsonWriter.close();
                            }
                        }
                    }
                }
                if (fks == null || fks.isEmpty()) break block28;
                jsonWriter = new JsonWriter(fkConstraintsFile.getFileSystem((Configuration)this.conf), fkConstraintsFile);
                throwable = null;
                try {
                    serializer2 = new ConstraintsSerializer(null, fks, null, null, this.conf);
                    serializer2.writeTo(jsonWriter, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jsonWriter != null) {
                        if (throwable != null) {
                            try {
                                jsonWriter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            jsonWriter.close();
                        }
                    }
                }
            }
            catch (NoSuchObjectException e) {
                this.LOG.debug(e.getMessage());
            }
        }
    }

    private HiveWrapper.Tuple<Function> functionTuple(String functionName, String dbName, Hive hiveDb) {
        try {
            HiveWrapper.Tuple<Function> tuple = new HiveWrapper(hiveDb, dbName).function(functionName);
            if (((Function)tuple.object).getResourceUris().isEmpty()) {
                this.LOG.warn("Not replicating function: " + functionName + " as it seems to have been created without USING clause");
                return null;
            }
            return tuple;
        }
        catch (HiveException e) {
            this.LOG.info("Function " + functionName + " could not be found, we are ignoring it as it can be a valid state ", (Throwable)e);
            return null;
        }
    }

    @Override
    public StageType getType() {
        return StageType.REPL_DUMP;
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }

    public static enum ConstraintFileType {
        COMMON("common", "c_"),
        FOREIGNKEY("fk", "f_");

        private final String name;
        private final String prefix;

        private ConstraintFileType(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

