/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.DirCopyWork;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.PathBuilder;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplExternalTables {
    private static final Logger LOG = LoggerFactory.getLogger(ReplExternalTables.class);
    private HiveConf hiveConf;
    private boolean includeExternalTables;
    private boolean dumpMetadataOnly;

    public ReplExternalTables(HiveConf conf) {
        this.hiveConf = conf;
        this.includeExternalTables = this.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES);
        this.dumpMetadataOnly = this.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY) || this.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY_FOR_EXTERNAL_TABLE);
    }

    private boolean shouldWrite() {
        return !this.dumpMetadataOnly && this.includeExternalTables;
    }

    void dataLocationDump(Table table, FileList fileList, HashMap<String, Boolean> singleCopyPaths, boolean isTableLevelReplication, HiveConf conf) throws IOException, HiveException {
        if (!this.shouldWrite()) {
            return;
        }
        if (!TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
            throw new IllegalArgumentException("only External tables can be writen via this writer, provided table is " + (Object)((Object)table.getTableType()));
        }
        Path fullyQualifiedDataLocation = PathBuilder.fullyQualifiedHDFSUri(table.getDataLocation(), FileSystem.get((Configuration)this.hiveConf));
        if (isTableLevelReplication || !this.isPathWithinSubtree(table.getDataLocation(), singleCopyPaths)) {
            this.dirLocationToCopy(table.getTableName(), fileList, fullyQualifiedDataLocation, conf, false, null, null, null, null, false);
        }
        if (table.isPartitioned()) {
            List<Partition> partitions;
            try {
                partitions = Hive.get(this.hiveConf).getPartitions(table);
            }
            catch (HiveException e) {
                if (e.getCause() instanceof NoSuchObjectException) {
                    LOG.debug(e.getMessage());
                    return;
                }
                throw e;
            }
            for (Partition partition : partitions) {
                boolean partitionLocOutsideTableLoc;
                boolean bl = partitionLocOutsideTableLoc = !FileUtils.isPathWithinSubtree(partition.getDataLocation(), table.getDataLocation());
                if (partitionLocOutsideTableLoc && !isTableLevelReplication && this.isPathWithinSubtree(partition.getDataLocation(), singleCopyPaths)) {
                    partitionLocOutsideTableLoc = false;
                }
                if (!partitionLocOutsideTableLoc) continue;
                fullyQualifiedDataLocation = PathBuilder.fullyQualifiedHDFSUri(partition.getDataLocation(), FileSystem.get((Configuration)this.hiveConf));
                this.dirLocationToCopy(table.getTableName(), fileList, fullyQualifiedDataLocation, conf, false, null, null, null, null, false);
            }
        }
    }

    void dumpNonTableLevelCopyPaths(HashMap<String, Boolean> singlePathLocations, FileList fileList, HiveConf conf, boolean isSnapshotEnabled, String snapshotPrefix, SnapshotUtils.ReplSnapshotCount replSnapshotCount, FileList snapPathFileList, ArrayList<String> prevSnaps, boolean isBootstrap) throws HiveException, IOException {
        for (Map.Entry<String, Boolean> location : singlePathLocations.entrySet()) {
            if (StringUtils.isEmpty(location.getKey()) || !location.getValue().booleanValue()) continue;
            Path fullyQualifiedDataLocation = PathBuilder.fullyQualifiedHDFSUri(new Path(location.getKey()), FileSystem.get((Configuration)this.hiveConf));
            this.dirLocationToCopy("dbPath:" + fullyQualifiedDataLocation.getName(), fileList, fullyQualifiedDataLocation, conf, isSnapshotEnabled, snapshotPrefix, replSnapshotCount, snapPathFileList, prevSnaps, isBootstrap);
        }
    }

    private boolean isPathWithinSubtree(Path path, HashMap<String, Boolean> parentPaths) {
        boolean response = false;
        for (Map.Entry<String, Boolean> parent : parentPaths.entrySet()) {
            if (!StringUtils.isEmpty(parent.getKey())) {
                response = FileUtils.isPathWithinSubtree(path, new Path(parent.getKey()));
            }
            if (!response) continue;
            parent.setValue(true);
            break;
        }
        return response;
    }

    private void dirLocationToCopy(String tableName, FileList fileList, Path sourcePath, HiveConf conf, boolean createSnapshot, String snapshotPrefix, SnapshotUtils.ReplSnapshotCount replSnapshotCount, FileList snapPathFileList, ArrayList<String> prevSnaps, boolean isBootstrap) throws HiveException, IOException {
        Path basePath = ReplExternalTables.getExternalTableBaseDir(conf);
        Path targetPath = ReplExternalTables.externalTableDataPath(conf, basePath, sourcePath);
        SnapshotUtils.SnapshotCopyMode copyMode = this.createSnapshotsAtSource(sourcePath, snapshotPrefix, createSnapshot, conf, replSnapshotCount, snapPathFileList, prevSnaps, isBootstrap);
        if (this.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_HA_DATAPATH_REPLACE_REMOTE_NAMESERVICE) && this.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET)) {
            String remoteNS = this.hiveConf.get(HiveConf.ConfVars.REPL_HA_DATAPATH_REPLACE_REMOTE_NAMESERVICE_NAME.varname);
            if (StringUtils.isEmpty(remoteNS)) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format("Configuration 'hive.repl.ha.datapath.replace.remote.nameservice.name' is not valid " + remoteNS == null ? "null" : remoteNS, "hive"));
            }
            targetPath = new Path(Utils.replaceHost(targetPath.toString(), sourcePath.toUri().getHost()));
            sourcePath = new Path(Utils.replaceHost(sourcePath.toString(), remoteNS));
        }
        fileList.add(new DirCopyWork(tableName, sourcePath, targetPath, copyMode, snapshotPrefix).convertToString());
    }

    private SnapshotUtils.SnapshotCopyMode createSnapshotsAtSource(Path sourcePath, String snapshotPrefix, boolean isSnapshotEnabled, HiveConf conf, SnapshotUtils.ReplSnapshotCount replSnapshotCount, FileList snapPathFileList, ArrayList<String> prevSnaps, boolean isBootstrap) throws IOException {
        if (!isSnapshotEnabled) {
            LOG.info("Snapshot copy not enabled for path {} Will use normal distCp for copying data.", (Object)sourcePath);
            return SnapshotUtils.SnapshotCopyMode.FALLBACK_COPY;
        }
        DistributedFileSystem sourceDfs = SnapshotUtils.getDFS(sourcePath, conf);
        try {
            if (isBootstrap) {
                SnapshotUtils.deleteSnapshotIfExists(sourceDfs, sourcePath, SnapshotUtils.firstSnapshot(snapshotPrefix), conf);
                SnapshotUtils.deleteSnapshotIfExists(sourceDfs, sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix), conf);
                this.allowAndCreateInitialSnapshot(sourcePath, snapshotPrefix, conf, replSnapshotCount, snapPathFileList, sourceDfs);
                return SnapshotUtils.SnapshotCopyMode.INITIAL_COPY;
            }
            if (prevSnaps.contains(sourcePath.toString())) {
                sourceDfs.deleteSnapshot(sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix));
                replSnapshotCount.incrementNumDeleted();
                SnapshotUtils.createSnapshot((FileSystem)sourceDfs, sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix), conf);
                replSnapshotCount.incrementNumCreated();
                snapPathFileList.add(sourcePath.toString());
                return SnapshotUtils.isSnapshotAvailable(sourceDfs, sourcePath, snapshotPrefix, "replOld", conf) ? SnapshotUtils.SnapshotCopyMode.DIFF_COPY : SnapshotUtils.SnapshotCopyMode.INITIAL_COPY;
            }
            boolean isSecondSnapAvlb = SnapshotUtils.isSnapshotAvailable(sourceDfs, sourcePath, snapshotPrefix, "replOld", conf);
            if (isSecondSnapAvlb) {
                sourceDfs.deleteSnapshot(sourcePath, SnapshotUtils.firstSnapshot(snapshotPrefix));
                replSnapshotCount.incrementNumDeleted();
                sourceDfs.renameSnapshot(sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix), SnapshotUtils.firstSnapshot(snapshotPrefix));
                SnapshotUtils.createSnapshot((FileSystem)sourceDfs, sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix), conf);
                replSnapshotCount.incrementNumCreated();
                snapPathFileList.add(sourcePath.toString());
                return SnapshotUtils.SnapshotCopyMode.DIFF_COPY;
            }
            boolean isFirstSnapshotAvailable = SnapshotUtils.isSnapshotAvailable(sourceDfs, sourcePath, snapshotPrefix, "replNew", conf);
            if (isFirstSnapshotAvailable) {
                sourceDfs.renameSnapshot(sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix), SnapshotUtils.firstSnapshot(snapshotPrefix));
                SnapshotUtils.createSnapshot((FileSystem)sourceDfs, sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix), conf);
                replSnapshotCount.incrementNumCreated();
                snapPathFileList.add(sourcePath.toString());
                return SnapshotUtils.SnapshotCopyMode.DIFF_COPY;
            }
            this.allowAndCreateInitialSnapshot(sourcePath, snapshotPrefix, conf, replSnapshotCount, snapPathFileList, sourceDfs);
            return SnapshotUtils.SnapshotCopyMode.INITIAL_COPY;
        }
        catch (FileNotFoundException fnf) {
            LOG.debug("Can not enable snapshot for path: {}", (Object)sourcePath, (Object)fnf);
            return SnapshotUtils.SnapshotCopyMode.FALLBACK_COPY;
        }
    }

    private void allowAndCreateInitialSnapshot(Path sourcePath, String snapshotPrefix, HiveConf conf, SnapshotUtils.ReplSnapshotCount replSnapshotCount, FileList snapPathFileList, DistributedFileSystem sourceDfs) throws IOException {
        SnapshotUtils.allowSnapshot(sourceDfs, sourcePath, conf);
        SnapshotUtils.createSnapshot((FileSystem)sourceDfs, sourcePath, SnapshotUtils.secondSnapshot(snapshotPrefix), conf);
        replSnapshotCount.incrementNumCreated();
        snapPathFileList.add(sourcePath.toString());
    }

    public static String externalTableLocation(HiveConf hiveConf, String location) throws SemanticException {
        Path basePath = ReplExternalTables.getExternalTableBaseDir(hiveConf);
        Path currentPath = new Path(location);
        Path dataLocation = ReplExternalTables.externalTableDataPath(hiveConf, basePath, currentPath);
        LOG.info("Incoming external table location: {} , new location: {}", (Object)location, (Object)dataLocation.toString());
        return dataLocation.toString();
    }

    public static Path getExternalTableBaseDir(HiveConf hiveConf) throws SemanticException {
        URI baseDirUri;
        String baseDir = hiveConf.get(HiveConf.ConfVars.REPL_EXTERNAL_TABLE_BASE_DIR.varname);
        URI uRI = baseDirUri = StringUtils.isEmpty(baseDir) ? null : new Path(baseDir).toUri();
        if (baseDirUri == null || baseDirUri.getScheme() == null || baseDirUri.getAuthority() == null) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(String.format("Fully qualified path for 'hive.repl.replica.external.table.base.dir' is required %s", baseDir == null ? "" : "- ('" + baseDir + "')"), "hive"));
        }
        return new Path(baseDirUri);
    }

    public static Path externalTableDataPath(HiveConf hiveConf, Path basePath, Path sourcePath) throws SemanticException {
        Path dataPath;
        String baseUriPath = basePath.toUri().getPath();
        String sourceUriPath = sourcePath.toUri().getPath();
        String targetPathWithoutSchemeAndAuth = "/".equalsIgnoreCase(baseUriPath) ? sourceUriPath : baseUriPath + sourceUriPath;
        try {
            dataPath = PathBuilder.fullyQualifiedHDFSUri(new Path(targetPathWithoutSchemeAndAuth), basePath.getFileSystem((Configuration)hiveConf));
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(ErrorMsg.INVALID_PATH.getMsg(), "hive"), e);
        }
        return dataPath;
    }
}

