/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Repl State Log", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplStateLogWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ReplLogger replLogger;
    private final LOG_TYPE logType;
    private String message = "";
    private String eventId;
    private String eventType;
    private String tableName;
    private TableType tableType;
    private String functionName;
    private String lastReplId;
    private boolean shouldFailover;
    String dumpDirectory;
    private final transient ReplicationMetricCollector metricCollector;

    public ReplStateLogWork(ReplLogger replLogger, ReplicationMetricCollector metricCollector, String eventId, String eventType) {
        this.logType = LOG_TYPE.EVENT;
        this.replLogger = replLogger;
        this.eventId = eventId;
        this.eventType = eventType;
        this.metricCollector = metricCollector;
    }

    public ReplStateLogWork(ReplLogger replLogger, ReplicationMetricCollector metricCollector, String eventId, String eventType, String dumpDirectory) {
        this.logType = LOG_TYPE.EVENT;
        this.replLogger = replLogger;
        this.eventId = eventId;
        this.eventType = eventType;
        this.metricCollector = metricCollector;
        this.dumpDirectory = dumpDirectory;
    }

    public ReplStateLogWork(ReplLogger replLogger, ReplicationMetricCollector metricCollector, String tableName, TableType tableType) {
        this.logType = LOG_TYPE.TABLE;
        this.replLogger = replLogger;
        this.tableName = tableName;
        this.tableType = tableType;
        this.metricCollector = metricCollector;
    }

    public ReplStateLogWork(ReplLogger replLogger, ReplicationMetricCollector metricCollector, String tableName, TableType tableType, String dumpDirectory) {
        this.logType = LOG_TYPE.TABLE;
        this.replLogger = replLogger;
        this.tableName = tableName;
        this.tableType = tableType;
        this.metricCollector = metricCollector;
        this.dumpDirectory = dumpDirectory;
    }

    public ReplStateLogWork(ReplLogger replLogger, String functionName, ReplicationMetricCollector metricCollector) {
        this.logType = LOG_TYPE.FUNCTION;
        this.replLogger = replLogger;
        this.functionName = functionName;
        this.metricCollector = metricCollector;
    }

    public ReplStateLogWork(ReplLogger replLogger, String functionName, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this.logType = LOG_TYPE.FUNCTION;
        this.replLogger = replLogger;
        this.functionName = functionName;
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public ReplStateLogWork(ReplLogger replLogger, Map<String, String> dbProps, String dumpDirectory, ReplicationMetricCollector collector, boolean shouldFailover) {
        this.logType = LOG_TYPE.END;
        this.replLogger = replLogger;
        this.lastReplId = ReplicationSpec.getLastReplicatedStateFromParameters(dbProps);
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = collector;
        this.shouldFailover = shouldFailover;
    }

    public ReplStateLogWork(ReplLogger replLogger, String message) {
        this.logType = LOG_TYPE.DATA_COPY_END;
        this.replLogger = replLogger;
        this.metricCollector = null;
        this.message = message;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public void replStateLog() throws SemanticException {
        switch (this.logType) {
            case TABLE: {
                this.replLogger.tableLog(this.tableName, this.tableType);
                this.metricCollector.reportStageProgress("REPL_LOAD", ReplUtils.MetricName.TABLES.name(), 1L);
                break;
            }
            case FUNCTION: {
                this.replLogger.functionLog(this.functionName);
                this.metricCollector.reportStageProgress("REPL_LOAD", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
                break;
            }
            case EVENT: {
                this.replLogger.eventLog(this.eventId, this.eventType);
                this.metricCollector.reportStageProgress("REPL_LOAD", ReplUtils.MetricName.EVENTS.name(), 1L);
                break;
            }
            case END: {
                this.replLogger.endLog(this.lastReplId);
                if (StringUtils.isEmpty(this.lastReplId) || "null".equalsIgnoreCase(this.lastReplId)) {
                    this.metricCollector.reportStageEnd("REPL_LOAD", Status.SUCCESS);
                } else {
                    this.metricCollector.reportStageEnd("REPL_LOAD", Status.SUCCESS, Long.parseLong(this.lastReplId), new SnapshotUtils.ReplSnapshotCount(), this.replLogger.getReplStatsTracker());
                }
                this.metricCollector.reportEnd(this.shouldFailover ? Status.FAILOVER_READY : Status.SUCCESS);
                break;
            }
            case DATA_COPY_END: {
                this.replLogger.dataCopyLog(this.message);
            }
        }
    }

    private static enum LOG_TYPE {
        TABLE,
        FUNCTION,
        EVENT,
        END,
        DATA_COPY_END;

    }
}

