/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.DatabaseEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.log.BootstrapLoadLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;

public class BootstrapEventsIterator
implements Iterator<BootstrapEvent> {
    private DatabaseEventsIterator currentDatabaseIterator = null;
    private Iterator<DatabaseEventsIterator> dbEventsIterator;
    private final String dumpDirectory;
    private final String dbNameToLoadIn;
    private final HiveConf hiveConf;
    private final boolean needLogger;
    private ReplLogger replLogger;
    private final transient ReplicationMetricCollector metricCollector;

    public BootstrapEventsIterator(String dumpDirectory, String dbNameToLoadIn, boolean needLogger, HiveConf hiveConf, ReplicationMetricCollector metricCollector) throws IOException {
        this.metricCollector = metricCollector;
        Path path = new Path(dumpDirectory);
        FileSystem fileSystem = path.getFileSystem((Configuration)hiveConf);
        if (!fileSystem.exists(path)) {
            throw new IllegalArgumentException("No data to load in path " + dumpDirectory);
        }
        FileStatus[] fileStatuses = fileSystem.listStatus(path, ReplUtils.getBootstrapDirectoryFilter(fileSystem));
        if (fileStatuses == null || fileStatuses.length == 0) {
            throw new IllegalArgumentException("No data to load in path " + dumpDirectory);
        }
        if (dbNameToLoadIn != null && fileStatuses.length > 1) {
            throw new IllegalArgumentException("Multiple dirs in " + dumpDirectory + " does not correspond to REPL LOAD expecting to load to a singular destination point.");
        }
        List dbsToCreate = Arrays.stream(fileStatuses).filter(f -> !f.getPath().getName().equals("_constraints")).collect(Collectors.toList());
        this.dbEventsIterator = dbsToCreate.stream().map(f -> {
            try {
                return new DatabaseEventsIterator(f.getPath(), hiveConf);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while creating event iterator for db at path" + f.getPath().toString(), e);
            }
        }).collect(Collectors.toList()).iterator();
        this.dumpDirectory = dumpDirectory;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.needLogger = needLogger;
        this.hiveConf = hiveConf;
        if (needLogger) {
            String dbName = StringUtils.isBlank(dbNameToLoadIn) ? "" : dbNameToLoadIn;
            this.replLogger = new BootstrapLoadLogger(dbName, dumpDirectory, 0L, 0L);
        }
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.currentDatabaseIterator == null) {
                if (this.dbEventsIterator.hasNext()) {
                    this.currentDatabaseIterator = this.dbEventsIterator.next();
                    if (this.needLogger) {
                        this.initReplLogger();
                    }
                    this.initMetricCollector();
                    continue;
                }
                return false;
            }
            if (this.currentDatabaseIterator.hasNext()) {
                return true;
            }
            this.currentDatabaseIterator = null;
        }
    }

    @Override
    public BootstrapEvent next() {
        return this.currentDatabaseIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void forEachRemaining(Consumer<? super BootstrapEvent> action) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public boolean currentDbHasNext() {
        return this.currentDatabaseIterator != null && this.currentDatabaseIterator.hasNext();
    }

    public void setReplicationState(ReplicationState replicationState) {
        this.currentDatabaseIterator.replicationState = replicationState;
    }

    public ReplLogger replLogger() {
        return this.replLogger;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    private void initReplLogger() {
        try {
            String dbName;
            Path dbDumpPath = this.currentDatabaseIterator.dbLevelPath();
            FileSystem fs = dbDumpPath.getFileSystem((Configuration)this.hiveConf);
            long numTables = this.getNumTables(dbDumpPath, fs);
            long numFunctions = this.getNumFunctions(dbDumpPath, fs);
            String string = dbName = StringUtils.isBlank(this.dbNameToLoadIn) ? dbDumpPath.getName() : this.dbNameToLoadIn;
            if (this.replLogger != null) {
                this.replLogger.setParams(dbName, this.dumpDirectory, numTables, numFunctions);
            } else {
                this.replLogger = new BootstrapLoadLogger(dbName, this.dumpDirectory, numTables, numFunctions);
            }
            this.replLogger.startLog();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private long getNumFunctions(Path dbDumpPath, FileSystem fs) throws IOException {
        Path funcPath = new Path(dbDumpPath, "_functions");
        if (fs.exists(funcPath)) {
            return this.getSubDirs(fs, funcPath).length;
        }
        return 0L;
    }

    private long getNumTables(Path dbDumpPath, FileSystem fs) throws IOException {
        return this.getSubDirs(fs, dbDumpPath).length;
    }

    private void initMetricCollector() {
        try {
            Path dbDumpPath = this.currentDatabaseIterator.dbLevelPath();
            FileSystem fs = dbDumpPath.getFileSystem((Configuration)this.hiveConf);
            long numTables = this.getNumTables(dbDumpPath, fs);
            long numFunctions = this.getNumFunctions(dbDumpPath, fs);
            HashMap<String, Long> metricMap = new HashMap<String, Long>();
            metricMap.put(ReplUtils.MetricName.TABLES.name(), numTables);
            metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), numFunctions);
            this.metricCollector.reportStageStart("REPL_LOAD", metricMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to collect Metrics ", e);
        }
    }

    FileStatus[] getSubDirs(FileSystem fs, Path dirPath) throws IOException {
        return fs.listStatus(dirPath, new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        });
    }
}

