/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.ranger;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerExportPolicyList;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerPolicy;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClient;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.util.MultiPartWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRestClientImpl
implements RangerRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRestClientImpl.class);
    private static final String RANGER_REST_URL_EXPORTJSONFILE = "service/plugins/policies/exportJson";
    private static final String RANGER_REST_URL_IMPORTJSONFILE = "service/plugins/policies/importPoliciesFromFile";
    private static final String RANGER_REST_URL_DELETEPOLICY = "service/public/v2/api/policy";

    @Override
    public RangerExportPolicyList exportRangerPolicies(String sourceRangerEndpoint, String dbName, String rangerHiveServiceName, HiveConf hiveConf) throws Exception {
        LOG.info("Ranger endpoint for cluster " + sourceRangerEndpoint);
        if (StringUtils.isEmpty(rangerHiveServiceName)) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format("Ranger Service Name cannot be empty", "ranger"));
        }
        String finalUrl = this.getRangerExportUrl(sourceRangerEndpoint, rangerHiveServiceName, dbName);
        LOG.debug("Url to export policies from source Ranger: {}", (Object)finalUrl);
        Retryable retryable = Retryable.builder().withHiveConf(hiveConf).withFailOnException(RuntimeException.class).withRetryOnException(Exception.class).build();
        try {
            return retryable.executeCallable(() -> this.exportRangerPoliciesPlain(finalUrl, hiveConf));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
        }
    }

    @VisibleForTesting
    RangerExportPolicyList exportRangerPoliciesPlain(String finalUrl, HiveConf hiveConf) throws Exception {
        WebResource.Builder builder = this.getRangerResourceBuilder(finalUrl, hiveConf);
        RangerExportPolicyList rangerExportPolicyList = new RangerExportPolicyList();
        ClientResponse clientResp = (ClientResponse)builder.get(ClientResponse.class);
        String response = null;
        if (clientResp != null) {
            if (clientResp.getStatus() == 200) {
                Gson gson = new GsonBuilder().create();
                response = (String)clientResp.getEntity(String.class);
                LOG.debug("Response received for ranger export {} ", (Object)response);
                if (StringUtils.isNotEmpty(response)) {
                    rangerExportPolicyList = (RangerExportPolicyList)gson.fromJson(response, RangerExportPolicyList.class);
                    return rangerExportPolicyList;
                }
            } else {
                if (clientResp.getStatus() == 204) {
                    LOG.debug("Ranger policy export request returned empty list");
                    return rangerExportPolicyList;
                }
                if (clientResp.getStatus() == 401) {
                    throw new RuntimeException(ErrorMsg.RANGER_AUTHENTICATION_FAILED.getMsg());
                }
                if (clientResp.getStatus() == 403) {
                    throw new RuntimeException(ErrorMsg.RANGER_AUTHORIZATION_FAILED.getMsg());
                }
            }
        }
        if (StringUtils.isEmpty(response)) {
            LOG.debug("Ranger policy export request returned empty list or failed, Please refer Ranger admin logs.");
        }
        return null;
    }

    public String getRangerExportUrl(String sourceRangerEndpoint, String rangerHiveServiceName, String dbName) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(sourceRangerEndpoint);
        uriBuilder.setPath(RANGER_REST_URL_EXPORTJSONFILE);
        uriBuilder.addParameter("serviceName", rangerHiveServiceName);
        uriBuilder.addParameter("polResource", dbName);
        uriBuilder.addParameter("resource:database", dbName);
        uriBuilder.addParameter("serviceType", "hive");
        uriBuilder.addParameter("resourceMatchScope", "self_or_ancestor");
        uriBuilder.addParameter("resourceMatch", "full");
        return uriBuilder.build().toString();
    }

    @Override
    public List<RangerPolicy> removeMultiResourcePolicies(List<RangerPolicy> rangerPolicies) {
        ArrayList<RangerPolicy> rangerPoliciesToImport = new ArrayList<RangerPolicy>();
        if (CollectionUtils.isNotEmpty(rangerPolicies)) {
            Map<String, RangerPolicy.RangerPolicyResource> rangerPolicyResourceMap = null;
            RangerPolicy.RangerPolicyResource rangerPolicyResource = null;
            List<String> resourceNameList = null;
            for (RangerPolicy rangerPolicy : rangerPolicies) {
                if (rangerPolicy == null || (rangerPolicyResourceMap = rangerPolicy.getResources()) == null || (rangerPolicyResource = rangerPolicyResourceMap.get("database")) == null || !CollectionUtils.isNotEmpty(resourceNameList = rangerPolicyResource.getValues()) || resourceNameList.size() != 1) continue;
                rangerPoliciesToImport.add(rangerPolicy);
            }
        }
        return rangerPoliciesToImport;
    }

    @Override
    public void deleteRangerPolicy(String policyName, String baseUrl, String rangerHiveServiceName, HiveConf hiveConf) throws Exception {
        String finalUrl = this.getRangerDeleteUrl(baseUrl, policyName, rangerHiveServiceName);
        LOG.debug("URL to delete policy on target Ranger: {}", (Object)finalUrl);
        Retryable retryable = Retryable.builder().withHiveConf(hiveConf).withFailOnException(RuntimeException.class).withRetryOnException(Exception.class).build();
        try {
            retryable.executeCallable(() -> {
                ClientResponse clientResp = null;
                WebResource.Builder builder = this.getRangerResourceBuilder(finalUrl, hiveConf);
                clientResp = (ClientResponse)builder.delete(ClientResponse.class);
                if (clientResp != null) {
                    switch (clientResp.getStatus()) {
                        case 204: {
                            LOG.debug("Ranger policy: {} deleted successfully", (Object)policyName);
                            break;
                        }
                        case 404: {
                            LOG.debug("Ranger policy: {} not found.", (Object)policyName);
                            break;
                        }
                        case 403: {
                            throw new RuntimeException(ErrorMsg.RANGER_AUTHORIZATION_FAILED.getMsg());
                        }
                        case 401: {
                            throw new RuntimeException(ErrorMsg.RANGER_AUTHENTICATION_FAILED.getMsg());
                        }
                        default: {
                            throw new SemanticException("Ranger policy deletion failed, Please refer target Ranger admin logs.");
                        }
                    }
                }
                return null;
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
        }
    }

    @Override
    public RangerExportPolicyList importRangerPolicies(RangerExportPolicyList rangerExportPolicyList, String dbName, String baseUrl, String rangerHiveServiceName, HiveConf hiveConf) throws Exception {
        String sourceClusterServiceName = null;
        String serviceMapJsonFileName = "hive_servicemap.json";
        String rangerPoliciesJsonFileName = "hive_replicationPolicies.json";
        if (!rangerExportPolicyList.getPolicies().isEmpty()) {
            sourceClusterServiceName = rangerExportPolicyList.getPolicies().get(0).getService();
        }
        if (StringUtils.isEmpty(sourceClusterServiceName)) {
            sourceClusterServiceName = rangerHiveServiceName;
        }
        LinkedHashMap<String, String> serviceMap = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty(sourceClusterServiceName) && !StringUtils.isEmpty(rangerHiveServiceName)) {
            serviceMap.put(sourceClusterServiceName, rangerHiveServiceName);
        }
        Gson gson = new GsonBuilder().create();
        String jsonServiceMap = gson.toJson(serviceMap);
        String jsonRangerExportPolicyList = gson.toJson((Object)rangerExportPolicyList);
        String finalUrl = this.getRangerImportUrl(baseUrl, dbName);
        LOG.debug("URL to import policies on target Ranger: {}", (Object)finalUrl);
        Retryable retryable = Retryable.builder().withHiveConf(hiveConf).withFailOnException(RuntimeException.class).withRetryOnException(Exception.class).build();
        try {
            return retryable.executeCallable(() -> this.importRangerPoliciesPlain(jsonRangerExportPolicyList, rangerPoliciesJsonFileName, serviceMapJsonFileName, jsonServiceMap, finalUrl, rangerExportPolicyList, hiveConf));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangerExportPolicyList importRangerPoliciesPlain(String jsonRangerExportPolicyList, String rangerPoliciesJsonFileName, String serviceMapJsonFileName, String jsonServiceMap, String finalUrl, RangerExportPolicyList rangerExportPolicyList, HiveConf hiveConf) throws Exception {
        block13: {
            ClientResponse clientResp = null;
            StreamDataBodyPart filePartPolicies = new StreamDataBodyPart("file", (InputStream)new ByteArrayInputStream(jsonRangerExportPolicyList.getBytes(StandardCharsets.UTF_8)), rangerPoliciesJsonFileName);
            StreamDataBodyPart filePartServiceMap = new StreamDataBodyPart("servicesMapJson", (InputStream)new ByteArrayInputStream(jsonServiceMap.getBytes(StandardCharsets.UTF_8)), serviceMapJsonFileName);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            MultiPart multipartEntity = null;
            try {
                multipartEntity = formDataMultiPart.bodyPart((BodyPart)filePartPolicies).bodyPart((BodyPart)filePartServiceMap);
                WebResource.Builder builder = this.getRangerResourceBuilder(finalUrl, hiveConf);
                clientResp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/json"})).type("multipart/form-data")).post(ClientResponse.class, (Object)multipartEntity);
                if (clientResp == null) break block13;
                if (clientResp.getStatus() == 204) {
                    LOG.debug("Ranger policy import finished successfully");
                    break block13;
                }
                if (clientResp.getStatus() == 401) {
                    throw new RuntimeException(ErrorMsg.RANGER_AUTHENTICATION_FAILED.getMsg());
                }
                throw new Exception("Ranger policy import failed, Please refer target Ranger admin logs.");
            }
            finally {
                try {
                    if (filePartPolicies != null) {
                        filePartPolicies.cleanup();
                    }
                    if (filePartServiceMap != null) {
                        filePartServiceMap.cleanup();
                    }
                    if (formDataMultiPart != null) {
                        formDataMultiPart.close();
                    }
                    if (multipartEntity != null) {
                        multipartEntity.close();
                    }
                }
                catch (IOException e) {
                    LOG.error("Exception occurred while closing resources: {}", (Throwable)e);
                }
            }
        }
        return rangerExportPolicyList;
    }

    public String getRangerImportUrl(String rangerUrl, String dbName) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(rangerUrl);
        uriBuilder.setPath(RANGER_REST_URL_IMPORTJSONFILE);
        uriBuilder.addParameter("updateIfExists", "true");
        uriBuilder.addParameter("polResource", dbName);
        uriBuilder.addParameter("policyMatchingAlgorithm", "matchByName");
        return uriBuilder.build().toString();
    }

    public String getRangerDeleteUrl(String rangerUrl, String policyName, String serviceName) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(rangerUrl);
        uriBuilder.setPath(RANGER_REST_URL_DELETEPOLICY);
        uriBuilder.addParameter("servicename", serviceName);
        uriBuilder.addParameter("policyname", policyName);
        return uriBuilder.build().toString();
    }

    @VisibleForTesting
    synchronized Client getRangerClient(HiveConf hiveConf) {
        Client ret = null;
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(MultiPartWriter.class);
        config.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        config.getProperties().put("com.sun.jersey.client.property.connectTimeout", (int)hiveConf.getTimeVar(HiveConf.ConfVars.REPL_EXTERNAL_CLIENT_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS));
        config.getProperties().put("com.sun.jersey.client.property.readTimeout", (int)hiveConf.getTimeVar(HiveConf.ConfVars.REPL_RANGER_CLIENT_READ_TIMEOUT, TimeUnit.MILLISECONDS));
        ret = Client.create((ClientConfig)config);
        return ret;
    }

    @Override
    public List<RangerPolicy> changeDataSet(List<RangerPolicy> rangerPolicies, String sourceDbName, String targetDbName) {
        if (StringUtils.isEmpty(sourceDbName) || StringUtils.isEmpty(targetDbName) || targetDbName.equals(sourceDbName)) {
            return rangerPolicies;
        }
        if (CollectionUtils.isNotEmpty(rangerPolicies)) {
            Map<String, RangerPolicy.RangerPolicyResource> rangerPolicyResourceMap = null;
            RangerPolicy.RangerPolicyResource rangerPolicyResource = null;
            List<String> resourceNameList = null;
            for (RangerPolicy rangerPolicy : rangerPolicies) {
                if (rangerPolicy == null || (rangerPolicyResourceMap = rangerPolicy.getResources()) == null || (rangerPolicyResource = rangerPolicyResourceMap.get("database")) == null || !CollectionUtils.isNotEmpty(resourceNameList = rangerPolicyResource.getValues())) continue;
                for (int i = 0; i < resourceNameList.size(); ++i) {
                    String resourceName = resourceNameList.get(i);
                    if (!resourceName.equals(sourceDbName)) continue;
                    resourceNameList.set(i, targetDbName);
                }
            }
        }
        return rangerPolicies;
    }

    private Path writeExportedRangerPoliciesToJsonFile(String jsonString, String fileName, Path stagingDirPath, HiveConf conf) throws IOException {
        String filePath = "";
        Path newPath = null;
        FSDataOutputStream outStream = null;
        OutputStreamWriter writer = null;
        try {
            FileSystem fileSystem;
            if (!StringUtils.isEmpty(jsonString) && (fileSystem = stagingDirPath.getFileSystem((Configuration)conf)) != null) {
                if (!fileSystem.exists(stagingDirPath)) {
                    fileSystem.mkdirs(stagingDirPath);
                }
                newPath = stagingDirPath.suffix(File.separator + fileName);
                outStream = fileSystem.create(newPath, true);
                writer = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
                writer.write(jsonString);
            }
        }
        catch (IOException ex) {
            if (newPath != null) {
                filePath = newPath.toString();
            }
            throw new IOException("Failed to write json string to file:" + filePath, ex);
        }
        catch (Exception ex) {
            if (newPath != null) {
                filePath = newPath.toString();
            }
            throw new IOException("Failed to write json string to file:" + filePath, ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception ex) {
                throw new IOException("Unable to close writer/outStream.", ex);
            }
        }
        return newPath;
    }

    @Override
    public Path saveRangerPoliciesToFile(RangerExportPolicyList rangerExportPolicyList, Path stagingDirPath, String fileName, HiveConf conf) throws SemanticException {
        Gson gson = new GsonBuilder().create();
        String jsonRangerExportPolicyList = gson.toJson((Object)rangerExportPolicyList);
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).build();
        try {
            return retryable.executeCallable(() -> this.writeExportedRangerPoliciesToJsonFile(jsonRangerExportPolicyList, fileName, stagingDirPath, conf));
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
        }
    }

    @Override
    public RangerExportPolicyList readRangerPoliciesFromJsonFile(Path filePath, HiveConf conf) throws SemanticException {
        RangerExportPolicyList rangerExportPolicyList = null;
        Gson gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
        try {
            FileSystem fs = filePath.getFileSystem((Configuration)conf);
            FSDataInputStream inputStream = fs.open(filePath);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8"));
            rangerExportPolicyList = (RangerExportPolicyList)gsonBuilder.fromJson((Reader)reader, RangerExportPolicyList.class);
        }
        catch (FileNotFoundException e) {
            return rangerExportPolicyList;
        }
        catch (Exception ex) {
            throw new SemanticException("Error reading file :" + filePath, ex);
        }
        return rangerExportPolicyList;
    }

    @Override
    public boolean checkConnection(String url, HiveConf hiveConf) throws SemanticException {
        Retryable retryable = Retryable.builder().withHiveConf(hiveConf).withRetryOnException(Exception.class).build();
        try {
            return retryable.executeCallable(() -> this.checkConnectionPlain(url, hiveConf));
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
        }
    }

    @VisibleForTesting
    boolean checkConnectionPlain(String url, HiveConf hiveConf) {
        WebResource.Builder builder = this.getRangerResourceBuilder(url, hiveConf);
        ClientResponse clientResp = (ClientResponse)builder.get(ClientResponse.class);
        return clientResp.getStatus() < 401;
    }

    @Override
    public RangerPolicy getDenyPolicyForReplicatedDb(String rangerServiceName, String sourceDb, String targetDb) throws SemanticException {
        if (StringUtils.isEmpty(rangerServiceName)) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format("Ranger Service Name cannot be empty", "ranger"));
        }
        RangerPolicy denyRangerPolicy = new RangerPolicy();
        denyRangerPolicy.setService(rangerServiceName);
        denyRangerPolicy.setName(sourceDb + "_replication deny policy for " + targetDb);
        HashMap<String, RangerPolicy.RangerPolicyResource> rangerPolicyResourceMap = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        RangerPolicy.RangerPolicyResource rangerPolicyResource = new RangerPolicy.RangerPolicyResource();
        ArrayList<String> resourceNameList = new ArrayList<String>();
        List<RangerPolicy.RangerPolicyItem> denyPolicyItemsForPublicGroup = denyRangerPolicy.getDenyPolicyItems();
        RangerPolicy.RangerPolicyItem denyPolicyItem = new RangerPolicy.RangerPolicyItem();
        ArrayList<RangerPolicy.RangerPolicyItemAccess> denyPolicyItemAccesses = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        List<RangerPolicy.RangerPolicyItem> denyExceptionsItemsForBeaconUser = denyRangerPolicy.getDenyExceptions();
        RangerPolicy.RangerPolicyItem denyExceptionsPolicyItem = new RangerPolicy.RangerPolicyItem();
        ArrayList<RangerPolicy.RangerPolicyItemAccess> denyExceptionsPolicyItemAccesses = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        resourceNameList.add(targetDb);
        resourceNameList.add("dummy");
        rangerPolicyResource.setValues(resourceNameList);
        RangerPolicy.RangerPolicyResource rangerPolicyResourceColumn = new RangerPolicy.RangerPolicyResource();
        rangerPolicyResourceColumn.setValues((List<String>)new ArrayList<String>(){
            {
                this.add("*");
            }
        });
        RangerPolicy.RangerPolicyResource rangerPolicyResourceTable = new RangerPolicy.RangerPolicyResource();
        rangerPolicyResourceTable.setValues((List<String>)new ArrayList<String>(){
            {
                this.add("*");
            }
        });
        rangerPolicyResourceMap.put("database", rangerPolicyResource);
        rangerPolicyResourceMap.put("table", rangerPolicyResourceTable);
        rangerPolicyResourceMap.put("column", rangerPolicyResourceColumn);
        denyRangerPolicy.setResources(rangerPolicyResourceMap);
        List<String> accessTypes = Arrays.asList("create", "update", "drop", "alter", "index", "lock", "write", "ReplAdmin");
        for (String access : accessTypes) {
            denyPolicyItemAccesses.add(new RangerPolicy.RangerPolicyItemAccess(access, true));
        }
        denyPolicyItem.setAccesses(denyPolicyItemAccesses);
        denyPolicyItemsForPublicGroup.add(denyPolicyItem);
        ArrayList<String> denyPolicyItemsGroups = new ArrayList<String>();
        denyPolicyItemsGroups.add("public");
        denyPolicyItem.setGroups(denyPolicyItemsGroups);
        denyRangerPolicy.setDenyPolicyItems(denyPolicyItemsForPublicGroup);
        List<String> denyExcludeAccessTypes = Arrays.asList("create", "update", "drop", "alter", "index", "lock", "write", "ReplAdmin", "select", "read");
        for (String access : denyExcludeAccessTypes) {
            denyExceptionsPolicyItemAccesses.add(new RangerPolicy.RangerPolicyItemAccess(access, true));
        }
        denyExceptionsPolicyItem.setAccesses(denyExceptionsPolicyItemAccesses);
        denyExceptionsItemsForBeaconUser.add(denyExceptionsPolicyItem);
        ArrayList<String> denyExceptionsPolicyItemsUsers = new ArrayList<String>();
        denyExceptionsPolicyItemsUsers.add("hive");
        denyExceptionsPolicyItem.setUsers(denyExceptionsPolicyItemsUsers);
        denyRangerPolicy.setDenyExceptions(denyExceptionsItemsForBeaconUser);
        return denyRangerPolicy;
    }

    private WebResource.Builder getRangerResourceBuilder(String url, HiveConf hiveConf) {
        Client client = this.getRangerClient(hiveConf);
        WebResource webResource = client.resource(url);
        WebResource.Builder builder = webResource.getRequestBuilder();
        return builder;
    }
}

