/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpTask;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(SnapshotUtils.class);
    public static final String OLD_SNAPSHOT = "replOld";
    public static final String NEW_SNAPSHOT = "replNew";

    public static DistributedFileSystem getDFS(Path path, HiveConf conf) throws IOException {
        FileSystem fs = path.getFileSystem((Configuration)conf);
        if (fs instanceof DistributedFileSystem) {
            return (DistributedFileSystem)fs;
        }
        LOG.error("FileSystem for {} is not DistributedFileSystem", (Object)path);
        throw new IOException("The filesystem for path {} is {}, The filesystem should be DistributedFileSystem to support snapshot based copy.");
    }

    public static boolean isSnapshotAvailable(DistributedFileSystem dfs, Path path, String snapshotPrefix, String snapshotName, HiveConf conf) throws IOException {
        AtomicBoolean isSnapAvlb = new AtomicBoolean(false);
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).withFailOnException(SnapshotException.class).build();
        try {
            retryable.executeCallable(() -> {
                isSnapAvlb.set(dfs.exists(new Path(path, ".snapshot/" + snapshotPrefix + snapshotName)));
                LOG.debug("Snapshot for path {} is {}", (Object)path, (Object)(isSnapAvlb.get() ? "available" : "unavailable"));
                return null;
            });
        }
        catch (Exception e) {
            throw new SnapshotException("Failed to check if snapshot is available on " + path, (Throwable)e);
        }
        return isSnapAvlb.get();
    }

    public static boolean deleteSnapshotSafe(DistributedFileSystem dfs, Path snapshotPath, String snapshotName) throws IOException {
        try {
            dfs.deleteSnapshot(snapshotPath, snapshotName);
            return true;
        }
        catch (SnapshotException e) {
            LOG.debug("Couldn't delete the snapshot {} under path {}", new Object[]{snapshotName, snapshotPath, e});
        }
        catch (FileNotFoundException fnf) {
            LOG.warn("Couldn't delete the snapshot {} under path {}", new Object[]{snapshotName, snapshotPath, fnf});
        }
        return false;
    }

    public static boolean deleteSnapshotIfExists(DistributedFileSystem fs, Path snapshotPath, String snapshotName, HiveConf conf) throws IOException {
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).withFailOnException(SnapshotException.class).build();
        try {
            retryable.executeCallable(() -> {
                block4: {
                    try {
                        if (fs.exists(new Path(snapshotPath, ".snapshot/" + snapshotName))) {
                            fs.deleteSnapshot(snapshotPath, snapshotName);
                        }
                    }
                    catch (FileNotFoundException e) {
                        LOG.warn("Couldn't create the snapshot {} under path {}. It doesn't exist", new Object[]{snapshotName, snapshotPath, e});
                    }
                    catch (SnapshotException e) {
                        if (!e.getMessage().contains("the snapshot does not exist") && !e.getMessage().contains("Directory is not a snapshottable directory")) break block4;
                        return true;
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new SnapshotException("Unable to delete snapshot for path: " + snapshotPath + " snapshot name: " + snapshotName, (Throwable)e);
        }
        return true;
    }

    public static void disallowSnapshot(DistributedFileSystem dfs, Path snapshotPath) {
        try {
            if (dfs.getFileStatus(snapshotPath).isSnapshotEnabled()) {
                dfs.disallowSnapshot(snapshotPath);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not disallow snapshot for path {}", (Object)snapshotPath, (Object)e);
        }
    }

    public static void allowSnapshot(DistributedFileSystem dfs, Path snapshotPath, HiveConf conf) throws IOException {
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).withFailOnException(SnapshotException.class).build();
        try {
            retryable.executeCallable(() -> {
                try {
                    if (!dfs.getFileStatus(snapshotPath).isSnapshotEnabled()) {
                        dfs.allowSnapshot(snapshotPath);
                    }
                }
                catch (FileNotFoundException fnf) {
                    LOG.info("Failed to allow snapshot for {} since the path got deleted", (Object)snapshotPath);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new SnapshotException("Failed to AllowSnapshot on " + snapshotPath, (Throwable)e);
        }
    }

    public static void createSnapshot(FileSystem fs, Path snapshotPath, String snapshotName, HiveConf conf) throws IOException {
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).withFailOnException(SnapshotException.class).build();
        try {
            retryable.executeCallable(() -> {
                try {
                    fs.createSnapshot(snapshotPath, snapshotName);
                }
                catch (FileNotFoundException e) {
                    LOG.warn("Couldn't create the snapshot {} under path {}", new Object[]{snapshotName, snapshotPath, e});
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new SnapshotException("Unable to create snapshot for path: " + snapshotPath + " snapshot name: " + snapshotName, (Throwable)e);
        }
    }

    public static void renameSnapshot(FileSystem fs, Path snapshotPath, String sourceSnapshotName, String targetSnapshotName, HiveConf conf) throws IOException {
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).withFailOnException(SnapshotException.class).build();
        try {
            retryable.executeCallable(() -> {
                try {
                    fs.renameSnapshot(snapshotPath, sourceSnapshotName, targetSnapshotName);
                }
                catch (FileNotFoundException e) {
                    LOG.warn("Couldn't rename the snapshot {} to {} under path {}", new Object[]{sourceSnapshotName, targetSnapshotName, snapshotPath, e});
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new SnapshotException("Unable to rename snapshot " + sourceSnapshotName + " to " + targetSnapshotName + " for path: " + snapshotPath, (Throwable)e);
        }
    }

    public static ArrayList<String> getListFromFileList(FileList fl) {
        ArrayList<String> result = new ArrayList<String>();
        while (fl.hasNext()) {
            result.add(fl.next());
        }
        return result;
    }

    private static void cleanUpSnapshots(DistributedFileSystem dfs, ArrayList<String> diffList, String prefix, ReplSnapshotCount snapshotCount, HiveConf conf) throws IOException {
        for (String path : diffList) {
            Path snapshotPath = new Path(path);
            boolean isFirstDeleted = SnapshotUtils.deleteSnapshotIfExists(dfs, snapshotPath, SnapshotUtils.firstSnapshot(prefix), conf);
            boolean isSecondDeleted = SnapshotUtils.deleteSnapshotIfExists(dfs, snapshotPath, SnapshotUtils.secondSnapshot(prefix), conf);
            SnapshotUtils.disallowSnapshot(dfs, snapshotPath);
            if (snapshotCount == null) continue;
            if (isFirstDeleted) {
                snapshotCount.incrementNumDeleted();
            }
            if (!isSecondDeleted) continue;
            snapshotCount.incrementNumDeleted();
        }
    }

    private static ArrayList<String> getDiffList(ArrayList<String> newList, ArrayList<String> oldList, HiveConf conf, boolean isLoad) throws SemanticException {
        ArrayList<String> diffList = new ArrayList<String>();
        for (String oldPath : oldList) {
            if (newList.contains(oldPath)) continue;
            if (isLoad) {
                diffList.add(ReplExternalTables.externalTableDataPath(conf, ReplExternalTables.getExternalTableBaseDir(conf), new Path(oldPath)).toString());
            } else {
                diffList.add(oldPath);
            }
            diffList.add(oldPath);
        }
        return diffList;
    }

    public static void cleanupSnapshots(Path dumpRoot, String snapshotPrefix, HiveConf conf, ReplSnapshotCount snapshotCount, boolean isLoad) throws IOException, SemanticException {
        DistributedFileSystem dfs = (DistributedFileSystem)dumpRoot.getFileSystem((Configuration)conf);
        if (dfs.exists(new Path(dumpRoot, "_file_list_external_old"))) {
            FileList snapOld = ReplDumpTask.createTableFileList(dumpRoot, "_file_list_external_old", conf);
            FileList snapNew = ReplDumpTask.createTableFileList(dumpRoot, "_file_list_external_current", conf);
            ArrayList<String> oldPaths = SnapshotUtils.getListFromFileList(snapOld);
            ArrayList<String> newPaths = SnapshotUtils.getListFromFileList(snapNew);
            ArrayList<String> diffList = SnapshotUtils.getDiffList(newPaths, oldPaths, conf, isLoad);
            dfs = isLoad ? (DistributedFileSystem)ReplExternalTables.getExternalTableBaseDir(conf).getFileSystem((Configuration)conf) : dfs;
            SnapshotUtils.cleanUpSnapshots(dfs, diffList, snapshotPrefix, snapshotCount, conf);
        }
        if (isLoad) {
            try {
                dfs.delete(new Path(dumpRoot, "_file_list_external_old"), true);
            }
            catch (FileNotFoundException fnf) {
                LOG.warn("Failed to clean up snapshot _file_list_external_old", (Throwable)fnf);
            }
            try {
                dfs.rename(new Path(dumpRoot, "_file_list_external_current"), new Path(dumpRoot, "_file_list_external_old"), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            catch (FileNotFoundException fnf) {
                LOG.warn("Failed to clean up snapshot _file_list_external_current", (Throwable)fnf);
            }
        }
    }

    public static Path getSnapshotFileListPath(Path dumpRoot) {
        return dumpRoot.getParent().getParent().getParent();
    }

    public static String firstSnapshot(String prefix) {
        return prefix + OLD_SNAPSHOT;
    }

    public static String secondSnapshot(String prefix) {
        return prefix + NEW_SNAPSHOT;
    }

    public static class ReplSnapshotCount {
        AtomicInteger numCreated = new AtomicInteger(0);
        AtomicInteger numDeleted = new AtomicInteger(0);

        public void incrementNumCreated() {
            this.numCreated.incrementAndGet();
        }

        public void incrementNumDeleted() {
            this.numDeleted.incrementAndGet();
        }

        public int getNumCreated() {
            return this.numCreated.get();
        }

        public int getNumDeleted() {
            return this.numCreated.get();
        }

        public String toString() {
            return "ReplSnapshotCount{numCreated=" + this.numCreated + ", numDeleted=" + this.numDeleted + '}';
        }
    }

    public static enum SnapshotCopyMode {
        INITIAL_COPY,
        DIFF_COPY,
        FALLBACK_COPY;

    }
}

