/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSession;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.apache.hadoop.hive.ql.wm.TriggerActionHandler;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillTriggerActionHandler
implements TriggerActionHandler<TezSession> {
    private static final Logger LOG = LoggerFactory.getLogger(KillTriggerActionHandler.class);

    @Override
    public void applyAction(Map<TezSession, Trigger> queriesViolated) {
        block5: for (Map.Entry<TezSession, Trigger> entry : queriesViolated.entrySet()) {
            switch (entry.getValue().getAction().getType()) {
                case KILL_QUERY: {
                    TezSession sessionState = entry.getKey();
                    try {
                        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                        SessionState ss = new SessionState(new HiveConf(), ugi.getShortUserName());
                        ss.setIsHiveServerQuery(true);
                        SessionState.start(ss);
                        boolean wasKilled = sessionState.killQuery(entry.getValue().getViolationMsg());
                        if (wasKilled) continue block5;
                        LOG.info("Didn't kill the query {}", (Object)sessionState.getWmContext().getQueryId());
                    }
                    catch (IOException | HiveException e) {
                        LOG.warn("Unable to kill query {} for trigger violation", (Object)sessionState.getWmContext().getQueryId());
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported action: " + entry.getValue());
                }
            }
        }
    }
}

