/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.KeyValuesAdapter;
import org.apache.hadoop.hive.ql.exec.tez.KeyValuesFromKeyValue;
import org.apache.hadoop.hive.ql.exec.tez.KeyValuesFromKeyValues;
import org.apache.hadoop.hive.ql.exec.tez.RecordSource;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceRecordSource
implements RecordSource {
    public static final Logger l4j = LoggerFactory.getLogger(ReduceRecordSource.class);
    private static final String CLASS_NAME = ReduceRecordSource.class.getName();
    private byte tag;
    private boolean abort = false;
    private Deserializer inputKeyDeserializer;
    private AbstractSerDe inputValueDeserializer;
    private TableDesc keyTableDesc;
    private TableDesc valueTableDesc;
    private ObjectInspector rowObjectInspector;
    private Operator<?> reducer;
    private Object keyObject = null;
    private BytesWritable groupKey;
    private boolean vectorized = false;
    private VectorDeserializeRow<BinarySortableDeserializeRead> keyBinarySortableDeserializeToRow;
    private VectorDeserializeRow<LazyBinaryDeserializeRead> valueLazyBinaryDeserializeToRow;
    private VectorizedRowBatch batch;
    private int firstValueColumnOffset;
    private final int BATCH_BYTES = 0x2000000;
    private StructObjectInspector keyStructInspector;
    private StructObjectInspector valueStructInspectors;
    private KeyValuesAdapter reader;
    private boolean handleGroupKey;
    private ObjectInspector valueObjectInspector;
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private Iterable<Object> valueWritables;
    private final GroupIterator groupIterator = new GroupIterator();
    private long vectorizedVertexNum;
    private int vectorizedTestingReducerBatchSize;
    private boolean flushLastRecord = false;

    void init(JobConf jconf, Operator<?> reducer, boolean vectorized, TableDesc keyTableDesc, TableDesc valueTableDesc, Reader reader, boolean handleGroupKey, byte tag, VectorizedRowBatchCtx batchContext, long vectorizedVertexNum, int vectorizedTestingReducerBatchSize) throws Exception {
        this.vectorizedVertexNum = vectorizedVertexNum;
        if (vectorizedTestingReducerBatchSize > 1024) {
            vectorizedTestingReducerBatchSize = 1024;
        }
        this.vectorizedTestingReducerBatchSize = vectorizedTestingReducerBatchSize;
        this.reducer = reducer;
        this.vectorized = vectorized;
        this.keyTableDesc = keyTableDesc;
        this.reader = reader instanceof KeyValueReader ? new KeyValuesFromKeyValue((KeyValueReader)reader) : new KeyValuesFromKeyValues((KeyValuesReader)reader);
        this.handleGroupKey = handleGroupKey;
        this.tag = tag;
        try {
            this.inputKeyDeserializer = (Deserializer)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe(this.inputKeyDeserializer, null, keyTableDesc.getProperties(), null);
            ObjectInspector keyObjectInspector = this.inputKeyDeserializer.getObjectInspector();
            if (vectorized) {
                this.keyStructInspector = (StructObjectInspector)keyObjectInspector;
                this.firstValueColumnOffset = this.keyStructInspector.getAllStructFieldRefs().size();
            }
            this.valueTableDesc = valueTableDesc;
            this.inputValueDeserializer = (AbstractSerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe(this.inputValueDeserializer, null, valueTableDesc.getProperties(), null);
            this.valueObjectInspector = this.inputValueDeserializer.getObjectInspector();
            ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
            if (vectorized) {
                this.valueStructInspectors = (StructObjectInspector)this.valueObjectInspector;
                int totalColumns = this.firstValueColumnOffset + this.valueStructInspectors.getAllStructFieldRefs().size();
                this.rowObjectInspector = Utilities.constructVectorizedReduceRowOI(this.keyStructInspector, this.valueStructInspectors);
                this.batch = batchContext.createVectorizedRowBatch();
                BinarySortableSerDe binarySortableSerDe = (BinarySortableSerDe)this.inputKeyDeserializer;
                this.keyBinarySortableDeserializeToRow = new VectorDeserializeRow<BinarySortableDeserializeRead>(new BinarySortableDeserializeRead(VectorizedBatchUtil.typeInfosFromStructObjectInspector(this.keyStructInspector), true, binarySortableSerDe.getSortOrders(), binarySortableSerDe.getNullMarkers(), binarySortableSerDe.getNotNullMarkers()));
                this.keyBinarySortableDeserializeToRow.init(0);
                int valuesSize = this.valueStructInspectors.getAllStructFieldRefs().size();
                if (valuesSize > 0) {
                    this.valueLazyBinaryDeserializeToRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(VectorizedBatchUtil.typeInfosFromStructObjectInspector(this.valueStructInspectors), true));
                    this.valueLazyBinaryDeserializeToRow.init(this.firstValueColumnOffset);
                    for (int i = this.firstValueColumnOffset; i < this.batch.numCols; ++i) {
                        ColumnVector colVector = this.batch.cols[i];
                        if (!(colVector instanceof BytesColumnVector)) continue;
                        BytesColumnVector bytesColumnVector = (BytesColumnVector)colVector;
                        bytesColumnVector.initBuffer();
                    }
                }
            } else {
                ois.add(keyObjectInspector);
                ois.add(this.valueObjectInspector);
                this.rowObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, ois);
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezInitializeOperators");
    }

    @Override
    public final boolean isGrouped() {
        return this.vectorized;
    }

    @Override
    public boolean pushRecord() throws HiveException {
        if (this.vectorized) {
            return this.pushRecordVector();
        }
        if (this.groupIterator.hasNext()) {
            this.groupIterator.next();
            return true;
        }
        try {
            if (!this.reader.next()) {
                if (this.flushLastRecord) {
                    this.reducer.flushRecursive();
                }
                return false;
            }
            BytesWritable keyWritable = (BytesWritable)this.reader.getCurrentKey();
            this.valueWritables = this.reader.getCurrentValues();
            try {
                this.keyObject = this.inputKeyDeserializer.deserialize((Writable)keyWritable);
            }
            catch (Exception e) {
                throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input key from " + Utilities.formatBinaryString(keyWritable.getBytes(), 0, keyWritable.getLength()) + " with properties " + this.keyTableDesc.getProperties(), e);
            }
            if (this.handleGroupKey && !keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    this.reducer.endGroup();
                }
                this.groupKey.set(keyWritable.getBytes(), 0, keyWritable.getLength());
                this.reducer.startGroup();
                this.reducer.setGroupKeyObject(this.keyObject);
            }
            this.groupIterator.initialize(this.valueWritables, this.keyObject, this.tag);
            if (this.groupIterator.hasNext()) {
                this.groupIterator.next();
            }
            return true;
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.error(StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private Object deserializeValue(BytesWritable valueWritable, byte tag) throws HiveException {
        try {
            return this.inputValueDeserializer.deserialize((Writable)valueWritable);
        }
        catch (SerDeException e) {
            throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(valueWritable.getBytes(), 0, valueWritable.getLength()) + " with properties " + this.valueTableDesc.getProperties(), e);
        }
    }

    private boolean pushRecordVector() {
        try {
            if (!this.reader.next()) {
                return false;
            }
            BytesWritable keyWritable = (BytesWritable)this.reader.getCurrentKey();
            this.valueWritables = this.reader.getCurrentValues();
            this.processVectorGroup(keyWritable, this.valueWritables, this.tag);
            return true;
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.error(StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private void processVectorGroup(BytesWritable keyWritable, Iterable<Object> values, byte tag) throws HiveException, IOException {
        Preconditions.checkState(this.batch.size == 0);
        byte[] keyBytes = keyWritable.getBytes();
        int keyLength = keyWritable.getLength();
        this.keyBinarySortableDeserializeToRow.setBytes(keyBytes, 0, keyLength);
        try {
            this.keyBinarySortableDeserializeToRow.deserialize(this.batch, 0);
        }
        catch (Exception e) {
            throw new HiveException("\nDeserializeRead details: " + this.keyBinarySortableDeserializeToRow.getDetailedReadPositionString(), e);
        }
        for (int i = 0; i < this.firstValueColumnOffset; ++i) {
            VectorizedBatchUtil.setRepeatingColumn(this.batch, i);
        }
        int maxSize = this.vectorizedTestingReducerBatchSize > 0 ? Math.min(this.vectorizedTestingReducerBatchSize, this.batch.getMaxSize()) : this.batch.getMaxSize();
        Preconditions.checkState(maxSize > 0);
        int rowIdx = 0;
        int batchBytes = keyBytes.length;
        try {
            for (Object value : values) {
                if (rowIdx >= maxSize || rowIdx > 0 && batchBytes >= 0x2000000) {
                    this.batch.size = rowIdx;
                    if (this.handleGroupKey) {
                        this.reducer.setNextVectorBatchGroupStatus(false);
                    }
                    this.reducer.process(this.batch, tag);
                    this.batch.selectedInUse = false;
                    this.batch.size = 0;
                    this.batch.endOfFile = false;
                    for (int i = this.firstValueColumnOffset; i < this.batch.numCols; ++i) {
                        this.batch.cols[i].reset();
                    }
                    rowIdx = 0;
                    batchBytes = keyBytes.length;
                }
                if (this.valueLazyBinaryDeserializeToRow != null) {
                    BytesWritable valueWritable = (BytesWritable)value;
                    byte[] valueBytes = valueWritable.getBytes();
                    int valueLength = valueWritable.getLength();
                    batchBytes += valueLength;
                    this.valueLazyBinaryDeserializeToRow.setBytes(valueBytes, 0, valueLength);
                    this.valueLazyBinaryDeserializeToRow.deserialize(this.batch, rowIdx);
                }
                ++rowIdx;
            }
            if (rowIdx > 0) {
                this.batch.size = rowIdx;
                if (this.handleGroupKey) {
                    this.reducer.setNextVectorBatchGroupStatus(true);
                }
                this.reducer.process(this.batch, tag);
            }
            this.batch.reset();
        }
        catch (Exception e) {
            String rowString = null;
            try {
                rowString = this.batch.toString();
            }
            catch (Exception e2) {
                rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            l4j.error("Hive Runtime Error while processing vector batch (tag=" + tag + ") (vectorizedVertexNum " + this.vectorizedVertexNum + ") " + rowString, (Throwable)e);
            throw new HiveException("Hive Runtime Error while processing vector batch (tag=" + tag + ") (vectorizedVertexNum " + this.vectorizedVertexNum + ")", e);
        }
    }

    boolean close() throws Exception {
        block3: {
            try {
                if (this.handleGroupKey && this.groupKey != null) {
                    this.reducer.endGroup();
                }
            }
            catch (Exception e) {
                if (this.abort) break block3;
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        return this.abort;
    }

    public ObjectInspector getObjectInspector() {
        return this.rowObjectInspector;
    }

    public void setFlushLastRecord(boolean flushLastRecord) {
        this.flushLastRecord = flushLastRecord;
    }

    private class GroupIterator {
        private final List<Object> row = new ArrayList<Object>(Utilities.reduceFieldNameList.size());
        private List<Object> passDownKey = null;
        private Iterator<Object> values;
        private byte tag;
        private Object keyObject;

        private GroupIterator() {
        }

        public void initialize(Iterable<Object> values, Object keyObject, byte tag) {
            this.passDownKey = null;
            this.values = values.iterator();
            this.tag = tag;
            this.keyObject = keyObject;
        }

        public boolean hasNext() {
            return this.values != null && this.values.hasNext();
        }

        public void next() throws HiveException {
            this.row.clear();
            Object value = this.values.next();
            BytesWritable valueWritable = (BytesWritable)value;
            if (this.passDownKey == null) {
                this.row.add(this.keyObject);
            } else {
                this.row.add(this.passDownKey.get(0));
            }
            if (this.passDownKey == null && ReduceRecordSource.this.reducer instanceof CommonMergeJoinOperator && this.hasNext()) {
                this.passDownKey = (List)ObjectInspectorUtils.copyToStandardObject(this.row, ReduceRecordSource.this.reducer.getInputObjInspectors()[this.tag], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                this.row.remove(0);
                this.row.add(0, this.passDownKey.get(0));
            }
            this.row.add(ReduceRecordSource.this.deserializeValue(valueWritable, this.tag));
            try {
                ReduceRecordSource.this.reducer.process(this.row, this.tag);
            }
            catch (Exception e) {
                String rowString = null;
                try {
                    rowString = SerDeUtils.getJSONString(this.row, ReduceRecordSource.this.rowObjectInspector);
                }
                catch (Exception e2) {
                    rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
                }
                l4j.trace("Hive Runtime Error while processing row (tag=" + this.tag + ") " + rowString);
                throw new HiveException("Hive Runtime Error while processing row", e);
            }
        }
    }
}

