/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.SessionExpirationTracker;
import org.apache.hadoop.hive.ql.exec.tez.TezSession;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.hive.registry.impl.TezAmInstance;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class TezSessionPoolSession
implements TezSession {
    protected static final Logger LOG = LoggerFactory.getLogger(TezSessionPoolSession.class);
    private static final int STATE_NONE = 0;
    private static final int STATE_IN_USE = 1;
    private static final int STATE_EXPIRED = 2;
    private final AtomicInteger sessionState = new AtomicInteger(0);
    private Long expirationNs;
    private final Manager manager;
    private final SessionExpirationTracker expirationTracker;
    private final TezSession baseSession;

    public TezSessionPoolSession(Manager manager, SessionExpirationTracker tracker, TezSession superr) {
        this.baseSession = superr;
        this.manager = manager;
        this.expirationTracker = tracker;
    }

    void setExpirationNs(long expirationNs) {
        this.expirationNs = expirationNs;
    }

    Long getExpirationNs() {
        return this.expirationNs;
    }

    @Override
    public void close(boolean keepTmpDir) throws Exception {
        try {
            this.baseSession.close(keepTmpDir);
        }
        finally {
            this.manager.unregisterOpenSession(this);
            if (this.expirationTracker != null) {
                this.expirationTracker.removeFromExpirationQueue(this);
            }
        }
    }

    @Override
    public void open(String[] additionalFilesNotFromConf) throws LoginException, IOException, URISyntaxException, TezException {
        this.baseSession.open(additionalFilesNotFromConf);
        this.afterOpen();
    }

    @Override
    public void open() throws IOException, LoginException, URISyntaxException, TezException {
        this.baseSession.open();
        this.afterOpen();
    }

    @Override
    public void open(boolean isPoolInit) throws IOException, LoginException, URISyntaxException, TezException {
        this.baseSession.open(isPoolInit);
        this.afterOpen();
    }

    private void afterOpen() {
        this.manager.registerOpenSession(this);
        if (this.expirationTracker != null) {
            boolean isNotExpired = this.expirationTracker.addToExpirationQueue(this, 0L);
            assert (isNotExpired);
        }
    }

    @Override
    public boolean reconnect(String applicationId, long amAgeMs) throws IOException, LoginException, URISyntaxException, TezException {
        if (this.expirationTracker != null && !this.expirationTracker.isOldAmUsable(amAgeMs)) {
            this.closeExpiredOnReconnect(applicationId);
            return false;
        }
        if (!this.baseSession.reconnect(applicationId, amAgeMs)) {
            return false;
        }
        this.manager.registerOpenSession(this);
        if (this.expirationTracker != null && !this.expirationTracker.addToExpirationQueue(this, amAgeMs)) {
            this.closeExpiredOnReconnect(applicationId);
            return false;
        }
        return true;
    }

    private void closeExpiredOnReconnect(String applicationId) {
        LOG.warn("Not using an old AM due to expiration timeout: " + applicationId);
        try {
            this.close(false);
        }
        catch (Exception e) {
            LOG.info("Failed to close the old AM", (Throwable)e);
        }
    }

    @Override
    public void open(TezSession.HiveResources resources) throws LoginException, IOException, URISyntaxException, TezException {
        this.baseSession.open(resources);
        this.afterOpen();
    }

    @Override
    public void beginOpen(String[] additionalFiles, SessionState.LogHelper console) throws IOException, LoginException, URISyntaxException, TezException {
        this.baseSession.beginOpen(additionalFiles, console);
        this.afterOpen();
    }

    @Override
    public void endOpen() throws InterruptedException, CancellationException {
        this.baseSession.endOpen();
    }

    @Override
    public void ensureLocalResources(Configuration conf, String[] newFilesNotFromConf) throws IOException, LoginException, URISyntaxException, TezException {
        this.baseSession.ensureLocalResources(conf, newFilesNotFromConf);
    }

    @Override
    public TezSession.HiveResources extractHiveResources() {
        return this.baseSession.extractHiveResources();
    }

    @Override
    public Path replaceHiveResources(TezSession.HiveResources resources, boolean isAsync) {
        return this.baseSession.replaceHiveResources(resources, isAsync);
    }

    @Override
    public boolean killQuery(String reason) throws HiveException {
        return this.baseSession.killQuery(reason);
    }

    public boolean tryUse(boolean ignoreExpiration) {
        int finalState;
        do {
            int oldValue;
            if ((oldValue = this.sessionState.get()) == 1) {
                throw new AssertionError((Object)(this + " is already in use"));
            }
            if (oldValue != 2) continue;
            return false;
        } while (!this.sessionState.compareAndSet(0, finalState = !ignoreExpiration && this.shouldExpire() ? 2 : 1));
        if (finalState == 1) {
            return true;
        }
        this.expirationTracker.closeAndRestartExpiredSessionAsync(this);
        return false;
    }

    boolean stopUsing() {
        int finalState;
        int n = finalState = this.shouldExpire() ? 2 : 0;
        if (!this.sessionState.compareAndSet(1, finalState)) {
            throw new AssertionError((Object)("Unexpected state change; currently " + this.sessionState.get()));
        }
        if (finalState == 0) {
            return true;
        }
        this.expirationTracker.closeAndRestartExpiredSessionAsync(this);
        return false;
    }

    public boolean tryExpire(boolean isAsync) throws Exception {
        if (this.expirationNs == null) {
            return true;
        }
        if (!this.shouldExpire()) {
            return false;
        }
        do {
            if (this.sessionState.get() == 0) continue;
            return true;
        } while (!this.sessionState.compareAndSet(0, 2));
        if (isAsync) {
            this.expirationTracker.closeAndRestartExpiredSessionAsync(this);
        } else {
            this.expirationTracker.closeAndRestartExpiredSession(this);
        }
        return true;
    }

    private final boolean shouldExpire() {
        return this.expirationNs != null && System.nanoTime() - this.expirationNs >= 0L;
    }

    @Override
    public void returnToSessionManager() throws Exception {
        this.manager.returnAfterUse(this);
    }

    @Override
    public TezSession reopen() throws Exception {
        return this.manager.reopen(this);
    }

    @Override
    public void destroy() throws Exception {
        this.manager.destroy(this);
    }

    public boolean isOwnedBy(Manager parent) {
        return this.manager == parent;
    }

    public void updateFromRegistry(TezAmInstance si, int ephSeqVersion) {
    }

    public String toString() {
        return this.baseSession.toString() + this.getExpirationString();
    }

    private String getExpirationString() {
        if (this.expirationNs == null) {
            return "";
        }
        long expiresInMs = (this.expirationNs - System.nanoTime()) / 1000000L;
        return ", expires in " + expiresInMs + "ms";
    }

    @Override
    public HiveConf getConf() {
        return this.baseSession.getConf();
    }

    @Override
    public String getSessionId() {
        return this.baseSession.getSessionId();
    }

    @Override
    public String getUser() {
        return this.baseSession.getUser();
    }

    @Override
    public boolean isOpen() {
        return this.baseSession.isOpen();
    }

    @Override
    public void setQueueName(String queueName) {
        this.baseSession.setQueueName(queueName);
    }

    @Override
    public String getQueueName() {
        return this.baseSession.getQueueName();
    }

    @Override
    public void setDefault() {
        this.baseSession.setDefault();
    }

    @Override
    public boolean isDefault() {
        return this.baseSession.isDefault();
    }

    @Override
    public boolean getDoAsEnabled() {
        return this.baseSession.getDoAsEnabled();
    }

    @Override
    public boolean getLegacyLlapMode() {
        return this.baseSession.getLegacyLlapMode();
    }

    @Override
    public void setLegacyLlapMode(boolean b) {
        this.baseSession.setLegacyLlapMode(b);
    }

    @Override
    public WmContext getWmContext() {
        return this.baseSession.getWmContext();
    }

    @Override
    public void setWmContext(WmContext ctx) {
        this.baseSession.setWmContext(ctx);
    }

    @Override
    public LocalResource getAppJarLr() {
        return this.baseSession.getAppJarLr();
    }

    @Override
    public List<LocalResource> getLocalizedResources() {
        return this.baseSession.getLocalizedResources();
    }

    @Override
    public TezClient getTezClient() {
        return this.baseSession.getTezClient();
    }

    @Override
    public boolean isOpening() {
        return this.baseSession.isOpening();
    }

    @Override
    public void setOwnerThread() {
        this.baseSession.setOwnerThread();
    }

    @Override
    public void unsetOwnerThread() {
        this.baseSession.unsetOwnerThread();
    }

    @Override
    public void setKillQuery(KillQuery kq) {
        this.baseSession.setKillQuery(kq);
    }

    public static interface Manager {
        public void registerOpenSession(TezSessionPoolSession var1);

        public void unregisterOpenSession(TezSessionPoolSession var1);

        public void returnAfterUse(TezSessionPoolSession var1) throws Exception;

        public TezSession reopen(TezSession var1) throws Exception;

        public void destroy(TezSession var1) throws Exception;
    }
}

