/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUnaryUDFDirect;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;

public class CastCharToBinary
extends StringUnaryUDFDirect {
    private static final long serialVersionUID = 1L;
    private int maxLength;

    public CastCharToBinary(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    public CastCharToBinary() {
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        this.maxLength = ((CharTypeInfo)this.inputTypeInfos[0]).getLength();
    }

    @Override
    protected void func(BytesColumnVector outV, byte[][] vector, int[] start, int[] length, int i) {
        StringExpr.padRight(outV, i, vector[i], start[i], length[i], this.maxLength);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn) + ", maxLength " + this.maxLength;
    }
}

