/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDecimalInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColumnInList
extends VectorExpression
implements IDecimalInExpr {
    private static final long serialVersionUID = 1L;
    private final int inputColumn;
    private HiveDecimal[] inListValues;
    private transient HashSet<HiveDecimalWritable> inSet;

    public DecimalColumnInList() {
        this.inputColumn = -1;
    }

    public DecimalColumnInList(int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.inputColumn = colNum;
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        this.inSet = new HashSet(this.inListValues.length);
        for (HiveDecimal val : this.inListValues) {
            this.inSet.add(new HiveDecimalWritable(val));
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColumnVector = (DecimalColumnVector)batch.cols[this.inputColumn];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        HiveDecimalWritable[] vector = inputColumnVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColumnVector.isRepeating) {
            if (inputColumnVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = this.inSet.contains(vector[0]) ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    outputVector[i] = this.inSet.contains(vector[i]) ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public void setInListValues(HiveDecimal[] a) {
        this.inListValues = a;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn) + ", values " + Arrays.toString(this.inListValues);
    }
}

