/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateAddScalarCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private Object object;
    private long longValue = 0L;
    private Timestamp timestampValue = null;
    private byte[] stringValue = null;
    protected boolean isPositive = true;
    private final transient Date baseDate = new Date();
    private transient PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;

    public VectorUDFDateAddScalarCol() {
        this.colNum = -1;
    }

    public VectorUDFDateAddScalarCol(Object object, int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.object = object;
        if (object instanceof Long) {
            this.longValue = (Long)object;
        } else if (object instanceof Timestamp) {
            this.timestampValue = (Timestamp)object;
        } else if (object instanceof byte[]) {
            this.stringValue = (byte[])object;
        } else {
            throw new RuntimeException("Unexpected scalar object " + object.getClass().getName() + " " + object.toString());
        }
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        this.primitiveCategory = ((PrimitiveTypeInfo)this.inputTypeInfos[0]).getPrimitiveCategory();
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputCol = (LongColumnVector)batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outputColVector.isNull;
        switch (this.primitiveCategory) {
            case DATE: {
                this.baseDate.setTimeInMillis(DateWritableV2.daysToMillis((int)this.longValue));
                break;
            }
            case TIMESTAMP: {
                this.baseDate.setTimeInMillis(this.timestampValue.getTime());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                boolean parsed = DateParser.parseDate(new String(this.stringValue, StandardCharsets.UTF_8), this.baseDate);
                if (parsed) break;
                outputColVector.noNulls = false;
                if (selectedInUse) {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        outputColVector.isNull[i] = true;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        outputColVector.isNull[i] = true;
                    }
                }
                return;
            }
            default: {
                throw new Error("Unsupported input type " + this.primitiveCategory.name());
            }
        }
        if (batch.size == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        long baseDateDays = DateWritableV2.millisToDays(this.baseDate.toEpochMilli());
        if (inputCol.isRepeating) {
            if (inputCol.noNulls || !inputCol.isNull[0]) {
                outputColVector.isNull[0] = false;
                this.evaluate(baseDateDays, inputCol.vector[0], outputColVector, 0);
            } else {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputCol.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outputColVector.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(baseDateDays, inputCol.vector[i], outputColVector, i);
                }
            }
        }
    }

    private void evaluate(long baseDateDays, long numDays, LongColumnVector output, int i) {
        long result = baseDateDays;
        result = this.isPositive ? (result += numDays) : (result -= numDays);
        output.vector[i] = result;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public byte[] getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(byte[] stringValue) {
        this.stringValue = stringValue;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public void setPositive(boolean isPositive) {
        this.isPositive = isPositive;
    }

    @Override
    public String vectorExpressionParameters() {
        String value;
        if (this.object instanceof Long) {
            Date tempDate = new Date();
            tempDate.setTimeInMillis(DateWritableV2.daysToMillis((int)this.longValue));
            value = tempDate.toString();
        } else {
            value = this.object instanceof Timestamp ? org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli(this.timestampValue.getTime(), this.timestampValue.getNanos()).toString() : (this.object instanceof byte[] ? new String(this.stringValue, StandardCharsets.UTF_8) : "unknown");
        }
        return "val " + value + ", " + this.getColumnParamString(0, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

