/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LongColGreaterEqualDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final int colNum1;
    protected final int colNum2;

    public LongColGreaterEqualDoubleColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public LongColGreaterEqualDoubleColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        DoubleColumnVector inputColVector2 = (DoubleColumnVector)batch.cols[this.colNum2];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        long[] vector1 = inputColVector1.vector;
        double[] vector2 = inputColVector2.vector;
        long[] outputVector = outputColVector.vector;
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            outputVector[0] = (double)vector1[0] >= vector2[0] ? 1L : 0L;
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (double)vector1[0] >= vector2[i] ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (double)vector1[0] >= vector2[i] ? 1L : 0L;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (double)vector1[i] >= vector2[0] ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (double)vector1[i] >= vector2[0] ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = (double)vector1[i] >= vector2[i] ? 1L : 0L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = (double)vector1[i] >= vector2[i] ? 1L : 0L;
            }
        }
        NullUtil.setNullDataEntriesLong(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

