/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashKeyRef;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public class VectorMapJoinFastBytesHashMultiSetStore
implements MemoryEstimate {
    private WriteBuffers writeBuffers;

    public WriteBuffers getWriteBuffers() {
        return this.writeBuffers;
    }

    public long addFirst(long partialHashCode, byte[] keyBytes, int keyStart, int keyLength) {
        boolean isKeyLengthBig;
        this.writeBuffers.write(MultiSetCount.oneCount);
        long absoluteOffset = this.writeBuffers.getWritePoint();
        boolean bl = isKeyLengthBig = keyLength >= 255;
        if (isKeyLengthBig) {
            this.writeBuffers.writeVInt(keyLength);
        }
        this.writeBuffers.write(keyBytes, keyStart, keyLength);
        long refWord = partialHashCode;
        refWord |= absoluteOffset << 15;
        refWord = isKeyLengthBig ? (refWord |= 0x3FC0000000000000L) : (refWord |= (long)keyLength << 54);
        return refWord |= 0x4000000000000000L;
    }

    public long bumpCount(long refWord, WriteBuffers.Position unsafeReadPos) {
        long countAbsoluteOffset = VectorMapJoinFastBytesHashKeyRef.KeyRef.getAbsoluteOffset(refWord) - 4L;
        int currentCount = this.writeBuffers.readInt(countAbsoluteOffset, unsafeReadPos);
        long saveAbsoluteOffset = this.writeBuffers.getWritePoint();
        this.writeBuffers.setWritePoint(countAbsoluteOffset);
        this.writeBuffers.writeInt(countAbsoluteOffset, currentCount + 1);
        this.writeBuffers.setWritePoint(saveAbsoluteOffset);
        return refWord &= 0xBFFFFFFFFFFFFFFFL;
    }

    public VectorMapJoinFastBytesHashMultiSetStore(int writeBuffersSize) {
        this.writeBuffers = new WriteBuffers(writeBuffersSize, 0x2000000000L);
    }

    @Override
    public long getEstimatedMemorySize() {
        long size = 0L;
        return size += this.writeBuffers == null ? 0L : this.writeBuffers.getEstimatedMemorySize();
    }

    private static final class MultiSetCount {
        private static final int byteLength = 4;
        private static final byte[] oneCount = new byte[]{0, 0, 0, 1};

        private MultiSetCount() {
        }
    }

    public static class HashMultiSetResult
    extends VectorMapJoinHashMultiSetResult {
        private VectorMapJoinFastBytesHashMultiSetStore multiSetStore;
        private int keyLength;
        private boolean isSingleCount;
        private long refWord = -1L;
        private long absoluteOffset;
        private WriteBuffers.Position readPos = new WriteBuffers.Position();

        public void setKey(VectorMapJoinFastBytesHashMultiSetStore multiSetStore, long refWord) {
            boolean isKeyLengthSmall;
            this.multiSetStore = multiSetStore;
            this.refWord = refWord;
            this.absoluteOffset = VectorMapJoinFastBytesHashKeyRef.KeyRef.getAbsoluteOffset(refWord);
            multiSetStore.writeBuffers.setReadPoint(this.absoluteOffset, this.readPos);
            this.keyLength = VectorMapJoinFastBytesHashKeyRef.KeyRef.getSmallKeyLength(refWord);
            boolean bl = isKeyLengthSmall = this.keyLength != 255;
            if (!isKeyLengthSmall) {
                this.keyLength = multiSetStore.writeBuffers.readVInt(this.readPos);
            }
        }

        public boolean equalKey(byte[] keyBytes, int keyStart, int keyLength) {
            if (this.keyLength != keyLength) {
                return false;
            }
            return this.multiSetStore.writeBuffers.isEqual(keyBytes, keyStart, this.readPos, keyLength);
        }

        public void setContains() {
            this.isSingleCount = VectorMapJoinFastBytesHashKeyRef.KeyRef.getIsSingleFlag(this.refWord);
            this.count = this.isSingleCount ? 1L : (long)this.multiSetStore.writeBuffers.readInt(this.absoluteOffset - 4L, this.readPos);
            this.setJoinResult(JoinUtil.JoinResult.MATCH);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(" + super.toString() + ", ");
            sb.append("count " + this.count + ")");
            return sb.toString();
        }
    }
}

