/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorCount;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public abstract class VectorPTFEvaluatorCountDistinct
extends VectorPTFEvaluatorCount {
    protected Set<Object> uniqueObjects;

    public VectorPTFEvaluatorCountDistinct(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        ColumnVector colVector = batch.cols[this.inputColumnNum];
        if (colVector.isRepeating) {
            if (colVector.noNulls || !colVector.isNull[0]) {
                this.countValue(colVector, 0);
            }
        } else {
            boolean[] batchIsNull = colVector.isNull;
            for (int i = 0; i < size; ++i) {
                if (batchIsNull[i]) continue;
                this.countValue(colVector, i);
            }
        }
    }

    protected void countValue(ColumnVector colVector, int i) {
        Object value = this.getValue(colVector, i);
        this.uniqueObjects.add(value);
    }

    protected abstract Object getValue(ColumnVector var1, int var2);

    @Override
    public long getLongGroupResult() {
        return this.uniqueObjects.size();
    }

    @Override
    public void resetEvaluator() {
        super.resetEvaluator();
        this.uniqueObjects = new HashSet<Object>();
    }
}

