/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorStreamingDecimalSum
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected HiveDecimalWritable sum = new HiveDecimalWritable();

    public VectorPTFEvaluatorStreamingDecimalSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        if (decimalColVector.isRepeating) {
            if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                this.isNull = false;
                HiveDecimalWritable repeatedValue = decimalColVector.vector[0];
                for (int i = 0; i < size; ++i) {
                    this.sum.mutateAdd(repeatedValue);
                    outputColVector.set(i, this.sum);
                }
            } else {
                if (this.isNull) {
                    outputColVector.isNull[0] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputColVector.set(0, this.sum);
                }
                outputColVector.isRepeating = true;
            }
        } else if (decimalColVector.noNulls) {
            this.isNull = false;
            HiveDecimalWritable[] vector = decimalColVector.vector;
            for (int i = 0; i < size; ++i) {
                this.sum.mutateAdd(vector[i]);
                outputColVector.set(i, this.sum);
            }
        } else {
            boolean[] batchIsNull = decimalColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (this.isNull) {
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputColVector.set(i, this.sum);
                }
                if (++i < size) continue;
                return;
            }
            this.isNull = false;
            HiveDecimalWritable[] vector = decimalColVector.vector;
            this.sum.mutateAdd(vector[i++]);
            outputColVector.set(i, this.sum);
            while (i < size) {
                if (!batchIsNull[i]) {
                    this.sum.mutateAdd(vector[i]);
                    outputColVector.set(i, this.sum);
                } else {
                    outputColVector.set(i, this.sum);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.sum.set(HiveDecimal.ZERO);
    }
}

