/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorStreamingDoubleMax
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected double max;

    public VectorPTFEvaluatorStreamingDoubleMax(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        double[] outputVector = outputColVector.vector;
        if (doubleColVector.isRepeating) {
            if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                double repeatedMax = doubleColVector.vector[0];
                if (this.isNull) {
                    this.max = repeatedMax;
                    this.isNull = false;
                } else if (repeatedMax > this.max) {
                    this.max = repeatedMax;
                }
                outputVector[0] = this.max;
            } else if (this.isNull) {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            } else {
                outputVector[0] = this.max;
            }
            outputColVector.isRepeating = true;
        } else if (doubleColVector.noNulls) {
            double[] vector = doubleColVector.vector;
            for (int i = 0; i < size; ++i) {
                double value = vector[i];
                if (this.isNull) {
                    this.max = value;
                    this.isNull = false;
                } else if (value > this.max) {
                    this.max = value;
                }
                outputVector[i] = this.max;
            }
        } else {
            boolean[] batchIsNull = doubleColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (this.isNull) {
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[i] = this.max;
                }
                if (++i < size) continue;
                return;
            }
            double[] vector = doubleColVector.vector;
            double firstValue = vector[i];
            if (this.isNull) {
                this.max = firstValue;
                this.isNull = false;
            } else if (firstValue > this.max) {
                this.max = firstValue;
            }
            outputVector[i++] = this.max;
            while (i < size) {
                if (!batchIsNull[i]) {
                    double value = vector[i];
                    if (this.isNull) {
                        this.max = value;
                        this.isNull = false;
                    } else if (value > this.max) {
                        this.max = value;
                    }
                    outputVector[i] = this.max;
                } else {
                    outputVector[i] = this.max;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.max = 0.0;
    }
}

