/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class AccurateEstimatesCheckerHook
extends AbstractSemanticAnalyzerHook {
    private double absErr;
    private double relErr;

    private void ensureEstimateAcceptable(long numRows, long runTimeNumRows) throws HiveException {
        double a;
        double currentDelta = Math.abs(runTimeNumRows - numRows);
        if (currentDelta <= this.absErr) {
            return;
        }
        if (runTimeNumRows > 0L && (a = currentDelta / (double)runTimeNumRows) <= this.relErr) {
            return;
        }
        throw new HiveException("Estimation error is unacceptable " + numRows + " / " + runTimeNumRows + " with absErr:" + this.absErr + ", relErr:" + this.relErr);
    }

    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<?>> rootTasks) throws SemanticException {
        HiveSemanticAnalyzerHookContext hookContext = context;
        HiveConf conf = (HiveConf)hookContext.getConf();
        this.absErr = conf.getDouble("accurate.estimate.checker.absolute.error", 3.0);
        this.relErr = conf.getDouble("accurate.estimate.checker.relative.error", 0.1);
        ArrayList<Node> rootOps = Lists.newArrayList();
        List<Task<?>> roots = rootTasks;
        for (Task<?> task0 : roots) {
            if (!(task0 instanceof ExplainTask)) continue;
            ExplainTask explainTask = (ExplainTask)task0;
            ExplainWork w = (ExplainWork)explainTask.getWork();
            List<Task<?>> explainRoots = w.getRootTasks();
            for (Task<?> task : explainRoots) {
                Object work = task.getWork();
                if (work instanceof MapredWork) {
                    ReduceWork reduceWork;
                    MapredWork mapredWork = (MapredWork)work;
                    MapWork mapWork = mapredWork.getMapWork();
                    if (mapWork != null) {
                        rootOps.addAll(mapWork.getAllRootOperators());
                    }
                    if ((reduceWork = mapredWork.getReduceWork()) != null) {
                        rootOps.addAll(reduceWork.getAllRootOperators());
                    }
                }
                if (!(work instanceof TezWork)) continue;
                for (BaseWork bw : ((TezWork)work).getAllWorkUnsorted()) {
                    rootOps.addAll(bw.getAllRootOperators());
                }
            }
        }
        if (rootOps.isEmpty()) {
            return;
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new EstimateCheckerHook(), new HashMap<Rule, NodeProcessor>(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
        ogw.startWalking(rootOps, nodeOutput);
    }

    class EstimateCheckerHook
    implements NodeProcessor {
        Map<String, Operator<?>> opMap = new HashMap();

        EstimateCheckerHook() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            Statistics stats = op.getStatistics();
            if (stats != null && stats.getRunTimeNumRows() >= 0L) {
                try {
                    AccurateEstimatesCheckerHook.this.ensureEstimateAcceptable(stats.getNumRows(), stats.getRunTimeNumRows());
                }
                catch (HiveException e) {
                    throw new SemanticException("On operator: " + op, e);
                }
            }
            return null;
        }
    }
}

