/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.io.arrow.Deserializer;
import org.apache.hadoop.hive.ql.io.arrow.RootAllocatorFactory;
import org.apache.hadoop.hive.ql.io.arrow.Serializer;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowColumnarBatchSerDe
extends AbstractSerDe {
    public static final Logger LOG = LoggerFactory.getLogger((String)ArrowColumnarBatchSerDe.class.getName());
    private static final String DEFAULT_ARROW_FIELD_NAME = "[DEFAULT]";
    static final int MILLIS_PER_SECOND = 1000;
    static final int MICROS_PER_SECOND = 1000000;
    static final int NS_PER_SECOND = 1000000000;
    static final int NS_PER_MILLIS = 1000000;
    static final int NS_PER_MICROS = 1000;
    static final int MICROS_PER_MILLIS = 1000;
    static final int SECOND_PER_DAY = 86400;
    BufferAllocator rootAllocator;
    StructTypeInfo rowTypeInfo;
    StructObjectInspector rowObjectInspector;
    Configuration conf;
    @VisibleForTesting
    Serializer serializer;
    private Deserializer deserializer;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.conf = conf;
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        String columnNameDelimiter = tbl.containsKey("column.name.delimiter") ? tbl.getProperty("column.name.delimiter") : String.valueOf(',');
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(columnNameDelimiter));
        ArrayList<TypeInfo> columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        this.rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        this.rowObjectInspector = (StructObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(this.rowTypeInfo);
        ArrayList<Field> fields = new ArrayList<Field>();
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            fields.add(ArrowColumnarBatchSerDe.toField((String)columnNames.get(i), (TypeInfo)columnTypes.get(i)));
        }
    }

    private static Field toField(String name, TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.BIT.getType());
                    }
                    case BYTE: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.TINYINT.getType());
                    }
                    case SHORT: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.SMALLINT.getType());
                    }
                    case INT: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.INT.getType());
                    }
                    case LONG: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.BIGINT.getType());
                    }
                    case FLOAT: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.FLOAT4.getType());
                    }
                    case DOUBLE: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.FLOAT8.getType());
                    }
                    case STRING: 
                    case VARCHAR: 
                    case CHAR: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.VARCHAR.getType());
                    }
                    case DATE: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.DATEDAY.getType());
                    }
                    case TIMESTAMP: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.TIMESTAMPMILLI.getType());
                    }
                    case TIMESTAMPLOCALTZ: {
                        TimestampLocalTZTypeInfo timestampLocalTZTypeInfo = (TimestampLocalTZTypeInfo)typeInfo;
                        String timeZone = timestampLocalTZTypeInfo.getTimeZone().toString();
                        return Field.nullable((String)name, (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, timeZone));
                    }
                    case BINARY: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.VARBINARY.getType());
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                        int precision = decimalTypeInfo.precision();
                        int scale = decimalTypeInfo.scale();
                        return Field.nullable((String)name, (ArrowType)new ArrowType.Decimal(precision, scale));
                    }
                    case INTERVAL_YEAR_MONTH: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.INTERVALYEAR.getType());
                    }
                    case INTERVAL_DAY_TIME: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.INTERVALDAY.getType());
                    }
                }
                throw new IllegalArgumentException();
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeInfo elementTypeInfo = listTypeInfo.getListElementTypeInfo();
                return new Field(name, FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), Lists.newArrayList(ArrowColumnarBatchSerDe.toField(DEFAULT_ARROW_FIELD_NAME, elementTypeInfo)));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList<Field> structFields = Lists.newArrayList();
                int structSize = fieldNames.size();
                for (int i = 0; i < structSize; ++i) {
                    structFields.add(ArrowColumnarBatchSerDe.toField((String)fieldNames.get(i), (TypeInfo)fieldTypeInfos.get(i)));
                }
                return new Field(name, FieldType.nullable((ArrowType)Types.MinorType.MAP.getType()), structFields);
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                ArrayList<Field> unionFields = Lists.newArrayList();
                int unionSize = unionFields.size();
                for (int i = 0; i < unionSize; ++i) {
                    unionFields.add(ArrowColumnarBatchSerDe.toField(DEFAULT_ARROW_FIELD_NAME, objectTypeInfos.get(i)));
                }
                return new Field(name, FieldType.nullable((ArrowType)Types.MinorType.UNION.getType()), unionFields);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeInfo keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
                StructTypeInfo mapStructTypeInfo = new StructTypeInfo();
                mapStructTypeInfo.setAllStructFieldNames(Lists.newArrayList("keys", "values"));
                mapStructTypeInfo.setAllStructFieldTypeInfos(Lists.newArrayList(keyTypeInfo, valueTypeInfo));
                ListTypeInfo mapListStructTypeInfo = new ListTypeInfo();
                mapListStructTypeInfo.setListElementTypeInfo(mapStructTypeInfo);
                return ArrowColumnarBatchSerDe.toField(name, mapListStructTypeInfo);
            }
        }
        throw new IllegalArgumentException();
    }

    static ListTypeInfo toStructListTypeInfo(MapTypeInfo mapTypeInfo) {
        StructTypeInfo structTypeInfo = new StructTypeInfo();
        structTypeInfo.setAllStructFieldNames(Lists.newArrayList("keys", "values"));
        structTypeInfo.setAllStructFieldTypeInfos(Lists.newArrayList(mapTypeInfo.getMapKeyTypeInfo(), mapTypeInfo.getMapValueTypeInfo()));
        ListTypeInfo structListTypeInfo = new ListTypeInfo();
        structListTypeInfo.setListElementTypeInfo(structTypeInfo);
        return structListTypeInfo;
    }

    static ListColumnVector toStructListVector(MapColumnVector mapVector) {
        StructColumnVector structVector = new StructColumnVector();
        structVector.fields = new ColumnVector[]{mapVector.keys, mapVector.values};
        ListColumnVector structListVector = new ListColumnVector();
        structListVector.child = structVector;
        structListVector.childCount = mapVector.childCount;
        structListVector.isRepeating = mapVector.isRepeating;
        structListVector.noNulls = mapVector.noNulls;
        System.arraycopy(mapVector.offsets, 0, structListVector.offsets, 0, mapVector.childCount);
        System.arraycopy(mapVector.lengths, 0, structListVector.lengths, 0, mapVector.childCount);
        return structListVector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return ArrowWrapperWritable.class;
    }

    public ArrowWrapperWritable serialize(Object obj, ObjectInspector objInspector) {
        if (this.serializer == null) {
            try {
                this.rootAllocator = RootAllocatorFactory.INSTANCE.getRootAllocator(this.conf);
                this.serializer = new Serializer(this);
            }
            catch (Exception e) {
                LOG.error("Unable to initialize serializer for ArrowColumnarBatchSerDe");
                throw new RuntimeException(e);
            }
        }
        return this.serializer.serialize(obj, objInspector);
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    @Override
    public Object deserialize(Writable writable) {
        if (this.deserializer == null) {
            try {
                this.rootAllocator = RootAllocatorFactory.INSTANCE.getRootAllocator(this.conf);
                this.deserializer = new Deserializer(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.deserializer.deserialize(writable);
    }

    @Override
    public ObjectInspector getObjectInspector() {
        return this.rowObjectInspector;
    }
}

