/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.BatchToRowReader;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.RecordReader;

public class OrcOiBatchToRowReader
extends BatchToRowReader<OrcStruct, OrcUnion>
implements AcidInputFormat.AcidRecordReader<NullWritable, Object> {
    private final RecordIdentifier recordIdentifier = new RecordIdentifier();
    private boolean isNull = true;

    public OrcOiBatchToRowReader(RecordReader<NullWritable, VectorizedRowBatch> vrbReader, VectorizedRowBatchCtx vrbCtx, List<Integer> includedCols) {
        super(vrbReader, vrbCtx, includedCols);
    }

    @Override
    protected OrcStruct createStructObject(Object previous, List<TypeInfo> childrenTypes) {
        int numChildren = childrenTypes.size();
        if (previous == null || !(previous instanceof OrcStruct)) {
            return new OrcStruct(numChildren);
        }
        OrcStruct result = (OrcStruct)previous;
        result.setNumFields(numChildren);
        return result;
    }

    @Override
    protected int getStructLength(OrcStruct structObj) {
        return structObj.getNumFields();
    }

    @Override
    protected OrcUnion createUnionObject(List<TypeInfo> childrenTypes, Object previous) {
        return previous instanceof OrcUnion ? (OrcUnion)previous : new OrcUnion();
    }

    @Override
    protected void setStructCol(OrcStruct structObj, int i, Object value) {
        structObj.setFieldValue(i, value);
    }

    @Override
    protected Object getStructCol(OrcStruct structObj, int i) {
        return structObj.getFieldValue(i);
    }

    @Override
    protected Object getUnionField(OrcUnion unionObj) {
        return unionObj.getObject();
    }

    @Override
    protected void setUnion(OrcUnion unionObj, byte tag, Object object) {
        unionObj.set(tag, object);
    }

    @Override
    protected void populateRecordIdentifier(OrcStruct rowId) {
        if (rowId == null) {
            this.isNull = true;
            return;
        }
        this.recordIdentifier.setValues(((LongWritable)rowId.getFieldValue(RecordIdentifier.Field.writeId.ordinal())).get(), ((IntWritable)rowId.getFieldValue(RecordIdentifier.Field.bucketId.ordinal())).get(), ((LongWritable)rowId.getFieldValue(RecordIdentifier.Field.rowId.ordinal())).get());
        this.isNull = false;
    }

    @Override
    public RecordIdentifier getRecordIdentifier() {
        return this.isNull ? null : this.recordIdentifier;
    }
}

