/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.IllegalCacheConfigurationException;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.common.util.Ref;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.impl.OrcTail;
import org.apache.orc.impl.SchemaEvolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedOrcAcidRowBatchReader
implements org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedOrcAcidRowBatchReader.class);
    private org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> baseReader;
    private final VectorizedRowBatchCtx rbCtx;
    private VectorizedRowBatch vectorizedRowBatchBase;
    private long offset;
    private long length;
    protected float progress = 0.0f;
    protected Object[] partitionValues;
    private boolean addPartitionCols = true;
    private final boolean isFlatPayload;
    private final ValidWriteIdList validWriteIdList;
    private final DeleteEventRegistry deleteEventRegistry;
    private final StructColumnVector recordIdColumnVector;
    private final Reader.Options readerOptions;
    private final boolean isOriginal;
    private final boolean rowIdProjected;
    private final boolean includeAcidColumns;
    private final Path rootPath;
    private final OrcSplit.OffsetAndBucketProperty syntheticProps;
    private RecordReader innerReader;
    private final OrcRawRecordMerger.KeyInterval keyInterval;
    private SearchArgument deleteEventSarg = null;
    private final CacheTag cacheTag;

    VectorizedOrcAcidRowBatchReader(OrcSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        this(inputSplit, conf, reporter, null);
    }

    @VisibleForTesting
    VectorizedOrcAcidRowBatchReader(OrcSplit inputSplit, JobConf conf, Reporter reporter, final VectorizedRowBatchCtx rbCtx) throws IOException {
        this(conf, inputSplit, reporter, rbCtx == null ? Utilities.getVectorizedRowBatchCtx((Configuration)conf) : rbCtx, false, null);
        Reader reader = OrcInputFormat.createOrcReaderForSplit((Configuration)conf, inputSplit);
        this.innerReader = reader.rowsOptions(this.readerOptions.range(this.offset, this.length), (Configuration)conf);
        this.baseReader = new org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch>(){

            public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
                return VectorizedOrcAcidRowBatchReader.this.innerReader.nextBatch(value);
            }

            public NullWritable createKey() {
                return NullWritable.get();
            }

            public VectorizedRowBatch createValue() {
                return rbCtx.createVectorizedRowBatch();
            }

            public long getPos() throws IOException {
                return 0L;
            }

            public void close() throws IOException {
                VectorizedOrcAcidRowBatchReader.this.innerReader.close();
            }

            public float getProgress() throws IOException {
                return VectorizedOrcAcidRowBatchReader.this.innerReader.getProgress();
            }
        };
        boolean useDecimal64ColumnVectors = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
        this.vectorizedRowBatchBase = useDecimal64ColumnVectors ? ((RecordReaderImpl)this.innerReader).createRowBatch(true) : ((RecordReaderImpl)this.innerReader).createRowBatch(false);
    }

    public VectorizedOrcAcidRowBatchReader(OrcSplit inputSplit, JobConf conf, Reporter reporter, org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> baseReader, VectorizedRowBatchCtx rbCtx, boolean isFlatPayload, MapWork mapWork) throws IOException {
        this(conf, inputSplit, reporter, rbCtx, isFlatPayload, mapWork);
        if (baseReader != null) {
            this.setBaseAndInnerReader(baseReader);
        }
    }

    private VectorizedOrcAcidRowBatchReader(JobConf conf, OrcSplit orcSplit, Reporter reporter, VectorizedRowBatchCtx rowBatchCtx, boolean isFlatPayload, MapWork mapWork) throws IOException {
        DeleteEventRegistry der;
        int partitionColumnCount;
        boolean isReadNotAllowed;
        this.isFlatPayload = isFlatPayload;
        this.rbCtx = rowBatchCtx;
        boolean isAcidRead = AcidUtils.isFullAcidScan((Configuration)conf);
        AcidUtils.AcidOperationalProperties acidOperationalProperties = AcidUtils.getAcidOperationalProperties((Configuration)conf);
        boolean bl = isReadNotAllowed = !isAcidRead || !acidOperationalProperties.isSplitUpdate();
        if (isReadNotAllowed) {
            OrcInputFormat.raiseAcidTablesMustBeReadWithAcidReaderException((Configuration)conf);
        }
        reporter.setStatus(orcSplit.toString());
        this.readerOptions = OrcInputFormat.createOptionsForReader((Configuration)conf);
        this.offset = orcSplit.getStart();
        this.length = orcSplit.getLength();
        int n = partitionColumnCount = this.rbCtx != null ? this.rbCtx.getPartitionColumnCount() : 0;
        if (partitionColumnCount > 0) {
            this.partitionValues = new Object[partitionColumnCount];
            VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, (Configuration)conf, (FileSplit)orcSplit, this.partitionValues);
        } else {
            this.partitionValues = null;
        }
        String txnString = conf.get("hive.txn.valid.writeids");
        this.validWriteIdList = txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
        LOG.info("Read ValidWriteIdList: " + this.validWriteIdList.toString() + ":" + orcSplit);
        this.syntheticProps = orcSplit.getSyntheticAcidProps();
        if (LlapHiveUtils.isLlapMode((Configuration)conf) && LlapProxy.isDaemon() && HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.LLAP_TRACK_CACHE_USAGE)) {
            if (mapWork == null) {
                mapWork = LlapHiveUtils.findMapWork(conf);
            }
            PartitionDesc partitionDesc = LlapHiveUtils.partitionDescForPath(orcSplit.getPath(), mapWork.getPathToPartitionInfo());
            this.cacheTag = LlapHiveUtils.getDbAndTableNameForMetrics(orcSplit.getPath(), true, partitionDesc);
        } else {
            this.cacheTag = null;
        }
        Reader.Options deleteEventReaderOptions = this.readerOptions.clone();
        deleteEventReaderOptions.range(0L, Long.MAX_VALUE);
        deleteEventReaderOptions.searchArgument(null, null);
        this.keyInterval = this.findMinMaxKeys(orcSplit, (Configuration)conf, deleteEventReaderOptions);
        try {
            der = new ColumnizedDeleteEventRegistry(conf, orcSplit, deleteEventReaderOptions, this.keyInterval, this.cacheTag);
        }
        catch (DeleteEventsOverflowMemoryException e) {
            der = new SortMergedDeleteEventRegistry(conf, orcSplit, deleteEventReaderOptions);
        }
        this.deleteEventRegistry = der;
        this.isOriginal = orcSplit.isOriginal();
        this.recordIdColumnVector = this.isOriginal ? new StructColumnVector(1024, new LongColumnVector(), new LongColumnVector(), new LongColumnVector()) : new StructColumnVector(1024, null, null, null);
        this.rowIdProjected = VectorizedOrcAcidRowBatchReader.areRowIdsProjected(this.rbCtx);
        this.rootPath = orcSplit.getRootDir();
        if (conf.getBoolean(HiveConf.ConfVars.OPTIMIZE_ACID_META_COLUMNS.varname, true) && this.deleteEventRegistry.isEmpty() && !this.rowIdProjected) {
            for (Path parent = orcSplit.getPath().getParent(); parent != null && !this.rootPath.equals((Object)parent); parent = parent.getParent()) {
                if (parent.getName().startsWith("base_")) {
                    this.readerOptions.includeAcidColumns(false);
                    break;
                }
                AcidUtils.ParsedDelta pd = AcidUtils.parsedDelta(parent, this.isOriginal);
                if (this.validWriteIdList.isWriteIdRangeValid(pd.getMinWriteId(), pd.getMaxWriteId()) != ValidWriteIdList.RangeResponse.ALL) continue;
                this.readerOptions.includeAcidColumns(false);
                break;
            }
        }
        this.includeAcidColumns = this.readerOptions.getIncludeAcidColumns();
    }

    private void setSARG(OrcRawRecordMerger.KeyInterval keyInterval, Reader.Options deleteEventReaderOptions, long minBucketProp, long maxBucketProp, long minRowId, long maxRowId) {
        RecordIdentifier k;
        SearchArgument.Builder b = null;
        if (keyInterval.getMinKey() != null) {
            k = keyInterval.getMinKey();
            b = SearchArgumentFactory.newBuilder();
            b.startAnd().startNot().lessThan("originalTransaction", PredicateLeaf.Type.LONG, k.getWriteId()).end();
            b.startNot().lessThan("bucket", PredicateLeaf.Type.LONG, minBucketProp).end();
            b.startNot().lessThan("rowId", PredicateLeaf.Type.LONG, minRowId).end();
            b.end();
        }
        if (keyInterval.getMaxKey() != null) {
            k = keyInterval.getMaxKey();
            if (b == null) {
                b = SearchArgumentFactory.newBuilder();
            }
            b.startAnd().lessThanEquals("originalTransaction", PredicateLeaf.Type.LONG, k.getWriteId());
            b.lessThanEquals("bucket", PredicateLeaf.Type.LONG, maxBucketProp);
            b.lessThanEquals("rowId", PredicateLeaf.Type.LONG, maxRowId);
            b.end();
        }
        if (b != null) {
            this.deleteEventSarg = b.build();
            LOG.info("deleteReader SARG(" + this.deleteEventSarg + ") ");
            deleteEventReaderOptions.searchArgument(this.deleteEventSarg, new String[]{"originalTransaction", "bucket", "rowId"});
            return;
        }
        deleteEventReaderOptions.searchArgument(null, null);
    }

    public boolean includeAcidColumns() {
        return this.includeAcidColumns;
    }

    public void setBaseAndInnerReader(org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> baseReader) {
        this.baseReader = baseReader;
        this.innerReader = null;
        this.vectorizedRowBatchBase = (VectorizedRowBatch)baseReader.createValue();
    }

    private OrcRawRecordMerger.KeyInterval findMinMaxKeys(OrcSplit orcSplit, Configuration conf, Reader.Options deleteEventReaderOptions) throws IOException {
        boolean columnStatsPresent;
        boolean noDeleteDeltas;
        boolean bl = noDeleteDeltas = orcSplit.getDeltas().size() == 0;
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.FILTER_DELETE_EVENTS) || noDeleteDeltas) {
            LOG.debug("findMinMaxKeys() " + (Object)((Object)HiveConf.ConfVars.FILTER_DELETE_EVENTS) + "=false");
            return new OrcRawRecordMerger.KeyInterval(null, null);
        }
        OrcTail orcTail = VectorizedOrcAcidRowBatchReader.getOrcTail((Path)orcSplit.getPath(), (Configuration)conf, (CacheTag)this.cacheTag, (Object)orcSplit.getFileKey()).orcTail;
        if (orcSplit.isOriginal()) {
            LOG.debug("findMinMaxKeys(original split)");
            return this.findOriginalMinMaxKeys(orcSplit, orcTail, deleteEventReaderOptions);
        }
        List<StripeInformation> stripes = orcTail.getStripes();
        long splitStart = orcSplit.getStart();
        long splitEnd = splitStart + orcSplit.getLength();
        int firstStripeIndex = -1;
        int lastStripeIndex = -1;
        for (int i = 0; i < stripes.size(); ++i) {
            StripeInformation stripe = stripes.get(i);
            long stripeEnd = stripe.getOffset() + stripe.getLength();
            if (firstStripeIndex == -1 && stripe.getOffset() >= splitStart) {
                firstStripeIndex = i;
            }
            if (lastStripeIndex != -1 || splitEnd > stripeEnd) continue;
            lastStripeIndex = i;
        }
        if (lastStripeIndex == -1) {
            assert (stripes.get(stripes.size() - 1).getOffset() + stripes.get(stripes.size() - 1).getLength() < splitEnd);
            lastStripeIndex = stripes.size() - 1;
        }
        if (firstStripeIndex > lastStripeIndex || firstStripeIndex == -1) {
            long minRowId = 1L;
            long maxRowId = 0L;
            int minBucketProp = 1;
            int maxBucketProp = 0;
            OrcRawRecordMerger.KeyInterval keyIntervalTmp = new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(1L, minBucketProp, minRowId), new RecordIdentifier(0L, maxBucketProp, maxRowId));
            this.setSARG(keyIntervalTmp, deleteEventReaderOptions, minBucketProp, maxBucketProp, minRowId, maxRowId);
            LOG.info("findMinMaxKeys(): " + keyIntervalTmp + " stripes(" + firstStripeIndex + "," + lastStripeIndex + ")");
            return keyIntervalTmp;
        }
        if (firstStripeIndex == -1 || lastStripeIndex == -1) {
            LOG.warn("Could not find stripe (" + firstStripeIndex + "," + lastStripeIndex + ")");
            return new OrcRawRecordMerger.KeyInterval(null, null);
        }
        RecordIdentifier[] keyIndex = OrcRecordUpdater.parseKeyIndex(orcTail);
        if (keyIndex == null) {
            LOG.warn("Could not find keyIndex (" + firstStripeIndex + "," + lastStripeIndex + "," + stripes.size() + ")");
        }
        if (keyIndex != null && keyIndex.length != stripes.size()) {
            LOG.warn("keyIndex length doesn't match (" + firstStripeIndex + "," + lastStripeIndex + "," + stripes.size() + "," + keyIndex.length + ")");
            return new OrcRawRecordMerger.KeyInterval(null, null);
        }
        boolean bl2 = columnStatsPresent = orcTail.getFooter().getRowIndexStride() > 0;
        if (!columnStatsPresent) {
            LOG.debug("findMinMaxKeys() No ORC column stats");
        }
        List<OrcProto.StripeStatistics> stats = orcTail.getStripeStatisticsProto();
        assert (stripes.size() == stats.size()) : "str.s=" + stripes.size() + " sta.s=" + stats.size();
        RecordIdentifier minKey = null;
        if (firstStripeIndex > 0 && keyIndex != null) {
            minKey = keyIndex[firstStripeIndex - 1];
            minKey.setRowId(minKey.getRowId() + 1L);
        } else if (columnStatsPresent) {
            minKey = VectorizedOrcAcidRowBatchReader.getKeyInterval(stats.get(firstStripeIndex).getColStatsList()).getMinKey();
        }
        RecordIdentifier maxKey = null;
        if (keyIndex != null) {
            maxKey = keyIndex[lastStripeIndex];
        } else if (columnStatsPresent) {
            maxKey = VectorizedOrcAcidRowBatchReader.getKeyInterval(stats.get(firstStripeIndex).getColStatsList()).getMaxKey();
        }
        OrcRawRecordMerger.KeyInterval keyInterval = new OrcRawRecordMerger.KeyInterval(minKey, maxKey);
        LOG.info("findMinMaxKeys(): " + keyInterval + " stripes(" + firstStripeIndex + "," + lastStripeIndex + ")");
        long minBucketProp = Long.MAX_VALUE;
        long maxBucketProp = Long.MIN_VALUE;
        long minRowId = Long.MAX_VALUE;
        long maxRowId = Long.MIN_VALUE;
        if (columnStatsPresent) {
            for (int i = firstStripeIndex; i <= lastStripeIndex; ++i) {
                OrcRawRecordMerger.KeyInterval key = VectorizedOrcAcidRowBatchReader.getKeyInterval(stats.get(i).getColStatsList());
                if ((long)key.getMinKey().getBucketProperty() < minBucketProp) {
                    minBucketProp = key.getMinKey().getBucketProperty();
                }
                if ((long)key.getMaxKey().getBucketProperty() > maxBucketProp) {
                    maxBucketProp = key.getMaxKey().getBucketProperty();
                }
                if (key.getMinKey().getRowId() < minRowId) {
                    minRowId = key.getMinKey().getRowId();
                }
                if (key.getMaxKey().getRowId() <= maxRowId) continue;
                maxRowId = key.getMaxKey().getRowId();
            }
        }
        if (minBucketProp == Long.MAX_VALUE) {
            minBucketProp = Long.MIN_VALUE;
        }
        if (maxBucketProp == Long.MIN_VALUE) {
            maxBucketProp = Long.MAX_VALUE;
        }
        if (minRowId == Long.MAX_VALUE) {
            minRowId = Long.MIN_VALUE;
        }
        if (maxRowId == Long.MIN_VALUE) {
            maxRowId = Long.MAX_VALUE;
        }
        this.setSARG(keyInterval, deleteEventReaderOptions, minBucketProp, maxBucketProp, minRowId, maxRowId);
        return keyInterval;
    }

    private OrcRawRecordMerger.KeyInterval findOriginalMinMaxKeys(OrcSplit orcSplit, OrcTail orcTail, Reader.Options deleteEventReaderOptions) {
        if (this.syntheticProps == null) {
            return new OrcRawRecordMerger.KeyInterval(null, null);
        }
        long splitStart = orcSplit.getStart();
        long splitEnd = orcSplit.getStart() + orcSplit.getLength();
        long minRowId = this.syntheticProps.getRowIdOffset();
        long maxRowId = this.syntheticProps.getRowIdOffset();
        for (StripeInformation stripe : orcTail.getStripes()) {
            if (splitStart > stripe.getOffset()) {
                minRowId += stripe.getNumberOfRows();
            }
            if (splitEnd <= stripe.getOffset()) break;
            maxRowId += stripe.getNumberOfRows();
        }
        RecordIdentifier minKey = new RecordIdentifier(this.syntheticProps.getSyntheticWriteId(), this.syntheticProps.getBucketProperty(), minRowId);
        RecordIdentifier maxKey = new RecordIdentifier(this.syntheticProps.getSyntheticWriteId(), this.syntheticProps.getBucketProperty(), maxRowId > 0L ? maxRowId - 1L : 0L);
        OrcRawRecordMerger.KeyInterval keyIntervalTmp = new OrcRawRecordMerger.KeyInterval(minKey, maxKey);
        if (minRowId >= maxRowId) {
            LOG.info("findOriginalMinMaxKeys(): This split starts and ends in the same stripe.");
        }
        LOG.info("findOriginalMinMaxKeys(): " + keyIntervalTmp);
        this.setSARG(keyIntervalTmp, deleteEventReaderOptions, minKey.getBucketProperty(), maxKey.getBucketProperty(), minKey.getRowId(), maxKey.getRowId());
        return keyIntervalTmp;
    }

    private static ReaderData getOrcTail(Path path, Configuration conf, CacheTag cacheTag, Object fileKey) throws IOException {
        ReaderData readerData = new ReaderData();
        if (VectorizedOrcAcidRowBatchReader.shouldReadDeleteDeltasWithLlap(conf, true)) {
            try {
                readerData.orcTail = LlapProxy.getIo().getOrcTailFromCache(path, conf, cacheTag, fileKey);
                return readerData;
            }
            catch (IllegalCacheConfigurationException icce) {
                throw new IOException("LLAP cache is not configured properly while delete delta caching is turned on", icce);
            }
        }
        readerData.reader = OrcFile.createReader(path, OrcFile.readerOptions(conf));
        readerData.orcTail = new OrcTail(readerData.reader.getFileTail(), readerData.reader.getSerializedFileFooter());
        return readerData;
    }

    private static boolean shouldReadDeleteDeltasWithLlap(Configuration conf, boolean metaDataLevelSufficient) {
        String ddCacheLevel = HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_IO_CACHE_DELETEDELTAS);
        return ("all".equals(ddCacheLevel) || metaDataLevelSufficient && ddCacheLevel.equals("metadata")) && LlapHiveUtils.isLlapMode(conf) && LlapProxy.isDaemon() && LlapProxy.getIo() != null;
    }

    static OrcSplit.OffsetAndBucketProperty computeOffsetAndBucket(FileStatus file, Path rootDir, boolean isOriginal, boolean hasDeletes, Configuration conf) throws IOException {
        VectorizedRowBatchCtx vrbCtx = Utilities.getVectorizedRowBatchCtx(conf);
        if (!VectorizedOrcAcidRowBatchReader.needSyntheticRowIds(isOriginal, hasDeletes, VectorizedOrcAcidRowBatchReader.areRowIdsProjected(vrbCtx))) {
            if (isOriginal) {
                OrcRawRecordMerger.TransactionMetaData syntheticTxnInfo = OrcRawRecordMerger.TransactionMetaData.findWriteIDForSynthetcRowIDs(file.getPath(), rootDir, conf);
                return new OrcSplit.OffsetAndBucketProperty(-1L, -1, syntheticTxnInfo.syntheticWriteId);
            }
            return null;
        }
        String txnString = conf.get("hive.txn.valid.writeids");
        ValidReaderWriteIdList validWriteIdList = txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
        long rowIdOffset = 0L;
        OrcRawRecordMerger.TransactionMetaData syntheticTxnInfo = OrcRawRecordMerger.TransactionMetaData.findWriteIDForSynthetcRowIDs(file.getPath(), rootDir, conf);
        int bucketId = AcidUtils.parseBucketId(file.getPath());
        int bucketProperty = BucketCodec.V1.encode(new AcidOutputFormat.Options(conf).statementId(syntheticTxnInfo.statementId).bucket(bucketId));
        AcidDirectory directoryState = AcidUtils.getAcidState(null, syntheticTxnInfo.folder, conf, validWriteIdList, Ref.from(false), true);
        for (HadoopShims.HdfsFileStatusWithId f : directoryState.getOriginalFiles()) {
            int bucketIdFromPath = AcidUtils.parseBucketId(f.getFileStatus().getPath());
            if (bucketIdFromPath != bucketId) continue;
            if (f.getFileStatus().getPath().equals((Object)file.getPath())) break;
            Reader reader = OrcFile.createReader(f.getFileStatus().getPath(), OrcFile.readerOptions(conf));
            rowIdOffset += reader.getNumberOfRows();
        }
        return new OrcSplit.OffsetAndBucketProperty(rowIdOffset, bucketProperty, syntheticTxnInfo.syntheticWriteId);
    }

    static boolean canUseLlapIoForAcid(OrcSplit split, boolean hasDeletes, Configuration conf) {
        if (!split.isOriginal()) {
            return true;
        }
        VectorizedRowBatchCtx rbCtx = Utilities.getVectorizedRowBatchCtx(conf);
        if (rbCtx == null) {
            throw new IllegalStateException("Could not create VectorizedRowBatchCtx for " + split.getPath());
        }
        return !VectorizedOrcAcidRowBatchReader.needSyntheticRowIds(split.isOriginal(), hasDeletes, VectorizedOrcAcidRowBatchReader.areRowIdsProjected(rbCtx));
    }

    private static boolean needSyntheticRowIds(boolean isOriginal, boolean hasDeletes, boolean rowIdProjected) {
        return isOriginal && (hasDeletes || rowIdProjected);
    }

    private static boolean areRowIdsProjected(VectorizedRowBatchCtx rbCtx) {
        if (rbCtx.getVirtualColumnCount() == 0) {
            return false;
        }
        for (VirtualColumn vc : rbCtx.getNeededVirtualColumns()) {
            if (vc != VirtualColumn.ROWID) continue;
            return true;
        }
        return false;
    }

    static Path[] getDeleteDeltaDirsFromSplit(OrcSplit orcSplit, Map<String, AcidInputFormat.DeltaMetaData> pathToDeltaMetaData) throws IOException {
        Path root;
        Path path = orcSplit.getPath();
        if (orcSplit.hasBase()) {
            if (orcSplit.isOriginal()) {
                root = orcSplit.getRootDir();
            } else {
                root = path.getParent().getParent();
                assert (root.equals((Object)orcSplit.getRootDir())) : "root mismatch: baseDir=" + orcSplit.getRootDir() + " path.p.p=" + root;
            }
        } else {
            throw new IllegalStateException("Split w/o base w/Acid 2.0??: " + path);
        }
        return AcidUtils.deserializeDeleteDeltas(root, orcSplit.getDeltas(), pathToDeltaMetaData);
    }

    public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
        try {
            if (this.addPartitionCols) {
                if (this.partitionValues != null) {
                    this.rbCtx.addPartitionColsToBatch(value, this.partitionValues);
                }
                this.addPartitionCols = false;
            }
            if (!this.baseReader.next(null, (Object)this.vectorizedRowBatchBase)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new IOException("error iterating", e);
        }
        if (!this.includeAcidColumns) {
            value.size = this.vectorizedRowBatchBase.size;
            value.selected = this.vectorizedRowBatchBase.selected;
            value.selectedInUse = this.vectorizedRowBatchBase.selectedInUse;
            this.copyFromBase(value);
            this.progress = this.baseReader.getProgress();
            return true;
        }
        BitSet selectedBitSet = new BitSet(this.vectorizedRowBatchBase.size);
        if (this.vectorizedRowBatchBase.selectedInUse) {
            selectedBitSet.set(0, this.vectorizedRowBatchBase.size, false);
            for (int j = 0; j < this.vectorizedRowBatchBase.size; ++j) {
                int i = this.vectorizedRowBatchBase.selected[j];
                selectedBitSet.set(i);
            }
        } else {
            selectedBitSet.set(0, this.vectorizedRowBatchBase.size, true);
        }
        ColumnVector[] innerRecordIdColumnVector = this.vectorizedRowBatchBase.cols;
        if (this.isOriginal) {
            innerRecordIdColumnVector = this.handleOriginalFile(selectedBitSet, innerRecordIdColumnVector);
        } else {
            this.findRecordsWithInvalidWriteIds(this.vectorizedRowBatchBase, selectedBitSet);
        }
        this.deleteEventRegistry.findDeletedRecords(innerRecordIdColumnVector, this.vectorizedRowBatchBase.size, selectedBitSet);
        if (selectedBitSet.cardinality() == this.vectorizedRowBatchBase.size) {
            value.size = this.vectorizedRowBatchBase.size;
            value.selected = this.vectorizedRowBatchBase.selected;
            value.selectedInUse = this.vectorizedRowBatchBase.selectedInUse;
        } else {
            value.size = selectedBitSet.cardinality();
            value.selectedInUse = true;
            value.selected = new int[selectedBitSet.cardinality()];
            int setBitIndex = selectedBitSet.nextSetBit(0);
            int selectedItr = 0;
            while (setBitIndex >= 0) {
                value.selected[selectedItr] = setBitIndex;
                setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
                ++selectedItr;
            }
        }
        this.copyFromBase(value);
        if (this.rowIdProjected) {
            int ix = this.rbCtx.findVirtualColumnNum(VirtualColumn.ROWID);
            value.cols[ix] = this.recordIdColumnVector;
        }
        this.progress = this.baseReader.getProgress();
        return true;
    }

    private void copyFromBase(VectorizedRowBatch value) {
        if (this.isOriginal) {
            System.arraycopy(this.vectorizedRowBatchBase.cols, 0, value.cols, 0, value.getDataColumnCount());
            return;
        }
        if (this.isFlatPayload) {
            int payloadCol = this.includeAcidColumns ? 5 : 0;
            System.arraycopy(this.vectorizedRowBatchBase.cols, payloadCol + 1, value.cols, 0, this.vectorizedRowBatchBase.cols.length - payloadCol - 1);
        } else {
            StructColumnVector payloadStruct = (StructColumnVector)this.vectorizedRowBatchBase.cols[5];
            System.arraycopy(payloadStruct.fields, 0, value.cols, 0, value.getDataColumnCount());
        }
        if (this.rowIdProjected) {
            this.recordIdColumnVector.fields[0] = this.vectorizedRowBatchBase.cols[1];
            this.recordIdColumnVector.fields[1] = this.vectorizedRowBatchBase.cols[2];
            this.recordIdColumnVector.fields[2] = this.vectorizedRowBatchBase.cols[3];
        }
    }

    private ColumnVector[] handleOriginalFile(BitSet selectedBitSet, ColumnVector[] innerRecordIdColumnVector) throws IOException {
        boolean needSyntheticRowId = VectorizedOrcAcidRowBatchReader.needSyntheticRowIds(true, !this.deleteEventRegistry.isEmpty(), this.rowIdProjected);
        if (needSyntheticRowId) {
            assert (this.syntheticProps != null) : "" + this.syntheticProps;
            assert (this.syntheticProps.getRowIdOffset() >= 0L) : "" + this.syntheticProps;
            assert (this.syntheticProps.getBucketProperty() >= 0) : "" + this.syntheticProps;
            if (this.innerReader == null) {
                throw new IllegalStateException(this.getClass().getName() + " requires " + org.apache.orc.RecordReader.class + " to handle original files that require ROW__IDs: " + this.rootPath);
            }
            this.recordIdColumnVector.fields[0].noNulls = true;
            this.recordIdColumnVector.fields[0].isRepeating = true;
            ((LongColumnVector)this.recordIdColumnVector.fields[0]).vector[0] = this.syntheticProps.getSyntheticWriteId();
            this.recordIdColumnVector.fields[1].noNulls = true;
            this.recordIdColumnVector.fields[1].isRepeating = true;
            ((LongColumnVector)this.recordIdColumnVector.fields[1]).vector[0] = this.syntheticProps.getBucketProperty();
            this.recordIdColumnVector.fields[2].noNulls = true;
            this.recordIdColumnVector.fields[2].isRepeating = false;
            long[] rowIdVector = ((LongColumnVector)this.recordIdColumnVector.fields[2]).vector;
            for (int i = 0; i < this.vectorizedRowBatchBase.size; ++i) {
                rowIdVector[i] = this.syntheticProps.getRowIdOffset() + this.innerReader.getRowNumber() + (long)i;
            }
            innerRecordIdColumnVector = new ColumnVector[6];
            innerRecordIdColumnVector[1] = this.recordIdColumnVector.fields[0];
            innerRecordIdColumnVector[2] = this.recordIdColumnVector.fields[1];
            innerRecordIdColumnVector[3] = this.recordIdColumnVector.fields[2];
            innerRecordIdColumnVector[4] = this.recordIdColumnVector.fields[0];
        }
        if (this.syntheticProps.getSyntheticWriteId() > 0L) {
            if (needSyntheticRowId) {
                this.findRecordsWithInvalidWriteIds(innerRecordIdColumnVector, this.vectorizedRowBatchBase.size, selectedBitSet);
            } else if (!this.validWriteIdList.isWriteIdValid(this.syntheticProps.getSyntheticWriteId())) {
                selectedBitSet.clear(0, this.vectorizedRowBatchBase.size);
            }
        }
        return innerRecordIdColumnVector;
    }

    private void findRecordsWithInvalidWriteIds(VectorizedRowBatch batch, BitSet selectedBitSet) {
        this.findRecordsWithInvalidWriteIds(batch.cols, batch.size, selectedBitSet);
    }

    private void findRecordsWithInvalidWriteIds(ColumnVector[] cols, int size, BitSet selectedBitSet) {
        if (cols[4].isRepeating) {
            long currentWriteIdForBatch = ((LongColumnVector)cols[4]).vector[0];
            if (!this.validWriteIdList.isWriteIdValid(currentWriteIdForBatch)) {
                selectedBitSet.clear(0, size);
            }
            return;
        }
        long[] currentWriteIdVector = ((LongColumnVector)cols[4]).vector;
        int setBitIndex = selectedBitSet.nextSetBit(0);
        while (setBitIndex >= 0) {
            if (!this.validWriteIdList.isWriteIdValid(currentWriteIdVector[setBitIndex])) {
                selectedBitSet.clear(setBitIndex);
            }
            setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
        }
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return this.offset + (long)(this.progress * (float)this.length);
    }

    public void close() throws IOException {
        try {
            this.baseReader.close();
        }
        finally {
            this.deleteEventRegistry.close();
        }
    }

    public float getProgress() throws IOException {
        return this.progress;
    }

    @VisibleForTesting
    DeleteEventRegistry getDeleteEventRegistry() {
        return this.deleteEventRegistry;
    }

    @VisibleForTesting
    OrcRawRecordMerger.KeyInterval getKeyInterval() {
        return this.keyInterval;
    }

    @VisibleForTesting
    SearchArgument getDeleteEventSarg() {
        return this.deleteEventSarg;
    }

    private static IntegerColumnStatistics deserializeIntColumnStatistics(List<OrcProto.ColumnStatistics> colStats, int id) {
        return (IntegerColumnStatistics)((Object)ColumnStatisticsImpl.deserialize(null, colStats.get(id)));
    }

    private static OrcRawRecordMerger.KeyInterval getKeyInterval(List<OrcProto.ColumnStatistics> colStats) {
        IntegerColumnStatistics origWriteId = VectorizedOrcAcidRowBatchReader.deserializeIntColumnStatistics(colStats, 2);
        IntegerColumnStatistics bucketProperty = VectorizedOrcAcidRowBatchReader.deserializeIntColumnStatistics(colStats, 3);
        IntegerColumnStatistics rowId = VectorizedOrcAcidRowBatchReader.deserializeIntColumnStatistics(colStats, 4);
        assert (bucketProperty.getMaximum() <= Integer.MAX_VALUE) : "was bucketProperty (max) changed to a long (" + bucketProperty.getMaximum() + ")?!";
        assert (bucketProperty.getMinimum() <= Integer.MAX_VALUE) : "was bucketProperty (min) changed to a long (" + bucketProperty.getMaximum() + ")?!";
        RecordIdentifier maxKey = new RecordIdentifier(origWriteId.getMaximum(), (int)bucketProperty.getMaximum(), rowId.getMaximum());
        RecordIdentifier minKey = new RecordIdentifier(origWriteId.getMinimum(), (int)bucketProperty.getMinimum(), rowId.getMinimum());
        return new OrcRawRecordMerger.KeyInterval(minKey, maxKey);
    }

    static class DeleteEventsOverflowMemoryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        DeleteEventsOverflowMemoryException() {
        }
    }

    static class ColumnizedDeleteEventRegistry
    implements DeleteEventRegistry {
        private TreeMap<DeleteRecordKey, DeleteReaderValue> sortMerger;
        private long[] rowIds;
        private CompressedOwid[] compressedOwids;
        private ValidWriteIdList validWriteIdList;
        private Boolean isEmpty;
        private final int maxEventsInMemory;
        private final OrcSplit orcSplit;
        private final boolean testMode;

        ColumnizedDeleteEventRegistry(JobConf conf, OrcSplit orcSplit, Reader.Options readerOptions, OrcRawRecordMerger.KeyInterval keyInterval, CacheTag cacheTag) throws IOException, DeleteEventsOverflowMemoryException {
            this.testMode = conf.getBoolean(HiveConf.ConfVars.HIVE_IN_TEST.varname, false);
            int bucket = AcidUtils.parseBucketId(orcSplit.getPath());
            String txnString = conf.get("hive.txn.valid.writeids");
            this.validWriteIdList = txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
            LOG.debug("Using ColumnizedDeleteEventRegistry");
            this.sortMerger = new TreeMap();
            this.rowIds = null;
            this.compressedOwids = null;
            this.maxEventsInMemory = HiveConf.getIntVar((Configuration)conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY);
            boolean isBucketedTable = conf.getInt("bucket_count", 0) > 0;
            this.orcSplit = orcSplit;
            try {
                if (orcSplit.getDeltas().size() > 0) {
                    AcidOutputFormat.Options orcSplitMinMaxWriteIds = AcidUtils.parseBaseOrDeltaBucketFilename(orcSplit.getPath(), (Configuration)conf);
                    int totalDeleteEventCount = 0;
                    for (AcidInputFormat.DeltaMetaData deltaMetaData : orcSplit.getDeltas()) {
                        for (Pair<Path, Integer> deleteDeltaDir : deltaMetaData.getPaths(orcSplit.getRootDir())) {
                            Integer stmtId = deleteDeltaDir.getRight();
                            if (!ColumnizedDeleteEventRegistry.isQualifiedDeleteDeltaForSplit(orcSplitMinMaxWriteIds, deltaMetaData, stmtId)) {
                                LOG.debug("Skipping delete delta dir {}", deleteDeltaDir);
                                continue;
                            }
                            Path deleteDeltaPath = deleteDeltaDir.getLeft();
                            for (AcidInputFormat.DeltaFileMetaData fileMetaData : deltaMetaData.getDeltaFilesForStmtId(stmtId)) {
                                OrcRawRecordMerger.KeyInterval deleteKeyInterval;
                                Path deleteDeltaFile = fileMetaData.getPath(deleteDeltaPath, bucket);
                                Object fileId = fileMetaData.getFileId(deleteDeltaFile, bucket, (Configuration)conf);
                                ReaderData readerData = VectorizedOrcAcidRowBatchReader.getOrcTail(deleteDeltaFile, (Configuration)conf, cacheTag, fileId);
                                OrcTail orcTail = readerData.orcTail;
                                long numRows = orcTail.getFooter().getNumberOfRows();
                                if (numRows <= 0L || !(deleteKeyInterval = ColumnizedDeleteEventRegistry.findDeleteMinMaxKeys(orcTail, deleteDeltaFile)).isIntersects(keyInterval)) continue;
                                totalDeleteEventCount = (int)((long)totalDeleteEventCount + numRows);
                                DeleteReaderValue deleteReaderValue = null;
                                if (readerData.reader == null) assert (VectorizedOrcAcidRowBatchReader.shouldReadDeleteDeltasWithLlap((Configuration)conf, true));
                                deleteReaderValue = new DeleteReaderValue(readerData.reader, deleteDeltaFile, readerOptions, bucket, this.validWriteIdList, isBucketedTable, conf, keyInterval, orcSplit, numRows, cacheTag, fileId);
                                DeleteRecordKey deleteRecordKey = new DeleteRecordKey();
                                if (deleteReaderValue.next(deleteRecordKey)) {
                                    this.sortMerger.put(deleteRecordKey, deleteReaderValue);
                                    continue;
                                }
                                deleteReaderValue.close();
                            }
                        }
                    }
                    this.readAllDeleteEventsFromDeleteDeltas();
                    LOG.debug("Number of delete events(limit, actual)=({},{})", (Object)totalDeleteEventCount, (Object)this.size());
                }
                this.isEmpty = this.compressedOwids == null || this.rowIds == null;
            }
            catch (IOException | DeleteEventsOverflowMemoryException e) {
                this.close();
                throw e;
            }
        }

        private static OrcRawRecordMerger.KeyInterval findDeleteMinMaxKeys(OrcTail orcTail, Path path) {
            boolean columnStatsPresent;
            boolean bl = columnStatsPresent = orcTail.getFooter().getRowIndexStride() > 0;
            if (!columnStatsPresent) {
                LOG.debug("findMinMaxKeys() No ORC column stats");
                return new OrcRawRecordMerger.KeyInterval(null, null);
            }
            return VectorizedOrcAcidRowBatchReader.getKeyInterval(orcTail.getFooter().getStatisticsList());
        }

        @VisibleForTesting
        protected static boolean isQualifiedDeleteDeltaForSplit(AcidOutputFormat.Options orcSplitMinMaxWriteIds, AcidInputFormat.DeltaMetaData deleteDelta, Integer stmtId) {
            if (orcSplitMinMaxWriteIds.getMinimumWriteId() == deleteDelta.getMaxWriteId()) {
                int orcSplitStmtId = orcSplitMinMaxWriteIds.getStatementId();
                if (orcSplitStmtId == -1) {
                    orcSplitStmtId = 0;
                }
                if (stmtId == null || stmtId == -1) {
                    stmtId = 0;
                }
                return orcSplitStmtId < stmtId;
            }
            return orcSplitMinMaxWriteIds.getMinimumWriteId() < deleteDelta.getMaxWriteId();
        }

        private void checkSize(int index) throws DeleteEventsOverflowMemoryException {
            if (index > this.maxEventsInMemory) {
                LOG.info("Total number of delete events exceeds the maximum number of delete events that can be loaded into memory for " + this.orcSplit + ". The max limit is currently set at " + this.maxEventsInMemory + " and can be changed by setting the Hive config variable " + HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname);
                throw new DeleteEventsOverflowMemoryException();
            }
            if (index < this.rowIds.length) {
                return;
            }
            int newLength = this.rowIds.length + 1000000;
            if (this.rowIds.length <= 1000000) {
                newLength = this.rowIds.length * 2;
            }
            this.rowIds = Arrays.copyOf(this.rowIds, newLength);
        }

        private void readAllDeleteEventsFromDeleteDeltas() throws IOException, DeleteEventsOverflowMemoryException {
            if (this.sortMerger == null || this.sortMerger.isEmpty()) {
                return;
            }
            this.rowIds = new long[this.testMode ? 1 : 10000];
            int index = 0;
            ArrayList<CompressedOwid> compressedOwids = new ArrayList<CompressedOwid>();
            CompressedOwid lastCo = null;
            while (!this.sortMerger.isEmpty()) {
                Map.Entry<DeleteRecordKey, DeleteReaderValue> entry = this.sortMerger.pollFirstEntry();
                DeleteRecordKey deleteRecordKey = entry.getKey();
                DeleteReaderValue deleteReaderValue = entry.getValue();
                long owid = deleteRecordKey.originalWriteId;
                int bp = deleteRecordKey.bucketProperty;
                this.checkSize(index);
                this.rowIds[index] = deleteRecordKey.rowId;
                if (lastCo == null || lastCo.originalWriteId != owid || lastCo.bucketProperty != bp) {
                    if (lastCo != null) {
                        lastCo.toIndex = index;
                    }
                    lastCo = new CompressedOwid(owid, bp, index, -1);
                    compressedOwids.add(lastCo);
                }
                ++index;
                if (deleteReaderValue.next(deleteRecordKey)) {
                    this.sortMerger.put(deleteRecordKey, deleteReaderValue);
                    continue;
                }
                deleteReaderValue.close();
            }
            if (lastCo != null) {
                lastCo.toIndex = index;
                lastCo = null;
            }
            if (this.rowIds.length > index) {
                this.rowIds = Arrays.copyOf(this.rowIds, index);
            }
            this.compressedOwids = compressedOwids.toArray(new CompressedOwid[compressedOwids.size()]);
        }

        private boolean isDeleted(long owid, int bucketProperty, long rowId) {
            if (this.compressedOwids == null || this.rowIds == null) {
                return false;
            }
            if (owid < this.compressedOwids[0].originalWriteId || owid > this.compressedOwids[this.compressedOwids.length - 1].originalWriteId) {
                return false;
            }
            CompressedOwid key = new CompressedOwid(owid, bucketProperty, -1, -1);
            int pos = Arrays.binarySearch(this.compressedOwids, key);
            if (pos >= 0) {
                key = this.compressedOwids[pos];
                if (rowId < this.rowIds[key.fromIndex] || rowId > this.rowIds[key.toIndex - 1]) {
                    return false;
                }
                if (Arrays.binarySearch(this.rowIds, key.fromIndex, key.toIndex, rowId) >= 0) {
                    return true;
                }
            }
            return false;
        }

        int size() {
            return this.rowIds == null ? 0 : this.rowIds.length;
        }

        @Override
        public boolean isEmpty() {
            if (this.isEmpty == null) {
                throw new IllegalStateException("Not yet initialized");
            }
            return this.isEmpty;
        }

        @Override
        public void findDeletedRecords(ColumnVector[] cols, int size, BitSet selectedBitSet) {
            if (this.rowIds == null || this.compressedOwids == null) {
                return;
            }
            long[] originalWriteIdVector = cols[1].isRepeating ? null : ((LongColumnVector)cols[1]).vector;
            long repeatedOriginalWriteId = originalWriteIdVector != null ? -1L : ((LongColumnVector)cols[1]).vector[0];
            long[] bucketProperties = cols[2].isRepeating ? null : ((LongColumnVector)cols[2]).vector;
            int repeatedBucketProperty = bucketProperties != null ? -1 : (int)((LongColumnVector)cols[2]).vector[0];
            long[] rowIdVector = ((LongColumnVector)cols[3]).vector;
            int setBitIndex = selectedBitSet.nextSetBit(0);
            while (setBitIndex >= 0) {
                long rowId;
                int bucketProperty;
                long owid = originalWriteIdVector != null ? originalWriteIdVector[setBitIndex] : repeatedOriginalWriteId;
                if (this.isDeleted(owid, bucketProperty = bucketProperties != null ? (int)bucketProperties[setBitIndex] : repeatedBucketProperty, rowId = rowIdVector[setBitIndex])) {
                    selectedBitSet.clear(setBitIndex);
                }
                setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
            }
        }

        @Override
        public void close() throws IOException {
            while (!this.sortMerger.isEmpty()) {
                Map.Entry<DeleteRecordKey, DeleteReaderValue> entry = this.sortMerger.pollFirstEntry();
                entry.getValue().close();
            }
        }

        private final class CompressedOwid
        implements Comparable<CompressedOwid> {
            final long originalWriteId;
            final int bucketProperty;
            final int fromIndex;
            int toIndex;

            CompressedOwid(long owid, int bucketProperty, int fromIndex, int toIndex) {
                this.originalWriteId = owid;
                this.bucketProperty = bucketProperty;
                this.fromIndex = fromIndex;
                this.toIndex = toIndex;
            }

            @Override
            public int compareTo(CompressedOwid other) {
                if (this.originalWriteId != other.originalWriteId) {
                    return this.originalWriteId < other.originalWriteId ? -1 : 1;
                }
                if (this.bucketProperty != other.bucketProperty) {
                    return this.bucketProperty < other.bucketProperty ? -1 : 1;
                }
                return 0;
            }
        }

        static class DeleteReaderValue {
            private static final List<Integer> DELETE_DELTA_INCLUDE_COLUMNS = IntStream.range(0, OrcInputFormat.getRootColumn(false)).boxed().collect(Collectors.toList());
            private static final TypeDescription DELETE_DELTA_EMPTY_STRUCT = new TypeDescription(TypeDescription.Category.STRUCT);
            private VectorizedRowBatch batch;
            private RecordReader recordReader;
            private int indexPtrInBatch;
            private final int bucketForSplit;
            private final ValidWriteIdList validWriteIdList;
            private boolean isBucketPropertyRepeating;
            private final boolean isBucketedTable;
            private final Path deleteDeltaFile;
            private final OrcRawRecordMerger.KeyInterval keyInterval;
            private final OrcSplit orcSplit;
            private final long numEvents;
            private long numEventsFromDisk = 0L;
            private long numEventsLoaded = 0L;

            DeleteReaderValue(Reader deleteDeltaReader, Path deleteDeltaFile, Reader.Options readerOptions, int bucket, ValidWriteIdList validWriteIdList, boolean isBucketedTable, JobConf conf, OrcRawRecordMerger.KeyInterval keyInterval, OrcSplit orcSplit, long numRows, CacheTag cacheTag, Object fileId) throws IOException {
                this.deleteDeltaFile = deleteDeltaFile;
                TypeDescription acidEmptyStructSchema = SchemaEvolution.createEventSchema(DELETE_DELTA_EMPTY_STRUCT);
                if (VectorizedOrcAcidRowBatchReader.shouldReadDeleteDeltasWithLlap((Configuration)conf, false)) {
                    this.recordReader = DeleteReaderValue.getLlapRecordReader(deleteDeltaFile, readerOptions, conf, cacheTag, fileId);
                }
                if (this.recordReader == null) {
                    if (deleteDeltaReader == null) {
                        deleteDeltaReader = OrcFile.createReader(deleteDeltaFile, OrcFile.readerOptions((Configuration)conf));
                    }
                    readerOptions = readerOptions.clone().schema(DELETE_DELTA_EMPTY_STRUCT).include(new boolean[]{true});
                    this.recordReader = deleteDeltaReader.rowsOptions(readerOptions, (Configuration)conf);
                }
                this.bucketForSplit = bucket;
                boolean useDecimal64ColumnVector = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
                this.batch = useDecimal64ColumnVector ? acidEmptyStructSchema.createRowBatchV2() : acidEmptyStructSchema.createRowBatch();
                if (!this.recordReader.nextBatch(this.batch)) {
                    this.batch = null;
                }
                this.indexPtrInBatch = 0;
                this.validWriteIdList = validWriteIdList;
                this.isBucketedTable = isBucketedTable;
                if (this.batch != null) {
                    this.checkBucketId();
                }
                this.keyInterval = keyInterval;
                this.orcSplit = orcSplit;
                this.numEvents = numRows;
                LOG.debug("Num events stats({},x,x)", (Object)this.numEvents);
            }

            public boolean next(DeleteRecordKey deleteRecordKey) throws IOException {
                if (this.batch == null) {
                    return false;
                }
                boolean isValidNext = false;
                while (!isValidNext) {
                    if (this.indexPtrInBatch >= this.batch.size) {
                        if (this.recordReader.nextBatch(this.batch)) {
                            this.checkBucketId();
                            this.indexPtrInBatch = 0;
                        } else {
                            return false;
                        }
                    }
                    long currentWriteId = this.setCurrentDeleteKey(deleteRecordKey);
                    if (!this.isBucketPropertyRepeating) {
                        this.checkBucketId(deleteRecordKey.bucketProperty);
                    }
                    ++this.indexPtrInBatch;
                    ++this.numEventsFromDisk;
                    if (!DeleteReaderValue.isDeleteEventInRange(this.keyInterval, deleteRecordKey) || !this.validWriteIdList.isWriteIdValid(currentWriteId)) continue;
                    isValidNext = true;
                }
                ++this.numEventsLoaded;
                return true;
            }

            static boolean isDeleteEventInRange(OrcRawRecordMerger.KeyInterval keyInterval, DeleteRecordKey deleteRecordKey) {
                if (keyInterval.getMinKey() != null && deleteRecordKey.compareTo(keyInterval.getMinKey()) < 0) {
                    return false;
                }
                return keyInterval.getMaxKey() == null || deleteRecordKey.compareTo(keyInterval.getMaxKey()) <= 0;
            }

            public void close() throws IOException {
                this.recordReader.close();
                LOG.debug("Num events stats({},{},{})", new Object[]{this.numEvents, this.numEventsFromDisk, this.numEventsLoaded});
            }

            private long setCurrentDeleteKey(DeleteRecordKey deleteRecordKey) {
                int originalWriteIdIndex = this.batch.cols[1].isRepeating ? 0 : this.indexPtrInBatch;
                long originalWriteId = ((LongColumnVector)this.batch.cols[1]).vector[originalWriteIdIndex];
                int bucketPropertyIndex = this.batch.cols[2].isRepeating ? 0 : this.indexPtrInBatch;
                int bucketProperty = (int)((LongColumnVector)this.batch.cols[2]).vector[bucketPropertyIndex];
                long rowId = ((LongColumnVector)this.batch.cols[3]).vector[this.indexPtrInBatch];
                int currentWriteIdIndex = this.batch.cols[4].isRepeating ? 0 : this.indexPtrInBatch;
                long currentWriteId = ((LongColumnVector)this.batch.cols[4]).vector[currentWriteIdIndex];
                deleteRecordKey.set(originalWriteId, bucketProperty, rowId);
                return currentWriteId;
            }

            private void checkBucketId() throws IOException {
                this.isBucketPropertyRepeating = this.batch.cols[2].isRepeating;
                if (this.isBucketPropertyRepeating) {
                    int bucketPropertyFromRecord = (int)((LongColumnVector)this.batch.cols[2]).vector[0];
                    this.checkBucketId(bucketPropertyFromRecord);
                }
            }

            private void checkBucketId(int bucketPropertyFromRecord) throws IOException {
                int bucketIdFromRecord = BucketCodec.determineVersion(bucketPropertyFromRecord).decodeWriterId(bucketPropertyFromRecord);
                if (bucketIdFromRecord != this.bucketForSplit) {
                    DeleteRecordKey dummy = new DeleteRecordKey();
                    this.setCurrentDeleteKey(dummy);
                    throw new IOException("Corrupted records with different bucket ids from the containing bucket file found! Expected bucket id " + this.bucketForSplit + ", however found " + dummy + ".  (" + this.orcSplit + "," + this.deleteDeltaFile + ")");
                }
            }

            public String toString() {
                return "{recordReader=" + this.recordReader + ", isBucketPropertyRepeating=" + this.isBucketPropertyRepeating + ", bucketForSplit=" + this.bucketForSplit + ", isBucketedTable=" + this.isBucketedTable + "}";
            }

            private static RecordReader getLlapRecordReader(Path deleteDeltaFile, Reader.Options readerOptions, JobConf conf, CacheTag tag, Object fileId) throws IOException {
                JobConf c = new JobConf((Configuration)conf);
                HiveConf.setBoolVar((Configuration)c, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, false);
                c.unset("hive.io.filter.expr.serialized");
                c.unset("sarg.pushdown");
                SearchArgument deleteDeltaSarg = readerOptions.getSearchArgument();
                if (deleteDeltaSarg != null) {
                    c.set("sarg.pushdown", ConvertAstToSearchArg.sargToKryo(deleteDeltaSarg));
                }
                return DeleteReaderValue.wrapLlapVectorizedRecordReader(LlapProxy.getIo().llapVectorizedOrcReaderForPath(fileId, deleteDeltaFile, tag, DELETE_DELTA_INCLUDE_COLUMNS, c, 0L, Long.MAX_VALUE));
            }

            private static RecordReader wrapLlapVectorizedRecordReader(final org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> rr) {
                if (rr == null) {
                    return null;
                }
                return new RecordReader(){

                    @Override
                    public boolean hasNext() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Object next(Object previous) throws IOException {
                        if (previous instanceof VectorizedRowBatch) {
                            return this.nextBatch((VectorizedRowBatch)previous);
                        }
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean nextBatch(VectorizedRowBatch vectorizedRowBatch) throws IOException {
                        return rr.next(null, (Object)vectorizedRowBatch);
                    }

                    @Override
                    public long getRowNumber() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public float getProgress() throws IOException {
                        return rr.getProgress();
                    }

                    @Override
                    public void close() throws IOException {
                        rr.close();
                    }

                    @Override
                    public void seekToRow(long l) throws IOException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        static class DeleteRecordKey
        implements Comparable<DeleteRecordKey> {
            private long originalWriteId = -1L;
            private int bucketProperty;
            private long rowId = -1L;

            DeleteRecordKey() {
            }

            public void set(long owid, int bucketProperty, long rowId) {
                this.originalWriteId = owid;
                this.bucketProperty = bucketProperty;
                this.rowId = rowId;
            }

            @Override
            public int compareTo(DeleteRecordKey other) {
                if (other == null) {
                    return -1;
                }
                return this.compareTo(other.originalWriteId, other.bucketProperty, other.rowId);
            }

            @Override
            private int compareTo(RecordIdentifier other) {
                if (other == null) {
                    return -1;
                }
                return this.compareTo(other.getWriteId(), other.getBucketProperty(), other.getRowId());
            }

            private int compareTo(long oOriginalWriteId, int oBucketProperty, long oRowId) {
                if (this.originalWriteId != oOriginalWriteId) {
                    return this.originalWriteId < oOriginalWriteId ? -1 : 1;
                }
                if (this.bucketProperty != oBucketProperty) {
                    return this.bucketProperty < oBucketProperty ? -1 : 1;
                }
                if (this.rowId != oRowId) {
                    return this.rowId < oRowId ? -1 : 1;
                }
                return 0;
            }

            public String toString() {
                return "DeleteRecordKey(" + this.originalWriteId + "," + RecordIdentifier.bucketToString(this.bucketProperty) + "," + this.rowId + ")";
            }
        }
    }

    static class SortMergedDeleteEventRegistry
    implements DeleteEventRegistry {
        private OrcRawRecordMerger deleteRecords;
        private OrcRawRecordMerger.ReaderKey deleteRecordKey;
        private OrcStruct deleteRecordValue;
        private Boolean isDeleteRecordAvailable = null;
        private ValidWriteIdList validWriteIdList;

        SortMergedDeleteEventRegistry(JobConf conf, OrcSplit orcSplit, Reader.Options readerOptions) throws IOException {
            HashMap<String, AcidInputFormat.DeltaMetaData> pathToDeltaMetaData = new HashMap<String, AcidInputFormat.DeltaMetaData>();
            Path[] deleteDeltas = VectorizedOrcAcidRowBatchReader.getDeleteDeltaDirsFromSplit(orcSplit, pathToDeltaMetaData);
            if (deleteDeltas.length > 0) {
                int bucket = AcidUtils.parseBucketId(orcSplit.getPath());
                String txnString = conf.get("hive.txn.valid.writeids");
                this.validWriteIdList = txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
                LOG.debug("Using SortMergedDeleteEventRegistry");
                Map<String, Integer> deltaToAttemptId = AcidUtils.getDeltaToAttemptIdMap(pathToDeltaMetaData, deleteDeltas, bucket);
                OrcRawRecordMerger.Options mergerOptions = new OrcRawRecordMerger.Options().isDeleteReader(true);
                assert (!orcSplit.isOriginal()) : "If this now supports Original splits, set up mergeOptions properly";
                this.deleteRecords = new OrcRawRecordMerger((Configuration)conf, true, null, false, bucket, this.validWriteIdList, readerOptions, deleteDeltas, mergerOptions, deltaToAttemptId);
                this.deleteRecordKey = new OrcRawRecordMerger.ReaderKey();
                this.deleteRecordValue = this.deleteRecords.createValue();
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
            } else {
                this.isDeleteRecordAvailable = false;
                this.deleteRecordKey = null;
                this.deleteRecordValue = null;
                this.deleteRecords = null;
            }
        }

        @Override
        public boolean isEmpty() {
            if (this.isDeleteRecordAvailable == null) {
                throw new IllegalStateException("Not yet initialized");
            }
            return this.isDeleteRecordAvailable == false;
        }

        @Override
        public void findDeletedRecords(ColumnVector[] cols, int size, BitSet selectedBitSet) throws IOException {
            if (!this.isDeleteRecordAvailable.booleanValue()) {
                return;
            }
            long[] originalWriteId = cols[1].isRepeating ? null : ((LongColumnVector)cols[1]).vector;
            long[] bucket = cols[2].isRepeating ? null : ((LongColumnVector)cols[2]).vector;
            long[] rowId = cols[3].isRepeating ? null : ((LongColumnVector)cols[3]).vector;
            long repeatedOriginalWriteId = originalWriteId != null ? -1L : ((LongColumnVector)cols[1]).vector[0];
            long repeatedBucket = bucket != null ? -1L : ((LongColumnVector)cols[2]).vector[0];
            long repeatedRowId = rowId != null ? -1L : ((LongColumnVector)cols[3]).vector[0];
            int firstValidIndex = selectedBitSet.nextSetBit(0);
            if (firstValidIndex == -1) {
                return;
            }
            RecordIdentifier firstRecordIdInBatch = new RecordIdentifier(originalWriteId != null ? originalWriteId[firstValidIndex] : repeatedOriginalWriteId, bucket != null ? (int)bucket[firstValidIndex] : (int)repeatedBucket, rowId != null ? (long)((int)rowId[firstValidIndex]) : repeatedRowId);
            int lastValidIndex = selectedBitSet.previousSetBit(size - 1);
            RecordIdentifier lastRecordIdInBatch = new RecordIdentifier(originalWriteId != null ? originalWriteId[lastValidIndex] : repeatedOriginalWriteId, bucket != null ? (int)bucket[lastValidIndex] : (int)repeatedBucket, rowId != null ? (long)((int)rowId[lastValidIndex]) : repeatedRowId);
            while (this.deleteRecordKey.compareRow(firstRecordIdInBatch) == -1) {
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
                if (this.isDeleteRecordAvailable.booleanValue()) continue;
                return;
            }
            int currIndex = firstValidIndex;
            RecordIdentifier currRecordIdInBatch = new RecordIdentifier();
            while (this.isDeleteRecordAvailable.booleanValue() && currIndex != -1 && currIndex <= lastValidIndex) {
                currRecordIdInBatch.setValues(originalWriteId != null ? originalWriteId[currIndex] : repeatedOriginalWriteId, bucket != null ? (int)bucket[currIndex] : (int)repeatedBucket, rowId != null ? rowId[currIndex] : repeatedRowId);
                if (this.deleteRecordKey.compareRow(currRecordIdInBatch) == 0) {
                    selectedBitSet.clear(currIndex);
                    currIndex = selectedBitSet.nextSetBit(currIndex + 1);
                    continue;
                }
                if (this.deleteRecordKey.compareRow(currRecordIdInBatch) == 1) {
                    if (this.deleteRecordKey.compareRow(lastRecordIdInBatch) == 1) {
                        return;
                    }
                    currIndex = selectedBitSet.nextSetBit(currIndex + 1);
                    continue;
                }
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.deleteRecords != null) {
                this.deleteRecords.close();
            }
        }
    }

    protected static interface DeleteEventRegistry {
        public void findDeletedRecords(ColumnVector[] var1, int var2, BitSet var3) throws IOException;

        public void close() throws IOException;

        public boolean isEmpty();
    }

    private static class ReaderData {
        OrcTail orcTail;
        Reader reader;

        private ReaderData() {
        }
    }
}

