/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.protobuf.ProtobufSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public class ProtobufBytesWritableSerDe
extends ProtobufSerDe {
    private Parser<? extends Message> parser;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        super.initialize(conf, tbl);
        try {
            Parser tmpParser;
            this.parser = tmpParser = (Parser)this.protoMessageClass.getField("PARSER").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new SerDeException("Unable get PARSER from class: " + this.protoMessageClass.getName(), e);
        }
    }

    @Override
    protected Message toMessage(Writable writable) throws SerDeException {
        try {
            BytesWritable bytes = (BytesWritable)writable;
            return this.parser.parseFrom(bytes.getBytes(), 0, bytes.getLength());
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerDeException("Unable to parse proto message", e);
        }
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return BytesWritable.class;
    }
}

