/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.table.lock.show.ShowLocksOperation;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbLockManager
implements HiveLockManager {
    private static final String CLASS_NAME = DbLockManager.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private long MAX_SLEEP;
    private Set<DbHiveLock> locks = new HashSet<DbHiveLock>();
    private long nextSleep = 50L;
    private final HiveConf conf;
    private final DbTxnManager txnManager;

    DbLockManager(HiveConf conf, DbTxnManager txnManager) {
        this.conf = conf;
        this.txnManager = txnManager;
    }

    @Override
    public void setContext(HiveLockManagerCtx ctx) throws LockException {
    }

    @Override
    public HiveLock lock(HiveLockObject key, HiveLockMode mode, boolean keepAlive) throws LockException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<HiveLock> lock(List<HiveLockObj> objs, boolean keepAlive, DriverState driverState) throws LockException {
        throw new UnsupportedOperationException();
    }

    LockState lock(LockRequest lock2, String queryId, boolean isBlocking, List<HiveLock> acquiredLocks) throws LockException {
        Objects.requireNonNull(queryId, "queryId cannot be null");
        this.nextSleep = 50L;
        this.MAX_SLEEP = Math.max(15000L, this.conf.getTimeVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES, TimeUnit.MILLISECONDS));
        int maxNumWaits = Math.max(0, this.conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES));
        try {
            LOG.info("Requesting: queryId=" + queryId + " " + lock2);
            LockResponse res = this.txnManager.getMS().lock(lock2);
            LOG.info("Response to queryId=" + queryId + " " + res);
            if (!isBlocking && res.getState() == LockState.WAITING) {
                return LockState.WAITING;
            }
            int numRetries = 0;
            long startRetry = System.currentTimeMillis();
            while (res.getState() == LockState.WAITING && numRetries++ < maxNumWaits) {
                this.backoff();
                res = this.txnManager.getMS().checkLock(res.getLockid());
            }
            long retryDuration = System.currentTimeMillis() - startRetry;
            DbHiveLock hl = new DbHiveLock(res.getLockid(), queryId, lock2.getTxnid(), lock2.getComponent());
            if (this.locks.size() > 0) {
                boolean logMsg = false;
                for (DbHiveLock l : this.locks) {
                    if (l.txnId != hl.txnId) {
                        logMsg = true;
                        break;
                    }
                    if (l.txnId != 0L || l.queryId.equals(hl.queryId)) continue;
                    logMsg = true;
                    break;
                }
                if (logMsg) {
                    LOG.warn("adding new DbHiveLock(" + hl + ") while we are already tracking locks: " + this.locks);
                }
            }
            this.locks.add(hl);
            if (res.getState() != LockState.ACQUIRED) {
                if (res.getState() == LockState.WAITING) {
                    this.unlock(hl);
                    LockException le = new LockException(null, ErrorMsg.LOCK_ACQUIRE_TIMEDOUT, lock2.toString(), Long.toString(retryDuration), res.toString());
                    if (this.conf.getBoolVar(HiveConf.ConfVars.TXN_MGR_DUMP_LOCK_STATE_ON_ACQUIRE_TIMEOUT)) {
                        this.showLocksNewFormat(le.getMessage());
                    }
                    throw le;
                }
                throw new LockException(ErrorMsg.LOCK_CANNOT_BE_ACQUIRED.getMsg() + " " + res);
            }
            acquiredLocks.add(hl);
            Metrics metrics = MetricsFactory.getInstance();
            if (metrics != null) {
                try {
                    metrics.incrementCounter("metastore_hive_locks");
                }
                catch (Exception e) {
                    LOG.warn("Error Reporting hive client metastore lock operation to Metrics system", (Throwable)e);
                }
            }
            return res.getState();
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString(lock2.getTxnid()));
            throw new LockException((Throwable)e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString(lock2.getTxnid()));
        }
        catch (TxnAbortedException e) {
            LockException le = new LockException((Throwable)e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString(lock2.getTxnid()), e.getMessage());
            LOG.error(le.getMessage());
            throw le;
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    private void showLocksNewFormat(String preamble) throws LockException {
        ShowLocksResponse rsp = this.getLocks();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        DataOutputStream os = new DataOutputStream(baos);
        try {
            ShowLocksOperation.dumpLockInfo(os, rsp);
            os.flush();
            LOG.info(baos.toString());
        }
        catch (IOException ex) {
            LOG.error("Dumping lock info for " + preamble + " failed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    LockState checkLock(long extLockId) throws LockException {
        try {
            return this.txnManager.getMS().checkLock(extLockId).getState();
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void unlock(HiveLock hiveLock) throws LockException {
        long lockId = ((DbHiveLock)hiveLock).lockId;
        boolean removed = false;
        try {
            LOG.debug("Unlocking " + hiveLock);
            this.txnManager.getMS().unlock(lockId);
            removed = this.locks.remove(hiveLock);
            Metrics metrics = MetricsFactory.getInstance();
            if (metrics != null) {
                try {
                    metrics.decrementCounter("metastore_hive_locks");
                }
                catch (Exception e) {
                    LOG.warn("Error Reporting hive client metastore unlock operation to Metrics system", (Throwable)e);
                }
            }
            LOG.debug("Removed a lock " + removed);
        }
        catch (NoSuchLockException e) {
            removed = this.locks.remove(hiveLock);
            LOG.error("Metastore could find no record of lock " + JavaUtils.lockIdToString(lockId));
            throw new LockException((Throwable)e, ErrorMsg.LOCK_NO_SUCH_LOCK, JavaUtils.lockIdToString(lockId));
        }
        catch (TxnOpenException e) {
            throw new RuntimeException("Attempt to unlock lock " + JavaUtils.lockIdToString(lockId) + "associated with an open transaction, " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            if (removed) {
                LOG.debug("Removed a lock " + hiveLock);
            }
        }
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) {
        LOG.info("releaseLocks: " + hiveLocks);
        for (HiveLock lock2 : hiveLocks) {
            try {
                this.unlock(lock2);
            }
            catch (LockException lockException) {}
        }
    }

    @Override
    public List<HiveLock> getLocks(boolean verifyTablePartitions, boolean fetchData) throws LockException {
        return new ArrayList<HiveLock>(this.locks);
    }

    @Override
    public List<HiveLock> getLocks(HiveLockObject key, boolean verifyTablePartitions, boolean fetchData) throws LockException {
        throw new UnsupportedOperationException();
    }

    public ShowLocksResponse getLocks() throws LockException {
        return this.getLocks(new ShowLocksRequest());
    }

    public ShowLocksResponse getLocks(ShowLocksRequest showLocksRequest) throws LockException {
        try {
            return this.txnManager.getMS().showLocks(showLocksRequest);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void close() throws LockException {
        for (HiveLock hiveLock : this.locks) {
            this.unlock(hiveLock);
        }
        this.locks.clear();
    }

    @Override
    public void prepareRetry() throws LockException {
    }

    @Override
    public void refresh() {
    }

    void clearLocalLockRecords() {
        this.locks.clear();
    }

    private void backoff() {
        this.nextSleep *= 2L;
        if (this.nextSleep > this.MAX_SLEEP) {
            this.nextSleep = this.MAX_SLEEP;
        }
        try {
            Thread.sleep(this.nextSleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class DbHiveLock
    extends HiveLock {
        long lockId;
        String queryId;
        long txnId;
        List<LockComponent> components;

        DbHiveLock(long id) {
            this.lockId = id;
        }

        DbHiveLock(long id, String queryId, long txnId, List<LockComponent> components) {
            this.lockId = id;
            this.queryId = queryId;
            this.txnId = txnId;
            this.components = ImmutableList.copyOf(components);
        }

        @Override
        public HiveLockObject getHiveLockObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HiveLockMode getHiveLockMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mayContainComponents() {
            return true;
        }

        @Override
        public List<LockComponent> getHiveLockComponents() {
            return this.components;
        }

        public boolean equals(Object other) {
            if (other instanceof DbHiveLock) {
                return this.lockId == ((DbHiveLock)other).lockId;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.lockId % Integer.MAX_VALUE);
        }

        public String toString() {
            return JavaUtils.lockIdToString(this.lockId) + " queryId=" + this.queryId + " " + JavaUtils.txnIdToString(this.txnId);
        }
    }
}

