/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageAuthorizationHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class DefaultStorageHandler
implements HiveStorageHandler,
HiveStorageAuthorizationHandler {
    private Configuration conf;

    @Override
    public Class<? extends InputFormat> getInputFormatClass() {
        return SequenceFileInputFormat.class;
    }

    @Override
    public Class<? extends OutputFormat> getOutputFormatClass() {
        return SequenceFileOutputFormat.class;
    }

    @Override
    public Class<? extends AbstractSerDe> getSerDeClass() {
        return LazySimpleSerDe.class;
    }

    @Override
    public HiveMetaHook getMetaHook() {
        return null;
    }

    @Override
    public URI getURIForAuth(Map<String, String> tableProperties) throws URISyntaxException {
        try {
            return new URI(this.getClass().getSimpleName().toLowerCase() + "://" + HiveCustomStorageHandlerUtils.getTablePropsForCustomStorageHandler(tableProperties));
        }
        catch (Exception ex) {
            throw new URISyntaxException("Unsupported ex", ex.getMessage());
        }
    }

    @Override
    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return new DefaultHiveAuthorizationProvider();
    }

    @Override
    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    @Override
    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    @Override
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    @Override
    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    @Override
    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> secrets) {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

