/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HdfsUtils;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRow;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.TempTable;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHiveMetaStoreClient
extends HiveMetaStoreClient
implements IMetaStoreClient {
    private static final Logger LOG = LoggerFactory.getLogger(SessionHiveMetaStoreClient.class);
    private Warehouse wh = null;

    SessionHiveMetaStoreClient(Configuration conf, Boolean allowEmbedded) throws MetaException {
        super(conf, null, allowEmbedded);
    }

    SessionHiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        super(conf, hookLoader, allowEmbedded);
    }

    private Warehouse getWh() throws MetaException {
        if (this.wh == null) {
            this.wh = new Warehouse(this.conf);
        }
        return this.wh;
    }

    @Override
    protected void create_table(CreateTableRequest request) throws InvalidObjectException, MetaException, NoSuchObjectException, TException {
        org.apache.hadoop.hive.metastore.api.Table tbl = request.getTable();
        if (tbl.isTemporary()) {
            this.createTempTable(tbl);
            return;
        }
        super.create_table(request);
    }

    @Override
    protected void drop_table_with_environment_context(String catName, String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbname, name);
        if (table != null) {
            try {
                this.deleteTempTableColumnStatsForTable(dbname, name);
            }
            catch (NoSuchObjectException err) {
                LOG.info("Object not found in metastore", (Throwable)err);
            }
            this.dropTempTable(table, deleteData, envContext);
            return;
        }
        super.drop_table_with_environment_context(catName, dbname, name, deleteData, envContext);
    }

    @Override
    public void truncateTable(String dbName, String tableName, List<String> partNames) throws MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table != null) {
            this.truncateTempTable(table);
            return;
        }
        super.truncateTable(dbName, tableName, partNames);
    }

    @Override
    public void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table != null) {
            this.truncateTempTable(table);
            return;
        }
        super.truncateTable(dbName, tableName, partNames, validWriteIds, writeId);
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        return this.getTable(dbname, name, false, null);
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getTable(String dbname, String name, boolean getColStats, String engine) throws MetaException, TException, NoSuchObjectException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbname, name);
        if (table != null) {
            return this.deepCopy(table);
        }
        return super.getTable(MetaStoreUtils.getDefaultCatalog(this.conf), dbname, name, getColStats, engine);
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getTable(String catName, String dbName, String tableName) throws TException {
        return this.getTable(catName, dbName, tableName, false, null);
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getTable(String catName, String dbName, String tableName, boolean getColStats, String engine) throws TException {
        if (!"hive".equals(catName)) {
            return super.getTable(catName, dbName, tableName, getColStats, engine);
        }
        return this.getTable(dbName, tableName, getColStats, engine);
    }

    @Override
    public List<String> getAllTables(String dbName) throws MetaException {
        List<String> tableNames = super.getAllTables(dbName);
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName, "?");
        if (tables == null || tables.size() == 0) {
            return tableNames;
        }
        Set<String> tempTableNames = tables.keySet();
        HashSet<String> allTableNames = new HashSet<String>(tableNames.size() + tempTableNames.size());
        allTableNames.addAll(tableNames);
        allTableNames.addAll(tempTableNames);
        tableNames = new ArrayList<String>(allTableNames);
        Collections.sort(tableNames);
        return tableNames;
    }

    @Override
    public List<String> getTables(String dbName, String tablePattern) throws MetaException {
        List<String> tableNames = super.getTables(dbName, tablePattern);
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName = dbName.toLowerCase(), tablePattern = tablePattern.toLowerCase());
        if (tables == null || tables.size() == 0) {
            return tableNames;
        }
        tablePattern = tablePattern.replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(tablePattern);
        Matcher matcher = pattern.matcher("");
        HashSet<String> combinedTableNames = new HashSet<String>();
        for (String tableName : tables.keySet()) {
            matcher.reset(tableName);
            if (!matcher.matches()) continue;
            combinedTableNames.add(tableName);
        }
        combinedTableNames.addAll(tableNames);
        tableNames = new ArrayList<String>(combinedTableNames);
        Collections.sort(tableNames);
        return tableNames;
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException {
        List<String> tableNames = super.getTables(dbname, tablePattern, tableType);
        if (tableType == TableType.MANAGED_TABLE || tableType == TableType.EXTERNAL_TABLE) {
            Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname = dbname.toLowerCase(), tablePattern = tablePattern.toLowerCase());
            if (tables == null || tables.size() == 0) {
                return tableNames;
            }
            tablePattern = tablePattern.replaceAll("\\*", ".*");
            Pattern pattern = Pattern.compile(tablePattern);
            Matcher matcher = pattern.matcher("");
            HashSet<String> combinedTableNames = new HashSet<String>();
            combinedTableNames.addAll(tableNames);
            for (Map.Entry<String, Table> tableData : tables.entrySet()) {
                matcher.reset(tableData.getKey());
                if (!matcher.matches()) continue;
                if (tableData.getValue().getTableType() == tableType) {
                    combinedTableNames.add(tableData.getKey());
                    continue;
                }
                combinedTableNames.remove(tableData.getKey());
            }
            tableNames = new ArrayList<String>(combinedTableNames);
            Collections.sort(tableNames);
        }
        return tableNames;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException {
        void var9_11;
        List<TableMeta> tableMetas = super.getTableMeta(dbPatterns, tablePatterns, tableTypes);
        Map<String, Map<String, Table>> tmpTables = SessionHiveMetaStoreClient.getTempTables("dbPatterns='" + dbPatterns + "' tablePatterns='" + tablePatterns + "'");
        if (tmpTables.isEmpty()) {
            return tableMetas;
        }
        ArrayList<Matcher> dbPatternList = new ArrayList<Matcher>();
        String[] stringArray = dbPatterns.split("\\|");
        int n = stringArray.length;
        boolean bl = false;
        while (var9_11 < n) {
            String element = stringArray[var9_11];
            dbPatternList.add(Pattern.compile(element.replaceAll("\\*", ".*")).matcher(""));
            ++var9_11;
        }
        ArrayList<Matcher> tblPatternList = new ArrayList<Matcher>();
        for (String element : tablePatterns.split("\\|")) {
            tblPatternList.add(Pattern.compile(element.replaceAll("\\*", ".*")).matcher(""));
        }
        for (Map.Entry entry : tmpTables.entrySet()) {
            if (!this.matchesAny((String)entry.getKey(), dbPatternList)) continue;
            for (Map.Entry inner : ((Map)entry.getValue()).entrySet()) {
                Table table = (Table)inner.getValue();
                String tableName = table.getTableName();
                String typeString = table.getTableType().name();
                if (tableTypes != null && !tableTypes.contains(typeString) || !this.matchesAny((String)inner.getKey(), tblPatternList)) continue;
                TableMeta tableMeta = new TableMeta(table.getDbName(), tableName, typeString);
                tableMeta.setComments(table.getProperty("comment"));
                tableMetas.add(tableMeta);
            }
        }
        return tableMetas;
    }

    private boolean matchesAny(String string, List<Matcher> matchers) {
        for (Matcher matcher : matchers) {
            if (!matcher.reset(string).matches()) continue;
            return true;
        }
        return matchers.isEmpty();
    }

    @Override
    public List<org.apache.hadoop.hive.metastore.api.Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        dbName = dbName.toLowerCase();
        if (SessionState.get() == null || SessionState.get().getTempTables().size() == 0) {
            return super.getTableObjectsByName(dbName, tableNames);
        }
        ArrayList<org.apache.hadoop.hive.metastore.api.Table> tables = new ArrayList<org.apache.hadoop.hive.metastore.api.Table>();
        for (String tableName : tableNames) {
            try {
                org.apache.hadoop.hive.metastore.api.Table table = this.getTable(dbName, tableName);
                if (table == null) continue;
                tables.add(table);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        }
        return tables;
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(databaseName, tableName);
        if (table != null) {
            return true;
        }
        return super.tableExists(databaseName, tableName);
    }

    @Override
    public List<FieldSchema> getSchema(String dbName, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table != null) {
            return this.deepCopyFieldSchemas(table.getSd().getCols());
        }
        return super.getSchema(dbName, tableName);
    }

    @Override
    @Deprecated
    public void alter_table(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, boolean cascade) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, null);
            return;
        }
        super.alter_table(dbname, tbl_name, new_tbl, cascade);
    }

    @Override
    public void alter_table(String catName, String dbName, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, EnvironmentContext envContext, String validWriteIds) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbName, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbName, tbl_name, old_tbl, new_tbl, null);
            return;
        }
        super.alter_table(catName, dbName, tbl_name, new_tbl, envContext, validWriteIds);
    }

    @Override
    public void alter_table(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, null);
            return;
        }
        super.alter_table(dbname, tbl_name, new_tbl);
    }

    @Override
    public void alter_table_with_environmentContext(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, envContext);
            return;
        }
        super.alter_table_with_environmentContext(dbname, tbl_name, new_tbl, envContext);
    }

    @Override
    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (hiveObject.getObjectType() == HiveObjectType.TABLE && (table = this.getTempTable(hiveObject.getDbName(), hiveObject.getObjectName())) != null) {
            return this.deepCopy(table.getPrivileges());
        }
        return super.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        String tableName;
        ColumnStatistics colStats;
        ColumnStatisticsDesc desc;
        String dbName;
        if (request.getColStatsSize() == 1 && this.getTempTable(dbName = (desc = (colStats = request.getColStatsIterator().next()).getStatsDesc()).getDbName().toLowerCase(), tableName = desc.getTableName().toLowerCase()) != null) {
            return this.updateTempTableColumnStats(dbName, tableName, colStats);
        }
        return super.setPartitionColumnStatistics(request);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException, InvalidInputException, InvalidObjectException {
        if (this.getTempTable(dbName, tableName) != null) {
            return this.getTempTableColumnStats(dbName, tableName, colNames);
        }
        return super.getTableColumnStatistics(dbName, tableName, colNames, engine);
    }

    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName, String engine) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        if (this.getTempTable(dbName, tableName) != null) {
            return this.deleteTempTableColumnStats(dbName, tableName, colName);
        }
        return super.deleteTableColumnStatistics(dbName, tableName, colName, engine);
    }

    private void createTempTable(org.apache.hadoop.hive.metastore.api.Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        Path tblPath;
        String tblName;
        boolean isVirtualTable = tbl.getTableName().startsWith("Values__Tmp__Table__");
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot create temporary table: " + Warehouse.getQualifiedName(tbl));
        }
        String dbName = (tbl = this.deepCopyAndLowerCaseTable(tbl)).getDbName();
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName, tblName = tbl.getTableName());
        if (tables != null && tables.containsKey(tblName)) {
            throw new MetaException("Temporary table " + StatsUtils.getFullyQualifiedTableName(dbName, tblName) + " already exists");
        }
        Warehouse wh = this.getWh();
        if (tbl.getSd().getLocation() == null) {
            tbl.getSd().setLocation(SessionState.generateTempTableLocation(this.conf));
        }
        if ((tblPath = wh.getDnsPath(new Path(tbl.getSd().getLocation()))) == null) {
            throw new MetaException("Temp table path not set for " + tbl.getTableName());
        }
        if (!wh.isDir(tblPath) && !wh.mkdirs(tblPath)) {
            throw new MetaException(tblPath + " is not a directory or unable to create one");
        }
        tbl.getSd().setLocation(tblPath.toString());
        Table tTable = new Table(tbl);
        if (!isVirtualTable) {
            StatsSetupConst.setStatsStateForCreateTable(tbl.getParameters(), MetaStoreUtils.getColumnNamesForTable(tbl), "true");
        }
        if (tables == null) {
            tables = new HashMap<String, Table>();
            ss.getTempTables().put(dbName, tables);
        }
        tables.put(tblName, tTable);
        this.createPartitionedTempTable(tbl);
    }

    private org.apache.hadoop.hive.metastore.api.Table getTempTable(String dbName, String tableName) throws MetaException {
        Table table;
        if (dbName == null) {
            throw new MetaException("Db name cannot be null");
        }
        if (tableName == null) {
            throw new MetaException("Table name cannot be null");
        }
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName.toLowerCase(), tableName.toLowerCase());
        if (tables != null && (table = tables.get(tableName.toLowerCase())) != null) {
            return table.getTTable();
        }
        return null;
    }

    private void alterTempTable(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        dbname = dbname.toLowerCase();
        tbl_name = tbl_name.toLowerCase();
        boolean shouldDeleteColStats = false;
        if (!newt.getSd().getLocation().equals(oldt.getSd().getLocation())) {
            throw new MetaException("Temp table location cannot be changed");
        }
        org.apache.hadoop.hive.metastore.api.Table newtCopy = this.deepCopyAndLowerCaseTable(newt);
        Table newTable = new Table(newtCopy);
        String newDbName = newTable.getDbName();
        String newTableName = newTable.getTableName();
        if (!newDbName.equals(oldt.getDbName()) || !newTableName.equals(oldt.getTableName())) {
            if (this.getTempTable(newDbName, newTableName) != null) {
                throw new MetaException("Cannot rename temporary table to " + newTableName + " - temporary table already exists with the same name");
            }
            Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname, tbl_name);
            if (tables == null || tables.remove(tbl_name) == null) {
                throw new MetaException("Could not find temp table entry for " + dbname + "." + tbl_name);
            }
            shouldDeleteColStats = true;
            tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(newDbName, tbl_name);
            if (tables == null) {
                tables = new HashMap<String, Table>();
                SessionState.get().getTempTables().put(newDbName, tables);
            }
            tables.put(newTableName, newTable);
        } else {
            if (SessionHiveMetaStoreClient.haveTableColumnsChanged(oldt, newt)) {
                shouldDeleteColStats = true;
            }
            SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname, tbl_name).put(tbl_name, newTable);
        }
        if (shouldDeleteColStats) {
            try {
                this.deleteTempTableColumnStatsForTable(dbname, tbl_name);
            }
            catch (NoSuchObjectException err) {
                LOG.info("Object not found in metastore", (Throwable)err);
            }
        }
    }

    private static boolean haveTableColumnsChanged(org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt) {
        List<FieldSchema> oldCols = oldt.getSd().getCols();
        List<FieldSchema> newCols = newt.getSd().getCols();
        if (oldCols.size() != newCols.size()) {
            return true;
        }
        Iterator<FieldSchema> oldColsIter = oldCols.iterator();
        Iterator<FieldSchema> newColsIter = newCols.iterator();
        while (oldColsIter.hasNext()) {
            if (SessionHiveMetaStoreClient.fieldSchemaEqualsIgnoreComment(oldColsIter.next(), newColsIter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean fieldSchemaEqualsIgnoreComment(FieldSchema left, FieldSchema right) {
        if (!left.getName().equals(right.getName())) {
            return true;
        }
        return !left.getType().equals(right.getType());
    }

    private boolean needToUpdateStats(Map<String, String> props, EnvironmentContext environmentContext) {
        if (null == props) {
            return false;
        }
        boolean statsPresent = false;
        for (String stat : StatsSetupConst.SUPPORTED_STATS) {
            String statVal = props.get(stat);
            if (statVal == null || Long.parseLong(statVal) <= 0L) continue;
            statsPresent = true;
            props.put(stat, "0");
        }
        StatsSetupConst.setBasicStatsState(props, "true");
        environmentContext.putToProperties("STATS_GENERATED", "TASK");
        StatsSetupConst.clearColumnStatsState(props);
        return statsPresent;
    }

    private void truncateTempTable(org.apache.hadoop.hive.metastore.api.Table table) throws MetaException, TException {
        boolean isAutopurge = "true".equalsIgnoreCase(table.getParameters().get("auto.purge"));
        try {
            Path location = new Path(table.getSd().getLocation());
            FileSystem fs = location.getFileSystem(this.conf);
            HadoopShims.HdfsEncryptionShim shim = ShimLoader.getHadoopShims().createHdfsEncryptionShim(fs, this.conf);
            if (!shim.isPathEncrypted(location)) {
                HdfsUtils.HadoopFileStatus status = new HdfsUtils.HadoopFileStatus(this.conf, fs, location);
                FileStatus targetStatus = fs.getFileStatus(location);
                String targetGroup = targetStatus == null ? null : targetStatus.getGroup();
                FileUtils.moveToTrash(fs, location, this.conf, isAutopurge);
                fs.mkdirs(location);
                HdfsUtils.setFullFileStatus(this.conf, status, targetGroup, fs, location, false);
            } else {
                boolean success;
                FileStatus[] statuses = fs.listStatus(location, FileUtils.HIDDEN_FILES_PATH_FILTER);
                if (statuses != null && statuses.length > 0 && !(success = Hive.trashFiles(fs, statuses, this.conf, isAutopurge))) {
                    throw new HiveException("Error in deleting the contents of " + location.toString());
                }
            }
            EnvironmentContext environmentContext = new EnvironmentContext();
            if (this.needToUpdateStats(table.getParameters(), environmentContext)) {
                this.alter_table_with_environmentContext(table.getDbName(), table.getTableName(), table, environmentContext);
            }
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage());
        }
    }

    private void dropTempTable(org.apache.hadoop.hive.metastore.api.Table table, boolean deleteData, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        Map<String, Table> tables;
        String dbName = table.getDbName().toLowerCase();
        String tableName = table.getTableName().toLowerCase();
        Path tablePath = null;
        String pathStr = table.getSd().getLocation();
        if (pathStr != null) {
            try {
                tablePath = new Path(table.getSd().getLocation());
                if (!this.getWh().isWritable(tablePath.getParent())) {
                    throw new MetaException("Table metadata not deleted since " + tablePath.getParent() + " is not writable by " + SecurityUtils.getUser());
                }
            }
            catch (IOException err) {
                MetaException metaException = new MetaException("Error checking temp table path for " + table.getTableName());
                metaException.initCause(err);
                throw metaException;
            }
        }
        if ((tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName, tableName)) == null || tables.remove(tableName) == null) {
            throw new MetaException("Could not find temp table entry for " + StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        }
        this.removePartitionedTempTable(table);
        if (deleteData && !MetaStoreUtils.isExternalTable(table)) {
            try {
                boolean ifPurge = false;
                if (envContext != null) {
                    ifPurge = Boolean.parseBoolean(envContext.getProperties().get("ifPurge"));
                }
                this.getWh().deleteDir(tablePath, true, ifPurge, false);
            }
            catch (Exception err) {
                LOG.error("Failed to delete temp table directory: " + tablePath, (Throwable)err);
            }
        }
    }

    private org.apache.hadoop.hive.metastore.api.Table deepCopyAndLowerCaseTable(org.apache.hadoop.hive.metastore.api.Table tbl) {
        org.apache.hadoop.hive.metastore.api.Table newCopy = this.deepCopy(tbl);
        newCopy.setDbName(newCopy.getDbName().toLowerCase());
        newCopy.setTableName(newCopy.getTableName().toLowerCase());
        return newCopy;
    }

    public static Map<String, Table> getTempTablesForDatabase(String dbName, String tblName) {
        return SessionHiveMetaStoreClient.getTempTables(Warehouse.getQualifiedName(dbName, tblName)).get(dbName);
    }

    private static Map<String, Map<String, Table>> getTempTables(String msg) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables for " + msg);
            return Collections.emptyMap();
        }
        return ss.getTempTables();
    }

    private Map<String, ColumnStatisticsObj> getTempTableColumnStatsForTable(String dbName, String tableName) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables for " + Warehouse.getQualifiedName(dbName, tableName));
            return null;
        }
        String lookupName = StatsUtils.getFullyQualifiedTableName(dbName.toLowerCase(), tableName.toLowerCase());
        return ss.getTempTableColStats().get(lookupName);
    }

    private List<ColumnStatisticsObj> getTempTableColumnStats(String dbName, String tableName, List<String> colNames) {
        Map<String, ColumnStatisticsObj> tableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        ArrayList<ColumnStatisticsObj> retval = new ArrayList<ColumnStatisticsObj>();
        if (tableColStats != null) {
            for (String colName : colNames) {
                if (!tableColStats.containsKey(colName = colName.toLowerCase())) continue;
                retval.add(new ColumnStatisticsObj(tableColStats.get(colName)));
            }
        }
        return retval;
    }

    private boolean updateTempTableColumnStats(String dbName, String tableName, ColumnStatistics colStats) throws MetaException {
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot update temporary table stats for " + StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        }
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats == null) {
            ssTableColStats = new HashMap<String, ColumnStatisticsObj>();
            ss.getTempTableColStats().put(StatsUtils.getFullyQualifiedTableName(dbName, tableName), ssTableColStats);
        }
        SessionHiveMetaStoreClient.mergeColumnStats(ssTableColStats, colStats);
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnStatisticsObj obj : colStats.getStatsObj()) {
            colNames.add(obj.getColName());
        }
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        StatsSetupConst.setColumnStatsState(table.getParameters(), colNames);
        return true;
    }

    private static void mergeColumnStats(Map<String, ColumnStatisticsObj> oldStats, ColumnStatistics newStats) {
        List<ColumnStatisticsObj> newColList = newStats.getStatsObj();
        if (newColList != null) {
            for (ColumnStatisticsObj colStat : newColList) {
                oldStats.put(colStat.getColName().toLowerCase(), colStat);
            }
        }
    }

    private boolean deleteTempTableColumnStatsForTable(String dbName, String tableName) throws NoSuchObjectException {
        Map<String, ColumnStatisticsObj> deletedEntry = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        SessionState.get().getTempTableColStats().remove(StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        return true;
    }

    private boolean deleteTempTableColumnStats(String dbName, String tableName, String columnName) throws NoSuchObjectException {
        ColumnStatisticsObj deletedEntry = null;
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats != null) {
            deletedEntry = ssTableColStats.remove(columnName.toLowerCase());
        }
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        return true;
    }

    @Override
    public Partition add_partition(Partition partition) throws TException {
        if (partition == null) {
            throw new MetaException("Partition cannot be null");
        }
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(partition.getDbName(), partition.getTableName());
        if (table == null) {
            return super.add_partition(partition);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        this.checkPartitionProperties(partition);
        Path partitionLocation = this.getPartitionLocation(table, partition, false);
        Partition result = tt.addPartition(this.deepCopy(partition));
        this.createAndSetLocationForAddedPartition(result, partitionLocation);
        return result;
    }

    @Override
    public int add_partitions(List<Partition> partitions) throws TException {
        if (partitions == null || partitions.contains(null)) {
            throw new MetaException("Partitions cannot be null");
        }
        if (partitions.isEmpty()) {
            return 0;
        }
        List<Partition> addedPartitions = this.add_partitions(partitions, false, true);
        if (addedPartitions != null) {
            return addedPartitions.size();
        }
        return super.add_partitions(partitions);
    }

    @Override
    public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws TException {
        if (partitionSpec == null) {
            throw new MetaException("PartitionSpec cannot be null.");
        }
        if (partitionSpec.size() == 0) {
            return 0;
        }
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(partitionSpec.getDbName(), partitionSpec.getTableName());
        if (table == null) {
            return super.add_partitions_pspec(partitionSpec);
        }
        this.assertTempTablePartitioned(table);
        PartitionSpecProxy.PartitionIterator partitionIterator = partitionSpec.getPartitionIterator();
        ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>(partitionSpec.size());
        while (partitionIterator.hasNext()) {
            partitionsToAdd.add((Partition)partitionIterator.next());
        }
        List<Partition> addedPartitions = this.addPartitionsToTempTable(partitionsToAdd, partitionSpec.getDbName(), partitionSpec.getTableName(), false);
        if (addedPartitions != null) {
            return addedPartitions.size();
        }
        return super.add_partitions_pspec(partitionSpec);
    }

    @Override
    public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResults) throws TException {
        if (partitions == null || partitions.contains(null)) {
            throw new MetaException("Partitions cannot be null");
        }
        if (partitions.isEmpty()) {
            return needResults ? new ArrayList() : null;
        }
        List<Partition> addedPartitions = this.addPartitionsToTempTable(partitions, null, null, ifNotExists);
        if (addedPartitions != null) {
            return needResults ? addedPartitions : null;
        }
        return super.add_partitions(partitions, ifNotExists, needResults);
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, String name) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.getPartition(catName, dbName, tblName, name);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        Partition partition = tt.getPartition(name);
        if (partition == null) {
            throw new NoSuchObjectException("Partition with name " + name + " for table " + tblName + " in database " + dbName + " is not found.");
        }
        return this.deepCopy(partition);
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.getPartition(catName, dbName, tblName, partVals);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        Partition partition = tt.getPartition(partVals);
        if (partition == null) {
            throw new NoSuchObjectException("Partition with partition values " + (partVals != null ? Arrays.toString(partVals.toArray()) : "null") + " for table " + tblName + " in database " + dbName + " is not found.");
        }
        return this.deepCopy(partition);
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, List<String> partialPvals, int maxParts, String userName, List<String> groupNames) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.listPartitionsWithAuthInfo(catName, dbName, tableName, partialPvals, maxParts, userName, groupNames);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        List<Partition> parts = tt.listPartitionsByPartitionValsWithAuthInfo(partialPvals, userName, groupNames);
        return this.getPartitionsForMaxParts(tableName, parts, maxParts);
    }

    @Override
    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, int maxParts, String userName, List<String> groupNames) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.listPartitionsWithAuthInfo(catName, dbName, tableName, maxParts, userName, groupNames);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        List<Partition> partitions = tt.listPartitionsWithAuthInfo(userName, groupNames);
        return this.getPartitionsForMaxParts(tableName, partitions, maxParts);
    }

    @Override
    public GetPartitionsPsWithAuthResponse listPartitionsWithAuthInfoRequest(GetPartitionsPsWithAuthRequest req) throws MetaException, TException, NoSuchObjectException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(req.getDbName(), req.getTblName());
        if (table == null) {
            return super.listPartitionsWithAuthInfoRequest(req);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        List<Partition> partitions = tt.listPartitionsWithAuthInfo(req.getUserName(), req.getGroupNames());
        GetPartitionsPsWithAuthResponse response = new GetPartitionsPsWithAuthResponse();
        response.setPartitions(this.getPartitionsForMaxParts(req.getTblName(), partitions, req.getMaxParts()));
        return response;
    }

    @Override
    public List<String> listPartitionNames(String catName, String dbName, String tblName, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.listPartitionNames(catName, dbName, tblName, maxParts);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        List<Partition> partitions = tt.listPartitions();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < (maxParts < 0 || maxParts > partitions.size() ? partitions.size() : maxParts); ++i) {
            result.add(Warehouse.makePartName(table.getPartitionKeys(), partitions.get(i).getValues()));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> listPartitionNames(String catName, String dbName, String tblName, List<String> partVals, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.listPartitionNames(catName, dbName, tblName, partVals, maxParts);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        List<Partition> partitions = tt.getPartitionsByPartitionVals(partVals);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < (maxParts < 0 || maxParts > partitions.size() ? partitions.size() : maxParts); ++i) {
            result.add(Warehouse.makePartName(table.getPartitionKeys(), partitions.get(i).getValues()));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<Partition> listPartitions(String catName, String dbName, String tblName, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.listPartitions(catName, dbName, tblName, maxParts);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        return this.getPartitionsForMaxParts(tblName, tt.listPartitions(), maxParts);
    }

    @Override
    public List<Partition> listPartitions(String catName, String dbName, String tblName, List<String> partVals, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.listPartitions(catName, dbName, tblName, partVals, maxParts);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        return this.getPartitionsForMaxParts(tblName, tt.getPartitionsByPartitionVals(partVals), maxParts);
    }

    @Override
    public PartitionSpecProxy listPartitionSpecs(String catName, String dbName, String tableName, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.listPartitionSpecs(catName, dbName, tableName, maxParts);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        return this.getPartitionSpecProxy(table, tt.listPartitions(), maxParts);
    }

    @Override
    public boolean listPartitionsByExpr(String catName, String dbName, String tblName, byte[] expr, String defaultPartitionName, int maxParts, List<Partition> result) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.listPartitionsByExpr(catName, dbName, tblName, expr, defaultPartitionName, maxParts, result);
        }
        assert (result != null);
        result.addAll(this.getPartitionsForMaxParts(tblName, this.getPartitionedTempTable(table).listPartitionsByFilter(this.generateJDOFilter(table, expr, defaultPartitionName)), maxParts));
        return result.isEmpty();
    }

    @Override
    public List<Partition> getPartitionsByNames(String catName, String dbName, String tblName, List<String> partNames, boolean getColStats, String engine) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.getPartitionsByNames(catName, dbName, tblName, partNames, getColStats, engine);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        List<Partition> partitions = tt.getPartitionsByNames(partNames);
        return this.deepCopyPartitions(partitions);
    }

    @Override
    public Partition getPartitionWithAuthInfo(String catName, String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.getPartitionWithAuthInfo(catName, dbName, tableName, pvals, userName, groupNames);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        Partition partition = tt.getPartitionWithAuthInfo(pvals, userName, groupNames);
        if (partition == null) {
            throw new NoSuchObjectException("Partition with partition values " + (pvals != null ? Arrays.toString(pvals.toArray()) : "null") + " for table " + tableName + " in database " + dbName + "and for user " + userName + " and group names " + (groupNames != null ? Arrays.toString(groupNames.toArray()) : "null") + " is not found.");
        }
        return this.deepCopy(partition);
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, List<String> partVals) throws TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog(this.conf), dbName, tableName, partVals, PartitionDropOptions.instance().deleteData(true));
    }

    @Override
    public boolean dropPartition(String catName, String dbName, String tblName, List<String> partVals, PartitionDropOptions options) throws TException {
        boolean deleteData;
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.dropPartition(catName, dbName, tblName, partVals, options);
        }
        if (partVals == null || partVals.isEmpty() || partVals.contains(null)) {
            throw new MetaException("Partition values cannot be null, empty or contain null values");
        }
        TempTable tt = this.getPartitionedTempTable(table);
        if (tt == null) {
            throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName(table));
        }
        Partition droppedPartition = tt.dropPartition(partVals);
        boolean result = droppedPartition != null;
        boolean purgeData = options != null ? options.purgeData : true;
        boolean bl = deleteData = options != null ? options.deleteData : true;
        if (deleteData && !tt.isExternal()) {
            result &= this.deletePartitionLocation(droppedPartition, purgeData);
        }
        return result;
    }

    @Override
    public boolean dropPartition(String catName, String dbName, String tableName, String partitionName, boolean deleteData) throws TException {
        boolean result;
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.dropPartition(catName, dbName, tableName, partitionName, deleteData);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        Partition droppedPartition = tt.dropPartition(partitionName);
        boolean bl = result = droppedPartition != null;
        if (deleteData && !tt.isExternal()) {
            result &= this.deletePartitionLocation(droppedPartition, true);
        }
        return result;
    }

    @Override
    public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.dropPartitions(catName, dbName, tblName, partExprs, options);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        ArrayList<Partition> result = new ArrayList<Partition>();
        for (Pair<Integer, byte[]> pair : partExprs) {
            byte[] expr = pair.getRight();
            String filter = this.generateJDOFilter(table, expr, this.conf.get(HiveConf.ConfVars.DEFAULTPARTITIONNAME.varname));
            List<Partition> partitions = tt.listPartitionsByFilter(filter);
            for (Partition p : partitions) {
                Partition droppedPartition = tt.dropPartition(p.getValues());
                if (droppedPartition == null) continue;
                result.add(droppedPartition);
                boolean purgeData = options != null ? options.purgeData : true;
                boolean deleteData = options != null ? options.deleteData : true;
                if (!deleteData || tt.isExternal()) continue;
                this.deletePartitionLocation(droppedPartition, purgeData);
            }
        }
        return result;
    }

    @Override
    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceCatName, String sourceDbName, String sourceTableName, String destCatName, String destDbName, String destTableName) throws TException {
        TempTable destTT;
        TempTable sourceTT;
        List<Partition> partitions;
        org.apache.hadoop.hive.metastore.api.Table sourceTempTable = this.getTempTable(sourceDbName, sourceTableName);
        org.apache.hadoop.hive.metastore.api.Table destTempTable = this.getTempTable(destDbName, destTableName);
        if (sourceTempTable == null && destTempTable == null) {
            return super.exchange_partition(partitionSpecs, sourceCatName, sourceDbName, sourceTableName, destCatName, destDbName, destTableName);
        }
        if (sourceTempTable != null && destTempTable != null && !(partitions = this.exchangePartitions(partitionSpecs, sourceTempTable, sourceTT = this.getPartitionedTempTable(sourceTempTable), destTempTable, destTT = this.getPartitionedTempTable(destTempTable))).isEmpty()) {
            return partitions.get(0);
        }
        throw new MetaException("Exchanging partitions between temporary and non-temporary tables is not supported.");
    }

    @Override
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceCatName, String sourceDbName, String sourceTableName, String destCatName, String destDbName, String destTableName) throws TException {
        org.apache.hadoop.hive.metastore.api.Table sourceTempTable = this.getTempTable(sourceDbName, sourceTableName);
        org.apache.hadoop.hive.metastore.api.Table destTempTable = this.getTempTable(destDbName, destTableName);
        if (sourceTempTable == null && destTempTable == null) {
            return super.exchange_partitions(partitionSpecs, sourceCatName, sourceDbName, sourceTableName, destCatName, destDbName, destTableName);
        }
        if (sourceTempTable != null && destTempTable != null) {
            return this.exchangePartitions(partitionSpecs, sourceTempTable, this.getPartitionedTempTable(sourceTempTable), destTempTable, this.getPartitionedTempTable(destTempTable));
        }
        throw new MetaException("Exchanging partitions between temporary and non-temporary tables is not supported.");
    }

    @Override
    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws TException {
        this.alter_partition(catName, dbName, tblName, newPart, environmentContext, null);
    }

    @Override
    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext, String writeIdList) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            super.alter_partition(catName, dbName, tblName, newPart, environmentContext, writeIdList);
            return;
        }
        TempTable tt = this.getPartitionedTempTable(table);
        tt.alterPartition(newPart);
    }

    @Override
    public void alter_partitions(String catName, String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            super.alter_partitions(catName, dbName, tblName, newParts, environmentContext, writeIdList, writeId);
            return;
        }
        TempTable tt = this.getPartitionedTempTable(table);
        tt.alterPartitions(newParts);
    }

    @Override
    public void renamePartition(String catName, String dbname, String tableName, List<String> partitionVals, Partition newPart, String validWriteIds) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbname, tableName);
        if (table == null) {
            super.renamePartition(catName, dbname, tableName, partitionVals, newPart, validWriteIds);
            return;
        }
        TempTable tt = this.getPartitionedTempTable(table);
        tt.renamePartition(partitionVals, newPart);
    }

    @Override
    public Partition appendPartition(String catName, String dbName, String tableName, List<String> partVals) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.appendPartition(catName, dbName, tableName, partVals);
        }
        if (partVals == null || partVals.isEmpty()) {
            throw new MetaException("The partition values must be not null or empty.");
        }
        this.assertTempTablePartitioned(table);
        Partition partition = new PartitionBuilder().inTable(table).setValues(partVals).build(this.conf);
        return this.appendPartitionToTempTable(table, partition);
    }

    @Override
    public Partition appendPartition(String catName, String dbName, String tableName, String partitionName) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.appendPartition(catName, dbName, tableName, partitionName);
        }
        if (partitionName == null || partitionName.isEmpty()) {
            throw new MetaException("The partition must be not null or empty.");
        }
        this.assertTempTablePartitioned(table);
        LinkedHashMap<String, String> specFromName = Warehouse.makeSpecFromName(partitionName);
        if (specFromName == null || specFromName.isEmpty()) {
            throw new InvalidObjectException("Invalid partition name " + partitionName);
        }
        ArrayList<String> pVals = new ArrayList<String>();
        for (FieldSchema field : table.getPartitionKeys()) {
            String val = (String)specFromName.get(field.getName());
            if (val == null) {
                throw new InvalidObjectException("Partition name " + partitionName + " and table partition keys " + Arrays.toString(table.getPartitionKeys().toArray()) + " does not match");
            }
            pVals.add(val);
        }
        Partition partition = new PartitionBuilder().inTable(table).setValues(pVals).build(this.conf);
        return this.appendPartitionToTempTable(table, partition);
    }

    @Override
    public List<Partition> listPartitionsByFilter(String catName, String dbName, String tableName, String filter, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.listPartitionsByFilter(catName, dbName, tableName, filter, maxParts);
        }
        return this.getPartitionsForMaxParts(tableName, this.getPartitionedTempTable(table).listPartitionsByFilter(this.generateJDOFilter(table, filter)), maxParts);
    }

    @Override
    public int getNumPartitionsByFilter(String catName, String dbName, String tableName, String filter) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table == null) {
            return super.getNumPartitionsByFilter(catName, dbName, tableName, filter);
        }
        return this.getPartitionedTempTable(table).getNumPartitionsByFilter(this.generateJDOFilter(table, filter));
    }

    @Override
    public PartitionSpecProxy listPartitionSpecsByFilter(String catName, String dbName, String tblName, String filter, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tblName);
        if (table == null) {
            return super.listPartitionSpecsByFilter(catName, dbName, tblName, filter, maxParts);
        }
        return this.getPartitionSpecProxy(table, this.getPartitionedTempTable(table).listPartitionsByFilter(this.generateJDOFilter(table, filter)), maxParts);
    }

    @Override
    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest request) throws TException {
        if (request == null || request.getPartitionKeys() == null || request.getPartitionKeys().isEmpty()) {
            return super.listPartitionValues(request);
        }
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(request.getDbName(), request.getTblName());
        if (table == null) {
            return super.listPartitionValues(request);
        }
        TempTable tt = this.getPartitionedTempTable(table);
        List<Partition> partitions = request.isSetFilter() ? tt.listPartitionsByFilter(this.generateJDOFilter(table, request.getFilter())) : tt.listPartitions();
        ArrayList<String> partitionNames = new ArrayList<String>();
        for (Partition p : partitions) {
            partitionNames.add(Warehouse.makePartName(table.getPartitionKeys(), p.getValues()));
        }
        if (partitionNames.isEmpty() && partitions.isEmpty()) {
            throw new MetaException("Cannot obtain list of partition by filter:\"" + request.getFilter() + "\" for " + Warehouse.getCatalogQualifiedTableName(table));
        }
        if (request.isSetAscending()) {
            if (request.isAscending()) {
                Collections.sort(partitionNames);
            } else {
                Collections.sort(partitionNames, Collections.reverseOrder());
            }
        }
        PartitionValuesResponse response = new PartitionValuesResponse();
        response.setPartitionValues(new ArrayList<PartitionValuesRow>(partitionNames.size()));
        for (String partName : partitionNames) {
            ArrayList<Object> vals = new ArrayList<Object>(Collections.nCopies(table.getPartitionKeysSize(), null));
            PartitionValuesRow row = new PartitionValuesRow();
            Warehouse.makeValsFromName(partName, vals);
            vals.forEach((Consumer<Object>)((Consumer<String>)row::addToRow));
            response.addToPartitionValues(row);
        }
        return response;
    }

    private PartitionSpecProxy getPartitionSpecProxy(org.apache.hadoop.hive.metastore.api.Table table, List<Partition> partitions, int maxParts) throws MetaException {
        PartitionSpec partitionSpec = new PartitionSpec();
        PartitionListComposingSpec partitionListComposingSpec = new PartitionListComposingSpec(new ArrayList<Partition>());
        for (int i = 0; i < (maxParts < 0 || maxParts > partitions.size() ? partitions.size() : maxParts); ++i) {
            partitionListComposingSpec.addToPartitions(this.deepCopy(partitions.get(i)));
        }
        partitionSpec.setCatName(table.getCatName());
        partitionSpec.setDbName(table.getDbName());
        partitionSpec.setTableName(table.getTableName());
        partitionSpec.setRootPath(table.getSd().getLocation());
        partitionSpec.setPartitionList(partitionListComposingSpec);
        List<PartitionSpec> partitionSpecs = Arrays.asList(partitionSpec);
        return PartitionSpecProxy.Factory.get(partitionSpecs);
    }

    private List<Partition> getPartitionsForMaxParts(String tableName, List<Partition> parts, int maxParts) {
        ArrayList<Partition> matchedParts = new ArrayList<Partition>();
        for (int i = 0; i < (maxParts < 0 || maxParts > parts.size() ? parts.size() : maxParts); ++i) {
            matchedParts.add(this.deepCopy(parts.get(i)));
        }
        return matchedParts;
    }

    private String generateJDOFilter(org.apache.hadoop.hive.metastore.api.Table table, String filter) throws MetaException {
        ExpressionTree exprTree = StringUtils.isNotEmpty(filter) ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        return this.generateJDOFilter(table, exprTree);
    }

    private String generateJDOFilter(org.apache.hadoop.hive.metastore.api.Table table, byte[] expr, String defaultPartitionName) throws MetaException {
        ExpressionTree expressionTree = PartFilterExprUtil.makeExpressionTree(PartFilterExprUtil.createExpressionProxy(this.conf), expr, defaultPartitionName, this.conf);
        return this.generateJDOFilter(table, expressionTree == null ? ExpressionTree.EMPTY_TREE : expressionTree);
    }

    private String generateJDOFilter(org.apache.hadoop.hive.metastore.api.Table table, ExpressionTree exprTree) throws MetaException {
        assert (table != null);
        ExpressionTree.FilterBuilder filterBuilder = new ExpressionTree.FilterBuilder(true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        exprTree.generateJDOFilterFragment(this.conf, params, filterBuilder, table.getPartitionKeys());
        StringBuilder stringBuilder = new StringBuilder(filterBuilder.getFilter());
        stringBuilder.replace(0, 4, "");
        params.entrySet().stream().forEach(e -> {
            int index = stringBuilder.indexOf((String)e.getKey());
            stringBuilder.replace(index, index + ((String)e.getKey()).length(), "\"" + e.getValue().toString() + "\"");
        });
        return stringBuilder.toString();
    }

    private Partition appendPartitionToTempTable(org.apache.hadoop.hive.metastore.api.Table table, Partition partition) throws MetaException, AlreadyExistsException {
        TempTable tt = this.getPartitionedTempTable(table);
        if (tt == null) {
            throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName(table));
        }
        Path partitionLocation = this.getPartitionLocation(table, partition, false);
        partition = tt.addPartition(this.deepCopy(partition));
        this.createAndSetLocationForAddedPartition(partition, partitionLocation);
        return partition;
    }

    private List<Partition> exchangePartitions(Map<String, String> partitionSpecs, org.apache.hadoop.hive.metastore.api.Table sourceTable, TempTable sourceTempTable, org.apache.hadoop.hive.metastore.api.Table destTable, TempTable destTempTable) throws TException {
        if (partitionSpecs == null || partitionSpecs.isEmpty()) {
            throw new MetaException("PartitionSpecs cannot be null or empty.");
        }
        List<String> partitionVals = MetaStoreUtils.getPvals(sourceTable.getPartitionKeys(), partitionSpecs);
        if (partitionVals.stream().allMatch(String::isEmpty)) {
            throw new MetaException("Invalid partition key & values; keys " + Arrays.toString(sourceTable.getPartitionKeys().toArray()) + ", values " + Arrays.toString(partitionVals.toArray()));
        }
        List<Partition> partitionsToExchange = sourceTempTable.getPartitionsByPartitionVals(partitionVals);
        if (partitionSpecs == null) {
            throw new MetaException("The partition specs must be not null.");
        }
        if (partitionsToExchange.isEmpty()) {
            throw new MetaException("No partition is found with the values " + partitionSpecs + " for the table " + sourceTable.getTableName());
        }
        boolean sameColumns = MetaStoreUtils.compareFieldColumns(sourceTable.getSd().getCols(), destTable.getSd().getCols());
        boolean samePartitions = MetaStoreUtils.compareFieldColumns(sourceTable.getPartitionKeys(), destTable.getPartitionKeys());
        if (!sameColumns || !samePartitions) {
            throw new MetaException("The tables have different schemas. Their partitions cannot be exchanged.");
        }
        for (Partition partition : partitionsToExchange) {
            String partToExchangeName = Warehouse.makePartName(destTable.getPartitionKeys(), partition.getValues());
            if (destTempTable.getPartition(partToExchangeName) == null) continue;
            throw new MetaException("The partition " + partToExchangeName + " already exists in the table " + destTable.getTableName());
        }
        ArrayList<Partition> result = new ArrayList<Partition>();
        for (Partition partition : partitionsToExchange) {
            Partition destPartition = new Partition(partition);
            destPartition.setCatName(destTable.getCatName());
            destPartition.setDbName(destTable.getDbName());
            destPartition.setTableName(destTable.getTableName());
            destPartition.getSd().setLocation(this.getPartitionLocation(destTable, destPartition, true).toString());
            this.wh.renameDir(new Path(partition.getSd().getLocation()), new Path(destPartition.getSd().getLocation()), false);
            destPartition = destTempTable.addPartition(destPartition);
            this.dropPartition(sourceTable.getDbName(), sourceTable.getTableName(), partition.getValues());
            result.add(destPartition);
        }
        return result;
    }

    private TempTable getPartitionedTempTable(org.apache.hadoop.hive.metastore.api.Table t) throws MetaException {
        String qualifiedTableName = Warehouse.getQualifiedName(t.getDbName().toLowerCase(), t.getTableName().toLowerCase());
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("No current SessionState, skipping temp partitions for " + qualifiedTableName);
            return null;
        }
        this.assertTempTablePartitioned(t);
        TempTable tt = ss.getTempPartitions().get(qualifiedTableName);
        if (tt == null) {
            throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName(t));
        }
        return tt;
    }

    private void removePartitionedTempTable(org.apache.hadoop.hive.metastore.api.Table t) {
        String qualifiedTableName = Warehouse.getQualifiedName(t.getDbName().toLowerCase(), t.getTableName().toLowerCase());
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("No current SessionState, skipping temp partitions for " + qualifiedTableName);
            return;
        }
        ss.getTempPartitions().remove(Warehouse.getQualifiedName(t));
    }

    private void createPartitionedTempTable(org.apache.hadoop.hive.metastore.api.Table t) {
        if (t.getPartitionKeysSize() <= 0) {
            return;
        }
        String qualifiedTableName = Warehouse.getQualifiedName(t.getDbName().toLowerCase(), t.getTableName().toLowerCase());
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("No current SessionState, skipping temp partitions for " + qualifiedTableName);
            return;
        }
        TempTable tt = new TempTable(t);
        if (ss.getTempPartitions().putIfAbsent(qualifiedTableName, tt) != null) {
            throw new IllegalStateException("TempTable for " + qualifiedTableName + " already exists");
        }
    }

    private void createAndSetLocationForAddedPartition(Partition partition, Path partitionLocation) throws MetaException {
        if (partitionLocation != null) {
            partition.getSd().setLocation(partitionLocation.toString());
            if (!this.getWh().isDir(partitionLocation) && !this.getWh().mkdirs(partitionLocation)) {
                throw new MetaException(partitionLocation + " is not a directory or unable to create one");
            }
        }
    }

    private void checkPartitionProperties(Partition partition) throws MetaException {
        if (partition.getDbName() == null) {
            throw new MetaException("Database name cannot be null. " + partition);
        }
        if (partition.getTableName() == null) {
            throw new MetaException("Table name cannot be null. " + partition);
        }
        if (partition.getValues() == null) {
            throw new MetaException("Partition values cannot be null. " + partition);
        }
        if (partition.getSd() == null) {
            throw new MetaException("Storage descriptor for partition cannot be null. " + partition);
        }
        if (partition.getSd().getCols() == null) {
            return;
        }
        for (FieldSchema schema : partition.getSd().getCols()) {
            if (schema.getType() == null) {
                throw new MetaException("Storage descriptor column type for partition cannot be null. " + partition);
            }
            if (schema.getName() != null) continue;
            throw new MetaException("Storage descriptor column name for partition cannot be null. " + partition);
        }
        if (partition.getSd().getSerdeInfo() == null) {
            throw new MetaException("Storage descriptor serde info for partition cannot be null. " + partition);
        }
    }

    private Path getPartitionLocation(org.apache.hadoop.hive.metastore.api.Table table, Partition partition, boolean forceOverwrite) throws MetaException {
        Path partLocation = null;
        String partLocationStr = null;
        if (partition.getSd() != null) {
            partLocationStr = partition.getSd().getLocation();
        }
        if (partLocationStr == null || partLocationStr.isEmpty() || forceOverwrite) {
            if (table.getSd().getLocation() != null) {
                partLocation = new Path(table.getSd().getLocation(), Warehouse.makePartName(table.getPartitionKeys(), partition.getValues()));
            }
        } else {
            if (table.getSd().getLocation() == null) {
                throw new MetaException("Cannot specify location for a view partition");
            }
            try {
                partLocation = this.getWh().getDnsPath(new Path(partLocationStr));
            }
            catch (IllegalArgumentException e) {
                throw new MetaException("Partition path is invalid. " + e.getLocalizedMessage());
            }
        }
        return partLocation;
    }

    private List<Partition> addPartitionsToTempTable(List<Partition> partitions, String dbName, String tableName, boolean ifNotExists) throws MetaException, AlreadyExistsException {
        org.apache.hadoop.hive.metastore.api.Table table;
        TempTable tt;
        if (!this.validatePartitions(partitions, dbName, tableName)) {
            return null;
        }
        if (dbName == null) {
            dbName = partitions.get(0).getDbName();
        }
        if (tableName == null) {
            tableName = partitions.get(0).getTableName();
        }
        if ((tt = this.getPartitionedTempTable(table = this.getTempTable(dbName, tableName))) == null) {
            throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName(table));
        }
        List<Partition> result = tt.addPartitions(this.deepCopyPartitions(partitions), ifNotExists);
        for (Partition p : result) {
            this.createAndSetLocationForAddedPartition(p, this.getPartitionLocation(table, p, false));
        }
        return result;
    }

    private boolean validatePartitions(List<Partition> partitions, String dbName, String tableName) throws MetaException {
        HashSet<List<String>> partitionVals = new HashSet<List<String>>();
        for (Partition p : partitions) {
            if (p.getDbName() == null) {
                throw new MetaException("Database for partition cannot be null. " + p.toString());
            }
            if (p.getTableName() == null) {
                throw new MetaException("Table for partition cannot be null. " + p.toString());
            }
            if (dbName != null && !dbName.equals(p.getDbName())) {
                throw new MetaException("Partition tables doesn't belong to the same database " + Arrays.toString(partitions.toArray()));
            }
            dbName = p.getDbName();
            if (tableName != null && !tableName.equals(p.getTableName())) {
                throw new MetaException("New partitions doesn't belong to the same table " + Arrays.toString(partitions.toArray()));
            }
            tableName = p.getTableName();
            if (partitionVals.contains(p.getValues())) {
                throw new MetaException("Partition values contains duplicate entries. " + Arrays.toString(partitions.toArray()));
            }
            partitionVals.add(p.getValues());
            org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(p.getDbName(), p.getTableName());
            if (table == null) {
                return false;
            }
            this.checkPartitionProperties(p);
            this.getPartitionLocation(table, p, false);
        }
        return true;
    }

    private void assertTempTablePartitioned(org.apache.hadoop.hive.metastore.api.Table table) throws MetaException {
        if (table.getPartitionKeysSize() <= 0) {
            throw new MetaException(Warehouse.getCatalogQualifiedTableName(table) + " is not partitioned");
        }
    }

    private boolean deletePartitionLocation(Partition partition, boolean purgeData) throws MetaException {
        String location = partition.getSd().getLocation();
        if (location != null) {
            Path path = this.getWh().getDnsPath(new Path(location));
            try {
                do {
                    if (!this.getWh().deleteDir(path, true, purgeData, false)) {
                        throw new MetaException("Unable to delete partition at " + location);
                    }
                    path = path.getParent();
                } while (this.getWh().isEmptyDir(path));
            }
            catch (IOException e) {
                throw new MetaException("Unable to delete partition at " + path.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getTranslateTableDryrun(org.apache.hadoop.hive.metastore.api.Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        if (tbl.isTemporary()) {
            org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(tbl.getDbName(), tbl.getTableName());
            return table != null ? this.deepCopy(table) : tbl;
        }
        return super.getTranslateTableDryrun(tbl);
    }
}

