/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;

public abstract class PrunerOperatorFactory {
    public static final NodeProcessor getDefaultProc() {
        return new DefaultPruner();
    }

    public static class DefaultPruner
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static abstract class FilterPruner
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator fop = (FilterOperator)nd;
            FilterOperator fop2 = null;
            Node tmp = stack.pop();
            Node tmp2 = stack.pop();
            TableScanOperator top = null;
            if (tmp2 instanceof TableScanOperator) {
                top = (TableScanOperator)tmp2;
            } else {
                top = (TableScanOperator)stack.peek();
                fop2 = (FilterOperator)tmp2;
            }
            stack.push(tmp2);
            stack.push(tmp);
            if (fop2 != null && !((FilterDesc)fop2.getConf()).getIsSamplingPred()) {
                return null;
            }
            if (((FilterDesc)fop.getConf()).getIsSamplingPred()) {
                return null;
            }
            this.generatePredicate(procCtx, fop, top);
            return null;
        }

        protected abstract void generatePredicate(NodeProcessorCtx var1, FilterOperator var2, TableScanOperator var3) throws SemanticException;

        protected void addPruningPred(Map<TableScanOperator, ExprNodeDesc> opToPrunner, TableScanOperator top, ExprNodeDesc new_pruner_pred) throws SemanticException {
            ExprNodeDesc old_pruner_pred = opToPrunner.get(top);
            ExprNodeDesc pruner_pred = null;
            pruner_pred = old_pruner_pred != null ? (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("OR", old_pruner_pred, new_pruner_pred) : new_pruner_pred;
            opToPrunner.put(top, pruner_pred);
        }

        protected void addPruningPred(Map<TableScanOperator, Map<String, ExprNodeDesc>> opToPrunner, TableScanOperator top, ExprNodeDesc new_pruner_pred, Partition part) throws SemanticException {
            Map<String, ExprNodeDesc> oldPartToPruner = opToPrunner.get(top);
            Map<String, ExprNodeDesc> partToPruner = null;
            ExprNodeDesc pruner_pred = null;
            if (oldPartToPruner == null) {
                pruner_pred = new_pruner_pred;
                partToPruner = new HashMap<String, ExprNodeDesc>();
            } else {
                partToPruner = oldPartToPruner;
                ExprNodeDesc old_pruner_pred = oldPartToPruner.get(part.getName());
                pruner_pred = old_pruner_pred != null ? (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("OR", old_pruner_pred, new_pruner_pred) : new_pruner_pred;
            }
            partToPruner.put(part.getName(), pruner_pred);
            opToPrunner.put(top, partToPruner);
        }
    }
}

