/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedWorkOptimizer
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger(SharedWorkOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LOG.info("SharedWorkOptimizer start");
        Map<String, TableScanOperator> topOps = pctx.getTopOps();
        if (topOps.size() < 2) {
            return pctx;
        }
        ArrayListMultimap<String, TableScanOperator> tableNameToOps = SharedWorkOptimizer.splitTableScanOpsByTable(pctx);
        boolean tablesReferencedOnlyOnce = tableNameToOps.asMap().entrySet().stream().noneMatch(e -> ((Collection)e.getValue()).size() > 1);
        if (tablesReferencedOnlyOnce) {
            return pctx;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before SharedWorkOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
        }
        List<Map.Entry<String, Long>> sortedTables = SharedWorkOptimizer.rankTablesByAccumulatedSize(pctx);
        LOG.debug("Sorted tables by size: {}", sortedTables);
        SharedWorkOptimizerCache optimizerCache = new SharedWorkOptimizerCache();
        SharedWorkOptimizer.gatherDPPTableScanOps(pctx, optimizerCache);
        SharedWorkOptimizer.sharedWorkOptimization(pctx, optimizerCache, tableNameToOps, sortedTables, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After SharedWorkOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_EXTENDED_OPTIMIZATION)) {
            SharedWorkOptimizer.sharedWorkExtendedOptimization(pctx, optimizerCache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("After SharedWorkExtendedOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
            }
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_SEMIJOIN_OPTIMIZATION)) {
            tableNameToOps = SharedWorkOptimizer.splitTableScanOpsByTable(pctx);
            boolean optimized = SharedWorkOptimizer.sharedWorkOptimization(pctx, optimizerCache, tableNameToOps, sortedTables = SharedWorkOptimizer.rankTablesByAccumulatedSize(pctx), true);
            if (optimized && pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_EXTENDED_OPTIMIZATION)) {
                SharedWorkOptimizer.sharedWorkExtendedOptimization(pctx, optimizerCache);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("After SharedWorkSJOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
            }
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_REUSE_MAPJOIN_CACHE)) {
            ArrayListMultimap<Operator<OperatorDesc>, MapJoinOperator> parentToMapJoinOperators = ArrayListMultimap.create();
            for (Set<Operator<?>> set : optimizerCache.getWorkGroups()) {
                for (Operator<?> operator : set) {
                    MapJoinOperator mapJoinOperator;
                    if (!(operator instanceof MapJoinOperator) || ((MapJoinDesc)(mapJoinOperator = (MapJoinOperator)operator).getConf()).isBucketMapJoin() || ((MapJoinDesc)mapJoinOperator.getConf()).isDynamicPartitionHashJoin()) continue;
                    parentToMapJoinOperators.put(SharedWorkOptimizer.obtainBroadcastInput(mapJoinOperator).getParentOperators().get(0), mapJoinOperator);
                }
            }
            for (Collection<Operator<Object>> collection : parentToMapJoinOperators.asMap().values()) {
                HashMap<ReduceSinkOperator, String> rsOpToCacheKey = new HashMap<ReduceSinkOperator, String>();
                for (MapJoinOperator mapJoinOperator : collection) {
                    ReduceSinkOperator rsOp = SharedWorkOptimizer.obtainBroadcastInput(mapJoinOperator);
                    String cacheKey = null;
                    for (Map.Entry e2 : rsOpToCacheKey.entrySet()) {
                        if (!SharedWorkOptimizer.compareOperator(pctx, rsOp, (Operator)e2.getKey())) continue;
                        cacheKey = (String)e2.getValue();
                        break;
                    }
                    if (cacheKey == null) {
                        cacheKey = MapJoinDesc.generateCacheKey(mapJoinOperator.getOperatorId());
                        rsOpToCacheKey.put(rsOp, cacheKey);
                    }
                    ((MapJoinDesc)mapJoinOperator.getConf()).setCacheKey(cacheKey);
                }
            }
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            HashSet visited = new HashSet();
            for (Map.Entry<String, TableScanOperator> entry : topOps.entrySet()) {
                for (Operator<?> operator : OperatorUtils.findOperators(entry.getValue(), Operator.class)) {
                    Set<Operator<?>> workPlanOps;
                    if (visited.contains(operator)) continue;
                    Set<Operator<?>> set = SharedWorkOptimizer.findWorkOperators(optimizerCache, operator);
                    if (!set.equals(workPlanOps = SharedWorkOptimizer.findWorkOperators(operator, new HashSet()))) {
                        throw new SemanticException("Error in shared work optimizer: operator cache contents and actual plan differ\nIn cache: " + set + "\nIn plan: " + workPlanOps);
                    }
                    visited.add(operator);
                }
            }
        }
        LOG.info("SharedWorkOptimizer end");
        return pctx;
    }

    private static boolean sharedWorkOptimization(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, ArrayListMultimap<String, TableScanOperator> tableNameToOps, List<Map.Entry<String, Long>> sortedTables, boolean removeSemijoin) throws SemanticException {
        boolean mergedExecuted = false;
        ArrayListMultimap<String, TableScanOperator> existingOps = ArrayListMultimap.create();
        HashSet removedOps = new HashSet();
        for (Map.Entry<String, Long> tablePair : sortedTables) {
            String tableName = tablePair.getKey();
            for (TableScanOperator discardableTsOp : tableNameToOps.get((Object)tableName)) {
                if (removedOps.contains(discardableTsOp)) {
                    LOG.debug("Skip {} as it has already been removed", (Object)discardableTsOp);
                    continue;
                }
                Collection prevTsOps = existingOps.get(tableName);
                for (TableScanOperator retainableTsOp : prevTsOps) {
                    SharedResult sr;
                    if (optimizerCache.getWorkGroup(discardableTsOp).contains(retainableTsOp)) {
                        LOG.trace("No need check further {} and {} are in the same group", (Object)discardableTsOp, (Object)retainableTsOp);
                        continue;
                    }
                    if (removedOps.contains(retainableTsOp)) {
                        LOG.debug("Skip {} as it has already been removed", (Object)retainableTsOp);
                        continue;
                    }
                    if (removeSemijoin) {
                        boolean mergeable = SharedWorkOptimizer.areMergeable(pctx, optimizerCache, retainableTsOp, discardableTsOp);
                        if (!mergeable) {
                            LOG.debug("{} and {} cannot be merged", (Object)retainableTsOp, (Object)discardableTsOp);
                            continue;
                        }
                        boolean validMerge = SharedWorkOptimizer.areMergeableExcludeSemijoinsExtendedCheck(pctx, optimizerCache, retainableTsOp, discardableTsOp);
                        if (!validMerge) {
                            LOG.debug("{} and {} do not meet preconditions", (Object)retainableTsOp, (Object)discardableTsOp);
                            continue;
                        }
                        sr = SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, retainableTsOp, discardableTsOp);
                    } else {
                        if (!SharedWorkOptimizer.areMergeable(pctx, optimizerCache, retainableTsOp, discardableTsOp) || !SharedWorkOptimizer.areMergeableExtendedCheck(pctx, optimizerCache, retainableTsOp, discardableTsOp)) {
                            LOG.debug("{} and {} cannot be merged", (Object)retainableTsOp, (Object)discardableTsOp);
                            continue;
                        }
                        sr = SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, retainableTsOp, discardableTsOp);
                        if (!SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, sr)) {
                            LOG.debug("{} and {} do not meet preconditions", (Object)retainableTsOp, (Object)discardableTsOp);
                            continue;
                        }
                    }
                    mergedExecuted = true;
                    if (sr.retainableOps.size() > 1) {
                        Operator<?> lastRetainableOp = sr.retainableOps.get(sr.retainableOps.size() - 1);
                        Operator<?> lastDiscardableOp = sr.discardableOps.get(sr.discardableOps.size() - 1);
                        if (lastDiscardableOp.getNumChild() != 0) {
                            ArrayList<Operator<OperatorDesc>> allChildren = Lists.newArrayList(lastDiscardableOp.getChildOperators());
                            for (Operator operator : allChildren) {
                                lastDiscardableOp.getChildOperators().remove(operator);
                                operator.replaceParent(lastDiscardableOp, lastRetainableOp);
                                lastRetainableOp.getChildOperators().add(operator);
                            }
                        }
                        LOG.debug("Merging subtree starting at {} into subtree starting at {}", (Object)discardableTsOp, (Object)retainableTsOp);
                    } else {
                        ExprNodeDesc newRetainableTsFilterExpr = null;
                        ArrayList<ExprNodeDesc> semijoinExprNodes = new ArrayList<ExprNodeDesc>();
                        if (((TableScanDesc)retainableTsOp.getConf()).getFilterExpr() != null) {
                            ArrayList<ExprNodeDesc> allExprNodesExceptSemijoin = new ArrayList<ExprNodeDesc>();
                            SharedWorkOptimizer.splitExpressions(((TableScanDesc)retainableTsOp.getConf()).getFilterExpr(), allExprNodesExceptSemijoin, semijoinExprNodes);
                            if (allExprNodesExceptSemijoin.size() > 1) {
                                newRetainableTsFilterExpr = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPAnd(), allExprNodesExceptSemijoin);
                            } else if (allExprNodesExceptSemijoin.size() > 0 && allExprNodesExceptSemijoin.get(0) instanceof ExprNodeGenericFuncDesc) {
                                newRetainableTsFilterExpr = (ExprNodeDesc)allExprNodesExceptSemijoin.get(0);
                            }
                            SharedWorkOptimizer.pushFilterToTopOfTableScan(optimizerCache, retainableTsOp);
                        }
                        ExprNodeDesc newDiscardableTsFilterExpr = null;
                        if (((TableScanDesc)discardableTsOp.getConf()).getFilterExpr() != null) {
                            ArrayList<ExprNodeDesc> allExprNodesExceptSemijoin = new ArrayList<ExprNodeDesc>();
                            SharedWorkOptimizer.splitExpressions(((TableScanDesc)discardableTsOp.getConf()).getFilterExpr(), allExprNodesExceptSemijoin, new ArrayList<ExprNodeDesc>());
                            if (allExprNodesExceptSemijoin.size() > 1) {
                                newDiscardableTsFilterExpr = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPAnd(), allExprNodesExceptSemijoin);
                            } else if (allExprNodesExceptSemijoin.size() > 0 && allExprNodesExceptSemijoin.get(0) instanceof ExprNodeGenericFuncDesc) {
                                newDiscardableTsFilterExpr = (ExprNodeDesc)allExprNodesExceptSemijoin.get(0);
                            }
                            SharedWorkOptimizer.replaceSemijoinExpressions(discardableTsOp, semijoinExprNodes);
                            SharedWorkOptimizer.pushFilterToTopOfTableScan(optimizerCache, discardableTsOp);
                        }
                        ExprNodeGenericFuncDesc exprNode = null;
                        if (newRetainableTsFilterExpr != null && newDiscardableTsFilterExpr != null && !(exprNode = (ExprNodeGenericFuncDesc)newRetainableTsFilterExpr).isSame(newDiscardableTsFilterExpr)) {
                            if (exprNode.getGenericUDF() instanceof GenericUDFOPOr) {
                                ExprNodeDesc exprNodeDesc;
                                ArrayList<ExprNodeDesc> arrayList = new ArrayList<ExprNodeDesc>(exprNode.getChildren().size() + 1);
                                Iterator<Object> iterator = exprNode.getChildren().iterator();
                                while (iterator.hasNext() && !(exprNodeDesc = (ExprNodeDesc)iterator.next()).isSame(newDiscardableTsFilterExpr)) {
                                    arrayList.add(exprNodeDesc);
                                }
                                if (exprNode.getChildren().size() == arrayList.size()) {
                                    arrayList.add(newDiscardableTsFilterExpr);
                                    exprNode = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPOr(), arrayList);
                                }
                            } else {
                                exprNode = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPOr(), Arrays.asList(exprNode, newDiscardableTsFilterExpr));
                            }
                        }
                        if (!semijoinExprNodes.isEmpty()) {
                            if (exprNode != null) {
                                semijoinExprNodes.add(0, exprNode);
                            }
                            exprNode = semijoinExprNodes.size() > 1 ? ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPAnd(), semijoinExprNodes) : (ExprNodeGenericFuncDesc)semijoinExprNodes.get(0);
                        }
                        ((TableScanDesc)retainableTsOp.getConf()).setFilterExpr(exprNode);
                        ArrayList<Operator<OperatorDesc>> arrayList = Lists.newArrayList(discardableTsOp.getChildOperators());
                        for (Operator operator : arrayList) {
                            discardableTsOp.getChildOperators().remove(operator);
                            operator.replaceParent(discardableTsOp, retainableTsOp);
                            retainableTsOp.getChildOperators().add(operator);
                        }
                        LOG.debug("Merging {} into {}", (Object)discardableTsOp, (Object)retainableTsOp);
                    }
                    for (Operator<?> op : sr.discardableInputOps) {
                        DynamicPruningEventDesc dped;
                        OperatorUtils.removeOperator(op);
                        optimizerCache.removeOp(op);
                        removedOps.add(op);
                        if (op instanceof ReduceSinkOperator) {
                            SemiJoinBranchInfo sjbi = pctx.getRsToSemiJoinBranchInfo().get(op);
                            if (sjbi != null && !sr.discardableOps.contains(sjbi.getTsOp()) && !sr.discardableInputOps.contains(sjbi.getTsOp())) {
                                GenTezUtils.removeSemiJoinOperator(pctx, (ReduceSinkOperator)op, sjbi.getTsOp());
                                optimizerCache.tableScanToDPPSource.remove(sjbi.getTsOp(), op);
                            }
                        } else if (op instanceof AppMasterEventOperator && !sr.discardableOps.contains((dped = (DynamicPruningEventDesc)op.getConf()).getTableScan()) && !sr.discardableInputOps.contains(dped.getTableScan())) {
                            GenTezUtils.removeSemiJoinOperator(pctx, (AppMasterEventOperator)op, dped.getTableScan());
                            optimizerCache.tableScanToDPPSource.remove(dped.getTableScan(), op);
                        }
                        LOG.debug("Input operator removed: {}", op);
                    }
                    optimizerCache.removeOpAndCombineWork(discardableTsOp, retainableTsOp);
                    removedOps.add(discardableTsOp);
                    for (Operator<?> op : sr.discardableOps) {
                        OperatorUtils.removeOperator(op);
                        optimizerCache.removeOp(op);
                        removedOps.add(op);
                        LOG.debug("Operator removed: {}", op);
                    }
                }
                if (removedOps.contains(discardableTsOp)) {
                    existingOps.remove(tableName, discardableTsOp);
                    continue;
                }
                existingOps.put(tableName, discardableTsOp);
            }
        }
        pctx.getTopOps().entrySet().removeIf(e -> ((TableScanOperator)e.getValue()).getNumChild() == 0);
        return mergedExecuted;
    }

    private static void replaceSemijoinExpressions(TableScanOperator tsOp, List<ExprNodeDesc> semijoinExprNodes) {
        ExprNodeGenericFuncDesc tsFilterExpr;
        ExprNodeConstantDesc constNode = new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, Boolean.TRUE);
        if (((TableScanDesc)tsOp.getConf()).getFilterExpr() != null && FunctionRegistry.isOpAnd(tsFilterExpr = ((TableScanDesc)tsOp.getConf()).getFilterExpr())) {
            ((ExprNodeDesc)tsFilterExpr).getChildren().removeIf(SharedWorkOptimizer::isSemijoinExpr);
            ((ExprNodeDesc)tsFilterExpr).getChildren().addAll(semijoinExprNodes);
            if (((ExprNodeDesc)tsFilterExpr).getChildren().isEmpty() || ((ExprNodeDesc)tsFilterExpr).getChildren().size() == 1 && !(((ExprNodeDesc)tsFilterExpr).getChildren().get(0) instanceof ExprNodeGenericFuncDesc)) {
                ((TableScanDesc)tsOp.getConf()).setFilterExpr(null);
            }
        }
        if (tsOp.getChildOperators() != null) {
            for (Operator<OperatorDesc> op : tsOp.getChildOperators()) {
                FilterOperator filterOp;
                ExprNodeDesc filterExpr;
                if (!(op instanceof FilterOperator) || !FunctionRegistry.isOpAnd(filterExpr = ((FilterDesc)(filterOp = (FilterOperator)op).getConf()).getPredicate())) continue;
                filterExpr.getChildren().removeIf(SharedWorkOptimizer::isSemijoinExpr);
                if (filterExpr.getChildren().isEmpty()) {
                    ((FilterDesc)filterOp.getConf()).setPredicate(constNode);
                    continue;
                }
                if (filterExpr.getChildren().size() != 1) continue;
                ((FilterDesc)filterOp.getConf()).setPredicate(filterExpr.getChildren().get(0));
            }
        }
    }

    private static boolean isSemijoinExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeDynamicListDesc) {
            return true;
        }
        if (FunctionRegistry.isOpBetween(expr) && expr.getChildren().get(2) instanceof ExprNodeDynamicValueDesc) {
            return true;
        }
        return FunctionRegistry.isOpInBloomFilter(expr) && expr.getChildren().get(1) instanceof ExprNodeDynamicValueDesc;
    }

    private static void splitExpressions(ExprNodeDesc exprNode, List<ExprNodeDesc> allExprNodesExceptSemijoin, List<ExprNodeDesc> semijoinExprNodes) {
        if (FunctionRegistry.isOpAnd(exprNode)) {
            for (ExprNodeDesc expr : exprNode.getChildren()) {
                if (SharedWorkOptimizer.isSemijoinExpr(expr)) {
                    semijoinExprNodes.add(expr);
                    continue;
                }
                allExprNodesExceptSemijoin.add(expr);
            }
        } else if (SharedWorkOptimizer.isSemijoinExpr(exprNode)) {
            semijoinExprNodes.add(exprNode);
        } else {
            allExprNodesExceptSemijoin.add(exprNode);
        }
    }

    private static void sharedWorkExtendedOptimization(ParseContext pctx, SharedWorkOptimizerCache optimizerCache) throws SemanticException {
        ArrayListMultimap<Operator<?>, ReduceSinkOperator> parentToRsOps = ArrayListMultimap.create();
        HashSet<Operator<Object>> visited = new HashSet();
        for (Map.Entry<String, TableScanOperator> e2 : pctx.getTopOps().entrySet()) {
            SharedWorkOptimizer.gatherReduceSinkOpsByInput(parentToRsOps, visited, SharedWorkOptimizer.findWorkOperators(optimizerCache, e2.getValue()));
        }
        HashSet removedOps = new HashSet();
        while (!parentToRsOps.isEmpty()) {
            List<Map.Entry<Operator<?>, Long>> sortedRSGroups = SharedWorkOptimizer.rankOpsByAccumulatedSize(parentToRsOps.keySet());
            LOG.debug("Sorted operators by size: {}", sortedRSGroups);
            ArrayListMultimap<Operator<?>, ReduceSinkOperator> existingRsOps = ArrayListMultimap.create();
            for (Map.Entry<Operator<?>, Long> entry : sortedRSGroups) {
                Operator<?> rsParent = entry.getKey();
                for (ReduceSinkOperator discardableRsOp : parentToRsOps.get(rsParent)) {
                    if (removedOps.contains(discardableRsOp)) {
                        LOG.debug("Skip {} as it has already been removed", (Object)discardableRsOp);
                        continue;
                    }
                    Collection otherRsOps = existingRsOps.get(rsParent);
                    for (ReduceSinkOperator retainableRsOp : otherRsOps) {
                        boolean mergeable;
                        if (removedOps.contains(retainableRsOp)) {
                            LOG.debug("Skip {} as it has already been removed", (Object)retainableRsOp);
                            continue;
                        }
                        boolean bl = mergeable = SharedWorkOptimizer.compareOperator(pctx, retainableRsOp, discardableRsOp) && SharedWorkOptimizer.compareOperator(pctx, retainableRsOp.getChildOperators().get(0), discardableRsOp.getChildOperators().get(0));
                        if (!mergeable) {
                            LOG.debug("{} and {} cannot be merged", (Object)retainableRsOp, (Object)discardableRsOp);
                            continue;
                        }
                        LOG.debug("Checking additional conditions for merging subtree starting at {} into subtree starting at {}", (Object)discardableRsOp, (Object)retainableRsOp);
                        Operator<OperatorDesc> retainableRsOpChild = retainableRsOp.getChildOperators().get(0);
                        Operator<OperatorDesc> discardableRsOpChild = discardableRsOp.getChildOperators().get(0);
                        SharedResult sr = SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, retainableRsOp, discardableRsOp, retainableRsOpChild, discardableRsOpChild);
                        if (sr.retainableOps.isEmpty() || !SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, sr)) {
                            LOG.debug("{} and {} do not meet preconditions", (Object)retainableRsOp, (Object)discardableRsOp);
                            continue;
                        }
                        SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)retainableRsOp.getConf(), (ReduceSinkDesc)discardableRsOp.getConf());
                        Operator<?> lastRetainableOp = sr.retainableOps.get(sr.retainableOps.size() - 1);
                        Operator<?> lastDiscardableOp = sr.discardableOps.get(sr.discardableOps.size() - 1);
                        if (lastDiscardableOp.getNumChild() != 0) {
                            ArrayList<Operator<OperatorDesc>> allChildren = Lists.newArrayList(lastDiscardableOp.getChildOperators());
                            for (Operator operator : allChildren) {
                                lastDiscardableOp.getChildOperators().remove(operator);
                                operator.replaceParent(lastDiscardableOp, lastRetainableOp);
                                lastRetainableOp.getChildOperators().add(operator);
                            }
                        }
                        LOG.debug("Merging subtree starting at {} into subtree starting at {}", (Object)discardableRsOp, (Object)retainableRsOp);
                        for (Operator<?> op : sr.discardableInputOps) {
                            DynamicPruningEventDesc dynamicPruningEventDesc;
                            OperatorUtils.removeOperator(op);
                            optimizerCache.removeOp(op);
                            removedOps.add(op);
                            if (op instanceof ReduceSinkOperator) {
                                SemiJoinBranchInfo semiJoinBranchInfo = pctx.getRsToSemiJoinBranchInfo().get(op);
                                if (semiJoinBranchInfo != null && !sr.discardableOps.contains(semiJoinBranchInfo.getTsOp()) && !sr.discardableInputOps.contains(semiJoinBranchInfo.getTsOp())) {
                                    GenTezUtils.removeSemiJoinOperator(pctx, (ReduceSinkOperator)op, semiJoinBranchInfo.getTsOp());
                                    optimizerCache.tableScanToDPPSource.remove(semiJoinBranchInfo.getTsOp(), op);
                                }
                            } else if (op instanceof AppMasterEventOperator && !sr.discardableOps.contains((dynamicPruningEventDesc = (DynamicPruningEventDesc)op.getConf()).getTableScan()) && !sr.discardableInputOps.contains(dynamicPruningEventDesc.getTableScan())) {
                                GenTezUtils.removeSemiJoinOperator(pctx, (AppMasterEventOperator)op, dynamicPruningEventDesc.getTableScan());
                                optimizerCache.tableScanToDPPSource.remove(dynamicPruningEventDesc.getTableScan(), op);
                            }
                            LOG.debug("Input operator removed: {}", op);
                        }
                        OperatorUtils.removeOperator(discardableRsOp);
                        optimizerCache.removeOp(discardableRsOp);
                        removedOps.add(discardableRsOp);
                        LOG.debug("Operator removed: {}", (Object)discardableRsOp);
                        optimizerCache.removeOpAndCombineWork(discardableRsOpChild, retainableRsOpChild);
                        for (Operator<?> op : sr.discardableOps) {
                            OperatorUtils.removeOperator(op);
                            optimizerCache.removeOp(op);
                            removedOps.add(op);
                            LOG.debug("Operator removed: {}", op);
                        }
                    }
                    if (removedOps.contains(discardableRsOp)) {
                        existingRsOps.remove(rsParent, discardableRsOp);
                        continue;
                    }
                    existingRsOps.put(rsParent, discardableRsOp);
                }
            }
            parentToRsOps = ArrayListMultimap.create();
            visited = new HashSet();
            for (Map.Entry<Operator<Object>, Long> entry : existingRsOps.entries()) {
                if (removedOps.contains(entry.getValue()) || ((ReduceSinkOperator)((Object)entry.getValue())).getNumChild() < 1) continue;
                SharedWorkOptimizer.gatherReduceSinkOpsByInput(parentToRsOps, visited, SharedWorkOptimizer.findWorkOperators(optimizerCache, ((ReduceSinkOperator)((Object)entry.getValue())).getChildOperators().get(0)));
            }
        }
        pctx.getTopOps().entrySet().removeIf(e -> ((TableScanOperator)e.getValue()).getNumChild() == 0);
    }

    private static ReduceSinkOperator obtainBroadcastInput(MapJoinOperator mapJoinOp) {
        return mapJoinOp.getParentOperators().get(0) instanceof ReduceSinkOperator ? (ReduceSinkOperator)mapJoinOp.getParentOperators().get(0) : (ReduceSinkOperator)mapJoinOp.getParentOperators().get(1);
    }

    private static void gatherDPPTableScanOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache) throws SemanticException {
        Map<String, TableScanOperator> topOps = pctx.getTopOps();
        ArrayList<Operator<?>> tableScanOps = Lists.newArrayList(topOps.values());
        Set<AppMasterEventOperator> s = OperatorUtils.findOperators(tableScanOps, AppMasterEventOperator.class);
        for (AppMasterEventOperator appMasterEventOperator : s) {
            if (!(appMasterEventOperator.getConf() instanceof DynamicPruningEventDesc)) continue;
            DynamicPruningEventDesc dped = (DynamicPruningEventDesc)appMasterEventOperator.getConf();
            optimizerCache.tableScanToDPPSource.put(dped.getTableScan(), appMasterEventOperator);
        }
        for (Map.Entry entry : pctx.getRsToSemiJoinBranchInfo().entrySet()) {
            optimizerCache.tableScanToDPPSource.put(((SemiJoinBranchInfo)entry.getValue()).getTsOp(), (Operator<?>)entry.getKey());
        }
        LOG.debug("DPP information stored in the cache: {}", optimizerCache.tableScanToDPPSource);
    }

    private static ArrayListMultimap<String, TableScanOperator> splitTableScanOpsByTable(ParseContext pctx) {
        ArrayListMultimap<String, TableScanOperator> tableNameToOps = ArrayListMultimap.create();
        TreeMap<String, TableScanOperator> sortedTopOps = new TreeMap<String, TableScanOperator>(pctx.getTopOps());
        for (Map.Entry e : sortedTopOps.entrySet()) {
            TableScanOperator tsOp = (TableScanOperator)e.getValue();
            tableNameToOps.put((Object)(((TableScanDesc)tsOp.getConf()).getTableMetadata().getDbName() + "." + ((TableScanDesc)tsOp.getConf()).getTableMetadata().getTableName()), (Object)tsOp);
        }
        return tableNameToOps;
    }

    private static List<Map.Entry<String, Long>> rankTablesByAccumulatedSize(ParseContext pctx) {
        HashMap<String, Long> tableToTotalSize = new HashMap<String, Long>();
        for (Map.Entry<String, TableScanOperator> e : pctx.getTopOps().entrySet()) {
            TableScanOperator tsOp = e.getValue();
            String tableName = ((TableScanDesc)tsOp.getConf()).getTableMetadata().getDbName() + "." + ((TableScanDesc)tsOp.getConf()).getTableMetadata().getTableName();
            long tableSize = tsOp.getStatistics() != null ? tsOp.getStatistics().getDataSize() : 0L;
            Long totalSize = (Long)tableToTotalSize.get(tableName);
            if (totalSize != null) {
                tableToTotalSize.put(tableName, StatsUtils.safeAdd(totalSize, tableSize));
                continue;
            }
            tableToTotalSize.put(tableName, tableSize);
        }
        ArrayList<Map.Entry<String, Long>> sortedTables = new ArrayList<Map.Entry<String, Long>>(tableToTotalSize.entrySet());
        Collections.sort(sortedTables, Collections.reverseOrder(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }));
        return sortedTables;
    }

    private static void gatherReduceSinkOpsByInput(Multimap<Operator<?>, ReduceSinkOperator> parentToRsOps, Set<Operator<?>> visited, Set<Operator<?>> ops) {
        for (Operator<?> op : ops) {
            if (!(op instanceof ReduceSinkOperator) || visited.contains(op)) continue;
            Operator<OperatorDesc> parent = op.getParentOperators().get(0);
            LinkedHashSet<ReduceSinkOperator> s = new LinkedHashSet<ReduceSinkOperator>();
            for (Operator<OperatorDesc> c : parent.getChildOperators()) {
                if (!(c instanceof ReduceSinkOperator)) continue;
                s.add((ReduceSinkOperator)c);
                visited.add(c);
            }
            if (s.size() <= 1) continue;
            parentToRsOps.putAll(parent, s);
        }
    }

    private static List<Map.Entry<Operator<?>, Long>> rankOpsByAccumulatedSize(Set<Operator<?>> opsSet) {
        HashMap opToTotalSize = new HashMap();
        for (Operator<?> op : opsSet) {
            long size = op.getStatistics() != null ? op.getStatistics().getDataSize() : 0L;
            opToTotalSize.put(op, StatsUtils.safeMult((long)op.getChildOperators().size(), size));
        }
        ArrayList sortedOps = new ArrayList(opToTotalSize.entrySet());
        Collections.sort(sortedOps, Collections.reverseOrder(new Comparator<Map.Entry<Operator<?>, Long>>(){

            @Override
            public int compare(Map.Entry<Operator<?>, Long> o1, Map.Entry<Operator<?>, Long> o2) {
                int valCmp = o1.getValue().compareTo(o2.getValue());
                if (valCmp == 0) {
                    return o1.getKey().toString().compareTo(o2.getKey().toString());
                }
                return valCmp;
            }
        }));
        return sortedOps;
    }

    private static boolean areMergeable(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        List<String> prevTsOpNeededColumns = tsOp1.getNeededColumns();
        List<String> tsOpNeededColumns = tsOp2.getNeededColumns();
        if (prevTsOpNeededColumns.size() != tsOpNeededColumns.size()) {
            return false;
        }
        boolean notEqual = false;
        for (int i = 0; i < prevTsOpNeededColumns.size(); ++i) {
            if (prevTsOpNeededColumns.get(i).equals(tsOpNeededColumns.get(i))) continue;
            notEqual = true;
            break;
        }
        if (notEqual) {
            return false;
        }
        if (((TableScanDesc)tsOp1.getConf()).getRowLimit() != ((TableScanDesc)tsOp2.getConf()).getRowLimit()) {
            return false;
        }
        if (!Objects.equals(((TableScanDesc)tsOp1.getConf()).getOpProps(), ((TableScanDesc)tsOp2.getConf()).getOpProps())) {
            return false;
        }
        PrunedPartitionList prevTsOpPPList = pctx.getPrunedPartitions(tsOp1);
        PrunedPartitionList tsOpPPList = pctx.getPrunedPartitions(tsOp2);
        if (!prevTsOpPPList.getPartitions().equals(tsOpPPList.getPartitions())) {
            return false;
        }
        return Objects.equals(((TableScanDesc)tsOp1.getConf()).getIncludedBuckets(), ((TableScanDesc)tsOp2.getConf()).getIncludedBuckets());
    }

    private static boolean areMergeableExtendedCheck(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        Set<Operator<?>> ascendants;
        Operator op;
        int i;
        ArrayList dppsOp1 = new ArrayList(optimizerCache.tableScanToDPPSource.get(tsOp1));
        ArrayList dppsOp2 = new ArrayList(optimizerCache.tableScanToDPPSource.get(tsOp2));
        if (dppsOp1.isEmpty() && dppsOp2.isEmpty()) {
            return true;
        }
        for (i = 0; i < dppsOp1.size(); ++i) {
            op = (Operator)dppsOp1.get(i);
            if (!(op instanceof ReduceSinkOperator) || !(ascendants = SharedWorkOptimizer.findAscendantWorkOperators(pctx, optimizerCache, op)).contains(tsOp2)) continue;
            return false;
        }
        for (i = 0; i < dppsOp2.size(); ++i) {
            op = (Operator)dppsOp2.get(i);
            if (!(op instanceof ReduceSinkOperator) || !(ascendants = SharedWorkOptimizer.findAscendantWorkOperators(pctx, optimizerCache, op)).contains(tsOp1)) continue;
            return false;
        }
        if (dppsOp1.size() != dppsOp2.size()) {
            return false;
        }
        BitSet bs = new BitSet();
        for (int i2 = 0; i2 < dppsOp1.size(); ++i2) {
            Operator dppOp1 = (Operator)dppsOp1.get(i2);
            for (int j = 0; j < dppsOp2.size(); ++j) {
                Operator dppOp2;
                if (bs.get(j) || SharedWorkOptimizer.compareAndGatherOps(pctx, dppOp1, dppOp2 = (Operator)dppsOp2.get(j)) == null) continue;
                bs.set(j);
                break;
            }
            if (bs.cardinality() >= i2 + 1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean areMergeableExcludeSemijoinsExtendedCheck(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        ArrayList<ReduceSinkOperator> semijoinRsOps;
        TableScanOperator targetTSOp;
        ReduceSinkOperator semijoinRSOp;
        Operator op;
        int i;
        ArrayList dppsOp1 = new ArrayList(optimizerCache.tableScanToDPPSource.get(tsOp1));
        boolean removedDppOp1 = false;
        ArrayList<ReduceSinkOperator> rsOpsSemijoin1 = new ArrayList<ReduceSinkOperator>();
        ArrayList dppsOp2 = new ArrayList(optimizerCache.tableScanToDPPSource.get(tsOp2));
        boolean removedDppOp2 = false;
        ArrayList<ReduceSinkOperator> rsOpsSemijoin2 = new ArrayList<ReduceSinkOperator>();
        for (i = 0; i < dppsOp1.size(); ++i) {
            op = (Operator)dppsOp1.get(i);
            if (!(op instanceof ReduceSinkOperator)) continue;
            semijoinRSOp = (ReduceSinkOperator)op;
            if (pctx.getRsToSemiJoinBranchInfo().get(semijoinRSOp).getIsHint()) {
                return false;
            }
            rsOpsSemijoin1.add(semijoinRSOp);
            dppsOp1.remove(i);
            removedDppOp1 = true;
        }
        for (i = 0; i < dppsOp2.size(); ++i) {
            op = (Operator)dppsOp2.get(i);
            if (!(op instanceof ReduceSinkOperator)) continue;
            semijoinRSOp = (ReduceSinkOperator)op;
            if (pctx.getRsToSemiJoinBranchInfo().get(semijoinRSOp).getIsHint()) {
                return false;
            }
            rsOpsSemijoin2.add(semijoinRSOp);
            dppsOp2.remove(i);
            removedDppOp2 = true;
        }
        if (removedDppOp1 && removedDppOp2) {
            return false;
        }
        if (!removedDppOp1 && !removedDppOp2) {
            return false;
        }
        if (dppsOp1.size() != dppsOp2.size()) {
            return false;
        }
        boolean equalBranches = true;
        BitSet bs = new BitSet();
        for (int i2 = 0; i2 < dppsOp1.size(); ++i2) {
            Operator dppOp1 = (Operator)dppsOp1.get(i2);
            for (int j = 0; j < dppsOp2.size(); ++j) {
                Object dppOp2;
                if (bs.get(j) || SharedWorkOptimizer.compareAndGatherOps(pctx, dppOp1, dppOp2 = (Operator)dppsOp2.get(j)) == null) continue;
                bs.set(j);
                break;
            }
            if (bs.cardinality() >= i2 + 1) continue;
            equalBranches = false;
            break;
        }
        if (!equalBranches) {
            return false;
        }
        ArrayList<SemiJoinBranchInfo> sjBranches = new ArrayList<SemiJoinBranchInfo>();
        if (removedDppOp1) {
            targetTSOp = tsOp1;
            semijoinRsOps = rsOpsSemijoin1;
        } else {
            targetTSOp = tsOp2;
            semijoinRsOps = rsOpsSemijoin2;
        }
        optimizerCache.tableScanToDPPSource.get(targetTSOp).removeAll(semijoinRsOps);
        for (ReduceSinkOperator reduceSinkOperator : semijoinRsOps) {
            sjBranches.add(pctx.getRsToSemiJoinBranchInfo().remove(reduceSinkOperator));
        }
        boolean validMerge = SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, tsOp1, tsOp2));
        if (validMerge) {
            for (ReduceSinkOperator semijoinRsOp : semijoinRsOps) {
                Operator<?> branchOp = GenTezUtils.removeBranch(semijoinRsOp);
                while (branchOp != null) {
                    optimizerCache.removeOp(branchOp);
                    branchOp = branchOp.getNumChild() > 0 ? branchOp.getChildOperators().get(0) : null;
                }
                GenTezUtils.removeSemiJoinOperator(pctx, semijoinRsOp, targetTSOp);
            }
        } else {
            void var16_23;
            optimizerCache.tableScanToDPPSource.get(targetTSOp).addAll(semijoinRsOps);
            boolean bl = false;
            while (var16_23 < semijoinRsOps.size()) {
                pctx.getRsToSemiJoinBranchInfo().put((ReduceSinkOperator)semijoinRsOps.get((int)var16_23), (SemiJoinBranchInfo)sjBranches.get((int)var16_23));
                ++var16_23;
            }
        }
        return validMerge;
    }

    private static SharedResult extractSharedOptimizationInfoForRoot(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator retainableTsOp, TableScanOperator discardableTsOp) throws SemanticException {
        LinkedHashSet retainableOps = new LinkedHashSet();
        LinkedHashSet discardableOps = new LinkedHashSet();
        HashSet discardableInputOps = new HashSet();
        long dataSize = 0L;
        long maxDataSize = 0L;
        retainableOps.add(retainableTsOp);
        discardableOps.add(discardableTsOp);
        Operator equalOp1 = retainableTsOp;
        Operator equalOp2 = discardableTsOp;
        if (equalOp1.getNumChild() > 1 || equalOp2.getNumChild() > 1) {
            discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
            return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
        }
        Operator<OperatorDesc> currentOp1 = retainableTsOp.getChildOperators().get(0);
        Operator<OperatorDesc> currentOp2 = discardableTsOp.getChildOperators().get(0);
        if (currentOp1 instanceof FilterOperator && currentOp2 instanceof FilterOperator) {
            Multiset<String> conjsOp2String;
            Multiset<String> conjsOp1String;
            boolean equalFilters = false;
            FilterDesc op1Conf = (FilterDesc)((FilterOperator)currentOp1).getConf();
            FilterDesc op2Conf = (FilterDesc)((FilterOperator)currentOp2).getConf();
            if (op1Conf.getIsSamplingPred() == op2Conf.getIsSamplingPred() && StringUtils.equals(op1Conf.getSampleDescExpr(), op2Conf.getSampleDescExpr()) && (conjsOp1String = SharedWorkOptimizer.extractConjsIgnoringDPPPreds(op1Conf.getPredicate())).equals(conjsOp2String = SharedWorkOptimizer.extractConjsIgnoringDPPPreds(op2Conf.getPredicate()))) {
                equalFilters = true;
            }
            if (equalFilters) {
                equalOp1 = currentOp1;
                equalOp2 = currentOp2;
                retainableOps.add(equalOp1);
                discardableOps.add(equalOp2);
                if (currentOp1.getChildOperators().size() > 1 || currentOp2.getChildOperators().size() > 1) {
                    discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
                    discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
                    return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
                }
                currentOp1 = currentOp1.getChildOperators().get(0);
                currentOp2 = currentOp2.getChildOperators().get(0);
            } else {
                discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
                discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
                return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
            }
        }
        return SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, equalOp1, equalOp2, currentOp1, currentOp2, retainableOps, discardableOps, discardableInputOps);
    }

    private static SharedResult extractSharedOptimizationInfo(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> retainableOpEqualParent, Operator<?> discardableOpEqualParent, Operator<?> retainableOp, Operator<?> discardableOp) throws SemanticException {
        return SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, retainableOpEqualParent, discardableOpEqualParent, retainableOp, discardableOp, new LinkedHashSet(), new LinkedHashSet(), new HashSet());
    }

    private static SharedResult extractSharedOptimizationInfo(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> retainableOpEqualParent, Operator<?> discardableOpEqualParent, Operator<?> retainableOp, Operator<?> discardableOp, LinkedHashSet<Operator<?>> retainableOps, LinkedHashSet<Operator<?>> discardableOps, Set<Operator<?>> discardableInputOps) throws SemanticException {
        Operator<?> equalOp1 = retainableOpEqualParent;
        Operator<?> equalOp2 = discardableOpEqualParent;
        Operator<Object> currentOp1 = retainableOp;
        Operator<Object> currentOp2 = discardableOp;
        long dataSize = 0L;
        long maxDataSize = 0L;
        while (!(currentOp1 instanceof ReduceSinkOperator) && SharedWorkOptimizer.compareOperator(pctx, currentOp1, currentOp2) && currentOp1.getParentOperators().size() == currentOp2.getParentOperators().size()) {
            if (currentOp1.getParentOperators().size() > 1) {
                int idx;
                ArrayList discardableOpsForCurrentOp = new ArrayList();
                for (idx = 0; idx < currentOp1.getParentOperators().size(); ++idx) {
                    List<Operator<?>> removeOpsForCurrentInput;
                    Operator<OperatorDesc> parentOp1 = currentOp1.getParentOperators().get(idx);
                    Operator<OperatorDesc> parentOp2 = currentOp2.getParentOperators().get(idx);
                    if (parentOp1 == equalOp1 && parentOp2 == equalOp2) continue;
                    if (parentOp1 == equalOp1 && parentOp2 != equalOp2 || parentOp1 != equalOp1 && parentOp2 == equalOp2 || (removeOpsForCurrentInput = SharedWorkOptimizer.compareAndGatherOps(pctx, parentOp1, parentOp2)) == null) break;
                    discardableOpsForCurrentOp.addAll(removeOpsForCurrentInput);
                }
                if (idx != currentOp1.getParentOperators().size()) break;
                discardableInputOps.addAll(discardableOpsForCurrentOp);
            }
            equalOp1 = currentOp1;
            equalOp2 = currentOp2;
            retainableOps.add(equalOp1);
            discardableOps.add(equalOp2);
            if (equalOp1 instanceof MapJoinOperator) {
                MapJoinOperator mop = (MapJoinOperator)equalOp1;
                dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
                maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
            }
            if (currentOp1.getChildOperators().size() > 1 || currentOp2.getChildOperators().size() > 1) break;
            currentOp1 = currentOp1.getChildOperators().get(0);
            currentOp2 = currentOp2.getChildOperators().get(0);
        }
        Set<Operator<?>> opsWork1 = SharedWorkOptimizer.findWorkOperators(optimizerCache, currentOp1);
        for (Operator<?> op : opsWork1) {
            if (!(op instanceof MapJoinOperator) || retainableOps.contains(op)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        Set<Operator<?>> opsWork2 = SharedWorkOptimizer.findWorkOperators(optimizerCache, currentOp2);
        for (Operator<?> op : opsWork2) {
            if (!(op instanceof MapJoinOperator) || discardableOps.contains(op)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, Sets.union(discardableInputOps, discardableOps)));
        discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
        return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
    }

    private static Multiset<String> extractConjsIgnoringDPPPreds(ExprNodeDesc predicate) {
        List<ExprNodeDesc> conjsOp = ExprNodeDescUtils.split(predicate);
        TreeMultiset<String> conjsOpString = TreeMultiset.create();
        for (int i = 0; i < conjsOp.size(); ++i) {
            ExprNodeGenericFuncDesc func;
            if (conjsOp.get(i) instanceof ExprNodeGenericFuncDesc ? GenericUDFInBloomFilter.class == (func = (ExprNodeGenericFuncDesc)conjsOp.get(i)).getGenericUDF().getClass() || GenericUDFBetween.class == func.getGenericUDF().getClass() && (func.getChildren().get(2) instanceof ExprNodeDynamicValueDesc || func.getChildren().get(3) instanceof ExprNodeDynamicValueDesc) : conjsOp.get(i) instanceof ExprNodeDynamicListDesc) continue;
            conjsOpString.add(conjsOp.get(i).toString());
        }
        return conjsOpString;
    }

    private static Set<Operator<?>> gatherDPPBranchOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Set<Operator<?>> ops) {
        HashSet dppBranches = new HashSet();
        for (Operator<?> op : ops) {
            if (!(op instanceof TableScanOperator)) continue;
            Collection<Operator<?>> c = optimizerCache.tableScanToDPPSource.get((TableScanOperator)op);
            for (Operator<?> dppSource : c) {
                SharedWorkOptimizer.removeBranch(dppSource, dppBranches, ops);
            }
        }
        return dppBranches;
    }

    private static Set<Operator<?>> gatherDPPBranchOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Set<Operator<?>> ops, Set<Operator<?>> discardedOps) {
        HashSet dppBranches = new HashSet();
        for (Operator<?> op : ops) {
            if (!(op instanceof TableScanOperator)) continue;
            Collection<Operator<?>> c = optimizerCache.tableScanToDPPSource.get((TableScanOperator)op);
            for (Operator<?> dppSource : c) {
                Set<Operator<?>> ascendants = SharedWorkOptimizer.findAscendantWorkOperators(pctx, optimizerCache, dppSource);
                if (Collections.disjoint(ascendants, discardedOps)) continue;
                SharedWorkOptimizer.removeBranch(dppSource, dppBranches, ops);
            }
        }
        return dppBranches;
    }

    private static void removeBranch(Operator<?> currentOp, Set<Operator<?>> branchesOps, Set<Operator<?>> discardableOps) {
        if (currentOp.getNumChild() > 1) {
            for (Operator<OperatorDesc> childOp : currentOp.getChildOperators()) {
                if (branchesOps.contains(childOp) || discardableOps.contains(childOp)) continue;
                return;
            }
        }
        branchesOps.add(currentOp);
        if (currentOp.getParentOperators() != null) {
            for (Operator<OperatorDesc> parentOp : currentOp.getParentOperators()) {
                SharedWorkOptimizer.removeBranch(parentOp, branchesOps, discardableOps);
            }
        }
    }

    private static List<Operator<?>> compareAndGatherOps(ParseContext pctx, Operator<?> op1, Operator<?> op2) throws SemanticException {
        ArrayList result = new ArrayList();
        boolean mergeable = SharedWorkOptimizer.compareAndGatherOps(pctx, op1, op2, result, true);
        if (!mergeable) {
            return null;
        }
        return result;
    }

    private static boolean compareAndGatherOps(ParseContext pctx, Operator<?> op1, Operator<?> op2, List<Operator<?>> result, boolean gather) throws SemanticException {
        if (!SharedWorkOptimizer.compareOperator(pctx, op1, op2)) {
            LOG.debug("Operators not equal: {} and {}", op1, op2);
            return false;
        }
        if (gather && op2.getChildOperators().size() > 1) {
            gather = false;
        }
        if (gather) {
            result.add(op2);
        }
        List<Operator<OperatorDesc>> op1ParentOperators = op1.getParentOperators();
        List<Operator<OperatorDesc>> op2ParentOperators = op2.getParentOperators();
        if (op1ParentOperators != null && op2ParentOperators != null) {
            if (op1ParentOperators.size() != op2ParentOperators.size()) {
                return false;
            }
            for (int i = 0; i < op1ParentOperators.size(); ++i) {
                Operator<OperatorDesc> op2ParentOp;
                Operator<OperatorDesc> op1ParentOp = op1ParentOperators.get(i);
                boolean mergeable = SharedWorkOptimizer.compareAndGatherOps(pctx, op1ParentOp, op2ParentOp = op2ParentOperators.get(i), result, gather);
                if (mergeable) continue;
                return false;
            }
        } else if (op1ParentOperators != null || op2ParentOperators != null) {
            return false;
        }
        return true;
    }

    private static boolean compareOperator(ParseContext pctx, Operator<?> op1, Operator<?> op2) throws SemanticException {
        if (!op1.getClass().getName().equals(op2.getClass().getName())) {
            return false;
        }
        if (op1 instanceof ReduceSinkOperator) {
            ReduceSinkDesc op1Conf = (ReduceSinkDesc)((ReduceSinkOperator)op1).getConf();
            ReduceSinkDesc op2Conf = (ReduceSinkDesc)((ReduceSinkOperator)op2).getConf();
            return StringUtils.equals(op1Conf.getKeyColString(), op2Conf.getKeyColString()) && StringUtils.equals(op1Conf.getValueColsString(), op2Conf.getValueColsString()) && StringUtils.equals(op1Conf.getParitionColsString(), op2Conf.getParitionColsString()) && op1Conf.getTag() == op2Conf.getTag() && StringUtils.equals(op1Conf.getOrder(), op2Conf.getOrder()) && op1Conf.getTopN() == op2Conf.getTopN() && SharedWorkOptimizer.canDeduplicateReduceTraits(op1Conf, op2Conf);
        }
        if (op1 instanceof TableScanOperator) {
            TableScanOperator tsOp1 = (TableScanOperator)op1;
            TableScanOperator tsOp2 = (TableScanOperator)op2;
            TableScanDesc op1Conf = (TableScanDesc)tsOp1.getConf();
            TableScanDesc op2Conf = (TableScanDesc)tsOp2.getConf();
            Table tableMeta1 = op1Conf.getTableMetadata();
            Table tableMeta2 = op2Conf.getTableMetadata();
            return StringUtils.equals(tableMeta1.getFullyQualifiedName(), tableMeta2.getFullyQualifiedName()) && op1Conf.getNeededColumns().equals(op2Conf.getNeededColumns()) && StringUtils.equals(op1Conf.getFilterExprString(), op2Conf.getFilterExprString()) && pctx.getPrunedPartitions(tsOp1).getPartitions().equals(pctx.getPrunedPartitions(tsOp2).getPartitions()) && op1Conf.getRowLimit() == op2Conf.getRowLimit() && Objects.equals(op1Conf.getIncludedBuckets(), op2Conf.getIncludedBuckets()) && Objects.equals(op1Conf.getOpProps(), op2Conf.getOpProps());
        }
        return op1.logicalEquals(op2);
    }

    private static boolean validPreConditions(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, SharedResult sr) {
        Set<Operator<?>> excludeOps2;
        Set<Operator<?>> inputWorksOps2;
        Set<Operator<?>> outputWorksOps2;
        if (sr.dataSize > sr.maxDataSize) {
            LOG.debug("accumulated data size: {} / max size: {}", (Object)sr.dataSize, (Object)sr.maxDataSize);
            return false;
        }
        Operator<?> op1 = sr.retainableOps.get(0);
        Operator<?> op2 = sr.discardableOps.get(0);
        Set<Operator<?>> workOps1 = SharedWorkOptimizer.findWorkOperators(optimizerCache, op1);
        Set<Operator<?>> workOps2 = SharedWorkOptimizer.findWorkOperators(optimizerCache, op2);
        for (Operator<?> op : workOps1) {
            if (op instanceof UnionOperator) {
                return false;
            }
            if (!(op instanceof DummyStoreOperator)) continue;
            return false;
        }
        for (Operator<?> op : workOps2) {
            if (op instanceof UnionOperator) {
                return false;
            }
            if (!(op instanceof DummyStoreOperator)) continue;
            return false;
        }
        Set<Operator<?>> outputWorksOps1 = SharedWorkOptimizer.findChildWorkOperators(pctx, optimizerCache, op1);
        if (!Collections.disjoint(outputWorksOps1, outputWorksOps2 = SharedWorkOptimizer.findChildWorkOperators(pctx, optimizerCache, op2))) {
            return false;
        }
        ImmutableSet<Operator<Object>> excludeOps1 = sr.retainableOps.get(0).getNumParent() > 0 ? ImmutableSet.copyOf(sr.retainableOps.get(0).getParentOperators()) : ImmutableSet.of();
        Set<Operator<?>> inputWorksOps1 = SharedWorkOptimizer.findParentWorkOperators(pctx, optimizerCache, op1, excludeOps1);
        if (!Collections.disjoint(inputWorksOps1, inputWorksOps2 = SharedWorkOptimizer.findParentWorkOperators(pctx, optimizerCache, op2, excludeOps2 = sr.discardableOps.get(0).getNumParent() > 0 ? Sets.union(ImmutableSet.copyOf(sr.discardableOps.get(0).getParentOperators()), sr.discardableInputOps) : sr.discardableInputOps))) {
            return false;
        }
        Set<Operator<?>> descendantWorksOps1 = SharedWorkOptimizer.findDescendantWorkOperators(pctx, optimizerCache, op1, sr.discardableInputOps);
        Set<Operator<?>> descendantWorksOps2 = SharedWorkOptimizer.findDescendantWorkOperators(pctx, optimizerCache, op2, sr.discardableInputOps);
        return Collections.disjoint(descendantWorksOps1, workOps2) && Collections.disjoint(workOps1, descendantWorksOps2);
    }

    private static Set<Operator<?>> findParentWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        return SharedWorkOptimizer.findParentWorkOperators(pctx, optimizerCache, start, ImmutableSet.of());
    }

    private static Set<Operator<?>> findParentWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start, Set<Operator<?>> excludeOps) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet set = new HashSet();
        for (Operator<?> op : workOps) {
            if (op.getParentOperators() != null) {
                for (Operator<OperatorDesc> operator : op.getParentOperators()) {
                    if (!(operator instanceof ReduceSinkOperator) || excludeOps.contains(operator)) continue;
                    set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, operator));
                }
                continue;
            }
            if (!(op instanceof TableScanOperator)) continue;
            for (Operator<OperatorDesc> operator : optimizerCache.tableScanToDPPSource.get((TableScanOperator)op)) {
                if (excludeOps.contains(operator)) continue;
                set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, operator));
            }
        }
        return set;
    }

    private static Set<Operator<?>> findAscendantWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet result = new HashSet();
        while (!workOps.isEmpty()) {
            HashSet set = new HashSet();
            for (Operator<?> op : workOps) {
                if (op.getParentOperators() != null) {
                    for (Operator<OperatorDesc> operator : op.getParentOperators()) {
                        if (!(operator instanceof ReduceSinkOperator)) continue;
                        set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, operator));
                    }
                    continue;
                }
                if (!(op instanceof TableScanOperator)) continue;
                for (Operator<OperatorDesc> operator : optimizerCache.tableScanToDPPSource.get((TableScanOperator)op)) {
                    set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, operator));
                }
            }
            workOps = set;
            result.addAll(set);
        }
        return result;
    }

    private static Set<Operator<?>> findChildWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet set = new HashSet();
        for (Operator<?> op : workOps) {
            if (op instanceof ReduceSinkOperator) {
                SemiJoinBranchInfo sjbi;
                if (op.getChildOperators() != null) {
                    for (Operator<OperatorDesc> child : op.getChildOperators()) {
                        set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, child));
                    }
                }
                if ((sjbi = pctx.getRsToSemiJoinBranchInfo().get(op)) == null) continue;
                set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, sjbi.getTsOp()));
                continue;
            }
            if (!(op.getConf() instanceof DynamicPruningEventDesc)) continue;
            set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, ((DynamicPruningEventDesc)op.getConf()).getTableScan()));
        }
        return set;
    }

    private static Set<Operator<?>> findDescendantWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start, Set<Operator<?>> excludeOps) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet result = new HashSet();
        while (!workOps.isEmpty()) {
            HashSet set = new HashSet();
            for (Operator<?> op : workOps) {
                if (excludeOps.contains(op)) continue;
                if (op instanceof ReduceSinkOperator) {
                    SemiJoinBranchInfo sjbi;
                    if (op.getChildOperators() != null) {
                        for (Operator<OperatorDesc> child : op.getChildOperators()) {
                            set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, child));
                        }
                    }
                    if ((sjbi = pctx.getRsToSemiJoinBranchInfo().get(op)) == null) continue;
                    set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, sjbi.getTsOp()));
                    continue;
                }
                if (!(op.getConf() instanceof DynamicPruningEventDesc)) continue;
                set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, ((DynamicPruningEventDesc)op.getConf()).getTableScan()));
            }
            workOps = set;
            result.addAll(set);
        }
        return result;
    }

    private static Set<Operator<?>> findWorkOperators(SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        Set<Operator<?>> c = optimizerCache.getWorkGroup(start);
        if (!c.isEmpty()) {
            return c;
        }
        c = SharedWorkOptimizer.findWorkOperators(start, new HashSet());
        optimizerCache.addWorkGroup(c);
        return c;
    }

    private static Set<Operator<?>> findWorkOperators(Operator<?> start, Set<Operator<?>> found) {
        found.add(start);
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                if (parent instanceof ReduceSinkOperator || found.contains(parent)) continue;
                SharedWorkOptimizer.findWorkOperators(parent, found);
            }
        }
        if (start instanceof ReduceSinkOperator) {
            return found;
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                if (found.contains(child)) continue;
                SharedWorkOptimizer.findWorkOperators(child, found);
            }
        }
        return found;
    }

    private static void pushFilterToTopOfTableScan(SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp) throws UDFArgumentException {
        ExprNodeGenericFuncDesc tableScanExprNode = ((TableScanDesc)tsOp.getConf()).getFilterExpr();
        ArrayList<Operator<OperatorDesc>> allChildren = Lists.newArrayList(tsOp.getChildOperators());
        for (Operator operator : allChildren) {
            if (operator instanceof FilterOperator) {
                Set visitedExprs;
                FilterOperator filterOp = (FilterOperator)operator;
                ExprNodeDesc filterExprNode = ((FilterDesc)filterOp.getConf()).getPredicate();
                if (tableScanExprNode.isSame(filterExprNode)) {
                    return;
                }
                if (tableScanExprNode.getGenericUDF() instanceof GenericUDFOPOr) {
                    for (ExprNodeDesc childExprNode : tableScanExprNode.getChildren()) {
                        if (!childExprNode.isSame(filterExprNode)) continue;
                        return;
                    }
                }
                boolean isOpAndFilter = FunctionRegistry.isOpAnd(filterExprNode);
                boolean isOpAndTS = FunctionRegistry.isOpAnd(tableScanExprNode);
                if (isOpAndFilter && isOpAndTS) {
                    visitedExprs = filterExprNode.getChildren().stream().map(ExprNodeDesc::getExprString).collect(Collectors.toSet());
                    for (ExprNodeDesc e : tableScanExprNode.getChildren()) {
                        if (!visitedExprs.add(e.getExprString())) continue;
                        filterExprNode.getChildren().add(e.clone());
                    }
                    continue;
                }
                if (isOpAndFilter) {
                    visitedExprs = filterExprNode.getChildren().stream().map(ExprNodeDesc::getExprString).collect(Collectors.toSet());
                    if (!visitedExprs.add(tableScanExprNode.getExprString())) continue;
                    filterExprNode.getChildren().add(tableScanExprNode.clone());
                    continue;
                }
                ExprNodeGenericFuncDesc newPred = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPAnd(), Arrays.asList(tableScanExprNode.clone(), filterExprNode));
                ((FilterDesc)filterOp.getConf()).setPredicate(newPred);
                continue;
            }
            Operator<FilterDesc> newOp = OperatorFactory.get(tsOp.getCompilationOpContext(), new FilterDesc(tableScanExprNode.clone(), false), new RowSchema(tsOp.getSchema().getSignature()));
            tsOp.replaceChild(operator, newOp);
            newOp.getParentOperators().add(tsOp);
            operator.replaceParent(tsOp, newOp);
            newOp.getChildOperators().add(operator);
            optimizerCache.putIfWorkExists(newOp, tsOp);
        }
    }

    static boolean canDeduplicateReduceTraits(ReduceSinkDesc retainable, ReduceSinkDesc discardable) {
        return SharedWorkOptimizer.deduplicateReduceTraits(retainable, discardable, false);
    }

    static boolean deduplicateReduceTraits(ReduceSinkDesc retainable, ReduceSinkDesc discardable) {
        return SharedWorkOptimizer.deduplicateReduceTraits(retainable, discardable, true);
    }

    private static boolean deduplicateReduceTraits(ReduceSinkDesc retainable, ReduceSinkDesc discardable, boolean apply) {
        EnumSet<ReduceSinkDesc.ReducerTraits> retainableTraits = retainable.getReducerTraits();
        EnumSet<ReduceSinkDesc.ReducerTraits> discardableTraits = discardable.getReducerTraits();
        boolean x1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNSET);
        boolean f1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.FIXED);
        boolean u1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
        boolean a1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
        int n1 = retainable.getNumReducers();
        boolean x2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNSET);
        boolean f2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.FIXED);
        boolean u2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
        boolean a2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
        int n2 = discardable.getNumReducers();
        boolean dedup = false;
        boolean x3 = false;
        boolean f3 = false;
        boolean u3 = false;
        boolean a3 = false;
        int n3 = n1;
        if (x1 || x2) {
            dedup = true;
            n3 = Math.max(n1, n2);
            x3 = x1 && x2;
            f3 = f1 || f2;
            u3 = u1 || u2;
            a3 = a1 || a2;
        } else if (f1 || f2) {
            if (f1 && f2) {
                if (n1 == n2) {
                    dedup = true;
                    f3 = true;
                }
            } else {
                dedup = true;
                f3 = true;
                n3 = f1 ? n1 : n2;
            }
        } else {
            if (u1 && u2) {
                dedup = true;
                u3 = true;
                n3 = Math.max(n1, n2);
            }
            if (a1 && a2) {
                dedup = true;
                a3 = true;
                n3 = Math.max(n1, n2);
            }
        }
        if (apply && dedup) {
            retainable.setNumReducers(n3);
            if (x3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.UNSET);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.UNSET);
            }
            if (f3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.FIXED);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.FIXED);
            }
            if (u3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.UNIFORM);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
            }
            if (a3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
            }
        }
        return dedup;
    }

    static class SharedWorkOptimizerCache {
        private final Map<Operator<?>, Set<Operator<?>>> operatorToWorkOperators = new IdentityHashMap();
        final Multimap<TableScanOperator, Operator<?>> tableScanToDPPSource = HashMultimap.create();

        SharedWorkOptimizerCache() {
        }

        void putIfWorkExists(Operator<?> opToAdd, Operator<?> existingOp) {
            Set<Operator<?>> group = this.operatorToWorkOperators.get(existingOp);
            if (group == null) {
                return;
            }
            group.add(opToAdd);
            this.operatorToWorkOperators.put(opToAdd, group);
        }

        public void addWorkGroup(Collection<Operator<?>> c) {
            Set<Operator<?>> group = Sets.newIdentityHashSet();
            group.addAll(c);
            for (Operator<?> op : c) {
                this.operatorToWorkOperators.put(op, group);
            }
        }

        public Set<Operator<?>> getWorkGroup(Operator<?> start) {
            Set<Operator<?>> set = this.operatorToWorkOperators.get(start);
            if (set == null) {
                return Collections.emptySet();
            }
            return set;
        }

        public Set<Set<Operator<?>>> getWorkGroups() {
            Set<Set<Operator<?>>> ret = Sets.newIdentityHashSet();
            ret.addAll(this.operatorToWorkOperators.values());
            return ret;
        }

        void removeOp(Operator<?> opToRemove) {
            Set<Operator<?>> group = this.operatorToWorkOperators.get(opToRemove);
            if (group == null) {
                return;
            }
            group.remove(opToRemove);
            this.operatorToWorkOperators.remove(opToRemove);
        }

        void removeOpAndCombineWork(Operator<?> opToRemove, Operator<?> replacementOp) {
            Set<Operator<?>> group1 = this.operatorToWorkOperators.get(opToRemove);
            Set<Operator<?>> group2 = this.operatorToWorkOperators.get(replacementOp);
            group1.remove(opToRemove);
            this.operatorToWorkOperators.remove(opToRemove);
            if (group1.size() > group2.size()) {
                Set<Operator<?>> t = group2;
                group2 = group1;
                group1 = t;
            }
            group2.addAll(group1);
            for (Operator<?> o : group1) {
                this.operatorToWorkOperators.put(o, group2);
            }
        }

        public String toString() {
            return "SharedWorkOptimizerCache { \n" + this.operatorToWorkOperators.toString() + "\n };";
        }
    }

    private static class SharedResult {
        final List<Operator<?>> retainableOps;
        final List<Operator<?>> discardableOps;
        final Set<Operator<?>> discardableInputOps;
        final long dataSize;
        final long maxDataSize;

        private SharedResult(Collection<Operator<?>> retainableOps, Collection<Operator<?>> discardableOps, Set<Operator<?>> discardableInputOps, long dataSize, long maxDataSize) {
            this.retainableOps = ImmutableList.copyOf(retainableOps);
            this.discardableOps = ImmutableList.copyOf(discardableOps);
            this.discardableInputOps = ImmutableSet.copyOf(discardableInputOps);
            this.dataSize = dataSize;
            this.maxDataSize = maxDataSize;
        }

        public String toString() {
            return "SharedResult { " + this.retainableOps + "; " + this.discardableOps + "; " + this.discardableInputOps + "};";
        }
    }
}

