/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelWriterImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRelOptUtil
extends RelOptUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HiveRelOptUtil.class);

    public static RexNode splitHiveJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp) throws CalciteSemanticException {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        HiveRelOptUtil.splitJoinCondition(sysFieldList, inputs, condition, joinKeys, filterNulls, rangeOp, nonEquiList);
        return RexUtil.composeConjunction((RexBuilder)inputs.get(0).getCluster().getRexBuilder(), nonEquiList, (boolean)false);
    }

    private static void splitJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp, List<RexNode> nonEquiList) throws CalciteSemanticException {
        int sysFieldCount = sysFieldList.size();
        RelOptCluster cluster = inputs.get(0).getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode operand : call.getOperands()) {
                    HiveRelOptUtil.splitJoinCondition(sysFieldList, inputs, operand, joinKeys, filterNulls, rangeOp, nonEquiList);
                }
                return;
            }
            RexNode leftKey = null;
            RexNode rightKey = null;
            int leftInput = 0;
            int rightInput = 0;
            List leftFields = null;
            List rightFields = null;
            boolean reverse = false;
            SqlKind kind = call.getKind();
            if (kind == SqlKind.EQUALS || filterNulls != null && kind == SqlKind.IS_NOT_DISTINCT_FROM || rangeOp != null && rangeOp.isEmpty() && (kind == SqlKind.GREATER_THAN || kind == SqlKind.GREATER_THAN_OR_EQUAL || kind == SqlKind.LESS_THAN || kind == SqlKind.LESS_THAN_OR_EQUAL)) {
                List operands = call.getOperands();
                RexNode op0 = (RexNode)operands.get(0);
                RexNode op1 = (RexNode)operands.get(1);
                ImmutableBitSet projRefs0 = RelOptUtil.InputFinder.bits((RexNode)op0);
                ImmutableBitSet projRefs1 = RelOptUtil.InputFinder.bits((RexNode)op1);
                ImmutableBitSet[] inputsRange = new ImmutableBitSet[inputs.size()];
                int totalFieldCount = 0;
                for (int i = 0; i < inputs.size(); ++i) {
                    int firstField = totalFieldCount + sysFieldCount;
                    totalFieldCount = firstField + inputs.get(i).getRowType().getFieldCount();
                    inputsRange[i] = ImmutableBitSet.range((int)firstField, (int)totalFieldCount);
                }
                boolean foundBothInputs = false;
                for (int i = 0; i < inputs.size() && !foundBothInputs; ++i) {
                    if (projRefs0.intersects(inputsRange[i]) && projRefs0.union(inputsRange[i]).equals((Object)inputsRange[i])) {
                        if (leftKey == null) {
                            leftKey = op0;
                            leftInput = i;
                            leftFields = inputs.get(leftInput).getRowType().getFieldList();
                            continue;
                        }
                        rightKey = op0;
                        rightInput = i;
                        rightFields = inputs.get(rightInput).getRowType().getFieldList();
                        reverse = true;
                        foundBothInputs = true;
                        continue;
                    }
                    if (!projRefs1.intersects(inputsRange[i]) || !projRefs1.union(inputsRange[i]).equals((Object)inputsRange[i])) continue;
                    if (leftKey == null) {
                        leftKey = op1;
                        leftInput = i;
                        leftFields = inputs.get(leftInput).getRowType().getFieldList();
                        continue;
                    }
                    rightKey = op1;
                    rightInput = i;
                    rightFields = inputs.get(rightInput).getRowType().getFieldList();
                    foundBothInputs = true;
                }
                if (leftKey != null && rightKey != null) {
                    RelDataType rightKeyType;
                    int[] adjustments = new int[totalFieldCount];
                    for (int i = 0; i < inputs.size(); ++i) {
                        int adjustment;
                        for (int j = adjustment = inputsRange[i].nextSetBit(0); j < inputsRange[i].length(); ++j) {
                            adjustments[j] = -adjustment;
                        }
                    }
                    rightKey = (RexNode)rightKey.accept((RexVisitor)new RelOptUtil.RexInputConverter(rexBuilder, rightFields, rightFields, adjustments));
                    RelDataType leftKeyType = (leftKey = (RexNode)leftKey.accept((RexVisitor)new RelOptUtil.RexInputConverter(rexBuilder, leftFields, leftFields, adjustments))).getType();
                    if (leftKeyType != (rightKeyType = rightKey.getType())) {
                        TypeInfo rType = TypeConverter.convert(rightKeyType);
                        TypeInfo lType = TypeConverter.convert(leftKeyType);
                        TypeInfo tgtType = FunctionRegistry.getCommonClassForComparison(lType, rType);
                        if (tgtType == null) {
                            throw new CalciteSemanticException("Cannot find common type for join keys " + leftKey + " (type " + leftKeyType + ") and " + rightKey + " (type " + rightKeyType + ")");
                        }
                        RelDataType targetKeyType = TypeConverter.convert(tgtType, rexBuilder.getTypeFactory());
                        if (leftKeyType != targetKeyType && TypeInfoUtils.isConversionRequiredForComparison(tgtType, lType)) {
                            leftKey = rexBuilder.makeCast(targetKeyType, leftKey);
                        }
                        if (rightKeyType != targetKeyType && TypeInfoUtils.isConversionRequiredForComparison(tgtType, rType)) {
                            rightKey = rexBuilder.makeCast(targetKeyType, rightKey);
                        }
                    }
                }
            }
            if (leftKey != null && rightKey != null) {
                HiveRelOptUtil.addJoinKey(joinKeys.get(leftInput), leftKey, rangeOp != null && !rangeOp.isEmpty());
                HiveRelOptUtil.addJoinKey(joinKeys.get(rightInput), rightKey, rangeOp != null && !rangeOp.isEmpty());
                if (filterNulls != null && kind == SqlKind.EQUALS) {
                    filterNulls.add(joinKeys.get(leftInput).size() - 1);
                }
                if (rangeOp != null && kind != SqlKind.EQUALS && kind != SqlKind.IS_DISTINCT_FROM) {
                    if (reverse) {
                        kind = HiveRelOptUtil.reverse(kind);
                    }
                    rangeOp.add(HiveRelOptUtil.op((SqlKind)kind, (SqlOperator)call.getOperator()));
                }
                return;
            }
        }
        nonEquiList.add(condition);
    }

    private static SqlKind reverse(SqlKind kind) {
        switch (kind) {
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return kind;
    }

    private static void addJoinKey(List<RexNode> joinKeyList, RexNode key, boolean preserveLastElementInList) {
        if (!joinKeyList.isEmpty() && preserveLastElementInList) {
            joinKeyList.add(joinKeyList.size() - 1, key);
        } else {
            joinKeyList.add(key);
        }
    }

    public static RelNode createProject(RelBuilder relBuilder, final RelNode child, final List<Integer> posList) {
        RelDataType rowType = child.getRowType();
        final List fieldNames = rowType.getFieldNames();
        final RexBuilder rexBuilder = child.getCluster().getRexBuilder();
        return HiveRelOptUtil.createProject((RelNode)child, (List)new AbstractList<RexNode>(){

            @Override
            public int size() {
                return posList.size();
            }

            @Override
            public RexNode get(int index) {
                int pos = (Integer)posList.get(index);
                return rexBuilder.makeInputRef(child, pos);
            }
        }, (List)new AbstractList<String>(){

            @Override
            public int size() {
                return posList.size();
            }

            @Override
            public String get(int index) {
                int pos = (Integer)posList.get(index);
                return (String)fieldNames.get(pos);
            }
        }, (boolean)true, (RelBuilder)relBuilder);
    }

    public static RexNode splitCorrelatedFilterCondition(Filter filter, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, boolean extractCorrelatedFieldAccess) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        HiveRelOptUtil.splitCorrelatedFilterCondition(filter, filter.getCondition(), joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
        return RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), nonEquiList, (boolean)true);
    }

    private static void splitCorrelatedFilterCondition(Filter filter, RexNode condition, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, List<RexNode> nonEquiList, boolean extractCorrelatedFieldAccess) {
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator().getKind() == SqlKind.AND) {
                for (RexNode operand : call.getOperands()) {
                    HiveRelOptUtil.splitCorrelatedFilterCondition(filter, operand, joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
                }
                return;
            }
            if (call.getOperator().getKind() == SqlKind.EQUALS) {
                List operands = call.getOperands();
                RexNode op0 = (RexNode)operands.get(0);
                RexNode op1 = (RexNode)operands.get(1);
                if (extractCorrelatedFieldAccess) {
                    if (!RexUtil.containsFieldAccess((RexNode)op0) && op1 instanceof RexFieldAccess) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexFieldAccess && !RexUtil.containsFieldAccess((RexNode)op1)) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                } else {
                    if (!RexUtil.containsInputRef((RexNode)op0) && op1 instanceof RexInputRef) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexInputRef && !RexUtil.containsInputRef((RexNode)op1)) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                }
            }
        }
        nonEquiList.add(condition);
    }

    public static RelNode createSingleValueAggRel(RelOptCluster cluster, RelNode rel, RelFactories.AggregateFactory aggregateFactory) {
        int aggCallCnt = rel.getRowType().getFieldCount();
        ArrayList<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
        for (int i = 0; i < aggCallCnt; ++i) {
            aggCalls.add(AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.SINGLE_VALUE, (boolean)false, (boolean)false, ImmutableList.of(Integer.valueOf(i)), (int)-1, (int)0, (RelNode)rel, null, null));
        }
        return aggregateFactory.createAggregate(rel, false, ImmutableBitSet.of(), null, aggCalls);
    }

    public static boolean isRowFilteringPlan(RelMetadataQuery mq, RelNode operator) {
        Multimap nodesBelowNonFkInput = mq.getNodeTypes(operator);
        for (Map.Entry e : nodesBelowNonFkInput.asMap().entrySet()) {
            if (e.getKey() == Project.class) continue;
            if (e.getKey() == TableScan.class) {
                if (e.getValue().size() <= 1) continue;
                return true;
            }
            if (e.getKey() == Aggregate.class) {
                for (RelNode node : e.getValue()) {
                    Aggregate a = (Aggregate)node;
                    if (a.getGroupType() == Aggregate.Group.SIMPLE) continue;
                    return true;
                }
                continue;
            }
            if (e.getKey() == Sort.class) {
                for (RelNode node : e.getValue()) {
                    Sort s = (Sort)node;
                    if (s.fetch == null && s.offset == null) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public static PKFKJoinInfo extractPKFKJoin(Join join, List<RexNode> joinFilters, boolean leftInputPotentialFK, RelMetadataQuery mq) {
        Sets.SetView<RexTableInputRef.RelTableRef> leftTables;
        ArrayList<RexNode> residualPreds = new ArrayList<RexNode>();
        JoinRelType joinType = join.getJoinType();
        RelNode fkInput = leftInputPotentialFK ? join.getLeft() : join.getRight();
        PKFKJoinInfo cannotExtract = PKFKJoinInfo.of(false, null, null);
        if (joinType != JoinRelType.INNER) {
            join = join.copy(join.getTraitSet(), (RexNode)join.getCluster().getRexBuilder().makeLiteral(true), join.getLeft(), join.getRight(), JoinRelType.INNER, false);
        }
        if ((leftTables = mq.getTableReferences(join.getLeft())) == null) {
            return cannotExtract;
        }
        Set joinTables = mq.getTableReferences((RelNode)join);
        if (joinTables == null) {
            return cannotExtract;
        }
        Sets.SetView<RexTableInputRef.RelTableRef> rightTables = Sets.difference(joinTables, leftTables);
        Sets.SetView<RexTableInputRef.RelTableRef> fkTables = join.getLeft() == fkInput ? leftTables : rightTables;
        Sets.SetView<RexTableInputRef.RelTableRef> nonFkTables = join.getLeft() == fkInput ? rightTables : leftTables;
        HashSet<RexCall> candidatePredicates = new HashSet<RexCall>();
        EquivalenceClasses ec = new EquivalenceClasses();
        for (RexNode conj : joinFilters) {
            if (!conj.isA(SqlKind.EQUALS)) {
                residualPreds.add(conj);
                continue;
            }
            RexCall equiCond = (RexCall)conj;
            RexNode eqOp1 = (RexNode)equiCond.getOperands().get(0);
            if (!RexUtil.isReferenceOrAccess((RexNode)eqOp1, (boolean)true)) {
                residualPreds.add(conj);
                continue;
            }
            Set eqOp1ExprsLineage = mq.getExpressionLineage((RelNode)join, eqOp1);
            if (eqOp1ExprsLineage == null) {
                residualPreds.add(conj);
                continue;
            }
            RexNode eqOp2 = (RexNode)equiCond.getOperands().get(1);
            if (!RexUtil.isReferenceOrAccess((RexNode)eqOp2, (boolean)true)) {
                residualPreds.add(conj);
                continue;
            }
            Set eqOp2ExprsLineage = mq.getExpressionLineage((RelNode)join, eqOp2);
            if (eqOp2ExprsLineage == null) {
                residualPreds.add(conj);
                continue;
            }
            ArrayList<RexTableInputRef> eqOp2ExprsFiltered = null;
            for (RexNode eqOpExprLineage1 : eqOp1ExprsLineage) {
                RexTableInputRef inputRef1 = HiveRelOptUtil.extractTableInputRef(eqOpExprLineage1);
                if (inputRef1 == null) continue;
                if (eqOp2ExprsFiltered == null) {
                    eqOp2ExprsFiltered = new ArrayList<RexTableInputRef>();
                    for (RexNode eqOpExprLineage2 : eqOp2ExprsLineage) {
                        RexTableInputRef inputRef2 = HiveRelOptUtil.extractTableInputRef(eqOpExprLineage2);
                        if (inputRef2 == null) continue;
                        eqOp2ExprsFiltered.add(inputRef2);
                        ec.addEquivalence(inputRef1, inputRef2, equiCond);
                        candidatePredicates.add(equiCond);
                    }
                    continue;
                }
                for (RexTableInputRef inputRef2 : eqOp2ExprsFiltered) {
                    ec.addEquivalence(inputRef1, inputRef2, equiCond);
                }
            }
            if (candidatePredicates.contains(conj)) continue;
            residualPreds.add(conj);
        }
        if (ec.getEquivalenceClassesMap().isEmpty()) {
            return cannotExtract;
        }
        for (RexTableInputRef.RelTableRef nonFkTable : nonFkTables) {
            List nonFkTableQName = nonFkTable.getQualifiedName();
            for (RexTableInputRef.RelTableRef tRef : fkTables) {
                List constraints = tRef.getTable().getReferentialConstraints();
                for (RelReferentialConstraint constraint : constraints) {
                    if (!constraint.getTargetQualifiedName().equals(nonFkTableQName)) continue;
                    EquivalenceClasses ecT = EquivalenceClasses.copy(ec);
                    HashSet<RexCall> removedOriginalPredicates = new HashSet<RexCall>();
                    ImmutableBitSet.Builder lBitSet = ImmutableBitSet.builder();
                    ImmutableBitSet.Builder rBitSet = ImmutableBitSet.builder();
                    boolean allContained = true;
                    for (int pos = 0; pos < constraint.getNumColumns(); ++pos) {
                        int foreignKeyPos = ((IntPair)constraint.getColumnPairs().get((int)pos)).source;
                        RelDataType foreignKeyColumnType = ((RelDataTypeField)tRef.getTable().getRowType().getFieldList().get(foreignKeyPos)).getType();
                        RexTableInputRef foreignKeyColumnRef = RexTableInputRef.of((RexTableInputRef.RelTableRef)tRef, (int)foreignKeyPos, (RelDataType)foreignKeyColumnType);
                        int uniqueKeyPos = ((IntPair)constraint.getColumnPairs().get((int)pos)).target;
                        RexTableInputRef uniqueKeyColumnRef = RexTableInputRef.of((RexTableInputRef.RelTableRef)nonFkTable, (int)uniqueKeyPos, (RelDataType)((RelDataTypeField)nonFkTable.getTable().getRowType().getFieldList().get(uniqueKeyPos)).getType());
                        if (ecT.getEquivalenceClassesMap().containsKey(uniqueKeyColumnRef) && ecT.getEquivalenceClassesMap().get(uniqueKeyColumnRef).contains(foreignKeyColumnRef)) {
                            for (RexCall originalPred : ecT.removeEquivalence(uniqueKeyColumnRef, foreignKeyColumnRef)) {
                                ImmutableBitSet leftCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)originalPred.getOperands().get(0)));
                                ImmutableBitSet rightCols = RelOptUtil.InputFinder.bits((RexNode)((RexNode)originalPred.getOperands().get(1)));
                                int nFieldsLeft = join.getLeft().getRowType().getFieldList().size();
                                int nFieldsRight = join.getRight().getRowType().getFieldList().size();
                                int nSysFields = join.getSystemFieldList().size();
                                ImmutableBitSet rightFieldsBitSet = ImmutableBitSet.range((int)(nSysFields + nFieldsLeft), (int)(nSysFields + nFieldsLeft + nFieldsRight));
                                if (rightFieldsBitSet.contains(leftCols)) {
                                    ImmutableBitSet t = leftCols;
                                    leftCols = rightCols;
                                    rightCols = t;
                                }
                                lBitSet.set(leftCols.nextSetBit(0) - nSysFields);
                                rBitSet.set(rightCols.nextSetBit(0) - (nSysFields + nFieldsLeft));
                                removedOriginalPredicates.add(originalPred);
                            }
                            continue;
                        }
                        allContained = false;
                        break;
                    }
                    if (!allContained) continue;
                    candidatePredicates.removeAll(removedOriginalPredicates);
                    residualPreds.addAll(candidatePredicates);
                    return PKFKJoinInfo.of(true, (Pair<ImmutableBitSet, ImmutableBitSet>)Pair.of((Object)lBitSet.build(), (Object)rBitSet.build()), residualPreds);
                }
            }
        }
        return cannotExtract;
    }

    /*
     * Exception decompiling
     */
    public static RewritablePKFKJoinInfo isRewritablePKFKJoin(Join join, boolean leftInputPotentialFK, RelMetadataQuery mq) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static RexTableInputRef extractTableInputRef(RexNode node) {
        RexTableInputRef ref = null;
        if (node instanceof RexTableInputRef) {
            ref = (RexTableInputRef)node;
        } else if (RexUtil.isLosslessCast((RexNode)node) && ((RexCall)node).getOperands().get(0) instanceof RexTableInputRef) {
            ref = (RexTableInputRef)((RexCall)node).getOperands().get(0);
        }
        return ref;
    }

    public static Pair<RelOptTable, List<Integer>> getColumnOriginSet(RelNode rel, ImmutableBitSet colSet) {
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        HashMap<RexTableInputRef.RelTableRef, ArrayList<Integer>> tabToOriginColumns = new HashMap<RexTableInputRef.RelTableRef, ArrayList<Integer>>();
        Iterator iterator = colSet.iterator();
        while (iterator.hasNext()) {
            int col = (Integer)iterator.next();
            RexInputRef tempColRef = rexBuilder.makeInputRef(rel, col);
            Set columnOrigins = mq.getExpressionLineage(rel, (RexNode)tempColRef);
            if (null == columnOrigins || columnOrigins.isEmpty()) {
                return null;
            }
            for (RexNode orgCol : columnOrigins) {
                RexTableInputRef inputRef = HiveRelOptUtil.extractTableInputRef(orgCol);
                if (inputRef == null) {
                    return null;
                }
                ArrayList<Integer> cols = (ArrayList<Integer>)tabToOriginColumns.get(inputRef.getTableRef());
                if (cols == null) {
                    cols = new ArrayList<Integer>();
                }
                cols.add(inputRef.getIndex());
                tabToOriginColumns.put(inputRef.getTableRef(), cols);
            }
        }
        for (Map.Entry mapEntries : tabToOriginColumns.entrySet()) {
            RexTableInputRef.RelTableRef tblRef = (RexTableInputRef.RelTableRef)mapEntries.getKey();
            List mapColList = (List)mapEntries.getValue();
            if (mapColList.size() != colSet.cardinality()) continue;
            RelOptTable tbl = tblRef.getTable();
            return Pair.of((Object)tbl, (Object)mapColList);
        }
        return null;
    }

    public static String toJsonString(RelNode rel) {
        if (rel == null) {
            return null;
        }
        HiveRelWriterImpl planWriter = new HiveRelWriterImpl();
        rel.explain((RelWriter)planWriter);
        return planWriter.asString();
    }

    public static List<RelFieldCollation> getNewRelFieldCollations(HiveProject project, RelCollation sortCollation, RelOptCluster cluster) {
        Mapping map = RelOptUtil.permutationIgnoreCast((List)project.getProjects(), (RelDataType)project.getInput().getRowType()).inverse();
        HashSet<Integer> needed = new HashSet<Integer>();
        for (RelFieldCollation fc : sortCollation.getFieldCollations()) {
            needed.add(fc.getFieldIndex());
            RexNode node = (RexNode)project.getProjects().get(map.getTarget(fc.getFieldIndex()));
            if (!node.isA(SqlKind.CAST)) continue;
            RexCall cast = (RexCall)node;
            RexCallBinding binding = RexCallBinding.create((RelDataTypeFactory)cluster.getTypeFactory(), (RexCall)cast, ImmutableList.of(RexUtil.apply((Mappings.TargetMapping)map, (RelCollation)sortCollation)));
            if (cast.getOperator().getMonotonicity((SqlOperatorBinding)binding) != SqlMonotonicity.NOT_MONOTONIC) continue;
            return null;
        }
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (int projPos = 0; projPos < project.getChildExps().size(); ++projPos) {
            int parentPos;
            Set<Integer> positions;
            RexNode expr = (RexNode)project.getChildExps().get(projPos);
            if (!(expr instanceof RexInputRef) || (positions = HiveCalciteUtil.getInputRefs(expr)).size() > 1 || !needed.contains(parentPos = positions.iterator().next().intValue())) continue;
            m.put(parentPos, projPos);
            needed.remove(parentPos);
        }
        if (!needed.isEmpty()) {
            return null;
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (RelFieldCollation fc : sortCollation.getFieldCollations()) {
            fieldCollations.add(new RelFieldCollation(((Integer)m.get(fc.getFieldIndex())).intValue(), fc.direction, fc.nullDirection));
        }
        return fieldCollations;
    }

    public static List<Integer> getNewRelDistributionKeys(HiveProject project, RelDistribution distribution) {
        HashSet needed = new HashSet(distribution.getKeys());
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (int projPos = 0; projPos < project.getChildExps().size(); ++projPos) {
            int parentPos;
            Set<Integer> positions;
            RexNode expr = (RexNode)project.getChildExps().get(projPos);
            if (!(expr instanceof RexInputRef) || (positions = HiveCalciteUtil.getInputRefs(expr)).size() > 1 || !needed.contains(parentPos = positions.iterator().next().intValue())) continue;
            m.put(parentPos, projPos);
            needed.remove(parentPos);
        }
        if (!needed.isEmpty()) {
            return null;
        }
        ArrayList<Integer> distributionKeys = new ArrayList<Integer>();
        for (Integer keyIndex : distribution.getKeys()) {
            distributionKeys.add((Integer)m.get(keyIndex));
        }
        return distributionKeys;
    }

    private static class EquivalenceClasses {
        private final Map<RexTableInputRef, Set<RexTableInputRef>> nodeToEquivalenceClass = new HashMap<RexTableInputRef, Set<RexTableInputRef>>();
        private final Multimap<Pair<RexTableInputRef, RexTableInputRef>, RexCall> equivalenceToOriginalNode = HashMultimap.create();

        protected EquivalenceClasses() {
        }

        protected void addEquivalence(RexTableInputRef p1, RexTableInputRef p2, RexCall originalCond) {
            this.addEquivalence(p1, p2);
            this.equivalenceToOriginalNode.put((Pair<RexTableInputRef, RexTableInputRef>)Pair.of((Object)p1, (Object)p2), originalCond);
            this.equivalenceToOriginalNode.put((Pair<RexTableInputRef, RexTableInputRef>)Pair.of((Object)p2, (Object)p1), originalCond);
        }

        protected void addEquivalence(RexTableInputRef p1, RexTableInputRef p2) {
            Object c1 = this.nodeToEquivalenceClass.get(p1);
            Set<RexTableInputRef> c2 = this.nodeToEquivalenceClass.get(p2);
            if (c1 != null && c2 != null) {
                if (c1.size() < c2.size()) {
                    Set<RexTableInputRef> c2Temp = c2;
                    c2 = c1;
                    c1 = c2Temp;
                }
                for (RexTableInputRef newRef : c2) {
                    c1.add(newRef);
                    this.nodeToEquivalenceClass.put(newRef, (Set<RexTableInputRef>)c1);
                }
            } else if (c1 != null) {
                c1.add((RexTableInputRef)p2);
                this.nodeToEquivalenceClass.put(p2, (Set<RexTableInputRef>)c1);
            } else if (c2 != null) {
                c2.add(p1);
                this.nodeToEquivalenceClass.put(p1, c2);
            } else {
                LinkedHashSet<RexTableInputRef> equivalenceClass = new LinkedHashSet<RexTableInputRef>();
                equivalenceClass.add(p1);
                equivalenceClass.add(p2);
                this.nodeToEquivalenceClass.put(p1, equivalenceClass);
                this.nodeToEquivalenceClass.put(p2, equivalenceClass);
            }
        }

        protected Map<RexTableInputRef, Set<RexTableInputRef>> getEquivalenceClassesMap() {
            return this.nodeToEquivalenceClass;
        }

        protected Set<RexCall> removeEquivalence(RexTableInputRef p1, RexTableInputRef p2) {
            this.nodeToEquivalenceClass.get(p1).remove(p2);
            if (this.nodeToEquivalenceClass.get(p1).size() == 1) {
                this.nodeToEquivalenceClass.remove(p1);
            }
            this.nodeToEquivalenceClass.get(p2).remove(p1);
            if (this.nodeToEquivalenceClass.get(p2).size() == 1) {
                this.nodeToEquivalenceClass.remove(p2);
            }
            HashSet<RexCall> originalNodes = new HashSet<RexCall>();
            originalNodes.addAll(this.equivalenceToOriginalNode.removeAll(Pair.of((Object)p1, (Object)p2)));
            originalNodes.addAll(this.equivalenceToOriginalNode.removeAll(Pair.of((Object)p2, (Object)p1)));
            return originalNodes;
        }

        protected static EquivalenceClasses copy(EquivalenceClasses ec) {
            EquivalenceClasses newEc = new EquivalenceClasses();
            for (Map.Entry<RexTableInputRef, Set<RexTableInputRef>> entry : ec.nodeToEquivalenceClass.entrySet()) {
                newEc.nodeToEquivalenceClass.put(entry.getKey(), Sets.newLinkedHashSet((Iterable)entry.getValue()));
            }
            for (Map.Entry<Object, Collection<Object>> entry : ec.equivalenceToOriginalNode.asMap().entrySet()) {
                newEc.equivalenceToOriginalNode.putAll((Pair<RexTableInputRef, RexTableInputRef>)entry.getKey(), (Iterable<RexCall>)entry.getValue());
            }
            return newEc;
        }
    }

    public static class RewritablePKFKJoinInfo {
        public final boolean rewritable;
        public final List<RexNode> nullableNodes;

        private RewritablePKFKJoinInfo(boolean rewritable, List<RexNode> nullableNodes) {
            this.rewritable = rewritable;
            this.nullableNodes = nullableNodes == null ? null : ImmutableList.copyOf(nullableNodes);
        }

        public static RewritablePKFKJoinInfo of(boolean rewritable, List<RexNode> nullableNodes) {
            return new RewritablePKFKJoinInfo(rewritable, nullableNodes);
        }
    }

    public static class PKFKJoinInfo {
        public final boolean isPkFkJoin;
        public final Pair<ImmutableBitSet, ImmutableBitSet> pkFkJoinColumns;
        public final List<RexNode> additionalPredicates;

        private PKFKJoinInfo(boolean isPkFkJoin, Pair<ImmutableBitSet, ImmutableBitSet> pkFkJoinColumns, List<RexNode> additionalPredicates) {
            this.isPkFkJoin = isPkFkJoin;
            this.pkFkJoinColumns = pkFkJoinColumns;
            this.additionalPredicates = additionalPredicates == null ? null : ImmutableList.copyOf(additionalPredicates);
        }

        public static PKFKJoinInfo of(boolean isPkFkJoin, Pair<ImmutableBitSet, ImmutableBitSet> pkFkJoinColumns, List<RexNode> additionalPredicates) {
            return new PKFKJoinInfo(isPkFkJoin, pkFkJoinColumns, additionalPredicates);
        }
    }
}

