/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.externalize.RelJsonWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRelWriterImpl
extends RelJsonWriter {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRelWriterImpl.class);

    public HiveRelWriterImpl() {
        try {
            Field fieldRelJson = RelJsonWriter.class.getDeclaredField("relJson");
            fieldRelJson.setAccessible(true);
            fieldRelJson.set((Object)this, (Object)new HiveRelJson(this.jsonBuilder));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        super.explain_(rel, values);
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Map map = (Map)this.relList.get(this.relList.size() - 1);
        map.put("rowCount", mq.getRowCount(rel));
        if (rel.getInputs().size() == 0) {
            map.put("avgRowSize", mq.getAverageRowSize(rel));
            map.put("rowType", this.relJson.toJson((Object)rel.getRowType()));
        }
    }
}

