/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.Util;

public class HiveBetween
extends SqlSpecialOperator {
    public static final SqlSpecialOperator INSTANCE = new HiveBetween();
    public static final int VALUE_OPERAND = 1;
    public static final int LOWER_OPERAND = 2;
    public static final int UPPER_OPERAND = 3;
    public static final SqlOperandTypeInference FIRST_BOOLEAN_THEN_FIRST_KNOWN = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataType unknownType;
            RelDataType knownType = unknownType = callBinding.getValidator().getUnknownType();
            for (int i = 1; i < callBinding.getCall().getOperandList().size(); ++i) {
                SqlNode operand = (SqlNode)callBinding.getCall().getOperandList().get(i);
                knownType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
                if (!knownType.equals(unknownType)) break;
            }
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            operandTypes[0] = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            for (int i = 1; i < operandTypes.length; ++i) {
                operandTypes[i] = knownType;
            }
        }
    };

    private HiveBetween() {
        super("BETWEEN", SqlKind.BETWEEN, 30, true, ReturnTypes.BOOLEAN_NULLABLE, FIRST_BOOLEAN_THEN_FIRST_KNOWN, null);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create((String)"BETWEEN"), "", "");
        call.operand(1).unparse(writer, this.getLeftPrec(), 0);
        writer.sep(super.getName());
        SqlNode lower = call.operand(2);
        SqlNode upper = call.operand(3);
        int lowerPrec = new AndFinder().containsAnd(lower) ? 100 : 0;
        lower.unparse(writer, lowerPrec, lowerPrec);
        writer.sep("AND");
        upper.unparse(writer, 0, this.getRightPrec());
        writer.endList(frame);
    }

    private static class AndFinder
    extends SqlBasicVisitor<Void> {
        private AndFinder() {
        }

        public Void visit(SqlCall call) {
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.AND) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visit(call);
        }

        boolean containsAnd(SqlNode node) {
            try {
                node.accept((SqlVisitor)this);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }
    }
}

