/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public final class HiveSortExchange
extends SortExchange
implements HiveRelNode {
    private final ImmutableList<RexNode> keys;
    private ExprNodeDesc[] keyExpressions;

    private HiveSortExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDistribution distribution, RelCollation collation, ImmutableList<RexNode> keys) {
        super(cluster, traitSet, input, distribution, collation);
        this.keys = ((ImmutableList.Builder)new ImmutableList.Builder().addAll(keys)).build();
    }

    public static HiveSortExchange create(RelNode input, RelDistribution distribution, RelCollation collation, ImmutableList<RexNode> keys) {
        RelOptCluster cluster = input.getCluster();
        distribution = (RelDistribution)RelDistributionTraitDef.INSTANCE.canonize((RelTrait)distribution);
        collation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)collation);
        RelTraitSet traitSet = HiveSortExchange.getTraitSet(collation, cluster, distribution);
        return new HiveSortExchange(cluster, traitSet, input, distribution, collation, keys);
    }

    private static RelTraitSet getTraitSet(RelCollation collation, RelOptCluster cluster, RelDistribution distribution) {
        return TraitsUtil.getDefaultTraitSet(cluster).replace((RelTrait)collation).replace((RelTrait)distribution);
    }

    public static HiveSortExchange create(RelNode input, RelDistribution distribution, RelCollation collation) {
        RelOptCluster cluster = input.getCluster();
        distribution = (RelDistribution)RelDistributionTraitDef.INSTANCE.canonize((RelTrait)distribution);
        collation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)collation);
        RelTraitSet traitSet = HiveSortExchange.getTraitSet(collation, cluster, distribution);
        RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollationImpl.of((List)collation.getFieldCollations()));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RelFieldCollation relFieldCollation : canonizedCollation.getFieldCollations()) {
            int index = relFieldCollation.getFieldIndex();
            builder.add(cluster.getRexBuilder().makeInputRef(input, index));
        }
        return new HiveSortExchange(cluster, traitSet, input, distribution, collation, (ImmutableList<RexNode>)builder.build());
    }

    public SortExchange copy(RelTraitSet traitSet, RelNode newInput, RelDistribution newDistribution, RelCollation newCollation) {
        return new HiveSortExchange(this.getCluster(), traitSet, newInput, newDistribution, newCollation, this.keys);
    }

    public ImmutableList<RexNode> getKeys() {
        return this.keys;
    }

    public ExprNodeDesc[] getKeyExpressions() {
        return this.keyExpressions;
    }

    public void setKeyExpressions(ExprNodeDesc[] keyExpressions) {
        this.keyExpressions = keyExpressions;
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }
}

