/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;

public class HiveAggregateSplitRule
extends RelOptRule {
    private static final Predicate<Aggregate> FILTER_PREDICATE = new PredicateImpl<Aggregate>(){

        public boolean test(Aggregate input) {
            return input.getGroupType() != Aggregate.Group.SIMPLE;
        }
    };
    public static final HiveAggregateSplitRule INSTANCE = new HiveAggregateSplitRule(HiveAggregate.class, HiveRelFactories.HIVE_BUILDER);

    private HiveAggregateSplitRule(Class<? extends Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory) {
        super(HiveAggregateSplitRule.operand(aggregateClass, null, FILTER_PREDICATE, (RelOptRuleOperandChildren)HiveAggregateSplitRule.any()), relBuilderFactory, null);
    }

    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelBuilder relBuilder = call.builder();
        ImmutableBitSet bottomAggregateGroupSet = aggregate.getGroupSet();
        ArrayList<AggregateCall> topAggregateCalls = new ArrayList<AggregateCall>();
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            AggregateCall aggregateCall = (AggregateCall)aggregate.getAggCallList().get(i);
            if (aggregateCall.isDistinct()) {
                return;
            }
            if (aggregateCall.getAggregation().equals((Object)HiveGroupingID.INSTANCE)) {
                return;
            }
            if (aggregateCall.filterArg >= 0) {
                return;
            }
            SqlAggFunction aggFunction = HiveRelBuilder.getRollup(aggregateCall.getAggregation());
            if (aggFunction == null) {
                return;
            }
            topAggregateCalls.add(AggregateCall.create((SqlAggFunction)aggFunction, (boolean)aggregateCall.isDistinct(), (boolean)aggregateCall.isApproximate(), ImmutableList.of(Integer.valueOf(bottomAggregateGroupSet.cardinality() + i)), (int)-1, (RelDataType)aggregateCall.type, (String)aggregateCall.name));
        }
        if (aggregate.getCluster().getMetadataQuery().areColumnsUnique(aggregate.getInput(), bottomAggregateGroupSet).booleanValue()) {
            return;
        }
        ImmutableBitSet topAggregateGroupSet = ImmutableBitSet.range((int)0, (int)bottomAggregateGroupSet.cardinality());
        HashMap map = new HashMap();
        bottomAggregateGroupSet.forEach(k -> map.put(k, map.size()));
        ImmutableList topAggregateGroupSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute((Iterable)aggregate.groupSets, map));
        relBuilder.push(aggregate.getInput()).aggregate(relBuilder.groupKey(bottomAggregateGroupSet, null), aggregate.getAggCallList()).aggregate(relBuilder.groupKey(topAggregateGroupSet, topAggregateGroupSets), topAggregateCalls);
        call.transformTo(relBuilder.build());
    }
}

