/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveBetween;

public class HiveDruidPullInvertFromBetweenRule
extends RelOptRule {
    protected static final Log LOG = LogFactory.getLog(HiveDruidPullInvertFromBetweenRule.class);
    public static final HiveDruidPullInvertFromBetweenRule INSTANCE = new HiveDruidPullInvertFromBetweenRule();

    private HiveDruidPullInvertFromBetweenRule() {
        super(HiveDruidPullInvertFromBetweenRule.operand(Filter.class, (RelOptRuleOperandChildren)HiveDruidPullInvertFromBetweenRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        RexNode condition;
        Filter filter = (Filter)call.rel(0);
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexPullInvertFromBetween t = new RexPullInvertFromBetween(rexBuilder);
        RexNode newCondition = t.apply(condition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)filter.getCondition()));
        if (newCondition.toString().equals(condition.toString())) {
            return;
        }
        Filter newNode = filter.copy(filter.getTraitSet(), filter.getInput(), newCondition);
        call.transformTo((RelNode)newNode);
    }

    protected static class RexPullInvertFromBetween
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        RexPullInvertFromBetween(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall inputCall) {
            RexCall call;
            Boolean isInverted;
            RexNode node = super.visitCall(inputCall);
            if (node instanceof RexCall && node.getKind() == SqlKind.BETWEEN && (isInverted = Boolean.valueOf(((RexNode)(call = (RexCall)node).getOperands().get(0)).isAlwaysTrue())).booleanValue()) {
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.rexBuilder.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{this.rexBuilder.makeLiteral(false), (RexNode)call.getOperands().get(1), (RexNode)call.getOperands().get(2), (RexNode)call.getOperands().get(3)})});
            }
            return node;
        }
    }
}

