/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveProjectSortTransposeRule
extends RelOptRule {
    public static final HiveProjectSortTransposeRule INSTANCE = new HiveProjectSortTransposeRule();

    private HiveProjectSortTransposeRule() {
        super(HiveProjectSortTransposeRule.operand(HiveProject.class, (RelOptRuleOperand)HiveProjectSortTransposeRule.operand(HiveSortLimit.class, (RelOptRuleOperandChildren)HiveProjectSortTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    protected HiveProjectSortTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveProject project = (HiveProject)call.rel(0);
        HiveSortLimit sort = (HiveSortLimit)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        List<RelFieldCollation> fieldCollations = HiveRelOptUtil.getNewRelFieldCollations(project, sort.getCollation(), cluster);
        if (fieldCollations == null) {
            return;
        }
        RelTraitSet traitSet = sort.getCluster().traitSetOf((RelTrait)HiveRelNode.CONVENTION);
        RelCollation newCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollationImpl.of(fieldCollations));
        RelNode newProject = project.copy(sort.getInput().getTraitSet(), ImmutableList.of(sort.getInput()));
        HiveSortLimit newSort = sort.copy(newProject.getTraitSet(), newProject, newCollation, sort.offset, sort.fetch);
        call.transformTo((RelNode)newSort);
    }
}

