/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;

public class HiveRemoveEmptySingleRules
extends PruneEmptyRules {
    public static final RelOptRule PROJECT_INSTANCE = new PruneEmptyRules.RemoveEmptySingleRule(HiveProject.class, project -> true, HiveRelFactories.HIVE_BUILDER, "HivePruneEmptyProject");
    public static final RelOptRule FILTER_INSTANCE = new PruneEmptyRules.RemoveEmptySingleRule(HiveFilter.class, hiveFilter -> true, HiveRelFactories.HIVE_BUILDER, "HivePruneEmptyFilter");
    public static final RelOptRule SORT_INSTANCE = new PruneEmptyRules.RemoveEmptySingleRule(HiveSortLimit.class, hiveSortLimit -> true, HiveRelFactories.HIVE_BUILDER, "HivePruneEmptySort");
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = new RemoveSortFetchZeroRule();
    public static final RelOptRule AGGREGATE_INSTANCE = new PruneEmptyRules.RemoveEmptySingleRule(HiveAggregate.class, Aggregate::isNotGrandTotal, HiveRelFactories.HIVE_BUILDER, "HivePruneEmptyAggregate");
    public static final RelOptRule JOIN_LEFT_INSTANCE = new RemoveLeftEmptyJoinRule<HiveJoin>(HiveJoin.class);
    public static final RelOptRule SEMI_JOIN_LEFT_INSTANCE = new RemoveLeftEmptyJoinRule<HiveSemiJoin>(HiveSemiJoin.class);
    public static final RelOptRule JOIN_RIGHT_INSTANCE = new RemoveRightEmptyJoinRule<HiveJoin>(HiveJoin.class);
    public static final RelOptRule SEMI_JOIN_RIGHT_INSTANCE = new RemoveRightEmptyJoinRule<HiveSemiJoin>(HiveSemiJoin.class);
    public static final RelOptRule UNION_INSTANCE = new UnionEmptyPruneRule();

    private static boolean isEmpty(RelNode node) {
        if (node instanceof Values) {
            return ((Values)node).getTuples().isEmpty();
        }
        if (node instanceof HepRelVertex) {
            return HiveRemoveEmptySingleRules.isEmpty(((HepRelVertex)node).getCurrentRel());
        }
        if (!(node instanceof RelSubset)) {
            return false;
        }
        RelSubset subset = (RelSubset)node;
        for (RelNode rel : subset.getRels()) {
            if (!HiveRemoveEmptySingleRules.isEmpty(rel)) continue;
            return true;
        }
        return false;
    }

    public static class UnionEmptyPruneRule
    extends RelOptRule {
        public UnionEmptyPruneRule() {
            super(UnionEmptyPruneRule.operand(HiveUnion.class, (RelOptRuleOperandChildren)UnionEmptyPruneRule.any()), HiveRelFactories.HIVE_BUILDER, "UnionEmptyPruneRule");
        }

        public void onMatch(RelOptRuleCall call) {
            Union union = (Union)call.rel(0);
            List inputs = union.getInputs();
            assert (inputs != null);
            RelBuilder builder = call.builder();
            int nonEmptyInputs = 0;
            for (RelNode input : inputs) {
                if (HiveRemoveEmptySingleRules.isEmpty(input)) continue;
                builder.push(input);
                ++nonEmptyInputs;
            }
            if (nonEmptyInputs == inputs.size()) {
                return;
            }
            if (nonEmptyInputs == 0) {
                builder.push((RelNode)union).empty();
            } else {
                builder.union(union.all, nonEmptyInputs);
                builder.convert(union.getRowType(), true);
            }
            call.transformTo(builder.build());
        }
    }

    public static class RemoveRightEmptyJoinRule<R extends RelNode>
    extends RelOptRule {
        public RemoveRightEmptyJoinRule(Class<R> clazz) {
            super(RemoveRightEmptyJoinRule.operand(clazz, (RelOptRuleOperand)RemoveRightEmptyJoinRule.operand(RelNode.class, (RelOptRuleOperandChildren)RemoveRightEmptyJoinRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{RemoveRightEmptyJoinRule.operand(Values.class, (RelOptRuleOperandChildren)RemoveRightEmptyJoinRule.none())}), HiveRelFactories.HIVE_BUILDER, "HivePruneEmptyJoin(right)");
        }

        public boolean matches(RelOptRuleCall call) {
            Values values = (Values)call.rel(2);
            return Values.isEmpty((Values)values);
        }

        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            RelNode left = call.rel(1);
            Values empty = (Values)call.rel(2);
            RelBuilder relBuilder = call.builder();
            if (join.getJoinType().generatesNullsOnRight()) {
                List<RexNode> nullLiterals = Collections.nCopies(empty.getRowType().getFieldCount(), relBuilder.literal(null));
                call.transformTo(relBuilder.push(left).project(Iterables.concat(relBuilder.fields(), nullLiterals)).convert(join.getRowType(), true).build());
                return;
            }
            call.transformTo(relBuilder.push((RelNode)join).empty().build());
        }
    }

    public static class RemoveLeftEmptyJoinRule<R extends RelNode>
    extends RelOptRule {
        public RemoveLeftEmptyJoinRule(Class<R> clazz) {
            super(RemoveLeftEmptyJoinRule.operand(clazz, (RelOptRuleOperand)RemoveLeftEmptyJoinRule.operand(Values.class, (RelOptRuleOperandChildren)RemoveLeftEmptyJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[]{RemoveLeftEmptyJoinRule.operand(RelNode.class, (RelOptRuleOperandChildren)RemoveLeftEmptyJoinRule.any())}), HiveRelFactories.HIVE_BUILDER, "HivePruneEmptyJoin(left)");
        }

        public boolean matches(RelOptRuleCall call) {
            Values values = (Values)call.rel(1);
            return Values.isEmpty((Values)values);
        }

        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            Values empty = (Values)call.rel(1);
            RelNode right = call.rel(2);
            RelBuilder relBuilder = call.builder();
            if (join.getJoinType().generatesNullsOnLeft()) {
                List<RexNode> nullLiterals = Collections.nCopies(empty.getRowType().getFieldCount(), relBuilder.literal(null));
                call.transformTo(relBuilder.push(right).project(Iterables.concat(nullLiterals, relBuilder.fields())).convert(join.getRowType(), true).build());
                return;
            }
            call.transformTo(relBuilder.push((RelNode)join).empty().build());
        }
    }

    public static class RemoveSortFetchZeroRule
    extends RelOptRule {
        public RemoveSortFetchZeroRule() {
            super(RemoveSortFetchZeroRule.operand(HiveSortLimit.class, (RelOptRuleOperandChildren)RelOptRule.any()), HiveRelFactories.HIVE_BUILDER, "PruneSortLimit0");
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            if (sort.fetch != null && !(sort.fetch instanceof RexDynamicParam) && RexLiteral.intValue((RexNode)sort.fetch) == 0) {
                call.transformTo(call.builder().push((RelNode)sort).empty().build());
            }
        }
    }
}

