/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsRule;

public final class HiveSortPullUpConstantsRule {
    public static final HiveSortPullUpConstantsRuleBase<HiveSortLimit> SORT_LIMIT_INSTANCE = new HiveSortLimitPullUpConstantsRule();
    public static final HiveSortExchangePullUpConstantsRule SORT_EXCHANGE_INSTANCE = new HiveSortExchangePullUpConstantsRule();

    private HiveSortPullUpConstantsRule() {
    }

    private static abstract class HiveSortPullUpConstantsRuleBase<T extends SingleRel>
    extends RelOptRule {
        protected HiveSortPullUpConstantsRuleBase(Class<T> sortClass) {
            super(HiveSortPullUpConstantsRuleBase.operand(RelNode.class, (RelOptRuleOperandChildren)HiveSortPullUpConstantsRuleBase.unordered((RelOptRuleOperand)HiveSortPullUpConstantsRuleBase.operand(sortClass, (RelOptRuleOperandChildren)HiveSortPullUpConstantsRuleBase.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0])), HiveRelFactories.HIVE_BUILDER, null);
        }

        public void onMatch(RelOptRuleCall call) {
            RelNode parent = call.rel(0);
            SingleRel sortNode = (SingleRel)call.rel(1);
            int count = sortNode.getInput().getRowType().getFieldCount();
            if (count == 1) {
                return;
            }
            RexBuilder rexBuilder = sortNode.getCluster().getRexBuilder();
            RelMetadataQuery mq = call.getMetadataQuery();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(sortNode.getInput());
            if (predicates == null) {
                return;
            }
            ImmutableMap conditionsExtracted = HiveReduceExpressionsRule.predicateConstants(RexNode.class, (RexBuilder)rexBuilder, (RelOptPredicateList)predicates);
            HashMap constants = new HashMap();
            for (int i = 0; i < count; ++i) {
                RexInputRef expr = rexBuilder.makeInputRef(sortNode.getInput(), i);
                if (!conditionsExtracted.containsKey(expr)) continue;
                constants.put(expr, conditionsExtracted.get(expr));
            }
            if (constants.isEmpty()) {
                return;
            }
            if (count == constants.size()) {
                constants.remove(constants.keySet().iterator().next());
            }
            List fields = sortNode.getInput().getRowType().getFieldList();
            ArrayList<Pair> newChildExprs = new ArrayList<Pair>();
            AbstractCollection topChildExprs = new ArrayList();
            ArrayList<String> topChildExprsFields = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                RexInputRef expr = rexBuilder.makeInputRef(sortNode.getInput(), i);
                RelDataTypeField field = (RelDataTypeField)fields.get(i);
                if (constants.containsKey(expr)) {
                    topChildExprs.add(constants.get(expr));
                    topChildExprsFields.add(field.getName());
                    continue;
                }
                newChildExprs.add(Pair.of((Object)expr, (Object)field.getName()));
                topChildExprs.add(expr);
                topChildExprsFields.add(field.getName());
            }
            Mapping mapping = RelOptUtil.permutation((List)Pair.left(newChildExprs), (RelDataType)sortNode.getInput().getRowType()).inverse();
            topChildExprs = ImmutableList.copyOf(RexUtil.apply((Mappings.TargetMapping)mapping, topChildExprs));
            RelBuilder relBuilder = call.builder();
            relBuilder.push(sortNode.getInput());
            relBuilder.project((Iterable)Pair.left(newChildExprs), (Iterable)Pair.right(newChildExprs));
            this.buildSort(relBuilder, sortNode, (Mappings.TargetMapping)mapping);
            relBuilder.project((Iterable)topChildExprs, topChildExprsFields);
            relBuilder.convert(sortNode.getRowType(), false);
            ArrayList<RelNode> inputs = new ArrayList<RelNode>();
            for (RelNode child : parent.getInputs()) {
                if (!((HepRelVertex)child).getCurrentRel().equals(sortNode)) {
                    inputs.add(child);
                    continue;
                }
                inputs.add(relBuilder.build());
            }
            call.transformTo(parent.copy(parent.getTraitSet(), inputs));
        }

        protected List<RelFieldCollation> applyToFieldCollations(RelCollation relCollation, Mappings.TargetMapping mapping) {
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
            for (RelFieldCollation fc : relCollation.getFieldCollations()) {
                int target = mapping.getTargetOpt(fc.getFieldIndex());
                if (target < 0) continue;
                fieldCollations.add(fc.copy(target));
            }
            return fieldCollations;
        }

        protected abstract void buildSort(RelBuilder var1, T var2, Mappings.TargetMapping var3);
    }

    private static final class HiveSortExchangePullUpConstantsRule
    extends HiveSortPullUpConstantsRuleBase<HiveSortExchange> {
        protected HiveSortExchangePullUpConstantsRule() {
            super(HiveSortExchange.class);
        }

        @Override
        protected void buildSort(RelBuilder relBuilder, HiveSortExchange sortNode, Mappings.TargetMapping mapping) {
            List<RelFieldCollation> fieldCollations = this.applyToFieldCollations(sortNode.getCollation(), mapping);
            RelDistribution distribution = sortNode.getDistribution().apply(mapping);
            relBuilder.sortExchange(distribution, RelCollations.of(fieldCollations));
        }
    }

    private static final class HiveSortLimitPullUpConstantsRule
    extends HiveSortPullUpConstantsRuleBase<HiveSortLimit> {
        protected HiveSortLimitPullUpConstantsRule() {
            super(HiveSortLimit.class);
        }

        @Override
        protected void buildSort(RelBuilder relBuilder, HiveSortLimit sortNode, Mappings.TargetMapping mapping) {
            List<RelFieldCollation> fieldCollations = this.applyToFieldCollations(sortNode.getCollation(), mapping);
            ImmutableList sortFields = relBuilder.fields(RelCollations.of(fieldCollations));
            relBuilder.sortLimit(sortNode.offset == null ? -1 : RexLiteral.intValue((RexNode)sortNode.offset), sortNode.fetch == null ? -1 : RexLiteral.intValue((RexNode)sortNode.fetch), (Iterable)sortFields);
        }
    }
}

