/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JDBCExpandExpressionsRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCExpandExpressionsRule.class);
    public static final FilterCondition FILTER_INSTANCE = new FilterCondition();
    public static final JoinCondition JOIN_INSTANCE = new JoinCondition();
    public static final ProjectionExpressions PROJECT_INSTANCE = new ProjectionExpressions();

    private JDBCExpandExpressionsRule(RelOptRuleOperand operand) {
        super(operand);
    }

    RexNode analyzeRexNode(RexBuilder rexBuilder, RexNode condition) {
        RexTransformIntoOrAndClause transformIntoInClause = new RexTransformIntoOrAndClause(rexBuilder);
        RexNode newCondition = transformIntoInClause.apply(condition);
        return newCondition;
    }

    protected static class RexTransformIntoOrAndClause
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        RexTransformIntoOrAndClause(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall inputCall) {
            RexNode node = super.visitCall(inputCall);
            if (node instanceof RexCall) {
                RexCall call = (RexCall)node;
                switch (call.getKind()) {
                    case IN: {
                        return this.transformIntoOrAndClause(this.rexBuilder, call);
                    }
                }
            }
            return node;
        }

        private RexNode transformIntoOrAndClause(RexBuilder rexBuilder, RexCall expression) {
            assert (expression.getKind() == SqlKind.IN);
            if (((RexNode)expression.getOperands().get(0)).getKind() != SqlKind.ROW) {
                return expression;
            }
            List<RexNode> disjuncts = RexNodeConverter.transformInToOrOperands(expression.getOperands(), rexBuilder);
            if (disjuncts == null) {
                return expression;
            }
            if (disjuncts.size() > 1) {
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, disjuncts);
            }
            return disjuncts.get(0);
        }
    }

    private static class ProjectionExpressions
    extends JDBCExpandExpressionsRule {
        private ProjectionExpressions() {
            super(ProjectionExpressions.operand(JdbcRules.JdbcProject.class, (RelOptRuleOperandChildren)ProjectionExpressions.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LOG.debug("JDBCExpandExpressionsRule.ProjectionExpressions has been called");
            Project project = (Project)call.rel(0);
            RexBuilder rexBuilder = project.getCluster().getRexBuilder();
            boolean changed = false;
            ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
            for (RexNode oldNode : project.getProjects()) {
                RexNode newNode = this.analyzeRexNode(rexBuilder, oldNode);
                if (!newNode.toString().equals(oldNode.toString())) {
                    changed = true;
                    newProjects.add(newNode);
                    continue;
                }
                newProjects.add(oldNode);
            }
            if (!changed) {
                return;
            }
            Project newProject = project.copy(project.getTraitSet(), project.getInput(), newProjects, project.getRowType());
            call.transformTo((RelNode)newProject);
        }
    }

    private static class JoinCondition
    extends JDBCExpandExpressionsRule {
        private JoinCondition() {
            super(JoinCondition.operand(JdbcRules.JdbcJoin.class, (RelOptRuleOperandChildren)JoinCondition.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LOG.debug("JDBCExpandExpressionsRule.JoinCondition has been called");
            Join join = (Join)call.rel(0);
            RexNode condition = RexUtil.pullFactors((RexBuilder)join.getCluster().getRexBuilder(), (RexNode)join.getCondition());
            RexNode newCondition = this.analyzeRexNode(join.getCluster().getRexBuilder(), condition);
            if (newCondition.toString().equals(condition.toString())) {
                return;
            }
            Join newNode = join.copy(join.getTraitSet(), newCondition, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
            call.transformTo((RelNode)newNode);
        }
    }

    private static class FilterCondition
    extends JDBCExpandExpressionsRule {
        private FilterCondition() {
            super(FilterCondition.operand(JdbcRules.JdbcFilter.class, (RelOptRuleOperandChildren)FilterCondition.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LOG.debug("JDBCExpandExpressionsRule.FilterCondition has been called");
            JdbcRules.JdbcFilter filter = (JdbcRules.JdbcFilter)call.rel(0);
            RexNode condition = filter.getCondition();
            RexNode newCondition = this.analyzeRexNode(filter.getCluster().getRexBuilder(), condition);
            if (newCondition.toString().equals(condition.toString())) {
                return;
            }
            JdbcRules.JdbcFilter newNode = filter.copy(filter.getTraitSet(), filter.getInput(), newCondition);
            call.transformTo((RelNode)newNode);
        }
    }
}

