/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdDistinctRowCount;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NumberUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveRelMdDistinctRowCount
extends RelMdDistinctRowCount {
    private static final HiveRelMdDistinctRowCount INSTANCE = new HiveRelMdDistinctRowCount();
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.DISTINCT_ROW_COUNT.method, (MetadataHandler)INSTANCE), ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.CUMULATIVE_COST.method, (MetadataHandler)INSTANCE)));

    private HiveRelMdDistinctRowCount() {
    }

    public Double getDistinctRowCount(HiveTableScan htRel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        List<Integer> projIndxLst = HiveCalciteUtil.translateBitSetToProjIndx(groupKey);
        List<ColStatistics> colStats = htRel.getColStat(projIndxLst);
        Double noDistinctRows = 1.0;
        for (ColStatistics cStat : colStats) {
            noDistinctRows = noDistinctRows * (double)cStat.getCountDistint();
        }
        return Math.min(noDistinctRows, mq.getRowCount((RelNode)htRel));
    }

    public static Double getDistinctRowCount(RelNode r, RelMetadataQuery mq, int indx) {
        ImmutableBitSet bitSetOfRqdProj = ImmutableBitSet.of((int[])new int[]{indx});
        return mq.getDistinctRowCount(r, bitSetOfRqdProj, (RexNode)r.getCluster().getRexBuilder().makeLiteral(true));
    }

    public Double getDistinctRowCount(Join rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        if (rel instanceof HiveJoin) {
            HiveJoin hjRel = (HiveJoin)rel;
            if (rel instanceof SemiJoin) {
                return mq.getDistinctRowCount(hjRel.getLeft(), groupKey, (RexNode)rel.getCluster().getRexBuilder().makeLiteral(true));
            }
            return HiveRelMdDistinctRowCount.getJoinDistinctRowCount(mq, (RelNode)rel, rel.getJoinType(), groupKey, predicate, true);
        }
        return mq.getDistinctRowCount((RelNode)rel, groupKey, predicate);
    }

    public static Double getJoinDistinctRowCount(RelMetadataQuery mq, RelNode joinRel, JoinRelType joinType, ImmutableBitSet groupKey, RexNode predicate, boolean useMaxNdv) {
        Double distRowCount = null;
        ImmutableBitSet.Builder leftMask = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightMask = ImmutableBitSet.builder();
        RelNode left = (RelNode)joinRel.getInputs().get(0);
        RelNode right = (RelNode)joinRel.getInputs().get(1);
        RelMdUtil.setLeftRightBitmaps((ImmutableBitSet)groupKey, (ImmutableBitSet.Builder)leftMask, (ImmutableBitSet.Builder)rightMask, (int)left.getRowType().getFieldCount());
        RexNode leftPred = null;
        RexNode rightPred = null;
        if (predicate != null) {
            ArrayList leftFilters = new ArrayList();
            ArrayList rightFilters = new ArrayList();
            ArrayList joinFilters = new ArrayList();
            List predList = RelOptUtil.conjunctions((RexNode)predicate);
            RelOptUtil.classifyFilters((RelNode)joinRel, (List)predList, (JoinRelType)joinType, (joinType == JoinRelType.INNER ? 1 : 0) != 0, (!joinType.generatesNullsOnLeft() ? 1 : 0) != 0, (!joinType.generatesNullsOnRight() ? 1 : 0) != 0, joinFilters, leftFilters, rightFilters);
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            leftPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, leftFilters, (boolean)true);
            rightPred = RexUtil.composeConjunction((RexBuilder)rexBuilder, rightFilters, (boolean)true);
        }
        Double leftDistRowCount = mq.getDistinctRowCount(left, leftMask.build(), leftPred);
        Double rightDistRowCount = mq.getDistinctRowCount(right, rightMask.build(), rightPred);
        if (leftDistRowCount != null && rightDistRowCount != null) {
            distRowCount = useMaxNdv ? Double.valueOf(Math.max(leftDistRowCount, rightDistRowCount)) : NumberUtil.multiply((Double)leftDistRowCount, (Double)rightDistRowCount);
        }
        return RelMdUtil.numDistinctVals(distRowCount, (Double)mq.getRowCount(joinRel));
    }

    public RelOptCost getCumulativeCost(HiveJoin rel, RelMetadataQuery mq) {
        RelOptCost cost = mq.getNonCumulativeCost((RelNode)rel);
        List inputs = rel.getInputs();
        HiveCost maxICost = HiveCost.ZERO;
        for (RelNode input : inputs) {
            RelOptCost iCost = mq.getCumulativeCost(input);
            if (!maxICost.isLt(iCost)) continue;
            maxICost = iCost;
        }
        return cost.plus((RelOptCost)maxICost);
    }
}

